/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.StructureParameter;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.XMLWriter;
import com.sap.conn.jco.rt.XRfcParser;
import com.sap.conn.jco.util.FastBufferedWriter;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.jco.util.XRfcOutputStream;
import com.sap.conn.rfc.api.IRfcComplexParameter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class ComplexParameter
extends StructureParameter
implements IRfcComplexParameter {
    AbstractRecord complexParameter;
    int numBytes;
    XRfcParser parser;

    public ComplexParameter(AbstractRecord complexParameter, String name, int index, byte[] flags) {
        super(name, index, flags);
        this.complexParameter = complexParameter;
        this.numBytes = 0;
    }

    @Override
    public int getType() {
        return 42;
    }

    @Override
    public byte[] getBytes() {
        String xmlData = XMLWriter.createXMLDocument(this.complexParameter, this.name);
        byte[] xmlBytes = xmlData.getBytes(Utf8ByteToCharConverter.UTF_8);
        this.numBytes = xmlBytes.length;
        return xmlBytes;
    }

    @Override
    public void setBytes(byte[] rfcBytes) {
    }

    @Override
    public int getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytes(int numBytes) {
        this.numBytes = numBytes;
    }

    @Override
    public void sendXmlDataStream(RfcIoOpenCntl act_cntl) throws RfcIoException {
        try {
            XRfcOutputStream xrfcStream = new XRfcOutputStream(act_cntl);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)xrfcStream, Utf8ByteToCharConverter.UTF_8);
            FastBufferedWriter buf = new FastBufferedWriter(osw, 14336);
            XMLWriter.writeXMLDocument(this.complexParameter, this.name, buf);
            buf.close();
            this.numBytes = xrfcStream.getNumBytes();
        }
        catch (RfcIoException rioe) {
            throw rioe;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void receiveXmlDataFinished() throws RfcGetException {
        try {
            this.parser.setFinished();
        }
        catch (XMLParserException ex) {
            Trace.fireTraceCritical(new StringBuilder(128).append("ComplexParameter.receiveXmlDataFinished for ").append(this.name).append(" caught ").append(ex.toString()).toString(), ex);
            throw new RfcGetException(14, (Throwable)ex);
        }
    }

    @Override
    public void setXmlBytes(byte[] xmlBytes) throws RfcGetException {
        try {
            this.parser.setBytes(xmlBytes);
            this.parser.parse();
            this.numBytes += xmlBytes.length;
        }
        catch (XMLParserException ex) {
            Trace.fireTraceCritical(new StringBuilder(128).append("ComplexParameter.setXmlBytes for ").append(this.name).append(" caught ").append(ex.toString()).toString(), ex);
            throw new RfcGetException(14, (Throwable)ex);
        }
    }

    @Override
    public void receiveXmlDataStarted() {
        try {
            this.parser = new XRfcParser(this.complexParameter);
            this.numBytes = 0;
            int n = this.index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        }
        catch (RuntimeException re) {
            Trace.fireTraceCritical("ComplexParameter.receiveXmlDataStarted for " + this.name + " caught " + re.toString(), re);
            throw re;
        }
    }

    void setRecord(AbstractRecord record) {
        this.complexParameter = record;
    }

    public AbstractRecord getComplexParameter() {
        return this.complexParameter;
    }
}

