/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.AbSysInfo;
import java.net.Inet6Address;
import java.net.InetAddress;

public final class ConnectionAttributes
implements JCoAttributes {
    static final long serialVersionUID = 3010020140423L;
    String dest;
    String own_host;
    String partner_host;
    InetAddress partner_inetAddress;
    String systnr;
    String sysid;
    String client;
    String user;
    String language;
    String iso_language;
    String own_codepage;
    String partner_codepage;
    String own_charset;
    String partner_charset;
    String own_encoding;
    String partner_encoding;
    byte own_bytes_per_char;
    byte partner_bytes_per_char;
    String own_rel;
    String partner_rel;
    String kernel_rel;
    char partner_type;
    char trace;
    char rfc_role = (char)32;
    char own_type;
    String sso_ticket;
    int partner_rel_number = -1;
    int kernel_rel_number = -1;
    AttributesProvider attributesProvider = null;

    ConnectionAttributes(AttributesProvider attribProvider) {
        this.attributesProvider = attribProvider;
    }

    public final String getDestination() {
        return this.dest;
    }

    public final String getHost() {
        return this.own_host;
    }

    public final String getPartnerHost() {
        return this.attributesProvider.canUseCachedValues() ? this.partner_host : this.attributesProvider.getPartnerHost();
    }

    public final InetAddress getPartnerInetAddress() {
        return this.attributesProvider.canUseCachedValues() ? this.partner_inetAddress : this.attributesProvider.getPartnerInetAdress();
    }

    public final String getSystemID() {
        return this.sysid;
    }

    public final String getSystemNumber() {
        return this.attributesProvider.canUseCachedValues() ? this.systnr : this.attributesProvider.getInstanceNumber();
    }

    public final String getClient() {
        return this.client;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getISOLanguage() {
        return this.iso_language;
    }

    public final String getOwnCodepage() {
        return this.own_codepage;
    }

    public final String getOwnCharset() {
        return this.own_charset;
    }

    public final String getOwnEncoding() {
        return this.own_encoding;
    }

    public final int getOwnBytesPerChar() {
        return this.own_bytes_per_char;
    }

    public final String getPartnerCodepage() {
        return this.partner_codepage;
    }

    public final String getPartnerCharset() {
        return this.partner_charset;
    }

    public final String getPartnerEncoding() {
        return this.partner_encoding;
    }

    public final int getPartnerBytesPerChar() {
        return this.partner_bytes_per_char;
    }

    public final String getRelease() {
        return this.own_rel;
    }

    public final String getPartnerRelease() {
        return this.partner_rel;
    }

    public final String getKernelRelease() {
        return this.kernel_rel;
    }

    public final char getPartnerType() {
        return this.partner_type;
    }

    public final boolean getTrace() {
        return this.trace == 'X' || this.trace == 'x';
    }

    public final char getRfcRole() {
        return this.rfc_role;
    }

    public final char getType() {
        return this.own_type;
    }

    public final String getCPICConversationID() {
        return this.attributesProvider.getConversationID();
    }

    public final String getSSOTicket() {
        return this.sso_ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPartnerReleaseNumber() {
        if (this.partner_rel_number < 0) {
            ConnectionAttributes connectionAttributes = this;
            synchronized (connectionAttributes) {
                if (this.partner_rel_number < 0) {
                    int relNumber = this.determineReleaseNumber(this.partner_rel);
                    if (relNumber > 0) {
                        this.partner_rel_number = relNumber;
                    } else {
                        return 0;
                    }
                }
            }
        }
        return this.partner_rel_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getKernelReleaseNumber() {
        if (this.kernel_rel_number < 0) {
            ConnectionAttributes connectionAttributes = this;
            synchronized (connectionAttributes) {
                if (this.kernel_rel_number < 0) {
                    int relNumber = this.determineReleaseNumber(this.kernel_rel);
                    if (relNumber > 0) {
                        this.kernel_rel_number = relNumber;
                    } else {
                        return 0;
                    }
                }
            }
        }
        return this.kernel_rel_number;
    }

    private int determineReleaseNumber(String releaseString) {
        int releaseNumber = 0;
        if (releaseString != null && releaseString.length() > 0) {
            releaseNumber = (releaseString.charAt(0) - 48) * 100;
            releaseNumber += (releaseString.charAt(1) - 48) * 10;
            releaseNumber = Character.isDigit(releaseString.charAt(2)) ? (releaseNumber += releaseString.charAt(2) - 48) : (releaseNumber += releaseString.charAt(2) - 65);
        }
        return releaseNumber;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DEST:                  ");
        sb.append(this.dest);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_HOST:              ");
        sb.append(this.own_host);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_HOST:          ");
        sb.append(this.getPartnerHost());
        sb.append(JCoRuntime.CRLF);
        InetAddress partner_ipAddress = this.getPartnerInetAddress();
        if (partner_ipAddress != null) {
            String ipAsString = null;
            ipAsString = partner_ipAddress instanceof Inet6Address && ((Inet6Address)partner_ipAddress).isIPv4CompatibleAddress() ? AbSysInfo.getIPv4Address((Inet6Address)partner_ipAddress) : partner_ipAddress.getHostAddress();
            sb.append("PARTNER_IP:            ");
            sb.append(ipAsString);
            sb.append(JCoRuntime.CRLF);
        } else {
            sb.append("PARTNER_IP:            ");
            sb.append("Not available");
            sb.append(JCoRuntime.CRLF);
        }
        sb.append("SYSTNR:                ");
        sb.append(this.getSystemNumber());
        sb.append(JCoRuntime.CRLF);
        sb.append("SYSID:                 ");
        sb.append(this.sysid);
        sb.append(JCoRuntime.CRLF);
        sb.append("CLIENT:                ");
        sb.append(this.client);
        sb.append(JCoRuntime.CRLF);
        sb.append("USER:                  ");
        sb.append(this.user);
        sb.append(JCoRuntime.CRLF);
        sb.append("LANGUAGE:              ");
        sb.append(this.language);
        sb.append(JCoRuntime.CRLF);
        sb.append("ISO_LANGUAGE:          ");
        sb.append(this.iso_language);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_CODEPAGE:          ");
        sb.append(this.own_codepage);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_CHARSET:           ");
        sb.append(this.own_charset);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_ENCODING:          ");
        sb.append(this.own_encoding);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_BYTES_PER_CHAR:    ");
        sb.append(this.own_bytes_per_char);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_CODEPAGE:      ");
        sb.append(this.partner_codepage);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_CHARSET:       ");
        sb.append(this.partner_charset);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_ENCODING:      ");
        sb.append(this.partner_encoding);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARNER_BYTES_PER_CHAR: ");
        sb.append(this.partner_bytes_per_char);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_REL:               ");
        sb.append(this.own_rel);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_REL:           ");
        sb.append(this.partner_rel);
        sb.append(JCoRuntime.CRLF);
        sb.append("PARTNER_TYPE:          ");
        sb.append(this.partner_type);
        sb.append(JCoRuntime.CRLF);
        sb.append("KERNEL_REL:            ");
        sb.append(this.kernel_rel);
        sb.append(JCoRuntime.CRLF);
        sb.append("TRACE:                 ");
        sb.append(this.trace);
        sb.append(JCoRuntime.CRLF);
        sb.append("RFC_ROLE:              ");
        sb.append(this.rfc_role);
        sb.append(JCoRuntime.CRLF);
        sb.append("OWN_TYPE:              ");
        sb.append(this.own_type);
        sb.append(JCoRuntime.CRLF);
        sb.append("CPIC_CONVID:           ");
        sb.append(this.getCPICConversationID());
        sb.append(JCoRuntime.CRLF);
        if (this.sso_ticket != null) {
            sb.append("SSOTICKET:             ");
            sb.append(this.sso_ticket.substring(0, 10) + "...");
            sb.append(JCoRuntime.CRLF);
        }
        return sb.toString();
    }

    protected void clear() {
        this.dest = null;
        this.own_host = null;
        this.partner_host = null;
        this.partner_inetAddress = null;
        this.systnr = null;
        this.sysid = null;
        this.client = null;
        this.user = null;
        this.language = null;
        this.iso_language = null;
        this.own_codepage = null;
        this.partner_codepage = null;
        this.own_charset = null;
        this.partner_charset = null;
        this.own_encoding = null;
        this.partner_encoding = null;
        this.own_bytes_per_char = 0;
        this.partner_bytes_per_char = 0;
        this.own_rel = null;
        this.partner_rel = null;
        this.kernel_rel = null;
        this.partner_type = (char)32;
        this.trace = (char)32;
        this.rfc_role = (char)32;
        this.own_type = (char)32;
        this.sso_ticket = null;
        this.partner_rel_number = -1;
    }

    protected boolean isInitial() {
        return this.rfc_role == ' ';
    }

    static interface AttributesProvider {
        public static final String STR_UNKNOWN = "<unknown>";

        public boolean canUseCachedValues();

        public String getConversationID();

        public String getInstanceNumber();

        public String getPartnerHost();

        public InetAddress getPartnerInetAdress();
    }
}

