/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.PasswordChangeHandler;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.PoolingFactory;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.TenantContext;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.rfc.engine.PasswordState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ConnectionManager {
    private static final HashSet<String> friendlyClasses = ConnectionManager.getFriendlyClasses();
    private static ConnectionManager singleton;

    private static HashSet<String> getFriendlyClasses() {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.jco.rt.JCoJ2EERuntime");
        friends.add("com.sap.conn.jco.rt.DefaultJCoRuntime");
        friends.add("com.sap.conn.jco.rt.DefaultConnectionManager");
        return friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionManager() {
        if (!JCoRuntime.checkAccess(friendlyClasses, "com.sap.conn.jco.rt.ConnectionManager")) {
            throw new UnsupportedOperationException("It is not allowed to extend the ConnectionManager class");
        }
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (singleton == null) {
                singleton = this;
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(JCoRuntime.jcoThreadGroup, new PoolFinalizer(), "JCoPoolFinalizerThread"));
                }
                catch (Throwable t) {
                    Trace.fireTraceCritical("[JCoAPI] Exception while adding ConnectionManager shutdown hook:", t);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static ConnectionManager getConnectionManager() {
        if (singleton == null) {
            JCoRuntimeFactory.getRuntime();
        }
        return singleton;
    }

    protected final void clearAllFactories() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] Clearing all connection pools");
        }
        for (TenantContext context : JCoRuntimeFactory.getRuntime().getTenantContextManager().getAllTenants()) {
            HashMap<String, ClientFactory> factories = context.getFactories();
            ArrayList<ClientFactory> factoryList = new ArrayList<ClientFactory>();
            factoryList.addAll(factories.values());
            for (ClientFactory factory : factoryList) {
                try {
                    factory.clear();
                }
                catch (Exception exc) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeAllDetachedClients() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] Closing all detached clients");
        }
        for (TenantContext context : JCoRuntimeFactory.getRuntime().getTenantContextManager().getAllTenants()) {
            ArrayList<ClientConnection> detachedClients = context.getDetachedClients();
            if (detachedClients.size() <= 0) continue;
            ClientConnection[] clients = null;
            ArrayList<ClientConnection> arrayList = detachedClients;
            synchronized (arrayList) {
                clients = detachedClients.toArray(new ClientConnection[detachedClients.size()]);
            }
            if (clients == null) continue;
            for (int i = 0; i < clients.length; ++i) {
                try {
                    clients[i].disconnect();
                    continue;
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }
    }

    protected final ClientConnection getClient(InternalDestination destination, boolean forRepository, boolean forChangePassword) throws JCoException {
        return this.getClient(destination.getTenantContext(), destination, forRepository, forChangePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final ClientConnection getClient(TenantContext context, InternalDestination destination, boolean forRepository, boolean forChangePassword) throws JCoException {
        try {
            PasswordChangeHandler changeHandler;
            ClientFactory factory = this.getFactory(context, destination, forRepository, true);
            ClientConnection client = factory.getClient();
            PasswordState passwordState = client.rfcHandle.getPasswordState();
            if (passwordState == null) return client;
            if (passwordState != PasswordState.INITIAL && passwordState != PasswordState.EXPIRED) {
                if (passwordState != PasswordState.RULES_ENFORCED) return client;
            }
            if ((changeHandler = RuntimeEnvironment.getPasswordChangeHandler()) != null && !forRepository) {
                destination.setInPasswordChangeHandler(true);
                try {
                    if (this.doPasswortChangeWithHandler(changeHandler, destination, client)) {
                        ClientConnection clientConnection = client;
                        return clientConnection;
                    }
                }
                finally {
                    destination.setInPasswordChangeHandler(false);
                }
            }
            if (!"1".equals(client.properties.getProperty("jco.client.deny_initial_password"))) return client;
            if (forChangePassword) return client;
            StringBuilder message = new StringBuilder(134);
            switch (passwordState) {
                case INITIAL: {
                    message.append("The current password is initial.");
                    break;
                }
                case EXPIRED: {
                    message.append("The current password has expired.");
                    break;
                }
                case RULES_ENFORCED: {
                    message.append("The password rules have changed.");
                    break;
                }
            }
            message.append(" Please change your password in the AS ABAP system as well as in the local destination configuration.");
            throw new JCoException(138, message.toString());
        }
        catch (ClassCastException cce) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", new StringBuilder(130).append("Unsupported class ").append(destination.getClass().getName()).append(" encountered. Use the DestinationManager to obtain destination instances").toString(), (Throwable)cce);
        }
    }

    private boolean doPasswortChangeWithHandler(PasswordChangeHandler changeHandler, InternalDestination destination, ClientConnection client) {
        boolean successfulChange = false;
        Exception previous = null;
        for (int i = 0; i < 7; ++i) {
            if (i > 0 && !client.isValid()) {
                throw new JCoRuntimeException(136, "Connection was closed when trying to change password", previous);
            }
            String[] passwords = changeHandler.promptPassword(destination, previous);
            if (passwords == null || passwords.length < 2) break;
            try {
                client.changeBackendPassword(destination.getUser(), passwords[0], passwords[1]);
                successfulChange = true;
                break;
            }
            catch (Exception e) {
                previous = e;
                continue;
            }
        }
        return successfulChange;
    }

    protected final void releaseClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseClient()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.releaseClient(client);
        } else {
            client.context.removeDetachedClient(client);
            if (client.isAlive()) {
                client.disconnect();
            }
        }
    }

    protected final void releaseWithCancel(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseWithCancel()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        } else {
            client.context.removeDetachedClient(client);
        }
        client.cancel();
    }

    protected final void clearClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in clearClient()", true);
            return;
        }
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        } else {
            client.context.removeDetachedClient(client);
        }
        client.free();
    }

    protected final void restoreClient(ClientConnection client, String destinationId, boolean allocate) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in restoreClient()", true);
            return;
        }
        ClientFactory factory = JCoRuntimeFactory.getRuntime().getTenantContextManager().getTenantContext().getFactories().get(destinationId);
        if (factory != null) {
            factory.attachToPool(client, allocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientFactory getFactory(TenantContext context, InternalDestination destination, boolean forRepository, boolean create) throws JCoException {
        String key = forRepository ? destination.getRepositoryKey() : destination.getDestinationID();
        HashMap<String, ClientFactory> factories = context.getFactories();
        HashMap<String, AtomicInteger> creationSemaphores = context.getCreationSemaphores();
        ClientFactory factory = factories.get(key);
        if (factory == null && create) {
            AtomicInteger semaphore = null;
            Serializable serializable = creationSemaphores;
            synchronized (serializable) {
                factory = factories.get(key);
                if (factory == null) {
                    semaphore = creationSemaphores.get(key);
                    if (semaphore == null) {
                        semaphore = new AtomicInteger(1);
                        creationSemaphores.put(key, semaphore);
                    } else {
                        semaphore.incrementAndGet();
                    }
                }
            }
            if (semaphore != null) {
                serializable = semaphore;
                synchronized (serializable) {
                    block27: {
                        HashMap<String, Object> hashMap;
                        try {
                            factory = factories.get(key);
                            if (factory != null) break block27;
                            factory = this.createFactory(destination, forRepository);
                            hashMap = factories;
                            synchronized (hashMap) {
                                ClientFactory tmpFactory = factories.get(key);
                                if (tmpFactory == null) {
                                    factories.put(key, factory);
                                } else {
                                    factory.clear();
                                    factory = tmpFactory;
                                }
                                ClientConnection client = context.removeDetachedClient(key);
                                while (client != null) {
                                    factory.attachToPool(client, true);
                                    client = context.removeDetachedClient(key);
                                }
                            }
                        }
                        finally {
                            hashMap = creationSemaphores;
                            synchronized (hashMap) {
                                if (semaphore.decrementAndGet() == 0) {
                                    creationSemaphores.remove(key);
                                }
                            }
                        }
                    }
                }
            }
        }
        return factory;
    }

    protected ClientFactory createFactory(InternalDestination destination, boolean forRepository) throws JCoException {
        PoolingFactory factory = new PoolingFactory(destination, forRepository);
        ((ClientFactory)factory).init(destination);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactories(TenantContext context, InternalDestination destination) {
        HashMap<String, ClientFactory> factories;
        ClientFactory removed = null;
        ClientFactory removedRepositoryFactory = null;
        HashMap<String, ClientFactory> hashMap = factories = context.getFactories();
        synchronized (hashMap) {
            removed = factories.remove(destination.getDestinationID());
            removedRepositoryFactory = factories.remove(destination.getRepositoryKey());
        }
        if (removed != null) {
            removed.clear();
            removed.removeDestinationMonitor();
        }
        if (removedRepositoryFactory != null) {
            removedRepositoryFactory.clear();
            removedRepositoryFactory.removeDestinationMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFactory(TenantContext context, ClientFactory factory) {
        HashMap<String, ClientFactory> factories;
        if (factory.getCurrentPoolSize() > 0) {
            return false;
        }
        ClientFactory removed = null;
        HashMap<String, ClientFactory> hashMap = factories = context.getFactories();
        synchronized (hashMap) {
            if (factory.getCurrentPoolSize() > 0) {
                return false;
            }
            String destinationID = factory.getDestinationID();
            if (factories.get(destinationID) == factory) {
                removed = factories.remove(destinationID);
            }
            removed = factories.remove(factory.getDestinationID());
        }
        if (removed != null) {
            removed.removeDestinationMonitor();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void internalExecute(JCoFunction function, JCoDestination destination, boolean repositoryCall) throws JCoException {
        ClientConnection client = null;
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null, which is not allowed, hence the call cannot be executed.");
        }
        try {
            InternalDestination dest = (InternalDestination)destination;
            client = ConnectionManager.getConnectionManager().getClient(JCoRuntimeFactory.getRuntime().getTenantContextManager().getTenantContext(), dest, repositoryCall, false);
            client.execute(function, (RepositoryProvider)dest);
            if (client == null) return;
        }
        catch (Throwable throwable) {
            if (client == null) throw throwable;
            ConnectionManager.getConnectionManager().releaseClient(client);
            throw throwable;
        }
        ConnectionManager.getConnectionManager().releaseClient(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(TenantContext context, List<MonitoredConnectionData> monitoredData) {
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> factoriesMap = context.getFactories();
        ClientConnection[] clients = null;
        String[] groupNames = null;
        HashMap<String, ClientFactory> hashMap = factoriesMap;
        synchronized (hashMap) {
            factories.addAll(factoriesMap.values());
            Object[][] detachedClients = context.getDetachedConnectionsForMonitor();
            if (detachedClients != null) {
                clients = (ClientConnection[])detachedClients[0];
                groupNames = (String[])detachedClients[1];
            }
        }
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            ((ClientFactory)it.next()).getMonitoredData(monitoredData);
        }
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                MonitoredConnectionData mcd = clients[i].getMonitoredData();
                mcd.group = groupNames[i];
                monitoredData.add(mcd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientFactory> getCopyOfAllFactories(TenantContext context) {
        HashMap<String, ClientFactory> factoriesMap;
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> hashMap = factoriesMap = context.getFactories();
        synchronized (hashMap) {
            factories.addAll(factoriesMap.values());
        }
        return factories;
    }

    ClientFactory getFactoryByDestinationID(TenantContext context, String destinationID) {
        if (destinationID != null) {
            return context.getFactories().get(destinationID);
        }
        return null;
    }

    private class PoolFinalizer
    implements Runnable {
        private PoolFinalizer() {
        }

        @Override
        public void run() {
            ConnectionManager.this.clearAllFactories();
            ConnectionManager.this.closeAllDetachedClients();
        }
    }
}

