/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertXToC;

public class Converter {
    private static char[] NULL_ARRAY = new char[]{'\u0000', '\u0000', '\u0000', '\u0000'};
    private static char[] SPACE_ARRAY = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static char[] ZERO_ARRAY = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    ConvertCToX c2xConverter;
    ConvertXToC x2cConverter;
    String receiveCodepage;
    String sendCodepage;
    boolean littleEndian;
    int receiveCodepageType;
    int sendCodepageType;

    public Converter() {
        this(AbSysInfo.charset, AbSysInfo.charset, false);
    }

    public Converter(RfcIoOpenCntl currentCntl) {
        this(currentCntl.getCommunicationCodepage(), currentCntl.pcs == 2 ? currentCntl.getCodepage() : currentCntl.getCommunicationCodepage(), 1 == currentCntl.intformat);
    }

    public Converter(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.init(receiveCodepage, sendCodepage, littleEndian);
    }

    public void update(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.init(receiveCodepage, sendCodepage, littleEndian);
    }

    private void init(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.x2cConverter = I18NConverters.getConvertXToC(receiveCodepage);
        this.c2xConverter = I18NConverters.getConvertCToX(sendCodepage);
        this.receiveCodepage = receiveCodepage;
        this.sendCodepage = sendCodepage;
        this.littleEndian = littleEndian;
        this.receiveCodepageType = receiveCodepage.startsWith("410") ? 1 : 0;
        this.sendCodepageType = sendCodepage.startsWith("410") ? 1 : 0;
    }

    public final void decodeChar(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        this.c2xConverter.ConvertArr(temp_data, iboffset, iend, buffer, offset, offset + ilength);
    }

    public final byte[] decodeCharArray(char[] data, int length) {
        return this.c2xConverter.ConvertArr(data, 0, length);
    }

    public final byte[] decodeString(String data) {
        return this.c2xConverter.Convert(data);
    }

    public final String encodeString(byte[] data) {
        return this.x2cConverter.Convert(data);
    }

    public final char[] encodeCharArr(byte[] data, int offset, int length) {
        return this.x2cConverter.ConvertArr(data, offset, length);
    }

    public final void decodeNumber(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    public final void decodeBinary(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    public final void decodeDecNumber(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void encodeChar(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        int fieldEnd = Math.min(offset + ilength, value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, offset, fieldEnd, temp_data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            temp_data[i] = 32;
        }
    }

    protected final void encodeNumchar(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        int fieldEnd = Math.min(offset + ilength, value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, offset, fieldEnd, temp_data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            temp_data[i] = 48;
        }
    }

    protected final void encodeNumber(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        System.arraycopy(NULL_ARRAY, 0, temp_data, iboffset, rec.metaData.blength[index]);
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    public final char[] getEncodedNumber(byte[] value, int length) {
        char[] temp_data = new char[length / 2 + length % 2];
        if (this.littleEndian) {
            for (int k = 0; k < length; ++k) {
                int n = k >> 1;
                temp_data[n] = (char)(temp_data[n] | (char)((value[length - 1 - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < length; ++k) {
                int n = k >> 1;
                temp_data[n] = (char)(temp_data[n] | (char)((value[k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
        return temp_data;
    }

    public static void convertBytesToChars(byte[] inputValues, char[] ouputValues, boolean fillLeadingZeros) {
        int start;
        if (fillLeadingZeros) {
            for (start = 0; start < ouputValues.length - inputValues.length / 2; ++start) {
                ouputValues[start] = 48;
            }
        }
        for (int i = 0; i < inputValues.length; ++i) {
            int n = start + (i >> 1);
            ouputValues[n] = (char)(ouputValues[n] | (char)((inputValues[i] & 0xFF) << (1 - (i & 1) << 3)));
        }
    }

    public final void encodeBinary(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        for (int i = iboffset; i < iend; ++i) {
            temp_data[i] = '\u0000';
        }
        if (ilength > value.length - offset) {
            ilength = value.length - offset;
        }
        for (int k = 0; k < ilength; ++k) {
            int n = iboffset + (k >> 1);
            temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
        }
    }

    protected final void encodeDecNumber(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        if (this.littleEndian) {
            for (int k = 0; k < ilength; k += 2) {
                char c = (char)((value[end - k] & 0xFF) << 8);
                temp_data[iboffset + (k >> 1)] = c = (char)(c | (char)(value[end - k - 1] & 0xFF));
            }
        } else {
            for (int k = 0; k < ilength; k += 2) {
                char c = (char)((value[offset + k] & 0xFF) << 8);
                temp_data[iboffset + (k >> 1)] = c = (char)(c | (char)(value[offset + k + 1] & 0xFF));
            }
        }
    }

    public char[] getEncodedDecNumber(byte[] value, int length) {
        char[] temp_data = new char[length];
        if (this.littleEndian) {
            for (int k = 0; k < length; k += 2) {
                char c = (char)((value[length - 1 - k] & 0xFF) << 8);
                temp_data[k >> 1] = c = (char)(c | (char)(value[length - 1 - k - 1] & 0xFF));
            }
        } else {
            for (int k = 0; k < length; k += 2) {
                char c = (char)((value[k] & 0xFF) << 8);
                temp_data[k >> 1] = c = (char)(c | (char)(value[k + 1] & 0xFF));
            }
        }
        return temp_data;
    }

    protected final void decodeNestedType1Char(DefaultStructure rec, byte[] buffer, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.sendCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLength[index];
        this.c2xConverter.ConvertArr(rec.type1Record.type1Data, iboffset, iend, buffer, offset, offset + rec.type1Record.type1MetaData.type1Length[this.sendCodepageType][index]);
    }

    protected final void decodeNestedType1Number(DefaultStructure rec, byte[] buffer, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.sendCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void decodeNestedType1Binary(DefaultStructure rec, byte[] buffer, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.sendCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void decodeNestedType1DecNumber(DefaultStructure rec, byte[] buffer, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.sendCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void encodeNestedType1Char(DefaultStructure rec, byte[] value, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.receiveCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLength[index];
        int fieldEnd = Math.min(offset + rec.type1Record.type1MetaData.type1Length[this.receiveCodepageType][index], value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, offset, fieldEnd, rec.type1Record.type1Data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            rec.type1Record.type1Data[i] = 32;
        }
    }

    protected final void encodeNestedType1Numchar(DefaultStructure rec, byte[] value, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.receiveCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLength[index];
        int fieldEnd = Math.min(offset + rec.type1Record.type1MetaData.type1Length[this.receiveCodepageType][index], value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, offset, fieldEnd, rec.type1Record.type1Data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            rec.type1Record.type1Data[i] = 48;
        }
    }

    protected final void encodeNestedType1Number(DefaultStructure rec, byte[] value, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.receiveCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int end = offset + ilength - 1;
        System.arraycopy(NULL_ARRAY, 0, rec.type1Record.type1Data, iboffset, rec.type1Record.type1MetaData.type1BLength[index]);
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    protected final void encodeNestedType1Binary(DefaultStructure rec, byte[] value, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.receiveCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLength[index];
        for (int i = iboffset; i < iend; ++i) {
            rec.type1Record.type1Data[i] = '\u0000';
        }
        if (ilength > value.length - offset) {
            ilength = value.length - offset;
        }
        for (int k = 0; k < ilength; ++k) {
            int n = iboffset + (k >> 1);
            rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
        }
    }

    protected final void encodeNestedType1DecNumber(DefaultStructure rec, byte[] value, int index) {
        int offset = rec.type1Record.type1MetaData.type1Offset[this.receiveCodepageType][index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveCodepageType][index];
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int end = offset + ilength - 1;
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    protected final void padSpaces(byte[] buffer, int offset) {
        this.c2xConverter.ConvertArr(SPACE_ARRAY, 0, SPACE_ARRAY.length, buffer, offset, buffer.length);
    }

    protected final void padZeros(byte[] buffer, int offset) {
        this.c2xConverter.ConvertArr(ZERO_ARRAY, 0, ZERO_ARRAY.length, buffer, offset, buffer.length);
    }

    public int getSendCodepageType() {
        return this.sendCodepageType;
    }
}

