/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.MessageServerDataProvider;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.ext.TenantProvider;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.ConnectionMonitor;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultConnectionManager;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.DefaultSessionManager;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MiddlewareJavaRfc;
import com.sap.conn.jco.rt.PropertyFileDestinationDataProvider;
import com.sap.conn.jco.rt.PropertyFileServerDataProvider;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.SessionFinalizer;
import com.sap.conn.jco.rt.StandaloneServerFactory;
import com.sap.conn.jco.rt.TenantContextManager;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.DefaultTrace;
import com.sap.conn.jco.util.Log4jTraceWriter;
import com.sap.conn.jco.util.SapLoggingTrace;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.DefaultRfcRuntime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Security;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.SocketFactory;

public final class DefaultJCoRuntime
extends JCoRuntime {
    static final String PROPERTY_DESTINATION_DIRECTORY = "jco.destinations.dir";
    private static final String JCO_LIB_BASENAME = "sapjco3";
    private static boolean initializedJniLb = false;
    private ConcurrentHashMap<String, Context> contexts = null;
    private RfcRuntime rfcRuntimeInstance = null;
    private ConnectionMonitor connectionMonitor = null;
    private DefaultDestinationManager destinationManager = null;
    private StandaloneServerFactory serverFactory = null;
    private DefaultServerManager serverManager = null;
    private AutoJobRunner autoJobRunner = null;
    private DefaultTrace defaultTrace = null;

    DefaultJCoRuntime() {
    }

    @Override
    protected void initialize() {
        this.tenantManager = new TenantContextManager();
        this.contexts = new ConcurrentHashMap();
        this.sessionManager = new DefaultSessionManager(this.contexts);
        this.destinationManager = this.createDestinationManager();
        this.rfcRuntimeInstance = new DefaultRfcRuntime();
        this.middlewareInstance = new MiddlewareJavaRfc();
        this.createConnectionManager();
        this.connectionMonitor = new ConnectionMonitor();
        this.serverManager = new DefaultServerManager();
        this.serverFactory = this.createServerFactory();
        this.sessionManager.startTimeoutChecker(this);
        this.setMiddlewarePropertyValue("jco.middleware.native_layer_path", JCoRuntime.nativeLibraryPath);
        if (Environment.inNeo()) {
            try {
                Log4jTraceWriter.initialize();
            }
            catch (LinkageError linkageError) {}
        } else if (Environment.inEclipsePlugin()) {
            SapLoggingTrace.initialize();
        }
    }

    @Override
    protected void readSystemProperties() {
        block17: {
            super.readSystemProperties();
            try {
                this.setSystemProperty("jco.allow_non_abap_partner", "0");
                this.setSystemProperty("jco.cpic_maxconv", "202");
                this.setSystemProperty("jco.program_name", "SAPJCo31");
                String defaultIpAddress = null;
                try {
                    defaultIpAddress = System.getProperty("com.sap.jvm.net.DefaultLocalSocketAddress", null);
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(16, "[JCoAPI] Exception occurred while retrieving the Java system property com.sap.jvm.net.DefaultLocalSocketAddress:", re);
                }
                if (defaultIpAddress != null && (defaultIpAddress.length() == 0 || defaultIpAddress.indexOf(59) >= 0)) {
                    defaultIpAddress = null;
                }
                this.setSystemProperty("jco.ni.local_address", defaultIpAddress);
                this.setSystemProperty("jco.trace.format", "jco");
                int defaultTTL = 86400;
                int defaultNegativeTTL = 10;
                String ttlString = null;
                try {
                    ttlString = Security.getProperty("networkaddress.cache.ttl");
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(16, "[JCoAPI] Exception occurred while retrieving the Java security property networkaddress.cache.ttl:", re);
                }
                if (ttlString != null && ttlString.length() > 0) {
                    try {
                        defaultTTL = Integer.parseInt(ttlString);
                        if (defaultTTL < 0 || defaultTTL > 86400) {
                            defaultTTL = 86400;
                        }
                    }
                    catch (RuntimeException re) {
                        Trace.fireTrace(16, "[JCoAPI] Default value \"" + ttlString + "\" for property " + "jco.ni.dnscache.ttl" + " is not an integer");
                    }
                }
                try {
                    ttlString = null;
                    ttlString = Security.getProperty("networkaddress.cache.negative.ttl");
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(16, "[JCoAPI] Exception occurred while retrieving the Java security property networkaddress.cache.negative.ttl:", re);
                }
                if (ttlString != null && ttlString.length() > 0) {
                    try {
                        defaultNegativeTTL = Integer.parseInt(ttlString);
                        if (defaultNegativeTTL < 0 || defaultNegativeTTL > 86400) {
                            defaultNegativeTTL = 86400;
                        }
                    }
                    catch (RuntimeException re) {
                        Trace.fireTrace(16, "[JCoAPI] Default value \"" + ttlString + "\" for property " + "jco.ni.dnscache.negative.ttl" + " is not an integer");
                    }
                }
                this.setSystemProperty("jco.ni.dnscache.ttl", Integer.toString(defaultTTL));
                this.setSystemProperty("jco.ni.dnscache.negative.ttl", Integer.toString(defaultNegativeTTL));
            }
            catch (RuntimeException re) {
                if (!JCoRuntime.nativeLibraryLoadFailure) break block17;
                Trace.fireTraceCritical("[JCoAPI] Exception while reading system properties:", re);
            }
        }
    }

    @Override
    boolean processPublicProperty(String key, String value) {
        boolean isPropertyDefined = true;
        if (key.equals("jco.trace.format")) {
            if ("log4j".equals(value)) {
                Log4jTraceWriter.initialize();
            } else if ("jco".equals(value)) {
                if ("log4j".equals(this.tracingMethod)) {
                    Log4jTraceWriter.uninitialize();
                }
            } else {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "log4j and jco are the only allowed values for property jco.trace.format");
            }
            this.tracingMethod = value;
        } else if (key.equals("jco.socket.factory")) {
            SocketFactory socketFactory = null;
            if (value != null) {
                try {
                    Class<?> socketFactoryClass = Class.forName(value);
                    Constructor<?> socketFactoryDefaultConstructor = socketFactoryClass.getConstructor(null);
                    socketFactory = (SocketFactory)socketFactoryDefaultConstructor.newInstance(null);
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Failed to create the socketFacory instance: ", (Throwable)e);
                }
            }
            JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setSocketFactory(socketFactory);
        } else {
            isPropertyDefined = super.processPublicProperty(key, value);
        }
        return isPropertyDefined;
    }

    @Override
    protected JCoMiddleware getMiddlewareInstance() {
        return this.middlewareInstance;
    }

    @Override
    protected void updateDestinationDataProvider(DestinationDataProvider provider) {
        this.destinationManager.updateDestinationDataProvider(provider);
    }

    @Override
    protected void updateServerDataProvider(ServerDataProvider provider) {
        this.serverFactory.updateServerDataProvider(provider);
    }

    @Override
    protected void updateTenantProvider(TenantProvider provider) {
        this.tenantManager.updateTenantProvider(provider);
    }

    StandaloneServerFactory createServerFactory() {
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            PropertyFileServerDataProvider provider = new PropertyFileServerDataProvider(directory);
            RuntimeEnvironment.setDefaultServerDataProvider(provider);
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        ServerDataProvider provider = RuntimeEnvironment.getServerDataProvider();
        return new StandaloneServerFactory(provider, this.serverManager);
    }

    void adjustServerFactory(StandaloneServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateSessionRefProvider(SessionReferenceProvider provider) {
        if (provider != this.sessionManager.getSessionReferenceProvider()) {
            ConcurrentHashMap<String, Context> concurrentHashMap = this.contexts;
            synchronized (concurrentHashMap) {
                if (this.contexts.size() > 0) {
                    this.startAutoJob(new SessionFinalizer(this.autoJobRunner, this.contexts));
                    this.contexts = new ConcurrentHashMap();
                }
                this.sessionManager.getTimeoutChecker().reset(this.contexts, true);
            }
        }
        this.sessionManager.updateSessionRefProvider(provider);
    }

    @Override
    DefaultSessionManager getSessionManager() {
        return (DefaultSessionManager)this.sessionManager;
    }

    @Override
    protected DefaultDestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    private DefaultDestinationManager createDestinationManager() {
        try {
            String directory = System.getProperty(PROPERTY_DESTINATION_DIRECTORY, ".");
            PropertyFileDestinationDataProvider defProvider = new PropertyFileDestinationDataProvider(directory);
            RuntimeEnvironment.setDefaultDestinationDataProvider(defProvider);
        }
        catch (FileNotFoundException e) {
            throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", e.toString());
        }
        DestinationDataProvider provider = RuntimeEnvironment.getDestinationDataProvider();
        return new DefaultDestinationManager(provider);
    }

    @Override
    protected ConnectionManager createConnectionManager() {
        return new DefaultConnectionManager();
    }

    @Override
    protected String getRuntimeParameter(String parameter) {
        return System.getProperty(parameter);
    }

    @Override
    protected boolean registerNativeMethods(Class<?> clazz) {
        if (!initializedJniLb) {
            try {
                String jcolib = System.getProperty("jco.library", "").trim();
                if (jcolib.length() == 0) {
                    JCoRuntime.nativeLibraryPath = DefaultJCoRuntime.loadJCoLibrary();
                } else {
                    JCoRuntime.nativeLibraryPath = jcolib;
                    System.load(jcolib);
                }
                initializedJniLb = true;
            }
            catch (UnsatisfiedLinkError ule) {
                JCoRuntime.nativeLibraryPath = "not loaded, caused by " + ule.toString();
                throw ule;
            }
        }
        return true;
    }

    private static String loadJCoLibrary() {
        String myUrlProtocol;
        String myResourceName;
        URL myUrl;
        block85: {
            myUrl = null;
            myResourceName = null;
            myUrlProtocol = null;
            try {
                Class<?> classURLResolver;
                Class<DefaultJCoRuntime> myClass = DefaultJCoRuntime.class;
                myResourceName = myClass.getName().replace('.', '/') + ".class";
                myUrl = myClass.getClassLoader().getResource(myResourceName);
                myUrlProtocol = myUrl.getProtocol();
                if (!"bundleresource".equals(myUrlProtocol)) break block85;
                try {
                    classURLResolver = myClass.getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
                }
                catch (Throwable t) {
                    classURLResolver = myClass.getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
                }
                Method methodResolve = classURLResolver.getDeclaredMethod("resolve", URL.class);
                myUrl = (URL)methodResolve.invoke(classURLResolver, myUrl);
                myUrlProtocol = myUrl.getProtocol();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if ("bundleresource".equals(myUrlProtocol)) {
            try {
                System.loadLibrary(JCO_LIB_BASENAME);
                String fullname = System.mapLibraryName(JCO_LIB_BASENAME);
                return new StringBuilder(23 + fullname.length()).append("System-defined path to ").append(fullname).toString();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        OS os = OS.unknown;
        String libname = null;
        try {
            String osName = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH);
            if (osName.startsWith("windows")) {
                os = OS.Windows;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 4).append(JCO_LIB_BASENAME).append(".dll").toString();
            } else if (osName.startsWith("linux")) {
                os = OS.Linux;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("mac")) {
                os = OS.MacOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 10).append("lib").append(JCO_LIB_BASENAME).append(".jnilib").toString();
            } else if (osName.startsWith("aix")) {
                os = OS.AIX;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("hp-ux")) {
                if (System.getProperty("os.arch", "").toLowerCase(Locale.ENGLISH).startsWith("pa")) {
                    os = OS.HPUX_PARISC;
                    libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".sl").toString();
                } else {
                    os = OS.HPUX_IA64;
                    libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
                }
            } else if (osName.startsWith("sunos")) {
                os = OS.SunOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.startsWith("z/os")) {
                os = OS.zOS;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else if (osName.equals("os400") || osName.equals("os/400")) {
                os = OS.OS400;
                libname = new StringBuilder(JCO_LIB_BASENAME.length() + 6).append("lib").append(JCO_LIB_BASENAME).append(".so").toString();
            } else {
                os = OS.unknown;
                libname = System.mapLibraryName(JCO_LIB_BASENAME);
            }
        }
        catch (Throwable t) {
            os = OS.unknown;
            libname = System.mapLibraryName(JCO_LIB_BASENAME);
        }
        int strLen = 0;
        String path = null;
        File file = null;
        if ("jar".equals(myUrlProtocol) || "file".equals(myUrlProtocol)) {
            try {
                path = URLDecoder.decode(myUrl.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            if (path == null) {
                path = myUrl.getFile();
            }
            if ((path = path.substring(0, path.length() - myResourceName.length())).startsWith("jar:")) {
                path = path.substring(4);
            }
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if ("jar".equals(myUrlProtocol)) {
                int startIndex;
                int endIndex = path.lastIndexOf(33);
                if (endIndex < 0) {
                    endIndex = path.length();
                }
                path = (startIndex = path.lastIndexOf(47, endIndex)) >= 0 ? path.substring(0, startIndex + 1) : "";
            }
            try {
                strLen = path.length() + libname.length();
                file = new File(new StringBuilder(strLen).append(path).append(libname).toString());
                if (file.isFile() && file.canRead()) {
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (os == OS.OS400) {
                    try {
                        return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw ule;
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                switch (os) {
                    case Windows: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.ENGLISH);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 8).append(path).append("ntamd64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 8).append(path).append("ntintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("ia64")) {
                            path = new StringBuilder(strLen + 7).append(path).append("ntia64/").append(libname).toString();
                            break;
                        }
                        path = new StringBuilder(strLen + 8).append(path).append("ntamd64/").append(libname).toString();
                        break;
                    }
                    case Linux: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.ENGLISH);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 12).append(path).append("linuxx86_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("i386") || osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 11).append(path).append("linuxintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            int idx = osArch.length();
                            if (idx > 2 && osArch.charAt(--idx) == 'e' && osArch.charAt(--idx) == 'l') {
                                path = new StringBuilder(strLen + 13).append(path).append("linuxppc64le/").append(libname).toString();
                                break;
                            }
                            path = new StringBuilder(strLen + 11).append(path).append("linuxppc64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("ia64")) {
                            path = new StringBuilder(strLen + 10).append(path).append("linuxia64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("zarch_64") || osArch.equals("s390x")) {
                            path = new StringBuilder(strLen + 11).append(path).append("linuxs390x/").append(libname).toString();
                            break;
                        }
                        path = new StringBuilder(strLen + 12).append(path).append("linuxx86_64/").append(libname).toString();
                        break;
                    }
                    case MacOS: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.ENGLISH);
                        if (osArch.equals("x86_64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 14).append(path).append("darwinintel64/").append(libname).toString();
                            break;
                        }
                        if (osArch.equals("i386") || osArch.equals("x86")) {
                            path = new StringBuilder(strLen + 12).append(path).append("darwinintel/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            path = null;
                            break;
                        }
                        path = new StringBuilder(strLen + 14).append(path).append("darwinintel64/").append(libname).toString();
                        break;
                    }
                    case AIX: {
                        path = new StringBuilder(strLen + 10).append(path).append("rs6000_64/").append(libname).toString();
                        break;
                    }
                    case HPUX_IA64: {
                        path = new StringBuilder(strLen + 7).append(path).append("hpia64/").append(libname).toString();
                        break;
                    }
                    case HPUX_PARISC: {
                        path = new StringBuilder(strLen + 6).append(path).append("hp_64/").append(libname).toString();
                        break;
                    }
                    case SunOS: {
                        String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.ENGLISH);
                        if (osArch.equals("amd64") || osArch.length() == 0) {
                            path = new StringBuilder(strLen + 10).append(path).append("sunx86_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 's') {
                            path = new StringBuilder(strLen + 7).append(path).append("sun_64/").append(libname).toString();
                            break;
                        }
                        if (osArch.charAt(0) == 'p') {
                            path = null;
                            break;
                        }
                        path = new StringBuilder(strLen + 10).append(path).append("sunx86_64/").append(libname).toString();
                        break;
                    }
                    case zOS: {
                        path = new StringBuilder(strLen + 9).append(path).append("os390_64/").append(libname).toString();
                        break;
                    }
                    case OS400: {
                        path = new StringBuilder(strLen + 14).append(path).append("as400_pase_64/").append(libname).toString();
                        break;
                    }
                    default: {
                        path = null;
                    }
                }
                if (path != null && (file = new File(path)).isFile() && file.canRead()) {
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (os == OS.OS400) {
                    try {
                        return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw ule;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            strLen = libname.length() + 1;
            path = System.getProperty("java.library.path", "");
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                try {
                    path = tokenizer.nextToken();
                    if (path == null || path.length() == 0 || !(file = new File(new StringBuilder(path.length() + strLen).append(path).append(File.separatorChar).append(libname).toString())).isFile() || !file.canRead()) continue;
                    path = file.getCanonicalPath();
                    System.load(path);
                    return path;
                }
                catch (UnsatisfiedLinkError ule) {
                    if (os == OS.OS400) {
                        try {
                            return DefaultJCoRuntime.loadOS400JCoLibraries(path, path.length() - libname.length());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw ule;
                }
                catch (Throwable t) {
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.loadLibrary(JCO_LIB_BASENAME);
        return new StringBuilder(23 + libname.length()).append("System-defined path to ").append(libname).toString();
    }

    private static String loadOS400JCoLibraries(String path, int dirLen) {
        System.load(new StringBuilder(dirLen + 13).append(path.substring(0, dirLen)).append("libpathextension.so").toString());
        System.load(path);
        return path;
    }

    @Override
    public RfcRuntime getRfcRuntimeInstance() {
        return this.rfcRuntimeInstance;
    }

    @Override
    protected DefaultServerManager getJCoServerFactoryInstance() {
        return this.serverManager;
    }

    @Override
    protected void addTraceListener(JCoTraceListener listener) {
        super.addTraceListener(listener);
        if (this.defaultTrace != null && this.defaultTrace.isStandardOutputOn()) {
            Trace.removeTraceListener(this.defaultTrace);
            this.defaultTrace = null;
        }
    }

    @Override
    protected void removeTraceListener(JCoTraceListener listener) {
        super.removeTraceListener(listener);
    }

    @Override
    protected void setRuntimeTrace(int level, String path) {
        super.setRuntimeTrace(level, path);
        if (this.getTraceLevel() == 0) {
            if (this.defaultTrace != null) {
                Trace.removeTraceListener(this.defaultTrace);
                this.defaultTrace = null;
            }
        } else if (this.defaultTrace == null) {
            if (Trace.getTraceListenerCount() == 0) {
                this.defaultTrace = (DefaultTrace)DefaultTrace.getListener();
                Trace.addTraceListener(this.defaultTrace);
                this.defaultTrace.setTracePath(this.getTracePath());
            }
        } else {
            this.defaultTrace.setTracePath(this.getTracePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startAutoJob(AutoJobRunner.AutoJob job) {
        DefaultJCoRuntime defaultJCoRuntime = this;
        synchronized (defaultJCoRuntime) {
            if (this.autoJobRunner == null) {
                this.autoJobRunner = new AutoJobRunner();
                this.autoJobRunner.initialize();
            }
        }
        return this.autoJobRunner.addJob(job);
    }

    @Override
    public void endTask() {
    }

    @Override
    public void startTask(String monitorEntry) {
    }

    StandaloneServerFactory getServerFactory() {
        return this.serverFactory;
    }

    @Override
    protected void updateMessageServerDataProvider(MessageServerDataProvider provider) {
        try {
            Method m = DefaultJCoRuntime.class.getDeclaredMethod("_updateMessageServerDataProvider", MessageServerDataProvider.class);
            m.invoke((Object)this, provider);
        }
        catch (NoSuchMethodException e) {
            throw new JCoRuntimeException(128, "Message Server Operation are supported in Standalone Environment only", (Throwable)e);
        }
        catch (Exception e) {
            throw new JCoRuntimeException(108, "Failed during update of message server data provider", (Throwable)e);
        }
    }

    protected List<String> getServerIDs() {
        return this.getJCoServerFactoryInstance().getServerIDs(this.tenantManager.getTenantContext());
    }

    protected JCoServerMonitor getServerMonitor(String serverID) {
        return this.getJCoServerFactoryInstance().getServerMonitor(this.tenantManager.getTenantContext(), serverID);
    }

    @Override
    protected ConnectionMonitor getConnectionMonitor() {
        return this.connectionMonitor;
    }

    @Override
    protected void setPropertyValue(String key, String value) {
        super.setPropertyValue(key, value);
        if ("jco.session_timeout".equals(key) || "jco.session_timeout.check_interval".equals(key)) {
            this.autoJobRunner.refresh();
        }
    }

    private static enum OS {
        unknown,
        Windows,
        Linux,
        MacOS,
        AIX,
        HPUX_IA64,
        HPUX_PARISC,
        SunOS,
        zOS,
        OS400;

    }
}

