/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoExtendedFieldMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.RecordMetaDataInternal;
import java.io.Serializable;

public class DefaultRecordMetaData
extends AbstractMetaData
implements JCoRecordMetaData {
    static final long serialVersionUID = 3000220081119L;
    protected int[][] offset = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
    protected int[] tabLength = new int[]{0, 0};
    protected String typeName = null;
    protected Type1MetaData type1MetaData = null;
    private int deepFieldsCount;
    private boolean isFlat;
    private boolean containsTable;
    private int hashcode = 0;

    DefaultRecordMetaData(String name) {
        this(name, 0);
    }

    DefaultRecordMetaData(String name, int capacity) {
        super(name);
        this.ensureCapacity(capacity);
    }

    DefaultRecordMetaData(JCoRecordMetaData obj) {
        super(obj.getName());
        this.copy(obj);
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (this.name.length >= capacity) {
            return;
        }
        super.ensureCapacity(capacity);
        int[][] oldOffset = this.offset;
        this.offset = new int[2][capacity];
        System.arraycopy(oldOffset[0], 0, this.offset[0], 0, this.numFields);
        System.arraycopy(oldOffset[1], 0, this.offset[1], 0, this.numFields);
    }

    protected void copy(JCoRecordMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy((JCoMetaData)obj);
        this.setRecordLength(obj.getRecordLength(), obj.getUnicodeRecordLength());
        if (obj instanceof DefaultRecordMetaData) {
            DefaultRecordMetaData meta = (DefaultRecordMetaData)obj;
            this.fastCopy(meta);
            System.arraycopy(meta.offset[0], 0, this.offset[0], 0, this.numFields);
            System.arraycopy(meta.offset[1], 0, this.offset[1], 0, this.numFields);
            this.typeName = meta.typeName;
            if (meta.type1MetaData != null) {
                this.type1MetaData = new Type1MetaData(meta.type1MetaData.isType1OnlyWithoutTables);
                this.type1MetaData.copy(meta.type1MetaData);
            }
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                this.add(obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getUnicodeByteLength(i), obj.getByteOffset(i), obj.getUnicodeByteOffset(i), obj.getDecimals(i), obj.getDescription(i), obj.getRecordTypeName(i), obj.getExtendedFieldMetaData(i));
            }
            if (obj.isNestedType1Structure()) {
                this.type1MetaData = new Type1MetaData(false);
                this.type1MetaData.constructMetaData();
            }
        }
    }

    public void add(String fieldname, int fieldType, int byteLength, int byteOffset, int unicodeByteLength, int unicodeOffset) {
        this.add(fieldname, fieldType, byteLength, byteOffset, unicodeByteLength, unicodeOffset, 0, null, null, null);
    }

    public void add(String fieldname, int fieldType, int byteOffset, int unicodeOffset, JCoRecordMetaData recordMetaData) {
        this.add(fieldname, fieldType, recordMetaData.getRecordLength(), byteOffset, recordMetaData.getUnicodeRecordLength(), unicodeOffset, 0, null, recordMetaData, null);
    }

    public void add(String fieldName, int fieldtype, int nucByteLength, int nucByteOffset, int ucByteLength, int ucByteOffset, int fieldDecimals, String fieldDesc, Object tabMetaData, JCoExtendedFieldMetaData extended) {
        super.add(fieldName, fieldtype, nucByteLength, ucByteLength, fieldDecimals, fieldDesc, tabMetaData, extended);
        if (nucByteOffset < 0) {
            int n = nucByteOffset = this.numFields > 1 ? this.offset[0][this.numFields - 2] + this.length[0][this.numFields - 2] : 0;
        }
        if (ucByteOffset < 0) {
            ucByteOffset = this.numFields > 1 ? this.offset[1][this.numFields - 2] + this.length[1][this.numFields - 2] : 0;
        }
        this.offset[0][this.numFields - 1] = nucByteOffset;
        this.offset[1][this.numFields - 1] = ucByteOffset;
    }

    public int getUnicodeRecordLength() {
        return this.tabLength[1];
    }

    public Type1MetaData getType1MetaData() {
        return this.type1MetaData;
    }

    public int getRecordLength() {
        return this.tabLength[0];
    }

    public void setRecordLength(int tabNUCLength, int tabUCLength) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.recName + " is already locked. Changes are no longer possible");
        }
        this.tabLength[0] = tabNUCLength;
        this.tabLength[1] = tabUCLength;
    }

    public int getUnicodeByteOffset(int index) {
        this.checkIndex(index);
        return this.offset[1][index];
    }

    public int getUnicodeByteOffset(String fieldName) {
        return this.offset[1][this.indexOf(fieldName)];
    }

    public int getByteOffset(int index) {
        super.checkIndex(index);
        return this.offset[0][index];
    }

    public int getByteOffset(String fieldName) {
        return this.offset[0][this.indexOf(fieldName)];
    }

    public boolean isNestedType1Structure() {
        return this.type1MetaData != null && !this.type1MetaData.isType1OnlyWithoutTables;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public boolean containsTable() {
        if (!this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.recName + " is not locked. Changes are still possible");
        }
        return this.containsTable;
    }

    private boolean containsTableCheck() {
        for (int i = 0; i < this.type.length; ++i) {
            if (this.type[i] != 99) continue;
            return true;
        }
        return false;
    }

    public int getDeepFieldsCount() {
        return this.deepFieldsCount;
    }

    private static int countNumFields(JCoRecordMetaData metaData, int fieldCount) {
        if (metaData == null) {
            return fieldCount + 1;
        }
        for (int i = 0; i < metaData.getFieldCount(); ++i) {
            if (metaData.getType(i) == 17) {
                fieldCount = DefaultRecordMetaData.countNumFields(metaData.getRecordMetaData(i), fieldCount);
                continue;
            }
            ++fieldCount;
        }
        return fieldCount;
    }

    public void markAsNestedType1Structure() {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.recName + " is already locked. Changes are no longer possible");
        }
        this.createNestedType1Structure(false);
    }

    protected void createNestedType1Structure(boolean isType1OnlyWithoutTables) {
        this.type1MetaData = new Type1MetaData(isType1OnlyWithoutTables);
        this.type1MetaData.constructMetaData();
    }

    public String getLineType() {
        return this.typeName;
    }

    public void setLineType(String lineType) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.recName + " is already locked. Changes are no longer possible");
        }
        this.typeName = lineType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultRecordMetaData)) {
            return false;
        }
        DefaultRecordMetaData md = (DefaultRecordMetaData)obj;
        if (!super.equals(obj)) {
            return false;
        }
        for (int i = 0; i < this.numFields; ++i) {
            if (this.offset[1][i] != md.offset[1][i]) {
                return false;
            }
            if (this.offset[0][i] == md.offset[0][i]) continue;
            return false;
        }
        if (this.tabLength[0] != md.tabLength[0]) {
            return false;
        }
        if (this.tabLength[1] != md.tabLength[1]) {
            return false;
        }
        return !(this.typeName != null ? !this.typeName.equals(md.typeName) : md.typeName != null);
    }

    @Override
    public int hashCode() {
        if (this.hashcode == 0) {
            for (int i = 0; i < this.numFields; ++i) {
                if (this.offset[0][i] > 0) {
                    this.hashcode = 31 * this.hashcode + this.offset[0][i];
                }
                if (this.offset[1][i] <= 0) continue;
                this.hashcode = 31 * this.hashcode + this.offset[1][i];
            }
            this.hashcode = 31 * this.hashcode + this.tabLength[0];
            this.hashcode = 31 * this.hashcode + this.tabLength[1];
            if (this.typeName != null) {
                this.hashcode = 31 * this.hashcode + this.typeName.hashCode();
            }
        }
        return this.hashcode;
    }

    @Override
    protected String toString(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.recName);
        if (this.typeName != null && this.typeName.length() != 0) {
            sb.append(" (").append(this.typeName).append(')');
        }
        sb.append(JCoRuntime.CRLF);
        for (int i = 0; i < this.numFields; ++i) {
            this.appendBlanks(sb, level * 10);
            String tmp = this.name[i];
            sb.append(tmp);
            this.appendBlanks(sb, 30 - tmp.length());
            sb.append(',');
            if (this.tabMeta[i] instanceof String) {
                tmp = (String)((Object)this.tabMeta[i]);
                sb.append(tmp);
                this.appendBlanks(sb, 30 - tmp.length());
            } else if (this.tabMeta[i] instanceof JCoMetaData) {
                tmp = ((JCoMetaData)this.tabMeta[i]).getName();
                sb.append(tmp);
                this.appendBlanks(sb, 30 - tmp.length());
            } else {
                this.appendBlanks(sb, 30);
            }
            sb.append(',');
            tmp = DefaultRecordMetaData.getJCOTypeString(this.type[i]);
            sb.append(tmp);
            this.appendBlanks(sb, 11 - tmp.length());
            sb.append(',');
            sb.append(this.blength[i]);
            sb.append(',');
            sb.append(this.boffset[i]);
            sb.append(',');
            sb.append(this.length[0][i]);
            sb.append(',');
            sb.append(this.offset[0][i]);
            sb.append(',');
            sb.append(this.length[1][i]);
            sb.append(',');
            sb.append(this.offset[1][i]);
            sb.append(',');
            sb.append(this.decimals[i]);
            sb.append(',');
            if (this.description != null && this.description.length > i && this.description[i] != null) {
                sb.append(this.description[i]);
            }
            sb.append(JCoRuntime.CRLF);
            if (this.tabMeta[i] == null || !(this.tabMeta[i] instanceof AbstractMetaData)) continue;
            sb.append(((AbstractMetaData)((Object)this.tabMeta[i])).toString(level + 1));
        }
        this.appendBlanks(sb, level * 10);
        sb.append("record length: ");
        sb.append(this.tabLength[0]);
        sb.append(',');
        sb.append(this.tabLength[1]);
        sb.append(JCoRuntime.CRLF);
        return sb.toString();
    }

    @Override
    protected void onLock() {
        if (this.numFields > 0) {
            int minLength = this.offset[0][this.numFields - 1] + this.length[0][this.numFields - 1];
            int minLengthUC = this.offset[1][this.numFields - 1] + this.length[1][this.numFields - 1];
            if (this.tabLength[0] < minLength) {
                this.tabLength[0] = minLength;
            }
            if (this.tabLength[1] < minLengthUC) {
                this.tabLength[1] = minLengthUC;
            }
        }
        this.containsTable = this.containsTableCheck();
        this.deepFieldsCount = DefaultRecordMetaData.countNumFields(this, 0);
        boolean bl = this.isFlat = !this.containsTable && this.deepFieldsCount == this.numFields;
        if (!this.containsTable && this.type1MetaData == null) {
            this.createNestedType1Structure(true);
        }
    }

    int computeFieldNumber(int bufferByteLength, int metaDataUnicodeType) {
        int maxFieldNumber = this.numFields;
        while (maxFieldNumber > 0) {
            if (this.offset[metaDataUnicodeType][--maxFieldNumber] + this.length[metaDataUnicodeType][maxFieldNumber] > bufferByteLength) continue;
            return ++maxFieldNumber;
        }
        return maxFieldNumber;
    }

    public class Type1MetaData
    implements Cloneable,
    Serializable,
    RecordMetaDataInternal {
        static final long serialVersionUID = 3000220081119L;
        protected String[] type1Name = JCoRuntime.EMPTY_STR_ARRAY;
        protected int[][] type1Offset = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
        protected int[][] type1Length = new int[][]{JCoRuntime.EMPTY_INT_ARRAY, JCoRuntime.EMPTY_INT_ARRAY};
        protected int[] type1BOffset = JCoRuntime.EMPTY_INT_ARRAY;
        protected int[] type1BLength = JCoRuntime.EMPTY_INT_ARRAY;
        protected byte[] type1Type = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected byte[] type1Decimals = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected byte[] flags = JCoRuntime.EMPTY_BYTE_ARRAY;
        protected int type1NumFields = 0;
        private boolean isType1OnlyWithoutTables;

        protected Type1MetaData(boolean isType1OnlyWithoutTables) {
            this.isType1OnlyWithoutTables = isType1OnlyWithoutTables;
        }

        public Object clone() {
            try {
                Type1MetaData obj = (Type1MetaData)super.clone();
                obj.copy(this);
                return obj;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected void copy(Type1MetaData type1Template) {
            if (type1Template == null) {
                return;
            }
            this.ensureCapacity(type1Template.type1NumFields);
            this.type1NumFields = type1Template.type1NumFields;
            System.arraycopy(type1Template.type1Name, 0, this.type1Name, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Offset[0], 0, this.type1Offset[0], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Offset[1], 0, this.type1Offset[1], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1BOffset, 0, this.type1BOffset, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Length[0], 0, this.type1Length[0], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Length[1], 0, this.type1Length[1], 0, this.type1NumFields);
            System.arraycopy(type1Template.type1BLength, 0, this.type1BLength, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Type, 0, this.type1Type, 0, this.type1NumFields);
            System.arraycopy(type1Template.type1Decimals, 0, this.type1Decimals, 0, this.type1NumFields);
            System.arraycopy(type1Template.flags, 0, this.flags, 0, this.type1NumFields);
        }

        private void ensureCapacity(int capacity) {
            if (this.type1Name.length < capacity) {
                String[] old_name = this.type1Name;
                this.type1Name = new String[capacity];
                System.arraycopy(old_name, 0, this.type1Name, 0, old_name.length);
                int[][] old_offset = this.type1Offset;
                this.type1Offset = new int[2][capacity];
                System.arraycopy(old_offset[0], 0, this.type1Offset[0], 0, old_offset[0].length);
                System.arraycopy(old_offset[1], 0, this.type1Offset[1], 0, old_offset[1].length);
                int[] old_boffset = this.type1BOffset;
                this.type1BOffset = new int[capacity];
                System.arraycopy(old_boffset, 0, this.type1BOffset, 0, old_boffset.length);
                int[][] old_length = this.type1Length;
                this.type1Length = new int[2][capacity];
                System.arraycopy(old_length[0], 0, this.type1Length[0], 0, old_length[0].length);
                System.arraycopy(old_length[1], 0, this.type1Length[1], 0, old_length[1].length);
                int[] old_blength = this.type1BLength;
                this.type1BLength = new int[capacity];
                System.arraycopy(old_blength, 0, this.type1BLength, 0, old_blength.length);
                byte[] old_type = this.type1Type;
                this.type1Type = new byte[capacity];
                System.arraycopy(old_type, 0, this.type1Type, 0, old_type.length);
                byte[] old_decimals = this.type1Decimals;
                this.type1Decimals = new byte[capacity];
                System.arraycopy(old_decimals, 0, this.type1Decimals, 0, old_decimals.length);
                byte[] old_flags = this.flags;
                this.flags = new byte[capacity];
                System.arraycopy(old_flags, 0, this.flags, 0, old_flags.length);
            }
        }

        protected void constructMetaData() {
            this.type1NumFields = DefaultRecordMetaData.countNumFields(DefaultRecordMetaData.this, 0);
            this.ensureCapacity(this.type1NumFields);
            this.constructMetaData(DefaultRecordMetaData.this, 0, "", 0, 0);
            this.type1BOffset[0] = 0;
            for (int i = 0; i < this.type1NumFields - 1; ++i) {
                this.type1BOffset[i + 1] = this.type1BOffset[i] + this.type1BLength[i];
            }
        }

        private final int constructMetaData(DefaultRecordMetaData metaData, int pos, String prefix, int structOffset, int structUnicodeOffset) {
            for (int i = 0; i < metaData.getFieldCount(); ++i) {
                if (metaData.getType(i) == 17) {
                    pos = this.constructMetaData((DefaultRecordMetaData)metaData.getRecordMetaData(i), pos, prefix + metaData.name[i] + '-', structOffset + metaData.offset[0][i], structUnicodeOffset + metaData.offset[1][i]);
                    continue;
                }
                this.type1Name[pos] = prefix + metaData.name[i];
                this.type1Offset[0][pos] = structOffset + metaData.offset[0][i];
                this.type1Offset[1][pos] = structUnicodeOffset + metaData.offset[1][i];
                this.type1Length[0][pos] = metaData.length[0][i];
                this.type1Length[1][pos] = metaData.length[1][i];
                this.type1BLength[pos] = metaData.blength[i];
                this.type1Type[pos] = metaData.type[i];
                this.type1Decimals[pos] = metaData.decimals[i];
                ++pos;
            }
            return pos;
        }

        int computeFieldNumber(int bufferByteLength, int metaDataUnicodeType) {
            int maxFieldNumber = this.type1NumFields;
            while (maxFieldNumber > 0) {
                if (this.type1Offset[metaDataUnicodeType][--maxFieldNumber] + this.type1Length[metaDataUnicodeType][maxFieldNumber] > bufferByteLength) continue;
                return ++maxFieldNumber;
            }
            return maxFieldNumber;
        }

        @Override
        public byte[] getTypes() {
            return this.type1Type;
        }

        @Override
        public int[][] getLengths() {
            return this.type1Length;
        }

        @Override
        public byte[] getDecimals() {
            return this.type1Decimals;
        }

        @Override
        public int getFieldCount() {
            return this.type1NumFields;
        }
    }
}

