/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRemoteContext;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.Language;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultRemoteContext
implements JCoRemoteContext {
    private static HashMap<Character, String> rfcCsIdMap = new HashMap();
    private String client = null;
    private String destination = null;
    private String installationNumber = null;
    private String language = null;
    private String serverInstance = null;
    private String serverIpAddress = null;
    private String user = null;
    private String failureTimeStampAsString = null;
    private Date failureTimeStamp = null;
    private Stack stack = null;

    public String getClient() {
        return this.client;
    }

    public String getDestination() {
        return this.destination;
    }

    public Date getFailureTimeStamp() {
        if (this.failureTimeStamp == null && this.failureTimeStampAsString != null && this.failureTimeStampAsString.length() == 14) {
            Calendar cal = Calendar.getInstance();
            try {
                cal.set(Integer.parseInt(this.failureTimeStampAsString.substring(0, 4)), Integer.parseInt(this.failureTimeStampAsString.substring(4, 6)), Integer.parseInt(this.failureTimeStampAsString.substring(6, 8)), Integer.parseInt(this.failureTimeStampAsString.substring(8, 10)), Integer.parseInt(this.failureTimeStampAsString.substring(10, 12)), Integer.parseInt(this.failureTimeStampAsString.substring(12, 14)));
                this.failureTimeStamp = cal.getTime();
            }
            catch (NumberFormatException ex) {
                this.failureTimeStamp = null;
            }
        }
        return this.failureTimeStamp;
    }

    public String getFailureTimeStampAsString() {
        return this.failureTimeStampAsString;
    }

    public String getInstallationNumber() {
        return this.installationNumber;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public String getServerIpAddress() {
        if (this.serverIpAddress == null && this.serverInstance != null) {
            try {
                this.serverIpAddress = InetAddress.getByName(this.serverInstance).getHostAddress();
            }
            catch (Throwable ex) {
                this.serverIpAddress = ex.toString();
            }
        }
        return this.serverIpAddress;
    }

    public String getUser() {
        return this.user;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setServerInstance(String serverInstance) {
        if (serverInstance == null) {
            this.serverInstance = null;
            this.serverIpAddress = null;
        } else if (!serverInstance.equals(this.serverInstance)) {
            this.serverInstance = serverInstance;
            this.serverIpAddress = null;
        }
    }

    public void scanCallStack(String callStack) {
        this.stack = new Stack();
        StringTokenizer st1 = new StringTokenizer(callStack, ";");
        block11: while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), ",");
            int tokenCount = 0;
            char id = '\u0000';
            StackEntry stackEntry = null;
            while (st2.hasMoreTokens()) {
                String nvp = st2.nextToken();
                ++tokenCount;
                if (nvp.indexOf(61) != 1) continue block11;
                char key = nvp.charAt(0);
                String value = nvp.substring(2);
                if (tokenCount == 1) {
                    if (rfcCsIdMap.get(Character.valueOf(key)) == null && key != 'I' && key != 'W') continue block11;
                    id = key;
                }
                if (id == 'I') {
                    switch (key) {
                        case 'C': {
                            this.client = value;
                            break;
                        }
                        case 'I': {
                            this.user = value;
                            break;
                        }
                        case 'L': {
                            this.language = Language.getISOLanguage(value);
                        }
                    }
                    continue;
                }
                if (id == 'W') {
                    switch (key) {
                        case 'W': {
                            this.stack.where = value;
                            break;
                        }
                        case 'E': {
                            this.stack.positionEntry = value;
                            break;
                        }
                        case 'N': {
                            this.stack.processNumber = value;
                            break;
                        }
                        case 'H': {
                            this.stack.stackLevel = value;
                        }
                    }
                    continue;
                }
                if (stackEntry == null) {
                    stackEntry = new StackEntry(id, value);
                    this.stack.add(stackEntry);
                    continue;
                }
                if (key != 'P') continue;
                stackEntry.progName = value;
            }
        }
    }

    public void scanClassExceptionInfo(String info) {
        StringTokenizer st = new StringTokenizer(info, ";");
        while (st.hasMoreTokens()) {
            String nvp = st.nextToken();
            int eqIndex = nvp.indexOf(61);
            if (eqIndex <= 0) continue;
            String name = nvp.substring(0, eqIndex);
            if (name.equals("TIME_STAMP")) {
                this.failureTimeStampAsString = nvp.substring(eqIndex + 1);
                this.failureTimeStamp = null;
                continue;
            }
            if (!name.equals("LICENSE_NO")) continue;
            this.installationNumber = nvp.substring(eqIndex + 1);
        }
    }

    public String callStackToString() {
        return this.stack == null ? "null" + JCoRuntime.CRLF : this.stack.toString();
    }

    public boolean isCallStackEmpty() {
        return this.stack == null || this.stack.isEmpty();
    }

    public static String rfcCsIdDescription(char rfcCsId) {
        String description = rfcCsIdMap.get(Character.valueOf(rfcCsId));
        return description == null ? "" : description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User     : ");
        sb.append(this.getUser()).append(JCoRuntime.CRLF);
        sb.append("Client  :");
        sb.append(this.getClient()).append(JCoRuntime.CRLF);
        sb.append("Language: ");
        sb.append(this.getLanguage()).append(JCoRuntime.CRLF);
        sb.append("Server      : ");
        sb.append(this.getServerInstance()).append(JCoRuntime.CRLF);
        sb.append("Destination : ");
        sb.append(this.getDestination()).append(JCoRuntime.CRLF);
        sb.append("Installation : ");
        sb.append(this.getInstallationNumber()).append(JCoRuntime.CRLF);
        sb.append("Failure Time Stamp: ");
        sb.append(this.getFailureTimeStampAsString()).append(JCoRuntime.CRLF);
        sb.append("---------- Call Stack ----------").append(JCoRuntime.CRLF);
        sb.append(this.callStackToString());
        sb.append("--------------------------------").append(JCoRuntime.CRLF);
        return sb.toString();
    }

    static {
        rfcCsIdMap.put(Character.valueOf('S'), "Subroutine");
        rfcCsIdMap.put(Character.valueOf('F'), "Form");
        rfcCsIdMap.put(Character.valueOf('M'), "Method");
        rfcCsIdMap.put(Character.valueOf('E'), "Event");
        rfcCsIdMap.put(Character.valueOf('D'), "Module");
        rfcCsIdMap.put(Character.valueOf('C'), "C-Call");
        rfcCsIdMap.put(Character.valueOf('U'), "Function");
    }

    private class StackEntry {
        private char type;
        private String name;
        private String progName = null;

        private StackEntry(char type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(DefaultRemoteContext.rfcCsIdDescription(this.type));
            sb.append(' ');
            sb.append(this.name);
            sb.append(" (");
            sb.append(this.progName == null ? "???" : this.progName);
            sb.append(')').append(JCoRuntime.CRLF);
            return sb.toString();
        }
    }

    private class Stack
    extends Vector<StackEntry> {
        private static final long serialVersionUID = 3001520160531L;
        private String where = null;
        private String positionEntry = null;
        private String stackLevel = null;
        private String processNumber = null;

        private Stack() {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Where: ");
            sb.append(this.where == null ? "???" : this.where);
            sb.append(", ");
            sb.append("Position Entry: ");
            sb.append(this.positionEntry == null ? "???" : this.positionEntry);
            sb.append(", ");
            sb.append("Stack Level: ");
            sb.append(this.stackLevel == null ? "???" : this.stackLevel);
            sb.append(", ");
            sb.append("Process Number: ");
            sb.append(this.processNumber == null ? "???" : this.processNumber);
            sb.append(JCoRuntime.CRLF);
            if (this.isEmpty()) {
                sb.append("<empty>").append(JCoRuntime.CRLF);
            } else {
                for (StackEntry se : this) {
                    sb.append(se.toString());
                }
            }
            return sb.toString();
        }
    }
}

