/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.DefaultServerWorker;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.TenantContext;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.server.JCoServerThreadStarter;
import com.sap.conn.jco.server.JCoServerUnitIDHandler;
import com.sap.conn.jco.util.ObjectList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DefaultServer
implements JCoServer {
    static final JCoRuntime jcoRuntime = JCoRuntimeFactory.getRuntime();
    private ConfigurationState configurationState = ConfigurationState.VALID;
    private JCoMiddleware middleware = jcoRuntime.getMiddlewareInstance();
    private JCoMiddleware.ServerGroup mwServerGroup = this.middleware.getListenerGroupInterface();
    private DefaultServerManager serverManager;
    private JCoServerThreadStarter runnableStarter;
    protected JCoRepositoryMapBox jcoRepositoryBox;
    private JCoServerTIDHandler tidHandler;
    private JCoServerUnitIDHandler unitIDHandler;
    private JCoServerSecurityHandler securityHandler;
    private JCoServerCallHandlerFactory callHandlerFactory;
    private List<DefaultServerWorker> listeners = new ArrayList<DefaultServerWorker>();
    private int minWorkerCount = 0;
    private int maxWorkerCount = 0;
    private int currentWorkerCount = 0;
    private int currentRequestsInProcess = 0;
    private int connectionCount = 0;
    private List<ServerConnection> connections = new ArrayList<ServerConnection>();
    private String name;
    protected String connParams;
    private Properties properties;
    private int startupDelay;
    private int maxStartupDelay = -255;
    private long lastRegisterTime = 0L;
    private RequestQueue requestQueue = new RequestQueue();
    private JCoServerState state = JCoServerState.STOPPED;
    private DefaultThroughput throughput = null;
    private ServerMonitor monitor = null;
    private TenantContext context;
    private ObjectList<JCoServerExceptionListener> serverExceptionListeners = new ObjectList();
    private ObjectList<JCoServerErrorListener> serverErrorListeners = new ObjectList();
    private ObjectList<JCoServerStateChangedListener> serverStateChangedListeners = new ObjectList();

    protected DefaultServer(Properties serverProperties) throws JCoException {
        this.update(serverProperties);
        this.context = JCoRuntimeFactory.getRuntime().getTenantContextManager().getTenantContext();
        this.serverManager = (DefaultServerManager)jcoRuntime.getJCoServerFactoryInstance();
    }

    final void updateRunning(Properties serverProperties) {
        String value;
        Properties oldProps = null;
        if (serverProperties != null) {
            oldProps = this.properties;
            this.properties = (Properties)serverProperties.clone();
        }
        if ((value = this.properties.getProperty("jco.server.connection_count")) != null) {
            this.setConnectionCount(Integer.parseInt(value));
        }
        if ((value = this.properties.getProperty("jco.server.max_startup_delay")) != null) {
            try {
                this.maxStartupDelay = Integer.parseInt(value);
            }
            catch (Exception ex) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTrace(2, "[JCoAPI] JCoServer.updateRunning(): Value of property jco.server.max_startup_delay is not an integer: '" + value + "'");
                }
                this.maxStartupDelay = -255;
            }
        }
        if (oldProps != null) {
            this.properties.setProperty("jco.server.group_key", oldProps.getProperty("jco.server.group_key"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOnChange(DefaultServer oldServer) throws JCoException {
        if (oldServer != null) {
            int i;
            this.callHandlerFactory = oldServer.callHandlerFactory;
            this.securityHandler = oldServer.securityHandler;
            this.tidHandler = oldServer.tidHandler;
            this.unitIDHandler = oldServer.unitIDHandler;
            this.runnableStarter = oldServer.runnableStarter;
            this.throughput = oldServer.throughput;
            int size = 0;
            ObjectList<Object> objectList = oldServer.serverErrorListeners;
            synchronized (objectList) {
                size = oldServer.serverErrorListeners.size();
                for (i = 0; i < size; ++i) {
                    this.serverErrorListeners.add(oldServer.serverErrorListeners.get(i));
                }
            }
            objectList = oldServer.serverExceptionListeners;
            synchronized (objectList) {
                size = oldServer.serverExceptionListeners.size();
                for (i = 0; i < size; ++i) {
                    this.serverExceptionListeners.add(oldServer.serverExceptionListeners.get(i));
                }
            }
            objectList = oldServer.serverStateChangedListeners;
            synchronized (objectList) {
                size = oldServer.serverStateChangedListeners.size();
                for (i = 0; i < size; ++i) {
                    this.serverStateChangedListeners.add(oldServer.serverStateChangedListeners.get(i));
                }
            }
        }
    }

    final void update(Properties serverProperties) throws JCoException {
        MappingRuleParser rulesParser;
        DefaultServer.checkProperties(serverProperties);
        Properties oldProps = this.properties;
        this.properties = (Properties)serverProperties.clone();
        this.updateRunning(null);
        JCoDestination repoDest = null;
        String repoDestName = this.properties.getProperty("jco.server.repository_destination");
        if (repoDestName != null) {
            try {
                repoDest = JCoDestinationManager.getDestination((String)repoDestName);
                if (repoDest != null) {
                    repoDest.getRepository();
                }
            }
            catch (JCoException ex) {
                switch (ex.getGroup()) {
                    case 102: 
                    case 135: {
                        break;
                    }
                    default: {
                        throw new JCoException(ex.getGroup(), ex.getKey(), "Server default repository destination " + repoDestName + " is invalid: " + ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if (repoDest == null) {
                throw new JCoException(101, "Server default repository destination " + repoDestName + " is unavailable");
            }
            this.setRepository(repoDest);
        }
        if ((rulesParser = MappingRuleParser.parse(this.properties)) != null) {
            while (rulesParser.hasNextRule()) {
                rulesParser.nextRule();
                repoDestName = rulesParser.getCurrentDestination();
                try {
                    repoDest = JCoDestinationManager.getDestination((String)repoDestName);
                }
                catch (JCoException ex) {
                    throw new JCoException(ex.getGroup(), ex.getKey(), "Server repository destination " + repoDestName + " specified by mapping rule " + rulesParser.getCurrentRule() + " is invalid: " + ex.getMessage(), (Throwable)ex);
                }
                if (repoDest == null) {
                    throw new JCoException(101, "Server repository destination " + repoDestName + " specified by mapping rule " + rulesParser.getCurrentRule() + " is unavailable");
                }
                while (rulesParser.hasNextSystem()) {
                    this.setRepositoryMappingRule(rulesParser.nextSystem(), repoDest);
                }
            }
        }
        if (oldProps != null) {
            this.properties.setProperty("jco.server.group_key", oldProps.getProperty("jco.server.group_key"));
        }
    }

    final void setServerKey(String key) {
        this.properties.setProperty("jco.server.group_key", key);
        this.connParams = this.mwServerGroup.initialize(this.properties);
    }

    public final String getServerKey() {
        return this.properties.getProperty("jco.server.group_key");
    }

    final void setServerName(String serverName) {
        this.name = serverName;
    }

    public final String getServerName() {
        if (this.name == null) {
            this.name = this.properties.getProperty("jco.server.name");
        }
        return this.name;
    }

    @Override
    public String getGatewayHost() {
        return this.properties.getProperty("jco.server.gwhost");
    }

    @Override
    public String getGatewayService() {
        return this.properties.getProperty("jco.server.gwserv");
    }

    @Override
    public String getMySncName() {
        return this.properties.getProperty("jco.server.snc_myname");
    }

    @Override
    public String getProgramID() {
        return this.properties.getProperty("jco.server.progid");
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getSAPRouterString() {
        return this.properties.getProperty("jco.server.saprouter");
    }

    @Override
    public String getSncLibrary() {
        return this.properties.getProperty("jco.server.snc_lib");
    }

    @Override
    public boolean getSncMode() {
        return !this.properties.getProperty("jco.server.snc_mode", "0").equals("0");
    }

    @Override
    public int getSncQOP() {
        return Integer.parseInt(this.properties.getProperty("jco.server.snc_qop"));
    }

    @Override
    public String getRepositoryDestination() {
        return this.properties.getProperty("jco.server.repository_destination");
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getCurrentConnectionCount() {
        return this.connections.size();
    }

    public int getCurrentServerRunnableCount() {
        return this.listeners.size();
    }

    public int getServeRunnableCount() {
        return this.getConnectionCount();
    }

    public int getMaxUsedServerRunnableCount() {
        return this.requestQueue.getMaxWorkingThreadsCount();
    }

    public int getMaxQueuedRequestsCount() {
        return this.requestQueue.getMaxQueuedRequestsCount();
    }

    final JCoMiddleware.ServerGroup getMiddlewareInterface() {
        return this.mwServerGroup;
    }

    RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(DefaultServerWorker listener) {
        List<DefaultServerWorker> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                DefaultServerManager srvManager = (DefaultServerManager)jcoRuntime.getJCoServerFactoryInstance();
                srvManager.addServer(this);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(DefaultServerWorker worker) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] JCoServer.removeListener() in " + Thread.currentThread().getName());
        }
        List<DefaultServerWorker> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(worker);
        }
        worker.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ServerConnection conn) {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] JCoServer.destroy() group [" + this.getServerKey() + ']');
        }
        List<ServerConnection> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() > 0) {
                throw new JCoRuntimeException(136, "The JCoServer can only be released if all workers are stopped [" + this.listeners.size() + " are still running]");
            }
        }
        list = this.requestQueue;
        synchronized (list) {
            while (this.requestQueue.size() > 0) {
                ServerConnection conn = this.requestQueue.remove(0);
                if (!conn.isValid()) continue;
                try {
                    conn.middlewareServer.abort(conn, "Request cannot be dispatched. All listeners are stopped by the application.");
                }
                catch (Exception exception) {}
            }
            this.requestQueue.notifyAll();
        }
        list = this.connections;
        synchronized (list) {
            while (!this.connections.isEmpty()) {
                this.closeConnection(this.connections.remove(this.connections.size() - 1));
            }
        }
    }

    void markDeleted() {
        this.configurationState = ConfigurationState.DELETED;
    }

    void markChanged() {
        this.configurationState = ConfigurationState.CHANGED;
    }

    @Override
    public boolean isValid() {
        return this.configurationState == ConfigurationState.VALID;
    }

    private void setState(JCoServerState newState) {
        if (this.state == newState) {
            return;
        }
        JCoServerState oldState = this.state;
        this.state = newState;
        this.fireServerStateChangeOccurred(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseRequestsInProcess() {
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            ++this.currentRequestsInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseRequestsInProcess() {
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            --this.currentRequestsInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerErrorListener(JCoServerErrorListener listener) {
        ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
        synchronized (objectList) {
            this.serverErrorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerExceptionListener(JCoServerExceptionListener listener) {
        ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
        synchronized (objectList) {
            this.serverExceptionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerStateChangedListener(JCoServerStateChangedListener listener) {
        ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
        synchronized (objectList) {
            this.serverStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerErrorListener(JCoServerErrorListener listener) {
        ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
        synchronized (objectList) {
            this.serverErrorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerExceptionListener(JCoServerExceptionListener listener) {
        ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
        synchronized (objectList) {
            this.serverExceptionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerStateChangedListener(JCoServerStateChangedListener listener) {
        ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
        synchronized (objectList) {
            this.serverStateChangedListeners.remove(listener);
        }
    }

    public void check() throws JCoException {
        this.serverManager.getNumServerConnections(this.properties);
    }

    static void checkProperties(Properties serverProperties) throws JCoException {
        String value = serverProperties.getProperty("jco.server.gwhost");
        if (value == null || value.trim().length() == 0) {
            throw new JCoException(101, "gateway host (jco.server.gwhost) is " + (value == null ? "null" : "empty"));
        }
        value = serverProperties.getProperty("jco.server.gwserv");
        if (value == null || value.trim().length() == 0) {
            throw new JCoException(101, "gateway service (jco.server.gwserv) is " + (value == null ? "null" : "empty"));
        }
        value = serverProperties.getProperty("jco.server.progid");
        if (value == null || value.trim().length() == 0) {
            throw new JCoException(101, "program ID (jco.server.progid) is " + (value == null ? "null" : "empty"));
        }
        value = serverProperties.getProperty("jco.server.snc_mode");
        if ("1".equals(value) && (value = serverProperties.getProperty("jco.server.snc_qop")) != null) {
            int qop = 0;
            try {
                qop = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new JCoException(101, "SNC QOP (jco.server.snc_qop) is not a number [" + value + "]");
            }
            if (qop < 1 || qop > 9) {
                throw new JCoException(101, "SNC QOP (jco.server.snc_qop) = " + qop + " is not in the valid range [1..9]");
            }
        }
        if ((value = serverProperties.getProperty("jco.server.connection_count")) != null) {
            int count = -1;
            try {
                count = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new JCoException(101, "connection count (jco.server.connection_count) is not a number [" + value + ']');
            }
            if (count < 0 || count > 100) {
                throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "invalid connection count (jco.server.connection_count) " + count + ". Valid range is [1..100], recommended value is 2");
            }
        }
        if ((value = serverProperties.getProperty("jco.server.max_startup_delay")) != null) {
            try {
                int maxDelay = Integer.parseInt(value);
                if (maxDelay < 0) {
                    throw new NumberFormatException("negative maximum startup delay is not allowed");
                }
            }
            catch (NumberFormatException ex) {
                throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "maximum startup delay  (jco.server.max_startup_delay) is not a number [" + value + ']');
            }
        }
    }

    protected void checkRuntimeConfiguration() throws JCoRuntimeException {
        StringBuilder error = new StringBuilder();
        if (this.callHandlerFactory == null) {
            error.append("call handler factory is null");
        } else if (!(this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory) && !(this.callHandlerFactory instanceof JCoServerRequestHandlerFactory)) {
            error.append("Unsupported type of call handler factory: ").append(this.callHandlerFactory.getClass().getName()).append(" is neither JCoServerFunctionHandlerFactory nor JCoServerRequestHandlerFactory");
        } else if (this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory && this.callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            error.append("not supported type of handler factory ").append(this.callHandlerFactory.getClass().getName()).append(" implements both JCoServerFunctionHandlerFactory and JCoServerRequestHandlerFactory");
        }
        if (this.jcoRepositoryBox == null) {
            if (error.length() > 0) {
                error.append(", ");
            }
            error.append("repository is not defined");
        }
        if (this.connectionCount < 1 || this.connectionCount > 100) {
            if (error.length() > 0) {
                error.append(", ");
            }
            error.append("connection count [").append(this.connectionCount).append("] is invalid (allowed range is [1..100])");
        }
        if (error.length() > 0) {
            error.insert(0, "Unable to start the server due to wrong configuration: ");
            JCoRuntimeException jre = new JCoRuntimeException(101, error.toString());
            if (Trace.isOn(4)) {
                StringBuilder trc = new StringBuilder(50);
                trc.append("[JCoAPI] JCoServer.start() on ").append(this.getServerKey()).append(", connection count ").append(this.connectionCount).append(". ");
                error.insert(0, trc);
                Trace.fireTrace(4, error.toString());
            }
            throw jre;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (Trace.isOn(4, true)) {
            Trace.fireTrace(4, "[JCoAPI] JCoServer.start() for server configuration " + this.name + " with key " + this.getServerKey() + " and connection count " + this.connectionCount);
        }
        if (this.configurationState != ConfigurationState.VALID) {
            StringBuilder buf = new StringBuilder(150).append("Server configuration ").append(this.name).append(" was ");
            buf.append(this.configurationState == ConfigurationState.CHANGED ? "changed. Please get an updated instance of the server from the JCoServerFactory." : "removed. Please check your configuration.");
            String msg = buf.toString();
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[JCoAPI] " + msg);
            }
            throw new JCoRuntimeException(181, "JCO_ERROR_SERVER_DATA_INVALID", msg);
        }
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            if (this.state != JCoServerState.STOPPED) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "JCoServer " + this.name + " is currently running. Current server state is " + this.state.toString());
            }
            this.checkRuntimeConfiguration();
            String serverKey = DefaultServerManager.computeGroupKey(this.properties);
            if (this.serverManager.isAvailable(serverKey)) {
                throw new JCoRuntimeException(106, "A JCoServer with the same configuration [" + serverKey + "] is already running");
            }
            this.setState(JCoServerState.STARTED);
            this.start(this.minWorkerCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(int count) {
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            for (int i = 0; i < count && this.state != JCoServerState.STOPPING && this.state != JCoServerState.STOPPED; ++i) {
                DefaultServerWorker worker = this.createServerWorkerInstance();
                worker.stopping = false;
                ++this.currentWorkerCount;
                this.addListener(worker);
                try {
                    this.runnableStarter.start(worker);
                    continue;
                }
                catch (Exception ex) {
                    --this.currentWorkerCount;
                    this.removeListener(worker);
                    this.fireServerExceptionOccurred(null, null, ex);
                    continue;
                }
                catch (Error e) {
                    --this.currentWorkerCount;
                    this.removeListener(worker);
                    this.fireServerErrorOccurred(null, null, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] JCoServer.stop() on [" + this.getServerKey() + ']');
        }
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            if (this.state == JCoServerState.STOPPED) {
                throw new JCoRuntimeException(136, "JCoServer " + this.name + " is already stopped or wasn't started yet");
            }
            if (this.state == JCoServerState.STOPPING) {
                throw new JCoRuntimeException(136, "JCoServer " + this.name + " is already stopping");
            }
            List<DefaultServerWorker> list = this.listeners;
            synchronized (list) {
                this.stop(this.currentWorkerCount);
            }
            this.setState(JCoServerState.STOPPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(int count) {
        RequestQueue requestQueue = this.getRequestQueue();
        synchronized (requestQueue) {
            List<DefaultServerWorker> list = this.listeners;
            synchronized (list) {
                int idx = this.listeners.size();
                while (--idx >= 0 && count > 0) {
                    DefaultServerWorker worker = this.listeners.get(idx);
                    if (worker.stopping) continue;
                    worker.stopping = true;
                    --count;
                    --this.currentWorkerCount;
                }
            }
        }
        this.requestQueue.notifyAllListeners();
    }

    @Override
    public void setConnectionCount(int count) {
        if (count < 1 || count > 100) {
            throw new JCoRuntimeException(131, "connection count argument value " + count + " is not in the valid range [1..100]; recommended value is 2");
        }
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] JCoServer.setConnectionCount(" + count + ')');
        }
        int workerCount = this.connectionCount = count;
        String workerCountValue = this.properties.getProperty("jco.server.worker_thread_count");
        if (workerCountValue != null) {
            workerCount = Integer.parseInt(workerCountValue);
            this.setWorkerCount(workerCount);
        } else if (workerCount > 0) {
            this.setWorkerCount(workerCount);
        }
        int workerCountMin = workerCount;
        String minWworkerCountValue = this.properties.getProperty("jco.server.worker_thread_min_count");
        if (minWworkerCountValue != null) {
            workerCountMin = Integer.parseInt(minWworkerCountValue);
            this.setMinWorkerCount(workerCountMin);
        } else if (workerCountMin > 0) {
            this.setMinWorkerCount(workerCountMin);
        }
    }

    public void setWorkerCount(int workerCount) {
        if (workerCount < 1 || workerCount > 100) {
            throw new JCoRuntimeException(131, "worker thread count argument value " + workerCount + " is not in the valid range [1..100]");
        }
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] JCoServer.setWorkerCount(" + workerCount + ')');
        }
        this.maxWorkerCount = workerCount;
        if (this.minWorkerCount > this.maxWorkerCount) {
            this.minWorkerCount = this.maxWorkerCount;
        }
    }

    public void setMinWorkerCount(int minimumWorkerCount) {
        if (minimumWorkerCount < 1 || minimumWorkerCount > this.maxWorkerCount) {
            throw new JCoRuntimeException(131, "minimum worker thread count argument value " + minimumWorkerCount + " is not in the valid range between 1 and the maximum worker thread count [1.." + this.maxWorkerCount + ']');
        }
        if (Trace.isOn(32)) {
            Trace.fireTrace(32, "[JCoAPI] JCoServer.setMinWorkerCount(" + minimumWorkerCount + ')');
        }
        this.minWorkerCount = minimumWorkerCount;
    }

    @Override
    public void release() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] JCoServer.release() on [" + this.getServerKey() + ']');
        }
    }

    public int getActualConnectionCount() {
        return this.connectionCount;
    }

    Properties getProperties() {
        return this.properties;
    }

    public boolean getTrace() {
        String value = this.properties.getProperty("jco.server.trace");
        return value != null && value.equals("1");
    }

    public void setTrace(boolean trace) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] JCoServer.setTrace(" + trace + "), current state " + this.getTrace());
        }
        if (this.getTrace() != trace) {
            this.properties.setProperty("jco.server.trace", trace ? "1" : "0");
            this.connParams = this.mwServerGroup.initialize(this.properties);
        }
    }

    private int getMaxStartupDelay() {
        return this.maxStartupDelay == -255 ? this.middleware.getMaxStartupDelay() : this.maxStartupDelay;
    }

    void dispatch(ServerConnection conn) {
        this.requestQueue.addRequest(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeConnectionDelta() {
        int delta;
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            int stateful = 0;
            Iterator<ServerConnection> it = this.connections.iterator();
            while (it.hasNext()) {
                if (it.next().getSessionId() == null) continue;
                ++stateful;
            }
            delta = this.connectionCount - (this.connections.size() - stateful);
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustConnectionCount() {
        block18: {
            if (this.state == JCoServerState.STOPPING) {
                this.releaseAndSetToStopped();
                return;
            }
            long now = System.currentTimeMillis();
            if (now > this.lastRegisterTime + (long)(this.startupDelay * 1000)) {
                try {
                    int delta = this.computeConnectionDelta();
                    this.lastRegisterTime = now;
                    if (delta > 0) {
                        this.openConnections(delta);
                    } else if (delta < 0) {
                        this.closeConnections(-delta);
                    }
                }
                catch (Exception ex) {
                    if (!Trace.isOn(2)) break block18;
                    Trace.fireTrace(2, "[JCoAPI] exception in adjustConnectionCount", ex);
                }
            }
        }
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            int niceToHave = this.currentRequestsInProcess - this.currentWorkerCount + 1;
            if (niceToHave > 0) {
                int couldBeStarted = this.maxWorkerCount - this.currentWorkerCount;
                if (couldBeStarted > niceToHave) {
                    this.start(niceToHave);
                } else {
                    this.start(couldBeStarted);
                }
            } else if (niceToHave < 0) {
                if (this.currentWorkerCount + niceToHave < this.minWorkerCount) {
                    if (this.currentWorkerCount > this.minWorkerCount) {
                        this.stop(this.currentWorkerCount - this.minWorkerCount);
                    }
                } else {
                    this.stop(-niceToHave);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseAndSetToStopped() {
        RequestQueue requestQueue = this.requestQueue;
        synchronized (requestQueue) {
            List<DefaultServerWorker> list = this.listeners;
            synchronized (list) {
                if (this.listeners.size() == 0) {
                    this.serverManager.releaseServer(this);
                    this.setState(JCoServerState.STOPPED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnections(int count) {
        ServerConnection conn = null;
        for (int i = 0; i < count; ++i) {
            conn = this.openConnection();
            if (conn.isValid()) {
                List<ServerConnection> list = this.connections;
                synchronized (list) {
                    conn.setThroughput(this.throughput);
                    this.connections.add(conn);
                }
                if (this.state != JCoServerState.STARTED && this.state != JCoServerState.DEAD) continue;
                if (this.state == JCoServerState.DEAD && Trace.isOn(2)) {
                    Trace.fireTrace(2, "Server is up and running again after more than one failed startup attempt");
                }
                this.setState(JCoServerState.ALIVE);
                continue;
            }
            if (this.startupDelay <= 0) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(int count) {
        ServerConnection conn = null;
        int i = 0;
        while (i < count) {
            List<ServerConnection> list = this.connections;
            synchronized (list) {
                conn = this.getFreeConnection(true);
            }
            if (conn != null) {
                list = this.connections;
                synchronized (list) {
                    this.closeConnection(conn);
                }
            } else {
                if (!Trace.isOn(2)) break;
                Trace.fireTrace(2, "[JCoAPI] Server group: cannot find free handle to disconnect");
                break;
            }
            ++count;
        }
    }

    private ServerConnection getFreeConnection(boolean remove) {
        ServerConnection conn = null;
        Iterator<ServerConnection> it = this.connections.iterator();
        while (it.hasNext()) {
            conn = it.next();
            if ((conn.state & 4) != 0 || conn.getSessionId() != null || this.requestQueue.indexOf(conn) != -1) continue;
            if (remove) {
                it.remove();
            }
            return conn;
        }
        return null;
    }

    private void closeConnection(ServerConnection conn) {
        try {
            conn.disconnect();
        }
        catch (Exception ex) {
            this.fireServerExceptionOccurred(null, conn, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerConnection openConnection() {
        String lastErrorMsg = null;
        ServerConnection conn = null;
        boolean tracingEnabled = true;
        try {
            conn = new ServerConnection(this);
            conn.accept();
            this.startupDelay = 0;
        }
        catch (JCoException ex) {
            switch (ex.getGroup()) {
                case 129: {
                    List<ServerConnection> list = this.connections;
                    synchronized (list) {
                        this.startupDelay = this.startupDelay == 0 ? 1 : this.startupDelay * 2;
                        this.maxStartupDelay = this.getMaxStartupDelay();
                        if (this.startupDelay > this.maxStartupDelay) {
                            this.startupDelay = this.maxStartupDelay;
                        }
                    }
                    ex = new JCoException(ex.getGroup(), ex.getKey(), "Server startup failed at " + new Date() + "." + JCoRuntime.CRLF + "This is caused by either a) erroneous server configuration, b) the backend system has been shutdown, or c) network problems." + (this.startupDelay > 0 ? " The next startup attempt will be done in " + this.startupDelay + (this.startupDelay == 1 ? " second." : " seconds.") : "") + JCoRuntime.CRLF + ex.getMessage(), (Throwable)ex);
                    this.fireServerExceptionOccurred(null, conn, (Exception)((Object)ex));
                    if (this.state == JCoServerState.STARTED || this.state == JCoServerState.ALIVE) {
                        this.setState(JCoServerState.DEAD);
                    }
                    if (this.startupDelay < 2) break;
                    tracingEnabled = false;
                    if (this.startupDelay != 2 || !Trace.isOn(2)) break;
                    Trace.fireTrace(2, "Server startup failed repeatedly; subsequent failures will not be traced");
                    break;
                }
                case 101: {
                    String message = "Server startup failed at " + new Date() + "." + JCoRuntime.CRLF + "This is caused by an erroneous server configuration. The server will be stopped." + JCoRuntime.CRLF + ex.getMessage();
                    if (Trace.isOn(2)) {
                        Trace.fireTrace(1, "[JCoAPI] " + message);
                    }
                    this.stop(1);
                    ex = new JCoException(ex.getGroup(), ex.getKey(), message);
                    this.fireServerExceptionOccurred(null, conn, (Exception)((Object)ex));
                    if (this.state == JCoServerState.STOPPED || this.state == JCoServerState.STOPPING) break;
                    this.setState(JCoServerState.STOPPING);
                    break;
                }
                default: {
                    this.startupDelay = 0;
                    this.fireServerExceptionOccurred(null, conn, (Exception)((Object)ex));
                }
            }
            lastErrorMsg = new StringBuffer(ex.getKey()).append(": ").append(ex.getMessage()).toString();
        }
        catch (Exception ex) {
            this.startupDelay = 0;
            this.fireServerExceptionOccurred(null, conn, ex);
            lastErrorMsg = ex.toString();
        }
        catch (Error err) {
            this.startupDelay = 0;
            this.fireServerErrorOccurred(null, conn, err);
            lastErrorMsg = err.toString();
        }
        finally {
            if (tracingEnabled && lastErrorMsg != null && Trace.isOn(2)) {
                Trace.fireTrace(2, "[JCoApi] JCoServer open connection failed: " + lastErrorMsg);
            }
        }
        return conn;
    }

    final void processQueuedRequests() {
        this.requestQueue.processQueuedRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            return this.connections.size() > 0;
        }
    }

    @Override
    public JCoServerState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ServerConnection[] conns;
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            conns = new ServerConnection[this.connections.size()];
            conns = this.connections.toArray(conns);
        }
        for (int i = 0; i < conns.length; ++i) {
            monitoredData.add(conns[i].getMonitoredData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCoServerMonitor getMonitor() {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            if (this.monitor == null) {
                this.monitor = new ServerMonitor();
            }
        }
        return this.monitor;
    }

    TenantContext getTenantContext() {
        return this.context;
    }

    @Override
    public String getTenant() {
        return JCoRuntimeFactory.getRuntime().getTenantContextManager().isDefaultContext(this.context) ? null : this.context.getTenant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerExceptionOccurred(DefaultServerWorker worker, ServerConnection conn, Exception exception) {
        if (this.serverExceptionListeners.size() > 0) {
            ObjectList<JCoServerExceptionListener> objectList = this.serverExceptionListeners;
            synchronized (objectList) {
                String connID = null;
                JCoServerContext context = null;
                try {
                    connID = conn != null ? conn.getConnectionId() : "[GENERAL]";
                    context = worker != null ? worker.getContext() : null;
                }
                catch (IllegalStateException ise) {
                }
                catch (Throwable th) {
                    Trace.fireTraceCritical("Error in JCoServer.fireServerExceptionOccurred()", th);
                }
                JCoServerExceptionListener listener = null;
                for (int i = 0; i < this.serverExceptionListeners.size(); ++i) {
                    listener = this.serverExceptionListeners.get(i);
                    try {
                        listener.serverExceptionOccurred(this, connID, context, exception);
                        continue;
                    }
                    catch (Throwable th) {
                        Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverExceptionOccurred()", th);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerErrorOccurred(DefaultServerWorker worker, ServerConnection conn, Error error) {
        if (this.serverErrorListeners.size() > 0) {
            ObjectList<JCoServerErrorListener> objectList = this.serverErrorListeners;
            synchronized (objectList) {
                String connID = conn != null ? conn.getConnectionId() : "[GENERAL]";
                for (int i = 0; i < this.serverErrorListeners.size(); ++i) {
                    JCoServerErrorListener listener = this.serverErrorListeners.get(i);
                    try {
                        listener.serverErrorOccurred(this, connID, worker != null ? worker.getContext() : null, error);
                        continue;
                    }
                    catch (Throwable th) {
                        Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverErrorOccurred()", th);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerStateChangeOccurred(JCoServerState oldState, JCoServerState newState) {
        block8: {
            try {
                if (this.serverStateChangedListeners.size() <= 0) break block8;
                ObjectList<JCoServerStateChangedListener> objectList = this.serverStateChangedListeners;
                synchronized (objectList) {
                    JCoServerStateChangedListener listener = null;
                    for (int i = 0; i < this.serverStateChangedListeners.size(); ++i) {
                        listener = this.serverStateChangedListeners.get(i);
                        try {
                            listener.serverStateChangeOccurred(this, oldState, newState);
                            continue;
                        }
                        catch (Throwable th) {
                            Trace.fireTraceCritical("Error in " + listener.getClass().getName() + ".serverStateChangeOccurred()", th);
                        }
                    }
                }
            }
            catch (Throwable th) {
                Trace.fireTraceCritical("Error in JCoServer.fireServerStateChangeOccurred()", th);
            }
        }
    }

    protected DefaultServerWorker createServerWorkerInstance() {
        return new DefaultServerWorker(this);
    }

    @Override
    public JCoServerCallHandlerFactory getCallHandlerFactory() {
        return this.callHandlerFactory;
    }

    @Override
    public JCoServerThreadStarter getServerThreadStarter() {
        return this.runnableStarter;
    }

    @Override
    public JCoServerSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public void setCallHandlerFactory(JCoServerCallHandlerFactory aCallHandlerFactory) {
        this.callHandlerFactory = aCallHandlerFactory;
    }

    @Override
    public void setRepository(JCoDestination destination) {
        if (this.jcoRepositoryBox == null) {
            this.jcoRepositoryBox = new JCoRepositoryMapBox(destination);
        } else {
            this.jcoRepositoryBox.setRepository(destination);
        }
    }

    @Override
    public void setRepository(JCoRepository repository) {
        if (this.jcoRepositoryBox == null) {
            this.jcoRepositoryBox = new JCoRepositoryMapBox(repository);
        } else {
            this.jcoRepositoryBox.setRepository(repository);
        }
    }

    @Override
    public void setRepository(String sid, String client, JCoDestination destination) throws JCoRuntimeException {
        if (sid != null) {
            sid = sid.trim();
        }
        if (sid == null || sid.length() != 3) {
            throw new JCoRuntimeException(101, "Illegal SID \"" + sid + "\" encountered in JCoServer.setRepository(sid, client, destination). SID must consist of exactly 3 characters.");
        }
        if (!(client == null || (client = client.trim()).length() == 3 && Character.isDigit(client.charAt(0)) && Character.isDigit(client.charAt(1)) && Character.isDigit(client.charAt(2)))) {
            throw new JCoRuntimeException(101, "Illegal client \"" + client + "\" encountered in JCoServer.setRepository(sid, client, destination). Client must consist of exactly 3 digits.");
        }
        String key = client == null ? sid : new StringBuilder(8).append(sid).append('(').append(client).append(')').toString();
        this.setRepositoryMappingRule(key, destination);
    }

    @Override
    public void setRepository(String sid, String client, JCoRepository repository) throws JCoRuntimeException {
        if (sid != null) {
            sid = sid.trim();
        }
        if (sid == null || sid.length() != 3) {
            throw new JCoRuntimeException(101, "Illegal SID \"" + sid + "\" encountered in JCoServer.setRepository(sid, client, repository). SID must consist of exactly 3 characters.");
        }
        if (!(client == null || (client = client.trim()).length() == 3 && Character.isDigit(client.charAt(0)) && Character.isDigit(client.charAt(1)) && Character.isDigit(client.charAt(2)))) {
            throw new JCoRuntimeException(101, "Illegal client \"" + client + "\" encountered in JCoServer.setRepository(sid, client, repository). Client must consist of exactly 3 digits.");
        }
        String key = client == null ? sid : new StringBuilder(8).append(sid).append('(').append(client).append(')').toString();
        this.setRepositoryMappingRule(key, repository);
    }

    private void setRepositoryMappingRule(String key, JCoDestination destination) {
        if (this.jcoRepositoryBox == null) {
            this.jcoRepositoryBox = new JCoRepositoryMapBox();
        }
        this.jcoRepositoryBox.setRepository(key, destination);
    }

    private void setRepositoryMappingRule(String key, JCoRepository repository) {
        if (this.jcoRepositoryBox == null) {
            this.jcoRepositoryBox = new JCoRepositoryMapBox();
        }
        this.jcoRepositoryBox.setRepository(key, repository);
    }

    @Override
    public JCoRepository getRepository() {
        return this.jcoRepositoryBox.getRepository();
    }

    @Override
    public JCoRepository getRepository(JCoServerContextInfo serverCtx) {
        return this.jcoRepositoryBox.getRepository(serverCtx);
    }

    @Override
    public void setServerThreadStarter(JCoServerThreadStarter starter) {
        this.runnableStarter = starter;
    }

    @Override
    public void setSecurityHandler(JCoServerSecurityHandler handler) {
        this.securityHandler = handler;
    }

    @Override
    public JCoServerTIDHandler getTIDHandler() {
        return this.tidHandler;
    }

    @Override
    public void setTIDHandler(JCoServerTIDHandler handler) {
        this.tidHandler = handler;
    }

    @Override
    public JCoServerUnitIDHandler getUnitIDHandler() {
        return this.unitIDHandler;
    }

    @Override
    public void setUnitIDHandler(JCoServerUnitIDHandler handler) {
        this.unitIDHandler = handler;
    }

    @Override
    public DefaultThroughput getThroughput() {
        return this.throughput;
    }

    @Override
    public void removeThroughput() {
        this.setThroughput(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThroughput(JCoThroughput aThroughput) {
        if (aThroughput == null) {
            this.throughput = null;
        } else if (aThroughput instanceof DefaultThroughput) {
            this.throughput = (DefaultThroughput)aThroughput;
        } else {
            throw new JCoRuntimeException(131, "Illegal instance passed to setThroughput - use JCo.createThroughput()");
        }
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            Iterator<ServerConnection> it = this.connections.iterator();
            while (it.hasNext()) {
                it.next().setThroughput(this.throughput);
            }
        }
    }

    public static class MappingRuleParser {
        private String currentDestination;
        private String systems;
        private SortedMap<Integer, String> rules = null;
        private Iterator<Integer> keyIterator;
        private Integer currentRuleNumber;
        private String currentRule;

        public static MappingRuleParser parse(Properties properties) throws JCoException {
            TreeMap<Integer, String> rules = null;
            boolean oneLineRule = false;
            boolean multiLineRule = false;
            for (String string : properties.keySet()) {
                if (!string.startsWith("jco.server.repository_map")) continue;
                if (rules == null) {
                    rules = new TreeMap<Integer, String>();
                }
                if ("jco.server.repository_map".length() < string.length()) {
                    if (oneLineRule) {
                        throw new JCoException(101, "Combination of repository mapping rules [" + string + "] and [" + "jco.server.repository_map" + "] is not allowed");
                    }
                    multiLineRule = true;
                    if (string.charAt("jco.server.repository_map".length()) != '.') {
                        throw new JCoException(101, "Illegal property key " + string + ". Expected jco.server.repository_map.<number>.");
                    }
                    String ruleNumber = string.substring("jco.server.repository_map".length() + 1).trim();
                    try {
                        rules.put(Integer.valueOf(ruleNumber), properties.getProperty(string));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new JCoException(101, "Unable to parse the repository rule [" + string + "]", (Throwable)nfe);
                    }
                }
                if (multiLineRule) {
                    throw new JCoException(101, "Combination of repository mapping rules [" + string + "] and [" + "jco.server.repository_map" + ".x] is not allowed");
                }
                oneLineRule = true;
                StringTokenizer stoken = new StringTokenizer(properties.getProperty(string), ";");
                int ruleIdx = 1;
                while (stoken.hasMoreTokens()) {
                    rules.put(new Integer(ruleIdx), stoken.nextToken());
                    ++ruleIdx;
                }
            }
            if (rules != null) {
                return new MappingRuleParser(rules);
            }
            return null;
        }

        private MappingRuleParser(SortedMap<Integer, String> rulesMap) {
            this.rules = rulesMap;
            this.keyIterator = rulesMap.keySet().iterator();
        }

        public boolean hasNextRule() {
            return this.keyIterator.hasNext();
        }

        public void nextRule() throws JCoException {
            Integer ruleNumber = this.keyIterator.next();
            this.currentRule = ((String)this.rules.get(ruleNumber)).trim();
            if (this.currentRuleNumber != null && ruleNumber - this.currentRuleNumber > 1) {
                throw new JCoException(101, "Missing repository rule with number " + (ruleNumber + 1) + ".");
            }
            this.currentRuleNumber = ruleNumber;
            try {
                int i = this.currentRule.indexOf(61);
                this.currentDestination = this.currentRule.substring(i + 1).trim();
                this.systems = this.currentRule.substring(0, i).trim();
            }
            catch (Exception exc) {
                throw new JCoException(101, "Unable to parse the repository rule " + this.currentRule, (Throwable)exc);
            }
        }

        public boolean hasNextSystem() {
            return this.systems != null && this.systems.length() > 0;
        }

        public String nextSystem() {
            String system;
            int i = this.systems.indexOf(44);
            if (i < 0) {
                system = this.systems.trim();
                this.systems = "";
            } else {
                system = this.systems.substring(0, i);
                this.systems = this.systems.substring(i + 1);
            }
            return system;
        }

        public String getCurrentDestination() {
            return this.currentDestination;
        }

        public String getCurrentRule() {
            return this.currentRule;
        }
    }

    public static class JCoRepositoryMapBox {
        private JCoRepositoryReference defaultRepoRef = null;
        private Map<String, JCoRepositoryReference> map = null;

        JCoRepositoryMapBox() {
        }

        JCoRepositoryMapBox(JCoDestination destination) {
            this.setRepository(destination);
        }

        JCoRepositoryMapBox(JCoRepository repository) {
            this.setRepository(repository);
        }

        public Map<String, JCoDestination> getDestinationMap() {
            HashMap<String, JCoDestination> destinations = new HashMap<String, JCoDestination>(this.size() * 4);
            JCoDestination dest = null;
            if (this.defaultRepoRef != null && (dest = this.defaultRepoRef.getDestination()) != null) {
                destinations.put(null, dest);
            }
            if (this.map != null) {
                for (String key : this.map.keySet()) {
                    dest = this.map.get(key).getDestination();
                    if (dest == null) continue;
                    destinations.put(key, dest);
                }
            }
            return destinations;
        }

        public JCoRepository getRepository() {
            if (this.defaultRepoRef == null) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, "[JCoAPI] No default repository reference found in repository box", true);
                }
                return null;
            }
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, "[JCoAPI] Using default repository reference " + this.defaultRepoRef);
            }
            return this.defaultRepoRef.getRepository();
        }

        public JCoRepository getRepository(JCoServerContextInfo ctx) {
            String callFrom;
            if (ctx == null) {
                return this.getRepository();
            }
            String sid = null;
            String client = null;
            if (this.map != null) {
                JCoRepositoryReference repoRef;
                sid = ctx.getConnectionAttributes().getSystemID();
                if (sid == null) {
                    sid = "EXTERN";
                }
                if ((client = ctx.getConnectionAttributes().getClient()) == null) {
                    client = "***";
                }
                if ((repoRef = this.map.get(new StringBuilder(11).append(sid).append('(').append(client).append(')').toString())) != null) {
                    if (Trace.isOn(64)) {
                        String callFrom2 = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                        Trace.fireTrace(64, "[JCoAPI] Using repository reference " + repoRef + " matching the SID " + sid + " and client " + client + " for the call from " + callFrom2);
                    }
                    return repoRef.getRepository();
                }
                repoRef = this.map.get(sid);
                if (repoRef != null) {
                    if (Trace.isOn(64)) {
                        String callFrom3 = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                        Trace.fireTrace(64, "[JCoAPI] Using repository reference " + repoRef + " matching the SID " + sid + " for the call from " + callFrom3);
                    }
                    return repoRef.getRepository();
                }
            }
            if (this.defaultRepoRef != null) {
                if (Trace.isOn(64)) {
                    if (sid == null) {
                        sid = ctx.getConnectionAttributes().getSystemID();
                        if (sid == null) {
                            sid = "EXTERN";
                        }
                        if ((client = ctx.getConnectionAttributes().getClient()) == null) {
                            client = "***";
                        }
                    }
                    callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
                    Trace.fireTrace(64, "[JCoAPI] Using default repository reference " + this.defaultRepoRef + " for the call from " + callFrom);
                }
                return this.defaultRepoRef.getRepository();
            }
            if (sid == null) {
                sid = ctx.getConnectionAttributes().getSystemID();
                if (sid == null) {
                    sid = "EXTERN";
                }
                if ((client = ctx.getConnectionAttributes().getClient()) == null) {
                    client = "***";
                }
            }
            callFrom = ctx.getConnectionAttributes().getPartnerHost() + "|" + sid + "|" + client;
            String error = "No repository reference found for the call from " + callFrom + " in " + this.mapToString();
            if (Trace.isOn(2)) {
                Trace.fireTrace(2, new StringBuilder(error.length() + 9).append("[JCoAPI] ").append(error).toString());
            }
            throw new JCoRuntimeException(101, error);
        }

        public void setRepository(JCoDestination destination) {
            if (destination == null) {
                this.defaultRepoRef = null;
            } else if (this.defaultRepoRef == null) {
                this.defaultRepoRef = new JCoRepositoryReference(destination);
            } else {
                this.defaultRepoRef.set(destination);
            }
        }

        public void setRepository(JCoRepository repository) {
            if (repository == null) {
                this.defaultRepoRef = null;
            } else if (this.defaultRepoRef == null) {
                this.defaultRepoRef = new JCoRepositoryReference(repository);
            } else {
                this.defaultRepoRef.set(repository);
            }
        }

        public void setRepository(String key, JCoDestination destination) throws JCoRuntimeException {
            if (key == null) {
                this.setRepository(destination);
                return;
            }
            if (destination != null) {
                JCoRepositoryReference removed;
                if (this.map == null) {
                    this.map = new Hashtable<String, JCoRepositoryReference>(11);
                }
                if ((removed = this.map.put(key, new JCoRepositoryReference(destination))) != null && Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] Repository reference " + removed + " was replaced by destination " + destination.getDestinationName() + " for system " + key, true);
                }
            } else {
                JCoRepositoryReference removed;
                JCoRepositoryReference jCoRepositoryReference = removed = this.map != null ? this.map.remove(key) : null;
                if (removed == null) {
                    throw new JCoRuntimeException(101, "Removal of repository reference for key " + key + " failed because it was not defined before in " + this.mapToString());
                }
                if (this.map.isEmpty()) {
                    this.map = null;
                }
            }
        }

        public void setRepository(String key, JCoRepository repository) throws JCoRuntimeException {
            if (key == null) {
                this.setRepository(repository);
                return;
            }
            if (repository != null) {
                JCoRepositoryReference removed;
                if (this.map == null) {
                    this.map = new Hashtable<String, JCoRepositoryReference>(11);
                }
                if ((removed = this.map.put(key, new JCoRepositoryReference(repository))) != null && Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] Repository reference " + removed + " was replaced by repository " + repository.getName() + " for system " + key, true);
                }
            } else {
                JCoRepositoryReference removed;
                JCoRepositoryReference jCoRepositoryReference = removed = this.map != null ? this.map.remove(key) : null;
                if (removed == null) {
                    throw new JCoRuntimeException(101, "Removal of repository reference for key " + key + " failed because it was not defined before in " + this.mapToString());
                }
                if (this.map.isEmpty()) {
                    this.map = null;
                }
            }
        }

        public boolean isEmpty() {
            return this.defaultRepoRef == null && this.map == null;
        }

        public int size() {
            return (this.defaultRepoRef == null ? 0 : 1) + (this.map == null ? 0 : this.map.size());
        }

        private String mapToString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("mapped repositories: { ");
            boolean first = true;
            if (this.defaultRepoRef != null) {
                first = false;
                buf.append("%%DEFAULT=").append(this.defaultRepoRef);
            }
            if (this.map != null) {
                for (String key : this.map.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key).append('=').append(this.map.get(key));
                }
            }
            buf.append(" }");
            return buf.toString();
        }

        public String toString() {
            return "JCoRepositoryMapBox for " + this.mapToString();
        }

        private class JCoRepositoryReference {
            private JCoDestination dest = null;
            private JCoRepository repo = null;
            private String tostring = null;

            JCoRepositoryReference(JCoDestination destination) {
                this.set(destination);
            }

            JCoRepositoryReference(JCoRepository repository) {
                this.set(repository);
            }

            JCoDestination getDestination() {
                return this.dest;
            }

            JCoRepository getRepository() {
                if (this.dest != null) {
                    if (!this.dest.isValid()) {
                        if (this.repo != null) {
                            this.repo = null;
                            this.tostring = null;
                        }
                        try {
                            JCoDestination newDest = JCoDestinationManager.getDestination((String)this.dest.getDestinationName());
                            if (newDest == null) {
                                throw new JCoRuntimeException(106, new StringBuilder(40 + this.tostring.length()).append("Failed to refresh repository reference ").append(this.toString()).toString());
                            }
                            this.dest = newDest;
                        }
                        catch (JCoException jex) {
                            throw new JCoRuntimeException(jex.getGroup(), jex.getKey(), new StringBuilder(40 + this.toString().length()).append("Failed to refresh repository reference ").append(this.toString()).toString(), (Throwable)jex);
                        }
                    }
                    if (this.repo != null) {
                        return this.repo;
                    }
                    try {
                        this.repo = this.dest.getRepository();
                        if (this.repo == null) {
                            throw new JCoRuntimeException(106, new StringBuilder(40 + this.toString().length()).append("Failed to resolve repository reference ").append(this.toString()).toString());
                        }
                        this.tostring = null;
                    }
                    catch (JCoException jex) {
                        throw new JCoRuntimeException(jex.getGroup(), jex.getKey(), new StringBuilder(40 + this.toString().length()).append("Failed to resolve repository reference ").append(this.toString()).toString(), (Throwable)jex);
                    }
                }
                return this.repo;
            }

            void set(JCoDestination destination) {
                this.dest = destination;
                this.repo = null;
                this.tostring = this.dest != null ? new StringBuilder(this.dest.getDestinationName().length() + 1).append('@').append(this.dest.getDestinationName()).toString() : "null";
            }

            void set(JCoRepository repository) {
                this.dest = null;
                this.repo = repository;
                this.tostring = this.repo != null ? new StringBuilder(this.repo.getName().length() + 1).append('=').append(this.repo.getName()).toString() : "null";
            }

            public String toString() {
                if (this.tostring == null) {
                    if (this.dest != null) {
                        if (this.repo != null) {
                            String name = this.repo.getName();
                            this.tostring = new StringBuilder(name.length() + 1).append('>').append(name).toString();
                        } else {
                            String name = this.dest.getDestinationName();
                            this.tostring = new StringBuilder(name.length() + 1).append('@').append(name).toString();
                        }
                    } else if (this.repo != null) {
                        String name = this.repo.getName();
                        this.tostring = new StringBuilder(name.length() + 1).append('=').append(name).toString();
                    } else {
                        this.tostring = "null";
                    }
                }
                return this.tostring;
            }
        }
    }

    class RequestQueue {
        private List<ServerConnection> queue = new LinkedList<ServerConnection>();
        private int maxQueuedRequests = 0;
        private int maxUsedThreadCount = 0;
        private int usedThreadCount = 0;

        RequestQueue() {
        }

        int getMaxQueuedRequestsCount() {
            return this.maxQueuedRequests;
        }

        int getMaxWorkingThreadsCount() {
            return this.maxUsedThreadCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequest(ServerConnection connRequest) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                this.queue.add(connRequest);
                if (this.queue.size() > this.maxQueuedRequests) {
                    this.maxQueuedRequests = this.queue.size();
                }
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAllListeners() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processQueuedRequest() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                int numRequests = this.queue.size();
                for (int i = 0; i < numRequests; ++i) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerConnection getRequest() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                if (this.queue.size() > 0) {
                    ServerConnection connRequestHandle = this.queue.remove(0);
                    ++this.usedThreadCount;
                    if (this.usedThreadCount > this.maxUsedThreadCount) {
                        this.maxUsedThreadCount = this.usedThreadCount;
                    }
                    return connRequestHandle;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerConnection remove(int i) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                return this.queue.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int indexOf(ServerConnection conn) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                return this.queue.indexOf(conn);
            }
        }

        int size() {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestFinished() {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                --this.usedThreadCount;
            }
        }

        int getUsedThreadCount() {
            return this.usedThreadCount;
        }
    }

    final class ServerMonitor
    implements JCoServerMonitor {
        ServerMonitor() {
        }

        @Override
        public String getServerName() {
            return DefaultServer.this.getServerName();
        }

        @Override
        public int getStatelessConnectionCount() {
            return DefaultServer.this.getConnectionCount();
        }

        @Override
        public int getCurrentConnectionCount() {
            return DefaultServer.this.getCurrentConnectionCount();
        }

        @Override
        public int getUsedServerThreadCount() {
            return DefaultServer.this.getRequestQueue().getUsedThreadCount();
        }

        @Override
        public int getServerThreadCount() {
            return DefaultServer.this.getServeRunnableCount();
        }

        @Override
        public int getCurrentServerThreadCount() {
            return DefaultServer.this.getCurrentServerRunnableCount();
        }

        @Override
        public int getMaximumUsedServerThreadCount() {
            return DefaultServer.this.getMaxUsedServerRunnableCount();
        }

        @Override
        public int getMaximumQueuedServerRequestsCount() {
            return DefaultServer.this.getMaxQueuedRequestsCount();
        }

        @Override
        public List<? extends JCoConnectionData> getConnectionsData() {
            ArrayList<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();
            DefaultServer.this.getMonitoredData(monitoredData);
            return monitoredData;
        }

        @Override
        public JCoServerState getState() {
            return DefaultServer.this.getState();
        }
    }

    static enum ConfigurationState {
        VALID,
        CHANGED,
        DELETED;

    }
}

