/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoResponse;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbstractSessionManager;
import com.sap.conn.jco.rt.CallbackHandler;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.DefaultResponse;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoApplicationAuthorizationException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerCallType;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerRunnable;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.server.JCoServerUnitIDHandler;

public class DefaultServerWorker
extends ServerWorker
implements JCoServerRunnable {
    static final AbstractSessionManager sessionManager = DefaultServer.jcoRuntime.getSessionManager();
    private static ThreadLocal<DefaultServerWorker> localWorker = new ThreadLocal();
    private static DenyTxHandler denyTxHandler = new DenyTxHandler();
    private CallbackHandler callbackHandler = new CallbackHandlerImpl();
    protected JCoServerSecurityHandler securityHandler;
    protected JCoServerTIDHandler tidManager = denyTxHandler;
    protected JCoServerUnitIDHandler unitIDHandler = denyTxHandler;
    protected JCoServerCallHandlerFactory callHandlerFactory;
    protected ServerContext ctx = new ServerContext();
    protected CallDispatcher callDispatcher;
    volatile boolean stopping = false;
    volatile Thread workerThread = null;
    private volatile SessionReferenceProvider sessionRefProvider = null;

    protected DefaultServerWorker(DefaultServer defaultServer) {
        JCoServerUnitIDHandler serverUnitIDHandler;
        this.server = defaultServer;
        this.securityHandler = this.server.getSecurityHandler();
        this.callHandlerFactory = this.server.getCallHandlerFactory();
        if (this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory) {
            this.callDispatcher = new FunctionDispatcher((JCoServerFunctionHandlerFactory)this.callHandlerFactory);
        } else if (this.callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            this.callDispatcher = new RequestDispatcher((JCoServerRequestHandlerFactory)this.callHandlerFactory);
        }
        JCoServerTIDHandler serverTIDHandler = this.server.getTIDHandler();
        if (serverTIDHandler != null) {
            this.tidManager = serverTIDHandler;
        }
        if ((serverUnitIDHandler = this.server.getUnitIDHandler()) != null) {
            this.unitIDHandler = serverUnitIDHandler;
        }
    }

    protected static DefaultServerWorker getThreadLocalServerWorker() {
        return localWorker.get();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public JCoServerContext getContext() throws IllegalStateException {
        ServerConnection serverConn = this.getConnection();
        if (serverConn == null || !serverConn.isValid()) {
            throw new IllegalStateException("Connection was not assigned or was already removed");
        }
        return this.ctx;
    }

    @Override
    protected void fireServerErrorOccurred(Error error) {
        this.server.fireServerErrorOccurred(this, this.conn, error);
    }

    @Override
    protected void fireServerExceptionOccurred(Exception exception) {
        this.server.fireServerExceptionOccurred(this, this.conn, exception);
    }

    @Override
    protected boolean checkAuthorization(String functionName, ServerAuthorizationData authData) {
        if (this.securityHandler != null) {
            try {
                this.securityHandler.checkAuthorization(this.ctx, functionName, authData);
            }
            catch (JCoApplicationAuthorizationException ae) {
                if (Trace.isOn(1, true)) {
                    Trace.fireTraceCritical("[JCoAPI] The application declines the authorization:", ae);
                }
                return false;
            }
            catch (Throwable th) {
                if (Trace.isOn(1, true)) {
                    Trace.fireTraceCritical("[JCoAPI] The security handler threw an error at checking an authorization request: ", th);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void dispatchRequest(JCoFunction function) throws AbapException, AbapClassException {
        try {
            localWorker.set(this);
            this.callDispatcher.handleRequest(this.ctx, function);
        }
        finally {
            localWorker.set(null);
        }
    }

    @Override
    protected JCoFunction getFunction(String functionName) throws JCoException {
        try {
            return this.callDispatcher.getFunction(this.ctx, functionName);
        }
        catch (RuntimeException ex) {
            this.fireServerExceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public JCoRepository getRepository() {
        return this.server.getRepository(this.ctx);
    }

    void destroy() {
        this.workerThread = null;
        this.conn = null;
        this.server = null;
    }

    @Override
    public Thread getThread() {
        return this.workerThread;
    }

    @Override
    protected boolean onCheckTID(String tid) {
        this.ctx.tid = tid;
        return this.tidManager.checkTID(this.ctx, tid);
    }

    @Override
    protected void onCommit(String tid) {
        this.ctx.tid = tid;
        this.tidManager.commit(this.ctx, tid);
    }

    @Override
    protected void onConfirmTID(String tid) {
        this.tidManager.confirmTID(this.ctx, tid);
    }

    @Override
    protected void onRollback(String tid) {
        this.ctx.tid = null;
        this.tidManager.rollback(this.ctx, tid);
    }

    @Override
    public void run() {
        this.workerThread = Thread.currentThread();
        this.loop();
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new StringBuilder(85).append("[JCoAPI] Leaving method ServerWorker.run() in thread ").append(Thread.currentThread().getName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void dispatch() throws JCoException {
        if (this.conn.connectionId == null) {
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, new StringBuilder(120).append("[JCoAPI] ServerWorker.dispatch() in thread ").append(this.workerThread.getName()).append(" waiting for handle initialization").toString());
            }
            ServerConnection serverConnection = this.conn;
            synchronized (serverConnection) {
                if (this.conn.connectionId == null) {
                    JCoException ex = new JCoException(133, "JCO_ERROR_INVALID_HANDLE", new StringBuilder(120).append("Handle [").append(this.conn.rfcHandle != null ? Long.toString(this.conn.rfcHandle.hrfc) : "null").append("] is uninitialized and cannot be dispatched in ServerWorker thread ").append(this.workerThread.getName()).toString());
                    this.fireServerExceptionOccurred((Exception)((Object)ex));
                    throw ex;
                }
            }
        }
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(100).append("[JCoAPI] ServerWorker.dispatch() in thread ").append(this.workerThread.getName()).append(" on handle [").append(this.conn.rfcHandle != null ? Long.valueOf(this.conn.rfcHandle.hrfc) : "null").append(']').toString());
        }
        String lastErrorMsg = null;
        try {
            this.conn.middlewareServer.listen(this);
            return;
        }
        catch (JCoException ex) {
            this.fireServerExceptionOccurred((Exception)((Object)ex));
            switch (ex.getGroup()) {
                case 104: {
                    lastErrorMsg = ex.getMessage();
                    return;
                }
                case 113: {
                    DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
                    synchronized (requestQueue) {
                        JCoServerState state = this.server.getState();
                        if (state != JCoServerState.STOPPING && state != JCoServerState.STOPPED) {
                            this.server.stop();
                        }
                    }
                    lastErrorMsg = ex.getMessage();
                    return;
                }
                case 102: {
                    lastErrorMsg = "COMMUNICATION_FAILURE " + ex.getMessage();
                    return;
                }
                default: {
                    lastErrorMsg = ex.getKey() + ": " + ex.getMessage();
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.fireServerExceptionOccurred(ex);
            lastErrorMsg = ex.toString();
            return;
        }
        catch (Error err) {
            this.fireServerErrorOccurred(err);
            lastErrorMsg = err.toString();
            return;
        }
        finally {
            block36: {
                if (lastErrorMsg != null && this.conn.isValid()) {
                    this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                    try {
                        this.abort(lastErrorMsg);
                    }
                    catch (Throwable t) {
                        if (!Trace.isOn(2, true)) break block36;
                        Trace.fireTrace(2, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loop() {
        while (!this.stopping) {
            this.conn = this.server.getRequestQueue().getRequest();
            if (this.conn == null) continue;
            try {
                this.dispatch();
            }
            catch (Throwable t) {
                Trace.fireTraceCritical("[JCoAPI] ServerWorker.dispatch() threw an exception:", t);
            }
            finally {
                this.server.getRequestQueue().requestFinished();
            }
        }
        this.server.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void abort(String message) throws JCoException {
        if (Trace.isOn(2, true)) {
            Trace.fireTrace(2, new StringBuilder(128).append("[JCoAPI] ServerWorker.abort(\"").append(message).append("\") on handle [").append(this.conn != null ? String.valueOf(this.conn.getConnectionHandle()) : "null").append(']').toString());
        }
        try {
            if (this.isValid()) {
                this.conn.middlewareServer.abort(this, message);
            }
        }
        finally {
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
        }
    }

    @Override
    void removeConnectionHandle() {
        this.conn.serverGroup.removeConnection(this.conn);
    }

    @Override
    final String callStartedInternal() {
        String currentSessionID = null;
        this.sessionRefProvider = sessionManager.getSessionReferenceProvider();
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(160).append("[JCoAPI] ServerWorker.callStartedInternal() uses SessionReferenceProvider: ").append(this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()).toString());
        }
        if (this.sessionRefProvider != null) {
            try {
                currentSessionID = this.conn.getSessionId();
                if (currentSessionID == null) {
                    JCoSessionReference ref = this.sessionRefProvider.jcoServerSessionStarted();
                    currentSessionID = ref != null ? ref.getID() : this.conn.getConversationID();
                } else {
                    this.sessionRefProvider.jcoServerSessionContinued(currentSessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(currentSessionID == null ? "jcoServerSessionStarted()" : "jcoServerSessionContinued()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(currentSessionID == null ? "jcoServerSessionStarted()" : "jcoServerSessionContinued()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            this.server.increaseRequestsInProcess();
        }
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, "[JCoAPI] ServerWorker.callStartedInternal() returns session ID " + currentSessionID);
        }
        return currentSessionID;
    }

    @Override
    final void callFinishedInternal(String currentSessionID) {
        if (Trace.isOn(64)) {
            Trace.fireTrace(64, new StringBuilder(160).append("[JCoAPI] ServerWorker.callFinishedInternal() uses cached SessionReferenceProvider: ").append(this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()).toString());
        }
        this.server.decreaseRequestsInProcess();
        if (this.sessionRefProvider != null) {
            String sessionID = this.conn.getSessionId();
            try {
                if (sessionID == null) {
                    this.sessionRefProvider.jcoServerSessionFinished(currentSessionID);
                } else {
                    this.sessionRefProvider.jcoServerSessionPassivated(sessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(sessionID == null ? "jcoServerSessionFinished()" : "jcoServerSessionPassivated()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(sessionID == null ? "jcoServerSessionFinished()" : "jcoServerSessionPassivated()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            this.sessionRefProvider = null;
        }
    }

    @Override
    protected void onSessionClose(String message, boolean error) {
        String sessionID;
        block16: {
            block15: {
                sessionID = this.conn.getSessionId();
                if (sessionID != null) {
                    if (this.sessionRefProvider == null) {
                        this.sessionRefProvider = sessionManager.getSessionReferenceProvider();
                    }
                    if (this.sessionRefProvider != null) {
                        try {
                            this.sessionRefProvider.jcoServerSessionContinued(sessionID);
                        }
                        catch (Throwable th) {
                            if (!Trace.isOn(2)) break block15;
                            Trace.fireTrace(2, "[JCoAPI] SessionReferenceProvider.jcoServerSessionContinued() threw an exception:", th);
                        }
                    }
                }
            }
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, "[JCoAPI] ServerWorker.onSessionClose(): session is closed");
            }
            try {
                this.callHandlerFactory.sessionClosed(this.ctx, message, error);
            }
            catch (Throwable th) {
                if (!Trace.isOn(2)) break block16;
                Trace.fireTrace(2, "[JCoAPI] sessionClosed() in ServerWorker.onSessionClose() threw an exception:", th);
            }
        }
        if (sessionID != null) {
            block17: {
                Context context = sessionManager.getRuntimeContext(sessionID, false);
                if (context != null) {
                    try {
                        context.setServerConnection(null);
                        sessionManager.releaseRuntimeContext(context);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(2)) break block17;
                        Trace.fireTrace(2, "[JCoAPI] releaseRuntimeContext() in ServerWorker.onSessionClose() threw an exception:", th);
                    }
                }
            }
            if (this.sessionRefProvider != null) {
                block18: {
                    try {
                        this.sessionRefProvider.jcoServerSessionFinished(sessionID);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(2)) break block18;
                        Trace.fireTrace(2, "[JCoAPI] SessionReferenceProvider.jcoServerSessionFinished() threw an exception:", th);
                    }
                }
                this.sessionRefProvider = null;
            }
        }
    }

    @Override
    void setState(byte state) {
        this.conn.state = state;
    }

    @Override
    byte getState() {
        return this.conn.state;
    }

    private static class DenyTxHandler
    implements JCoServerTIDHandler,
    JCoServerUnitIDHandler {
        private DenyTxHandler() {
        }

        @Override
        public boolean checkUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        @Override
        public void commit(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        @Override
        public void confirmUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        @Override
        public JCoFunctionUnitState getFunctionUnitState(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        @Override
        public void rollback(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        @Override
        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        @Override
        public void commit(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        @Override
        public void confirmTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        @Override
        public void rollback(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }
    }

    public class RequestDispatcher
    extends CallDispatcher {
        private JCoServerRequestHandlerFactory aFactory;

        public RequestDispatcher(JCoServerRequestHandlerFactory factory) {
            this.aFactory = factory;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected JCoServerRequestHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            JCoServerRequestHandler handler;
            block13: {
                block12: {
                    handler = null;
                    String errorMsg = null;
                    if (Trace.isOn(32)) {
                        Trace.fireTrace(32, new StringBuilder(125).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before getCallHandler()").toString());
                    }
                    try {
                        handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        if (errorMsg == null) break block12;
                    }
                    catch (RuntimeException re) {
                        try {
                            errorMsg = re.toString();
                            throw re;
                            catch (Error er) {
                                errorMsg = er.toString();
                                throw er;
                            }
                        }
                        catch (Throwable throwable) {
                            if (errorMsg != null) {
                                Trace.fireTrace(2, new StringBuilder(160).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]  getCallHandler() fails with: ").append(errorMsg).toString());
                                throw throwable;
                            }
                            if (!Trace.isOn(32)) throw throwable;
                            Trace.fireTrace(32, new StringBuilder(200).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                            throw throwable;
                        }
                    }
                    Trace.fireTrace(2, new StringBuilder(160).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]  getCallHandler() fails with: ").append(errorMsg).toString());
                    break block13;
                }
                if (Trace.isOn(32)) {
                    Trace.fireTrace(32, new StringBuilder(200).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuilder(180).append("The JCoServerRequestHandlerFactory ").append(this.aFactory.getClass().getName()).append(" returns null for function name ").append(function.getName()).toString());
            }
            if (Trace.isOn(32)) {
                StringBuilder buf = new StringBuilder(125).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before handleRequest()");
                if (Trace.isOn(8)) {
                    Trace.dumpFunction(buf, true, true, false, function);
                }
                Trace.fireTrace(32, buf.toString());
            }
            DefaultRequest request = new DefaultRequest(function);
            DefaultResponse response = request.getResponse();
            handler.handleRequest(serverCtx, request, response);
            if (!Trace.isOn(32)) return handler;
            StringBuilder buf = new StringBuilder(150).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after handleRequest() returns after ").append(System.currentTimeMillis() - DefaultServerWorker.this.conn.start_time).append(" ms");
            if (Trace.isOn(8)) {
                Trace.dumpFunction(buf, false, false, true, function);
            }
            Trace.fireTrace(32, buf.toString());
            return handler;
        }
    }

    public class FunctionDispatcher
    extends CallDispatcher {
        private JCoServerFunctionHandlerFactory aFactory;

        public FunctionDispatcher(JCoServerFunctionHandlerFactory factory) {
            this.aFactory = factory;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected JCoServerFunctionHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            StringBuilder buf;
            JCoServerFunctionHandler handler;
            block13: {
                block12: {
                    handler = null;
                    String errorMsg = null;
                    if (Trace.isOn(32)) {
                        Trace.fireTrace(32, new StringBuilder(125).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before getCallHandler()").toString());
                    }
                    try {
                        handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        if (errorMsg == null) break block12;
                    }
                    catch (RuntimeException re) {
                        try {
                            errorMsg = re.toString();
                            throw re;
                            catch (Error er) {
                                errorMsg = er.toString();
                                throw er;
                            }
                        }
                        catch (Throwable throwable) {
                            if (errorMsg != null) {
                                Trace.fireTrace(2, new StringBuilder(160).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                                throw throwable;
                            }
                            if (!Trace.isOn(32)) throw throwable;
                            Trace.fireTrace(32, new StringBuilder(200).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                            throw throwable;
                        }
                    }
                    Trace.fireTrace(2, new StringBuilder(160).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                    break block13;
                }
                if (Trace.isOn(32)) {
                    Trace.fireTrace(32, new StringBuilder(200).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuilder(180).append("The JCoServerFunctionHandlerFactory ").append(this.aFactory.getClass().getName()).append(" returns null for function name ").append(function.getName()).toString());
            }
            if (Trace.isOn(32)) {
                buf = new StringBuilder(125).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before handleRequest()");
                if (Trace.isOn(8)) {
                    Trace.dumpFunction(buf, true, true, false, function);
                }
                Trace.fireTrace(32, buf.toString());
            }
            handler.handleRequest(serverCtx, function);
            if (!Trace.isOn(32)) return handler;
            buf = new StringBuilder(150).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after handleRequest() returns after ").append(System.currentTimeMillis() - DefaultServerWorker.this.conn.start_time).append(" ms");
            if (Trace.isOn(8)) {
                Trace.dumpFunction(buf, false, false, true, function);
            }
            Trace.fireTrace(32, buf.toString());
            return handler;
        }
    }

    public abstract class CallDispatcher {
        protected CallDispatcher() {
        }

        protected CallDispatcher(JCoServerCallHandlerFactory factory) {
        }

        protected abstract Object handleRequest(JCoServerContext var1, JCoFunction var2) throws AbapException, AbapClassException;

        protected JCoFunction getFunction(JCoServerContext serverCtx, String functionName) throws JCoException {
            return DefaultServerWorker.this.server.getRepository(serverCtx).getFunction(functionName);
        }
    }

    final class BgRfcCallContext {
        AbapFunctionUnit.UnitIdentifier unitIdentifier = new AbapFunctionUnit.UnitIdentifier();
        JCoBackgroundUnitAttributes unitAttributes = null;

        BgRfcCallContext() {
        }
    }

    class ServerContext
    implements JCoServerContext {
        JCoServerCallType callType = JCoServerCallType.SYNCHRONOUS;
        BgRfcCallContext bgRfcCallCtx = new BgRfcCallContext();
        String tid;

        ServerContext() {
        }

        @Override
        public JCoAttributes getConnectionAttributes() {
            try {
                return DefaultServerWorker.this.conn.getAttributes();
            }
            catch (JCoException e) {
                if (Trace.isOn(2)) {
                    Trace.fireTrace(2, "[JCoAPI] ServerConnection.getAttributes() threw an exception: ", e);
                }
                return null;
            }
        }

        @Override
        public String getConnectionID() {
            return DefaultServerWorker.this.conn.getConnectionId();
        }

        @Override
        public JCoRepository getRepository() {
            return DefaultServerWorker.this.server.getRepository(this);
        }

        @Override
        public JCoServer getServer() {
            return DefaultServerWorker.this.server;
        }

        @Override
        public String getSessionID() {
            return DefaultServerWorker.this.conn.getSessionId();
        }

        @Override
        public String getTID() {
            return this.tid;
        }

        @Override
        public boolean isInTransaction() {
            return this.tid != null || this.bgRfcCallCtx.unitIdentifier.getType() != null;
        }

        @Override
        public JCoServerCallType getCallType() {
            return this.callType;
        }

        @Override
        public JCoUnitIdentifier getUnitIdentifier() {
            if (this.bgRfcCallCtx.unitIdentifier.getType() != null) {
                return this.bgRfcCallCtx.unitIdentifier;
            }
            return null;
        }

        public JCoBackgroundUnitAttributes getFunctionUnitAttributes() {
            if (this.getCallType() == JCoServerCallType.BACKGROUND_UNIT) {
                return this.bgRfcCallCtx.unitAttributes;
            }
            return null;
        }

        @Override
        public boolean isStatefulSession() {
            return this.getSessionID() != null;
        }

        @Override
        public void setStateful(boolean stateful) {
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, new StringBuilder(42).append("[JCoAPI] ServerContext.setStateful(").append(stateful).append(')').toString());
            }
            String connectionSessionId = DefaultServerWorker.this.conn.getSessionId();
            if (stateful && connectionSessionId == null) {
                String sessionID = null;
                JCoSessionReference sesRef = null;
                SessionReferenceProvider sesRefProvider = DefaultServerWorker.this.sessionRefProvider;
                if (sesRefProvider == null) {
                    sesRefProvider = sessionManager.getSessionReferenceProvider();
                }
                if (sesRefProvider != null) {
                    if (Trace.isOn(64)) {
                        Trace.fireTrace(64, new StringBuilder(120).append("[JCoAPI] Use ").append(sesRefProvider == DefaultServerWorker.this.sessionRefProvider ? "central" : "cached").append(" SessionReferenceProvider: ").append(sesRefProvider.getClass().getName()).toString());
                    }
                    try {
                        sesRef = sesRefProvider.getCurrentSessionReference(null);
                        if (sesRef == null) {
                            Trace.fireTraceCritical("[JCoAPI] SessionReferenceProvider.getCurrentSessionReference(null) returned null");
                        } else {
                            sessionID = sesRef.getID();
                        }
                    }
                    catch (Exception e) {
                        Trace.fireTraceCritical(new StringBuilder(85).append("[JCoAPI] ").append(sesRef == null ? "SessionReferenceProvider.getCurrentSessionReference(null)" : "JCoSessionReference().getID()").append(" threw an exception:").toString(), e);
                    }
                }
                if (sessionID == null) {
                    Trace.fireTraceCritical("[JCoAPI] The current session ID is null and the conversation ID will be used instead");
                    sessionID = DefaultServerWorker.this.conn.getConversationID();
                }
                DefaultServerWorker.this.conn.setSessionState(true, sessionID);
                Context context = sessionManager.getRuntimeContext(sessionID, true);
                context.setServerConnection(DefaultServerWorker.this.conn);
                if (sesRef != null) {
                    context.setSessionReference(sesRef, null);
                }
            } else if (!stateful && connectionSessionId != null) {
                Context context = sessionManager.getRuntimeContext(connectionSessionId, false);
                if (context != null) {
                    context.setServerConnection(null);
                }
                DefaultServerWorker.this.conn.setSessionState(false, connectionSessionId);
            }
        }
    }

    protected class CallbackHandlerImpl
    implements CallbackHandler {
        protected CallbackHandlerImpl() {
        }

        void checkState() {
            if ((DefaultServerWorker.this.conn.state & 4) == 0) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "CallbackHandler can be used only during request handling");
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void execute(JCoFunction function) throws JCoException {
            boolean isTaskMonitorOn;
            DefaultParameterList tablesParams;
            DefaultParameterList exportParams;
            DefaultParameterList changingParams;
            block36: {
                int i;
                int i22;
                this.checkState();
                long start_time_callback = System.currentTimeMillis();
                String name = function.getName();
                DefaultParameterList importParams = (DefaultParameterList)function.getImportParameterList();
                changingParams = (DefaultParameterList)function.getChangingParameterList();
                exportParams = (DefaultParameterList)function.getExportParameterList();
                tablesParams = (DefaultParameterList)function.getTableParameterList();
                isTaskMonitorOn = DefaultServer.jcoRuntime.isTaskMonitorOn();
                if (isTaskMonitorOn) {
                    DefaultServer.jcoRuntime.startTask(new StringBuilder(100).append("JCo executing ").append(name).append(" [").append(DefaultServerWorker.this.conn.attributes.sysid).append('|').append(DefaultServerWorker.this.conn.attributes.getPartnerHost()).append('|').append(DefaultServerWorker.this.conn.getConversationID()).append(']').toString());
                }
                if (importParams != null) {
                    importParams.checkIfInitialized();
                    for (i22 = 0; i22 < importParams.getMetaData().getFieldCount(); ++i22) {
                        if (importParams.isActive(i22) && importParams.isInitialized(i22)) continue;
                        int n = i22;
                        importParams.flags[n] = (byte)(importParams.flags[n] | 8);
                    }
                }
                if (tablesParams != null) {
                    for (i22 = 0; i22 < tablesParams.getMetaData().getFieldCount(); ++i22) {
                        if (tablesParams.isActive(i22)) continue;
                        int n = i22;
                        tablesParams.flags[n] = (byte)(tablesParams.flags[n] | 8);
                    }
                }
                if (changingParams != null) {
                    changingParams.checkIfInitialized();
                    for (i22 = 0; i22 < changingParams.getMetaData().getFieldCount(); ++i22) {
                        if (changingParams.isActive(i22) && changingParams.isInitialized(i22)) continue;
                        int n = i22;
                        changingParams.flags[n] = (byte)(changingParams.flags[n] | 8);
                    }
                }
                if (exportParams != null) {
                    for (i22 = 0; i22 < exportParams.getMetaData().getFieldCount(); ++i22) {
                        if (exportParams.isActive(i22)) continue;
                        int n = i22;
                        exportParams.flags[n] = (byte)(exportParams.flags[n] | 8);
                    }
                }
                try {
                    if (Trace.isOn(32)) {
                        StringBuilder buf = new StringBuilder(120).append("[JCoAPI] ServerWorker.execute(").append(name).append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("]");
                        if (Trace.isOn(8)) {
                            Trace.dumpFunction(buf, true, true, false, function);
                        }
                        Trace.fireTrace(32, buf.toString());
                    }
                    DefaultServerWorker.this.conn.middlewareServer.execute(DefaultServerWorker.this, name, importParams, tablesParams, changingParams, exportParams, ((AbapFunction)function).supportsASXML(), ((AbapFunction)function).getAbapClassExceptionMode());
                    if (Trace.isOn(32)) {
                        StringBuilder buf = new StringBuilder(200).append("[JCoAPI] ServerWorker.execute(").append(name).append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("] returns after ").append(System.currentTimeMillis() - start_time_callback).append(" ms");
                        if (Trace.isOn(8)) {
                            Trace.dumpFunction(buf, false, false, true, function);
                        }
                        Trace.fireTrace(32, buf.toString());
                    }
                    if (importParams == null) break block36;
                    i = 0;
                }
                catch (AbapException ex) {
                    try {
                        if (!Trace.isOn(4)) throw ex;
                        Trace.fireTrace(4, new StringBuilder(140).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw an ABAP exception: ").append(ex.toString()).toString());
                        throw ex;
                        catch (JCoException ex2) {
                            if (Trace.isOn(16)) {
                                Trace.fireTrace(2, new StringBuilder(90).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception:").toString(), ex2);
                                throw ex2;
                            }
                            if (!Trace.isOn(2)) throw ex2;
                            Trace.fireTrace(2, new StringBuilder(140).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception: ").append(ex2.toString()).toString());
                            throw ex2;
                        }
                        catch (Exception ex3) {
                            if (Trace.isOn(16)) {
                                Trace.fireTrace(2, new StringBuilder(90).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw an exception:").toString(), ex3);
                                throw new JCoException(108, "JCO_ERROR_INTERNAL", ex3.toString(), (Throwable)ex3);
                            }
                            if (!Trace.isOn(2)) throw new JCoException(108, "JCO_ERROR_INTERNAL", ex3.toString(), (Throwable)ex3);
                            Trace.fireTrace(2, new StringBuilder(140).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw an exception: ").append(ex3.toString()).toString());
                            throw new JCoException(108, "JCO_ERROR_INTERNAL", ex3.toString(), (Throwable)ex3);
                        }
                    }
                    catch (Throwable throwable) {
                        int i32;
                        if (importParams != null) {
                            i32 = 0;
                            while (i32 < importParams.getMetaData().getFieldCount()) {
                                int n = i32++;
                                importParams.flags[n] = (byte)(importParams.flags[n] & 0xFFFFFFF7);
                            }
                        }
                        if (tablesParams != null) {
                            i32 = 0;
                            while (i32 < tablesParams.getMetaData().getFieldCount()) {
                                int n = i32++;
                                tablesParams.flags[n] = (byte)(tablesParams.flags[n] & 0xFFFFFFF7);
                            }
                        }
                        if (changingParams != null) {
                            i32 = 0;
                            while (i32 < changingParams.getMetaData().getFieldCount()) {
                                int n = i32++;
                                changingParams.flags[n] = (byte)(changingParams.flags[n] & 0xFFFFFFF7);
                            }
                        }
                        if (exportParams != null) {
                            i32 = 0;
                            while (i32 < exportParams.getMetaData().getFieldCount()) {
                                int n = i32++;
                                exportParams.flags[n] = (byte)(exportParams.flags[n] & 0xFFFFFFF7);
                            }
                        }
                        if (!isTaskMonitorOn) throw throwable;
                        DefaultServer.jcoRuntime.endTask();
                        throw throwable;
                    }
                }
                while (i < importParams.getMetaData().getFieldCount()) {
                    int n = i++;
                    importParams.flags[n] = (byte)(importParams.flags[n] & 0xFFFFFFF7);
                }
            }
            if (tablesParams != null) {
                int i = 0;
                while (i < tablesParams.getMetaData().getFieldCount()) {
                    int n = i++;
                    tablesParams.flags[n] = (byte)(tablesParams.flags[n] & 0xFFFFFFF7);
                }
            }
            if (changingParams != null) {
                int i = 0;
                while (i < changingParams.getMetaData().getFieldCount()) {
                    int n = i++;
                    changingParams.flags[n] = (byte)(changingParams.flags[n] & 0xFFFFFFF7);
                }
            }
            if (exportParams != null) {
                int i = 0;
                while (i < exportParams.getMetaData().getFieldCount()) {
                    int n = i++;
                    exportParams.flags[n] = (byte)(exportParams.flags[n] & 0xFFFFFFF7);
                }
            }
            if (!isTaskMonitorOn) return;
            DefaultServer.jcoRuntime.endTask();
        }

        @Override
        public JCoResponse execute(JCoRequest request) throws JCoException {
            if (request == null) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "JCoRequest is null");
            }
            try {
                this.execute(((DefaultRequest)request).function);
                return ((DefaultRequest)request).getResponse();
            }
            catch (ClassCastException e) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unexpected JCoRequest type " + request.getClass().getName() + " detected");
            }
        }

        @Override
        public JCoFunction getFunction(String functionName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getFunction(functionName);
        }

        @Override
        public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getStructureDefinition(structureName);
        }
    }
}

