/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.DefaultSessionReferenceProvider;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionEventListener;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AbstractSessionManager;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.Trace;
import java.util.Map;

class DefaultSessionManager
extends AbstractSessionManager
implements SessionEventListener {
    private Map<String, Context> contexts = null;
    private boolean supportsEvents;

    DefaultSessionManager(Map<String, Context> contexts) {
        this.contexts = contexts;
        this.supportsEvents = false;
        DefaultSessionReferenceProvider referenceProvider = new DefaultSessionReferenceProvider();
        super.updateSessionRefProvider(referenceProvider);
        RuntimeEnvironment.setDefaultSessionReferenceProvider(referenceProvider);
    }

    @Override
    void startTimeoutChecker(JCoRuntime runtime) {
        SessionTimeoutChecker timeoutChecker = new SessionTimeoutChecker(this.contexts, true);
        this.setTimeoutChecker(timeoutChecker);
        timeoutChecker.setSessionEventsUsed(this.supportsEvents);
        runtime.startAutoJob(timeoutChecker);
    }

    @Override
    protected Context getRuntimeContext(String scopeType) {
        JCoSessionReference sessionRef = super.getSessionReferenceProvider().getCurrentSessionReference(scopeType);
        Context ctx = null;
        if (sessionRef != null) {
            ctx = this.contexts.get(sessionRef.getID());
            if (ctx != null) {
                ctx.setSessionReference(sessionRef, null);
            } else {
                ctx = new Context();
                ctx.setSessionReference(sessionRef, null);
                this.contexts.put(sessionRef.getID(), ctx);
            }
        } else {
            String msg = new StringBuilder(160).append("Session reference is null. SessionReferenceProvider: ").append(super.getSessionReferenceProvider().getClass().getName()).append(", scope type:").append(scopeType).toString();
            Trace.fireTraceCritical(new StringBuilder(msg.length() + 9).append("[JCoAPI] ").append(msg).toString(), true);
            throw new JCoRuntimeException(153, "JCO_ERROR_SESSION_REF_NOT_VALID", msg);
        }
        ctx.setLastAccess(System.currentTimeMillis());
        return ctx;
    }

    @Override
    protected Context getRuntimeContext(String sessionId, boolean create) {
        Context ctx = this.contexts.get(sessionId);
        if (ctx == null) {
            if (create) {
                ctx = new Context();
                ctx.setSessionID(sessionId);
                this.contexts.put(sessionId, ctx);
            }
        } else {
            ctx.setLastAccess(System.currentTimeMillis());
        }
        return ctx;
    }

    @Override
    protected void releaseRuntimeContext(Context ctx) {
        Context removed = null;
        if (ctx == null) {
            String sessionID;
            JCoSessionReference sessionRef = super.getSessionReferenceProvider().getCurrentSessionReference(null);
            if (sessionRef != null && (sessionID = sessionRef.getID()) != null) {
                removed = this.contexts.remove(sessionID);
            }
        } else {
            String sessionID = ctx.getSessionID();
            if (sessionID != null) {
                removed = this.contexts.remove(sessionID);
            }
            if (ctx != removed) {
                ctx.removeSessionReference();
                ctx.reset();
            }
        }
        if (removed != null) {
            removed.removeSessionReference();
            removed.reset();
        }
    }

    @Override
    void updateSessionRefProvider(SessionReferenceProvider provider) {
        super.updateSessionRefProvider(provider);
        if (super.getSessionReferenceProvider() == null) {
            super.updateSessionRefProvider(RuntimeEnvironment.getSessionReferenceProvider());
        }
        boolean oldSupportsEvents = this.supportsEvents;
        try {
            this.supportsEvents = provider.supportsEvents();
        }
        catch (AbstractMethodError ame) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[JCoAPI] A JCo 3.0 SessionReferenceProvider has been registered with DefaultSessionManager. " + "Hence, JCo can assume that there is no support for events in the implemntation of " + provider.getClass().getName());
            }
            this.supportsEvents = false;
        }
        if (this.supportsEvents) {
            provider.setSessionEventListener(this);
        }
        SessionTimeoutChecker timeoutChecker = this.getTimeoutChecker();
        if (oldSupportsEvents != this.supportsEvents && timeoutChecker != null) {
            timeoutChecker.setSessionEventsUsed(this.supportsEvents);
        }
    }

    @Override
    public void finished(String sessionID) {
        Context ctx;
        if (Trace.isOn(32, true)) {
            Trace.fireTrace(32, "[JCoAPI] DefaultSessionManager got event finished for session ID " + (sessionID == null ? "null" : sessionID));
        }
        if (sessionID != null && (ctx = this.contexts.remove(sessionID)) != null) {
            ctx.removeSessionReference();
            ctx.reset();
        }
    }
}

