/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultRecordFieldIterator;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.json.JSonParser;
import com.sap.conn.rfc.engine.RfcUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class DefaultTable
extends AbstractRecord
implements JCoTable {
    static final long serialVersionUID = 3000120080918L;
    protected static final int SAME_VALUE_IN_COLUMN = 16;
    protected boolean modified = false;
    protected boolean isOnlyModifiedInNgRfc = false;
    private boolean isFlatTable;
    private int row_capacity_increment = 0;
    private int row_capacity = 0;
    private int num_init_rows = 0;
    private char[] template_data = null;
    private Object[] template_odata = null;

    protected DefaultTable(JCoRecordMetaData metaData) {
        super(4, (JCoMetaData)metaData);
        this.isFlatTable = ((DefaultRecordMetaData)metaData).isFlat();
        int i = 0;
        while (i < this.metaData.numFields) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] | 1);
        }
    }

    protected DefaultTable(DefaultStructure value) {
        this(value.getRecordMetaData());
        this.appendRow();
        this.copyRaw(value);
    }

    public DefaultRecordMetaData getRecordMetaData() {
        return (DefaultRecordMetaData)this.metaData;
    }

    protected void copyContent(DefaultTable src) {
        this.row_capacity_increment = src.row_capacity_increment;
        super.copyContent(src);
        this.row_capacity = src.row_capacity;
        this.modified = src.modified;
        this.isOnlyModifiedInNgRfc = src.isOnlyModifiedInNgRfc;
        this.isFlatTable = src.isFlatTable;
        this.num_init_rows = src.numRows;
        if (src.template_data != null) {
            char[] cArray = this.template_data = src.rowLength > 0 ? (char[])src.template_data.clone() : JCoRuntime.EMPTY_CHAR_ARRAY;
        }
        if (src.template_odata != null) {
            this.template_odata = src.metaData.numOdata > 0 ? (Object[])src.template_odata.clone() : JCoRuntime.EMPTY_OBJ_ARRAY;
        }
    }

    protected static void copyRaw(DefaultStructure src, DefaultTable dest) {
        dest.copyRaw(src);
    }

    protected static void copyRaw(DefaultTable src, int srcrow, DefaultTable dest, int destrow) {
        if (srcrow < 0 || srcrow > src.numRows || destrow < 0 || destrow > dest.numRows) {
            throw new IllegalArgumentException("Illegal row number in source or destination table.");
        }
        int save_destrow = dest.row;
        dest.row = destrow;
        dest.copyRaw(src, srcrow);
        dest.row = save_destrow;
    }

    protected void copyRaw(DefaultStructure src) {
        this.copyRaw(src, 0);
    }

    private void copyRaw(AbstractRecord src, int srcrow) {
        int ioffset = this.metaData.boffset[0];
        int src_ioffset = src.metaData.boffset[0];
        if (src.rowLength > 0) {
            System.arraycopy(src.recType == 4 ? src.tableDataRows[srcrow] : src.data, src_ioffset, this.recType == 4 ? this.tableDataRows[this.row] : this.data, ioffset, this.rowLength);
        }
        if (src.metaData.numOdata > 0) {
            int src_offset = src.row * src.metaData.numOdata;
            for (int i = 0; i < src.metaData.numOdata; ++i) {
                Object o = src.odata[i + src_offset];
                if (o != null) {
                    if (o instanceof JCoRecord) {
                        o = ((AbstractRecord)o).clone();
                    } else if (o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[this.row * this.metaData.numOdata + i] = o;
            }
        }
        this.setModified();
        for (int i = 0; i < src.metaData.numFields; ++i) {
            if (src.isInitialized(i)) {
                this.setInitialized(i);
            }
            this.changeSameValueFlag(i, false);
        }
    }

    public void ensureBufferCapacity(int required_rows) {
        if (required_rows <= 0) {
            return;
        }
        if (this.num_init_rows >= required_rows) {
            return;
        }
        int old_row_capacity = this.row_capacity;
        if (this.row_capacity < required_rows) {
            if (this.row_capacity == 0) {
                this.row_capacity = Math.max(required_rows, 2);
            } else {
                this.row_capacity = this.row_capacity_increment <= 0 ? (int)((double)this.row_capacity * 1.2 + 10.0) : this.row_capacity_increment + this.row_capacity + 1;
                this.row_capacity = Math.max(required_rows, this.row_capacity);
            }
            Object[] old_odata = this.odata;
            char[][] old_tableDataRows = this.tableDataRows;
            if (this.metaData.numFields > 0) {
                this.rowLength = this.metaData.boffset[this.metaData.numFields - 1] + this.metaData.blength[this.metaData.numFields - 1];
            }
            try {
                int capacity = this.row_capacity * this.metaData.numOdata;
                if (this.odata == null || this.odata.length < capacity) {
                    this.odata = new Object[capacity];
                    if (old_odata != null && old_odata.length > 0) {
                        System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
                    }
                }
                if (this.rowLength > 0 && (this.tableDataRows == null || this.tableDataRows.length < this.row_capacity)) {
                    this.tableDataRows = new char[this.row_capacity][];
                    if (old_tableDataRows != null && old_tableDataRows.length > 0) {
                        System.arraycopy(old_tableDataRows, 0, this.tableDataRows, 0, old_tableDataRows.length);
                    }
                }
            }
            catch (Error error) {
                if (old_odata != null) {
                    this.odata = old_odata;
                }
                if (old_tableDataRows != null) {
                    this.tableDataRows = old_tableDataRows;
                }
                this.row_capacity = old_row_capacity;
                throw error;
            }
        }
        for (int irow = this.num_init_rows; irow < required_rows; ++irow) {
            this.initializeRow(irow);
        }
        this.num_init_rows = required_rows;
    }

    @Override
    protected void ensureBufferCapacity() {
        this.ensureBufferCapacity(this.numRows);
        if (this.flags.length < this.metaData.numFields) {
            byte[] newFlags = new byte[this.metaData.numFields];
            if (this.flags.length > 0) {
                System.arraycopy(this.flags, 0, newFlags, 0, this.flags.length);
            }
            this.flags = newFlags;
        }
    }

    @Override
    protected void initializeRow(int irow) {
        block10: {
            block9: {
                if (this.template_data != null) break block9;
                if (this.rowLength > 0) {
                    this.tableDataRows[irow] = new char[this.rowLength];
                }
                super.initializeRow(irow, null);
                char[] cArray = this.template_data = this.rowLength > 0 ? (char[])this.tableDataRows[irow].clone() : JCoRuntime.EMPTY_CHAR_ARRAY;
                if (this.metaData.numOdata <= 0) break block10;
                this.template_odata = new Object[this.metaData.numOdata];
                for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
                    Object template;
                    byte itype = this.metaData.type[ifield];
                    int idx = this.metaData.oindex[ifield];
                    if (idx <= -1 || (template = this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]]) == null) continue;
                    if ((itype == 17 || itype == 99) && template instanceof JCoRecord) {
                        this.template_odata[this.metaData.oindex[ifield]] = ((AbstractRecord)template).clone();
                        continue;
                    }
                    if (itype == 30 && template instanceof byte[]) {
                        this.template_odata[this.metaData.oindex[ifield]] = ((byte[])template).clone();
                        continue;
                    }
                    if (itype != 29) continue;
                    this.template_odata[this.metaData.oindex[ifield]] = template;
                }
                break block10;
            }
            if (this.rowLength > 0) {
                this.tableDataRows[irow] = (char[])this.template_data.clone();
            }
            if (this.metaData.numOdata > 0) {
                for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
                    Object template;
                    byte itype = this.metaData.type[ifield];
                    int idx = this.metaData.oindex[ifield];
                    if (idx <= -1 || (template = this.template_odata[this.metaData.oindex[ifield]]) == null) continue;
                    if ((itype == 17 || itype == 99) && template instanceof JCoRecord) {
                        this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = ((AbstractRecord)template).clone();
                        continue;
                    }
                    if (itype == 30 && template instanceof byte[]) {
                        this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = ((byte[])template).clone();
                        continue;
                    }
                    if (itype != 29) continue;
                    this.odata[irow * this.metaData.numOdata + this.metaData.oindex[ifield]] = template;
                }
            }
        }
    }

    public void trimToRows() {
        char[][] old_tableDataRows = null;
        Object[] old_odata = null;
        int capacity = this.numRows * this.metaData.numOdata;
        if (this.tableDataRows != null && this.tableDataRows.length > this.numRows) {
            old_tableDataRows = this.tableDataRows;
        }
        if (this.odata != null && this.odata.length > capacity) {
            old_odata = this.odata;
        }
        try {
            if (old_tableDataRows != null) {
                this.tableDataRows = new char[this.numRows][];
                System.arraycopy(old_tableDataRows, 0, this.tableDataRows, 0, this.numRows);
            }
            if (old_odata != null) {
                this.odata = new Object[capacity];
                System.arraycopy(old_odata, 0, this.odata, 0, capacity);
            }
            this.row_capacity = this.numRows;
        }
        catch (Error error) {
            if (old_tableDataRows != null) {
                this.tableDataRows = old_tableDataRows;
            }
            if (old_odata != null) {
                this.odata = old_odata;
            }
            throw error;
        }
    }

    @Override
    public boolean isInitialized(int index) {
        if (this.isFlatTable) {
            return super.isInitialized(index);
        }
        return this.modified;
    }

    public boolean isOnlyModifiedInNgRfc() {
        return this.isOnlyModifiedInNgRfc && this.isFlatTable;
    }

    public boolean isSameValue(int index) {
        if (this.isFlatTable) {
            return (this.flags[index] & 0x10) != 0;
        }
        return false;
    }

    @Override
    public void setEdited(int index) {
        this.setInitialized(index);
        this.setModified();
        this.changeSameValueFlag(index, false);
    }

    public void changeSameValueFlag(int index, boolean isSameValue) {
        if (this.isFlatTable) {
            if (isSameValue) {
                int n = index;
                this.flags[n] = (byte)(this.flags[n] | 0x10);
            } else {
                int n = index;
                this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFEF);
            }
        }
    }

    public void setModifiedWithoutOpcode() {
        this.modified = true;
    }

    public void setOnlyModifiedInNgrfc() {
        this.isOnlyModifiedInNgRfc = true;
    }

    private void setModified() {
        this.modified = true;
        this.isOnlyModifiedInNgRfc = false;
    }

    @Override
    public int copyFrom(JCoRecord source) {
        int n = super.copyFrom(source);
        this.setModified();
        return n;
    }

    public final boolean isEmpty() {
        return this.numRows == 0;
    }

    public final boolean isFirstRow() {
        return this.numRows > 0 && this.row == 0;
    }

    public final boolean isLastRow() {
        return this.numRows > 0 && this.row == this.numRows - 1;
    }

    public final int getNumRows() {
        return this.numRows;
    }

    public final int getNumColumns() {
        return this.metaData.numFields;
    }

    @Override
    public void clear() {
        if (this.numRows == 0) {
            return;
        }
        if (this.tableDataRows != null) {
            Arrays.fill((Object[])this.tableDataRows, null);
        }
        Arrays.fill(this.odata, null);
        this.num_init_rows = 0;
        this.numRows = 0;
        this.row = 0;
        this.setModified();
    }

    public void deleteAllRows() {
        this.clear();
    }

    public final void firstRow() {
        this.row = 0;
    }

    public final void lastRow() {
        this.row = this.numRows <= 0 ? 0 : this.numRows - 1;
    }

    public final boolean nextRow() {
        boolean eor;
        boolean bl = eor = ++this.row < this.numRows;
        if (this.row >= this.numRows) {
            this.row = this.numRows - 1;
        }
        return eor;
    }

    public final boolean previousRow() {
        boolean bor;
        boolean bl = bor = --this.row >= 0;
        if (this.row < 0) {
            this.row = 0;
        }
        return bor;
    }

    public final int getRow() {
        return this.row;
    }

    public void setRow(int pos) {
        this.row = pos;
        if (this.row < 0) {
            this.row = 0;
        } else if (this.row >= this.numRows) {
            this.row = this.numRows > 0 ? this.numRows - 1 : 0;
        }
    }

    public void appendRow() {
        this.appendRows(1);
    }

    public void appendRows(int rowCount) {
        if (rowCount < 1) {
            return;
        }
        this.row = this.numRows;
        this.ensureBufferCapacity(this.numRows + rowCount);
        this.numRows += rowCount;
        this.setModified();
    }

    public void insertRow(int pos) {
        pos = Math.min(Math.max(pos, 0), this.numRows);
        this.ensureBufferCapacity(this.numRows + 1);
        this.row = pos;
        if (pos < this.numRows) {
            char[] initial_row_data = null;
            Object[] initial_row_odata = null;
            if (this.rowLength > 0) {
                initial_row_data = this.tableDataRows[this.numRows];
            }
            if (this.metaData.numOdata > 0) {
                initial_row_odata = new Object[this.metaData.numOdata];
                System.arraycopy(this.odata, this.numRows * this.metaData.numOdata, initial_row_odata, 0, this.metaData.numOdata);
            }
            for (int irow = this.numRows; irow > pos; --irow) {
                if (this.rowLength > 0) {
                    this.tableDataRows[irow] = this.tableDataRows[irow - 1];
                }
                if (this.metaData.numOdata <= 0) continue;
                System.arraycopy(this.odata, (irow - 1) * this.metaData.numOdata, this.odata, irow * this.metaData.numOdata, this.metaData.numOdata);
            }
            if (this.rowLength > 0) {
                this.tableDataRows[pos] = initial_row_data;
            }
            if (this.metaData.numOdata > 0) {
                System.arraycopy(initial_row_odata, 0, this.odata, pos * this.metaData.numOdata, this.metaData.numOdata);
            }
        }
        ++this.numRows;
        this.setModified();
    }

    public void deleteRow() {
        this.deleteRow(this.row);
    }

    public void deleteRow(int pos) {
        int i;
        if (pos < 0 && pos >= this.numRows) {
            return;
        }
        for (i = pos + 1; i < this.num_init_rows; ++i) {
            if (this.rowLength > 0) {
                this.tableDataRows[i - 1] = this.tableDataRows[i];
            }
            if (this.metaData.numOdata <= 0) continue;
            System.arraycopy(this.odata, i * this.metaData.numOdata, this.odata, (i - 1) * this.metaData.numOdata, this.metaData.numOdata);
        }
        this.setModified();
        --this.num_init_rows;
        --this.numRows;
        this.row = Math.min(Math.max(this.row, 0), this.numRows - 1);
        if (this.rowLength > 0) {
            this.tableDataRows[this.num_init_rows] = null;
        }
        if (this.metaData.numOdata > 0) {
            for (i = 0; i < this.metaData.numOdata; ++i) {
                this.odata[i + this.num_init_rows * this.metaData.numOdata] = null;
            }
        }
    }

    public final boolean equalValuesInPrimitiveColumnNested(int columnIndex, List<Integer> indices, AbstractRecord actualRec) {
        while (this.nextRow()) {
            AbstractRecord tempRec = this.getNestedFieldRecord(indices, false);
            assert (indices.size() > 0);
            if (tempRec.equalsValuesInPrimitiveField(columnIndex, actualRec)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalValuesInPrimitiveColumn(int columnIndex) {
        int ioffset = this.metaData.boffset[columnIndex];
        int ilength = this.metaData.blength[columnIndex];
        char[] fixValue = this.tableDataRows[0];
        for (int i = 1; i < this.numRows; ++i) {
            char[] changingValue = this.tableDataRows[i];
            if (RfcUtilities.charArraySequenceEquals(fixValue, ioffset, changingValue, ioffset, ilength)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalValuesInStringColumnNested(int columnIndex, List<Integer> indices, String fixValue) {
        while (this.nextRow()) {
            AbstractRecord tempRec;
            String tempValue;
            if (!(fixValue == null ^ (tempValue = (tempRec = this.getNestedFieldRecord(indices, false)).decodeSTRING(columnIndex)) == null) && (fixValue == null || fixValue.equals(tempValue))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalValuesInStringColumn(int columnIndex) {
        String s_fixValue = (String)this.odata[this.metaData.oindex[columnIndex]];
        for (int i = 1; i < this.numRows; ++i) {
            String s_changingValue;
            if (!(s_fixValue == null ^ (s_changingValue = (String)this.odata[i * this.metaData.numOdata + this.metaData.oindex[columnIndex]]) == null) && (s_fixValue == null || s_fixValue.equals(s_changingValue))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalValuesInXStringColumnNested(int columnIndex, List<Integer> indices, byte[] fixValue) {
        while (this.nextRow()) {
            AbstractRecord tempRec = this.getNestedFieldRecord(indices, false);
            byte[] tempValue = tempRec.decodeXSTRING(columnIndex);
            if (Arrays.equals(fixValue, tempValue)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalValuesInXStringColumn(int columnIndex) {
        byte[] xs_fixValue = (byte[])this.odata[this.metaData.oindex[columnIndex]];
        for (int i = 1; i < this.numRows; ++i) {
            byte[] xs_changingValue = (byte[])this.odata[i * this.metaData.numOdata + this.metaData.oindex[columnIndex]];
            if (Arrays.equals(xs_fixValue, xs_changingValue)) continue;
            return false;
        }
        return true;
    }

    public final short posInPrimitiveValueListNested(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, List<Integer> indices, int[] tableDataRowIndices) {
        int rowSave = this.row;
        AbstractRecord savedRec = this.getNestedFieldRecord(indices, false);
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            this.setRow(tableDataRowIndices[i]);
            AbstractRecord tempRec = this.getNestedFieldRecord(indices, false);
            assert (indices.size() > 0);
            if (!tempRec.equalsValuesInPrimitiveField(columnIndex, savedRec)) continue;
            this.setRow(rowSave);
            return i;
        }
        this.setRow(rowSave);
        return -1;
    }

    public final short posInPrimitiveValueList(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, int[] tableDataRowIndices) {
        int ioffset = this.metaData.boffset[columnIndex];
        int ilength = this.metaData.blength[columnIndex];
        char[] fixValue = this.tableDataRows[rowIndexSavedRec];
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            char[] changingValue = this.tableDataRows[tableDataRowIndices[i]];
            if (!RfcUtilities.charArraySequenceEquals(fixValue, ioffset, changingValue, ioffset, ilength)) continue;
            return i;
        }
        return -1;
    }

    public final short posInStringValueListNested(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, List<Integer> indices, int[] tableDataRowIndices) {
        int rowSave = this.row;
        AbstractRecord savedRec = this.getNestedFieldRecord(indices, false);
        String fixValue = savedRec.decodeSTRING(columnIndex);
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            this.setRow(tableDataRowIndices[i]);
            AbstractRecord tempRec = this.getNestedFieldRecord(indices, false);
            String tempValue = tempRec.decodeSTRING(columnIndex);
            if ((fixValue != null || tempValue != null) && (fixValue == null || !fixValue.equals(tempValue))) continue;
            this.setRow(rowSave);
            return i;
        }
        this.setRow(rowSave);
        return -1;
    }

    public final short posInStringValueList(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, int[] tableDataRowIndices) {
        String s_fixValue = (String)this.odata[rowIndexSavedRec * this.metaData.numOdata + this.metaData.oindex[columnIndex]];
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            String s_changingValue = (String)this.odata[tableDataRowIndices[i] * this.metaData.numOdata + this.metaData.oindex[columnIndex]];
            if ((s_fixValue != null || s_changingValue != null) && (s_fixValue == null || !s_fixValue.equals(s_changingValue))) continue;
            return i;
        }
        return -1;
    }

    public final short posInXStringValueListNested(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, List<Integer> indices, int[] tableDataRowIndices) {
        int rowSave = this.row;
        AbstractRecord savedRec = this.getNestedFieldRecord(indices, false);
        byte[] fixValue = savedRec.decodeXSTRING(columnIndex);
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            this.setRow(tableDataRowIndices[i]);
            AbstractRecord tempRec = this.getNestedFieldRecord(indices, false);
            byte[] tempValue = tempRec.decodeXSTRING(columnIndex);
            if (!Arrays.equals(fixValue, tempValue)) continue;
            this.setRow(rowSave);
            return i;
        }
        this.setRow(rowSave);
        return -1;
    }

    public final short posInXStringValueList(int rowIndexSavedRec, int numRowsToCheck, int columnIndex, int[] tableDataRowIndices) {
        byte[] xs_fixValue = (byte[])this.odata[rowIndexSavedRec * this.metaData.numOdata + this.metaData.oindex[columnIndex]];
        for (short i = 0; i < numRowsToCheck; i = (short)(i + 1)) {
            byte[] xs_changingValue = (byte[])this.odata[tableDataRowIndices[i] * this.metaData.numOdata + this.metaData.oindex[columnIndex]];
            if (!Arrays.equals(xs_fixValue, xs_changingValue)) continue;
            return i;
        }
        return -1;
    }

    public JCoRecordFieldIterator getRecordFieldIterator() {
        return new DefaultRecordFieldIterator(this);
    }

    public static int getNestedTableFieldIndex(List<Integer> indices) {
        return indices.get(indices.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toJSONDocument(Writer writer) throws IOException {
        int saveRow = this.row;
        try {
            writer.write(91);
            for (int i = 0; i < this.numRows; ++i) {
                this.row = i;
                if (i > 0) {
                    writer.write(44);
                }
                super.toJSONDocument(writer);
            }
            writer.write(93);
        }
        finally {
            this.row = saveRow;
        }
    }

    @Override
    protected void readValuesFromJSON(JSonParser parser) {
        this.numRows = 0;
        try {
            parser.assertChar('[');
            this.row = 0;
            while (parser.nextNonBlankChar() != 93) {
                parser.undo();
                this.appendRow();
                if (this.row > 0) {
                    parser.assertChar(',');
                }
                super.readValuesFromJSON(parser);
            }
        }
        catch (IOException e) {
            Trace.fireTraceCritical("[JCoAPI] JCoRecord(DefaultTable).readValuesFromJSON(" + this.metaData.getName() + ") throws " + e.toString());
        }
    }
}

