/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.SerializationAwareVisitor;
import com.sap.conn.jco.rt.StructureParameter;
import com.sap.conn.rfc.api.SerializationAware;

public class FlatStructure
extends StructureParameter
implements SerializationAware {
    DefaultStructure structure;
    Converter converter;

    protected FlatStructure(JCoStructure structure, String name) {
        this((DefaultStructure)structure, name, 0, new byte[1]);
    }

    protected FlatStructure(DefaultStructure structure, String name) {
        this(structure, name, 0, new byte[1]);
    }

    public FlatStructure(DefaultStructure structure, String name, int index, byte[] flags) {
        this(structure, name, null, index, flags);
    }

    protected FlatStructure(DefaultStructure structure, String name, Converter converter, int index, byte[] flags) {
        super(name, index, flags);
        this.structure = structure;
        this.converter = converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public byte[] getBytes() {
        int padOffset;
        int i;
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.structure.metaData;
        byte[] ret = new byte[metaData.tabLength[this.converter.sendCodepageType]];
        block10: for (i = 0; i < metaData.numFields; ++i) {
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 40: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    this.converter.decodeNumber(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 23: 
                case 24: {
                    this.converter.decodeDecNumber(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
            }
        }
        if ((padOffset = metaData.offset[this.converter.sendCodepageType][--i] + metaData.length[this.converter.sendCodepageType][i]) < ret.length) {
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.padSpaces(ret, padOffset);
                    break;
                }
                case 6: {
                    this.converter.padZeros(ret, padOffset);
                    break;
                }
            }
        }
        return ret;
    }

    @Override
    public void setBytes(byte[] rfcBytes) {
        int offset;
        int i;
        this.structure.ensureBufferCapacity();
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.structure.metaData;
        int numFields = metaData.computeFieldNumber(rfcBytes.length, this.converter.receiveCodepageType);
        for (i = 0; i < numFields; ++i) {
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 40: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    this.converter.encodeNumber(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 23: 
                case 24: {
                    this.converter.encodeDecNumber(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
            }
            this.structure.setInitialized(i);
        }
        if (i < metaData.numFields && (offset = metaData.offset[this.converter.receiveCodepageType][i]) < rfcBytes.length) {
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
            }
            this.structure.setInitialized(i);
        }
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
    }

    @Override
    public int getNumBytes() {
        return ((DefaultRecordMetaData)this.structure.metaData).tabLength[this.converter.sendCodepageType];
    }

    public DefaultStructure getStructure() {
        return this.structure;
    }

    void setStructure(DefaultStructure structure) {
        this.structure = structure;
    }

    @Override
    public void accept(SerializationAwareVisitor v) {
        v.visit(this);
    }
}

