/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;
import java.util.Set;

public abstract class JCoMiddleware {
    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    protected int getMaxStartupDelay() {
        return 3600;
    }

    public abstract Client getClientInterface();

    public abstract Server getServerInterface();

    public abstract ServerGroup getListenerGroupInterface();

    public abstract Dispatcher getDispatcherInterface();

    protected abstract JCoException generateJCoException(RfcException var1);

    class CallContext {
        BgRfcUnit bgRfcUnit;
        String tid24;
        byte[] unitIdBytes;
        Set<String> queueSet;
        String queueName;
        AbstractConnection conn;
        RepositoryProvider repositoryProvider;

        CallContext() {
        }

        void reset(AbstractConnection connection) {
            this.conn = connection;
            this.tid24 = null;
            this.unitIdBytes = null;
            this.queueSet = null;
            this.queueName = null;
        }

        void startBgRfcUnit(AbapFunctionUnit unit) {
            this.unitIdBytes = unit.guid;
            this.queueSet = unit.queueSet;
            this.bgRfcUnit = this.conn.rfcHandle.RfcStartBgRfcUnit(this.unitIdBytes);
            this.bgRfcUnit.setQueueNames(unit.queueSet);
            this.bgRfcUnit.setAttributes(unit.unitAttributes);
        }

        void startQRfc(String tid, String queue) {
            this.tid24 = tid;
            this.queueName = queue;
        }

        boolean isTRfc() throws JCoException {
            if (this.tid24 != null) {
                if (this.tid24.length() > 24) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of TID encountered [" + this.tid24 + "]");
                }
                return true;
            }
            if (this.queueName != null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "TID is null, even though queuename [" + this.queueName + "] has been provided");
            }
            return false;
        }

        boolean isBgRfc() throws JCoException {
            if (this.unitIdBytes != null) {
                if (this.unitIdBytes.length != 16) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of unit GUID encountered [" + Codecs.Hex.encode(this.unitIdBytes) + "]");
                }
                return true;
            }
            if (this.queueSet != null && !this.queueSet.isEmpty()) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unit GUID is null even though a non-empty queue set has been provided");
            }
            return false;
        }

        boolean isQRfc() throws JCoException {
            if (this.queueName != null) {
                if (this.queueName.length() > 24) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of queue name encountered [" + this.queueName + "]");
                }
                return true;
            }
            return false;
        }

        boolean isTransactional() throws JCoException {
            return this.isTRfc() || this.isBgRfc();
        }

        public void commit() throws JCoException {
            if (this.bgRfcUnit != null) {
                try {
                    this.conn.rfcHandle.RfcCommit(this.bgRfcUnit, this.repositoryProvider);
                }
                catch (RfcException re) {
                    throw JCoMiddleware.this.generateJCoException(re);
                }
            }
        }
    }

    public static interface Server
    extends Connection {
        public static final String JCO_GROUP_KEY = "jco.server.group_key";
        public static final String JCO_SERVER_NAME = "jco.server.name";
        public static final String JCO_SERVER_APPLICATION = "jco.server.application";

        public void accept(ServerConnection var1) throws JCoException;

        public void listen(ServerWorker var1) throws JCoException;

        public void abort(ServerWorker var1, String var2) throws JCoException;

        public void disconnect(ServerConnection var1);

        public void getAttributes(ServerConnection var1) throws JCoException;

        public String createSessionId(ServerConnection var1);

        public void execute(ServerWorker var1, String var2, DefaultParameterList var3, DefaultParameterList var4, DefaultParameterList var5, DefaultParameterList var6, boolean var7, AbapClassException.Mode var8) throws JCoException;
    }

    public static abstract class Dispatcher {
        public static final int RC_RETRY_LISTEN = 0;
        public static final int RC_DISPATCH_CALL = 1;

        protected abstract int waitForRequest(int var1);

        protected abstract ServerConnection getNextListener();

        public abstract int getNumServerConnections(Properties var1) throws JCoException;
    }

    public static interface ServerGroup {
        public String initialize(Properties var1);

        public Object getAcceptParameters();
    }

    public static interface Client
    extends Connection {
        public static final String JCO_PRINCIPAL_NAME = "jco.client.principal_name";
        public static final String JCO_CLOUD_CONNECTOR_VERSION = "jco.client.cloud_connector_version";
        public static final String JCO_CLOUD_CONNECTOR_LOCATION_ID = "jco.client.cloud_connector_location_id";
        public static final String JCO_DESTINATION = "jco.client.destination";

        public void connect(ClientConnection var1) throws JCoException;

        public void initialize(Properties var1) throws JCoException;

        public void abort(ClientConnection var1, String var2) throws JCoException;

        public void reset(ClientConnection var1) throws JCoException;

        public void getAttributes(ClientConnection var1) throws JCoException;

        public CallContext getCallContext(ClientConnection var1) throws JCoException;

        public void execute(ClientConnection var1, String var2, DefaultParameterList var3, DefaultParameterList var4, DefaultParameterList var5, DefaultParameterList var6, boolean var7, AbapClassException.Mode var8) throws JCoException;

        public void ping(ClientConnection var1) throws JCoException;

        public void confirmTID(ClientConnection var1, String var2) throws JCoException;

        public void confirmUnitID(ClientConnection var1, JCoUnitIdentifier var2) throws JCoException;

        public String createTID(ClientConnection var1) throws JCoException;

        public Object getConnectionState(ClientConnection var1) throws JCoException;

        public void restoreConnection(ClientConnection var1, Object var2) throws JCoException;

        public void free(ClientConnection var1);

        @Override
        public Client createCopy();

        public boolean isPartnerReachable(ClientConnection var1);
    }

    public static interface Connection {
        public void releaseHandle(AbstractConnection var1);

        public boolean isAlive(AbstractConnection var1);

        public void disconnect(AbstractConnection var1) throws JCoException;

        public void abort(AbstractConnection var1, String var2) throws JCoException;

        public void cancel(AbstractConnection var1) throws JCoException;

        public Connection createCopy();
    }
}

