/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoFunctionUnit;
import com.sap.conn.jco.JCoInterface;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRepositoryQueryResult;
import com.sap.conn.jco.JCoRequestUnit;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.JCoThroughput;
import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.MessageServerDataProvider;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.ext.TenantProvider;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapBackgroundUnitAttributes;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.AbapRequestUnit;
import com.sap.conn.jco.rt.AbstractServerManager;
import com.sap.conn.jco.rt.AbstractSessionManager;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.ConnectionMonitor;
import com.sap.conn.jco.rt.CustomRepository;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.DefaultThroughput;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.TenantContextManager;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Dsr;
import com.sap.conn.jco.util.Jarm;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.GUID;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.SecretKey;

public abstract class JCoRuntime
extends JCoInterface {
    static final String VERSION = "3.1.1.22 (2018-09-28) for SAP Cloud Platform";
    static final String JCO_TRACE_LEVEL = "jco.trace_level";
    static final String JCO_TRACE_PATH = "jco.trace_path";
    static final String JCO_LIBRARY = "jco.library";
    public static final String JCO_JARM = "jco.jarm";
    public static final String JCO_JDSR = "jco.jdsr";
    static final String JCO_JDSR_COMP_NAME = "jco.jdsr.comp_name";
    static final String JCO_SESSION_TIMEOUT = "jco.session_timeout";
    static final String JCO_SESSION_TIMEOUT_CHECK_INTERVAL = "jco.session_timeout.check_interval";
    static final String JCO_JDSR_PROVIDER = "jco.jdsr_provider";
    static final String JCO_IGNORE_JDSR_PROVIDER_ERROR = "jco.ignore_jdsr_error";
    static final String JCO_AUTHORIZATION_TRACING = "jco.authorization_tracing";
    static final String JCO_CPIC_MAX_CONV = "jco.cpic_maxconv";
    static final String JCO_CPIC_KEEP_ALIVE_PERIOD = "jco.cpic_keep_alive_period";
    static final String JCO_CPIC_KEEP_ALIVE_TIMEOUT = "jco.cpic_keep_alive_timeout";
    static final String JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT = "jco.cpic_keep_alive_reply_timeou";
    static final String JCO_NI_DNS_NEGATIVE_CACHE_TTL = "jco.ni.dnscache.negative.ttl";
    static final String JCO_NI_DNS_CACHE_TTL = "jco.ni.dnscache.ttl";
    static final String JCO_NI_LOCAL_ADDRESS = "jco.ni.local_address";
    static final String CPIC_TRACE = "cpic.trace";
    static final String CPIC_TRACE_MAXFILESIZE = "cpic.trace.maxfilesize";
    static final String CPIC_TRACE_ACCEPT_REMOTE_ACTIVATION = "cpic.trace.accept_remote_activation";
    static final String JRFC_TRACE = "jrfc.trace";
    static final String JRFC_TRACE_PATH = "jrfc.trace_path";
    static final String JRFC_CLIENT_CONNECT_TIMEOUT = "jrfc.client_connect_timeout";
    static final String JCO_ALLOW_NON_ABAP_PARTNER = "jco.allow_non_abap_partner";
    static final String JCO_DELTA_MANAGEMENT = "jco.delta_management";
    static final String JCO_PROGRAM_NAME = "jco.program_name";
    static final String JCO_TRACE_FORMAT = "jco.trace.format";
    static final String JCO_SOCKET_FACTORY = "jco.socket.factory";
    static final String JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION = "jco.use_repository_roundtrip_optimization";
    static final String JRFC_LOGFILE_MAXSIZE = "jrfc.logfile.maxsize";
    static final String JRFC_LOGFILE_MAXBACKUPS = "jrfc.logfile.maxbackups";
    static final int JRFC_MINIMAL_TOTAL_SPACE = 20;
    private int jcoMode = 0;
    String tracingMethod = "jco";
    static final int MONITOR_JARM = 1;
    static final int MONITOR_JDSR = 2;
    static final int MONITOR_JDSR_PROVIDER = 4;
    static final int MONITOR_ON = 7;
    static final int JCO_IGNORE_JDSR_ERROR = 16;
    static final int NI_MAX_EXPIRE_TIME = 86400;
    public static final String CRLF = System.getProperty("line.separator");
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    public static final String[] EMPTY_STR_ARRAY = new String[0];
    public static final Serializable[] EMPTY_SER_ARRAY = new Serializable[0];
    public static final String EMPTY_STRING = "";
    public static final byte[] DECF16_ZERO = JCoRuntime.createZeroDecFloat(DecFloatType.DECFLOAT16_BE);
    public static final byte[] DECF34_ZERO = JCoRuntime.createZeroDecFloat(DecFloatType.DECFLOAT34_BE);
    protected static Properties properties = new Properties();
    private static boolean isNonAbapPartnerAllowed = false;
    static boolean authorizationTracingEnabled = true;
    static boolean nativeLibraryLoadFailure = false;
    static String nativeLibraryPath;
    static String nativeLibraryVersionInfo;
    static ThreadGroup jcoThreadGroup;
    int cpicTraceLevel = -1;
    AbstractSessionManager sessionManager = null;
    JCoMiddleware middlewareInstance = null;
    TenantContextManager tenantManager = null;

    JCoRuntime() {
    }

    public static boolean isNonAbapPartnerAllowed() {
        return isNonAbapPartnerAllowed;
    }

    protected abstract void initialize();

    protected abstract DefaultDestinationManager getDestinationManager();

    abstract AbstractSessionManager getSessionManager();

    protected JCoMiddleware getMiddlewareInstance() {
        return this.middlewareInstance;
    }

    public String getVersion() {
        if (Trace.isOn(4, true)) {
            Trace.fireTrace(4, "JCo version 3.1.1.22 (2018-09-28) for SAP Cloud Platform");
        }
        return VERSION;
    }

    static String getRuntimeVersion() {
        return VERSION;
    }

    protected void readSystemProperties() {
        block2: {
            try {
                this.setSystemProperty(JCO_TRACE_PATH, null);
                this.setSystemProperty(JCO_TRACE_LEVEL, null);
                this.setSystemProperty(JCO_JARM, "0");
                this.setSystemProperty(JCO_JDSR, "0");
                this.setSystemProperty(JCO_JDSR_PROVIDER, "0");
                this.setSystemProperty(JCO_IGNORE_JDSR_PROVIDER_ERROR, "1");
                this.setSystemProperty(JRFC_TRACE_PATH, null);
                this.setSystemProperty(CPIC_TRACE_MAXFILESIZE, "1024");
                this.setSystemProperty(CPIC_TRACE_ACCEPT_REMOTE_ACTIVATION, null);
                this.setSystemProperty(CPIC_TRACE, null);
                this.setSystemProperty(JRFC_TRACE, null);
                this.setSystemProperty(JRFC_LOGFILE_MAXSIZE, String.valueOf(8));
                this.setSystemProperty(JRFC_LOGFILE_MAXBACKUPS, String.valueOf(-1));
                this.setSystemProperty(JRFC_CLIENT_CONNECT_TIMEOUT, "60");
                this.setSystemProperty(JCO_CPIC_KEEP_ALIVE_TIMEOUT, "100");
                this.setSystemProperty(JCO_CPIC_KEEP_ALIVE_PERIOD, "300");
                this.setSystemProperty(JCO_SESSION_TIMEOUT, null);
                this.setSystemProperty(JCO_SESSION_TIMEOUT_CHECK_INTERVAL, null);
                this.setSystemProperty(JCO_DELTA_MANAGEMENT, "1");
                this.setSystemProperty(JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION, "0");
            }
            catch (RuntimeException ex) {
                if (nativeLibraryLoadFailure) break block2;
                Trace.fireTraceCritical("[JCoAPI] Exception while reading system properties: ", ex);
            }
        }
    }

    void setSystemProperty(String key, String defValue) {
        block6: {
            String propertyValue = null;
            try {
                propertyValue = System.getProperty(key, defValue);
                if (propertyValue != null) {
                    if (!this.processInternalProperty(key, propertyValue) && !this.processPublicProperty(key, propertyValue)) {
                        Trace.fireTraceCritical("[JCoAPI] Encountered unknown system property: " + key + "=" + propertyValue);
                    }
                    if (!JCO_TRACE_LEVEL.equals(key) && !JCO_TRACE_PATH.equals(key)) {
                        properties.setProperty(key, propertyValue);
                    }
                }
            }
            catch (Throwable t) {
                if (nativeLibraryLoadFailure) break block6;
                if (!Trace.isOn(1, true)) {
                    this.setRuntimeTrace(1, ".");
                }
                Trace.fireTraceCritical("[JCoAPI] Exception while setting system property to JCo property: " + key + "=" + propertyValue, t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean processInternalProperty(String key, String value) {
        boolean isInternalProperty = true;
        if (JCO_ALLOW_NON_ABAP_PARTNER.equals(key)) {
            int valueInt = 0;
            try {
                valueInt = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_ALLOW_NON_ABAP_PARTNER + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_ALLOW_NON_ABAP_PARTNER + " caused " + ex.getMessage(), (Throwable)ex);
            }
            if (valueInt != 0 && valueInt != 1) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property jco.allow_non_abap_partner are 0 or 1 only");
            }
            isNonAbapPartnerAllowed = valueInt == 1;
            return isInternalProperty;
        }
        if (JCO_PROGRAM_NAME.equals(key)) {
            if (value == null) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.program_name is null or an empty string");
            if (value.length() == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.program_name is null or an empty string");
            }
            AbSysInfo.programName = value;
            return isInternalProperty;
        }
        if (!JCO_NI_LOCAL_ADDRESS.equals(key)) return false;
        if (value == null) return isInternalProperty;
        if (value.length() <= 0) return isInternalProperty;
        try {
            int rc = JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setCpicLocalAddress(value);
            if (rc == 0) return isInternalProperty;
            if (rc != Integer.MIN_VALUE) throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value \"" + value + "\" for property " + JCO_NI_LOCAL_ADDRESS + " caused an internal CPIC error (rc=" + rc + ")");
            if (!Trace.isOn(16)) return isInternalProperty;
            Trace.fireTrace(16, "[JCoAPI] The native layer is too old and does not support setting the property jco.ni.local_address");
            return isInternalProperty;
        }
        catch (JCoRuntimeException jre) {
            throw jre;
        }
        catch (Exception ex) {
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value \"" + value + "\" for property " + JCO_NI_LOCAL_ADDRESS + " caused " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean processPublicProperty(String key, String value) {
        boolean isPropertyDefined = true;
        if (JCO_TRACE_LEVEL.equals(key)) {
            try {
                this.setRuntimeTrace(Integer.parseInt(value), properties.getProperty(JCO_TRACE_PATH));
                return isPropertyDefined;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_TRACE_LEVEL + " is not an integer", (Throwable)ex);
            }
        }
        if (JCO_TRACE_PATH.equals(key)) {
            try {
                String traceLevel = properties.getProperty(JCO_TRACE_LEVEL);
                if (traceLevel != null) {
                    this.setRuntimeTrace(Integer.parseInt(traceLevel), value);
                    return isPropertyDefined;
                }
                if (Trace.systemTracePath != null) {
                    properties.setProperty(JCO_TRACE_PATH, Trace.systemTracePath);
                    return isPropertyDefined;
                }
                if (value != null) {
                    properties.setProperty(JCO_TRACE_PATH, value);
                    return isPropertyDefined;
                }
                properties.remove(JCO_TRACE_PATH);
                return isPropertyDefined;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value \"" + value + "\" for property " + JCO_TRACE_PATH + " is not a valid path", (Throwable)ex);
            }
        }
        if (JCO_JARM.equals(key)) {
            if (!"0".equals(value)) {
                if (!"1".equals(value)) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property " + JCO_JARM + " are 0 or 1 only");
            }
            if (properties.getProperty(JCO_JARM, "0").equals(value)) return isPropertyDefined;
            Jarm.setState(value);
            this.setMiddlewarePropertyValue("jco.middleware.monitoring", value);
            this.jcoMode = "0".equals(value) ? (this.jcoMode &= 0xFFFFFFFE) : (this.jcoMode |= 1);
            return isPropertyDefined;
        }
        if (JCO_JDSR.equals(key)) {
            if (!"0".equals(value)) {
                if (!"1".equals(value)) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property " + JCO_JDSR + " are 0 or 1 only");
            }
            if (properties.getProperty(JCO_JDSR, "0").equals(value)) return isPropertyDefined;
            Dsr.setState(value);
            this.setMiddlewarePropertyValue("jco.middleware.monitoring", value);
            this.jcoMode = "0".equals(value) ? (this.jcoMode &= 0xFFFFFFFD) : (this.jcoMode |= 2);
            return isPropertyDefined;
        }
        if (JCO_JDSR_COMP_NAME.equals(key)) {
            Dsr.setDsrComponentName(value);
            return isPropertyDefined;
        }
        if (JCO_JDSR_PROVIDER.equals(key)) {
            if (value == null || value.equals("0")) {
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("1")) return isPropertyDefined;
                this.jcoMode &= 0xFFFFFFFB;
                this.setMiddlewarePropertyValue("jco.middleware.monitoring", "0");
                return isPropertyDefined;
            } else {
                if (!value.equals("1")) return isPropertyDefined;
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("0")) return isPropertyDefined;
                this.jcoMode |= 4;
                this.setMiddlewarePropertyValue("jco.middleware.monitoring", "1");
            }
            return isPropertyDefined;
        }
        if (JCO_IGNORE_JDSR_PROVIDER_ERROR.equals(key)) {
            if (value == null || value.equals("0")) {
                if (!properties.getProperty(JCO_IGNORE_JDSR_PROVIDER_ERROR, "0").equals("1")) return isPropertyDefined;
                this.jcoMode &= 0xFFFFFFEF;
                return isPropertyDefined;
            } else {
                if (!value.equals("1")) return isPropertyDefined;
                if (!properties.getProperty(JCO_JDSR_PROVIDER, "0").equals("0")) return isPropertyDefined;
                this.jcoMode |= 0x10;
            }
            return isPropertyDefined;
        }
        if (JCO_SESSION_TIMEOUT.equals(key)) {
            try {
                long valueLong = this.parseTimeValue(value, 60000);
                if (valueLong < 0L) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than zero for property jco.session_timeout is not allowed");
                }
                SessionTimeoutChecker.setTimeout(valueLong);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_SESSION_TIMEOUT + " is not a valid value", (Throwable)ex);
            }
        }
        if (JCO_SESSION_TIMEOUT_CHECK_INTERVAL.equals(key)) {
            try {
                long valueLong = this.parseTimeValue(value, 60000);
                if (valueLong <= 0L) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than or equal to zero for property jco.session_timeout.check_interval is not allowed");
                }
                SessionTimeoutChecker.setTimeoutCheckInterval(valueLong);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_SESSION_TIMEOUT + " is not a valid value", (Throwable)ex);
            }
        }
        if (CPIC_TRACE.equals(key)) {
            try {
                int cpicTraceInt = Integer.parseInt(value);
                RfcRuntime rfcRuntime = JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance();
                int rc = 0;
                if (cpicTraceInt <= 0) {
                    StringBuilder filename;
                    String path = properties.getProperty(JRFC_TRACE_PATH);
                    if (path == null) {
                        path = properties.getProperty(JCO_TRACE_PATH);
                    }
                    if (path != null && path.length() > 0 && new File(path).isDirectory()) {
                        filename = new StringBuilder(path.length() + 25);
                        filename.append(path);
                        char last = path.charAt(path.length() - 1);
                        if (last != '\\' && last != '/') {
                            filename.append(System.getProperty("file.separator"));
                        }
                    } else {
                        filename = new StringBuilder(24);
                    }
                    filename.append("CPIC");
                    filename.append(new SimpleDateFormat("yyMMdd'_'HHmmssSSS").format(new Date()));
                    filename.append(".trc");
                    rc = rfcRuntime.setCpicTrace(cpicTraceInt, filename.toString());
                    if (rc != 0) {
                        throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + CPIC_TRACE + " caused an internal CPIC error (rc=" + rc + ")");
                    }
                } else {
                    rc = rfcRuntime.changeCpicTraceLevel(cpicTraceInt);
                    if (rc != 0) {
                        throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + cpicTraceInt + " for property " + CPIC_TRACE + " caused an internal CPIC error (rc=" + rc + ")");
                    }
                }
                this.cpicTraceLevel = cpicTraceInt;
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + CPIC_TRACE + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + JCO_CPIC_MAX_CONV + " causes " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (CPIC_TRACE_MAXFILESIZE.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt < 1) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than 1 for property cpic.trace.maxfilesize is not allowed");
                }
                int rc = JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setCpicTraceFileSize(valueInt);
                if (rc == 0) return isPropertyDefined;
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + valueInt + " for property " + CPIC_TRACE_MAXFILESIZE + " caused an internal CPIC error (rc=" + rc + ")");
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + CPIC_TRACE_MAXFILESIZE + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + CPIC_TRACE_MAXFILESIZE + " caused " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (JCO_CPIC_MAX_CONV.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt <= 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than or equal to zero for property  jco.cpic_maxconv is not allowed");
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setCpicMaxConv(valueInt);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_CPIC_MAX_CONV + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + JCO_CPIC_MAX_CONV + " causes " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (JCO_CPIC_KEEP_ALIVE_PERIOD.equals(key)) {
            try {
                int keepAliveReplyTimeout;
                int keepAliveTimeout;
                int valueInt = Integer.parseInt(value);
                if (valueInt < 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value for property jco.cpic_keep_alive_period less than 0 is not allowed");
                }
                try {
                    String strKeepAliveTimeout = properties.getProperty(JCO_CPIC_KEEP_ALIVE_TIMEOUT);
                    keepAliveTimeout = strKeepAliveTimeout != null ? Integer.parseInt(strKeepAliveTimeout) : 100;
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_TIMEOUT + " caused " + e.getMessage(), (Throwable)e);
                }
                try {
                    String strKeepAliveReplyTimeout = properties.getProperty(JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT);
                    keepAliveReplyTimeout = strKeepAliveReplyTimeout != null ? Integer.parseInt(strKeepAliveReplyTimeout) : 0;
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_reply_timeou caused " + e.getMessage(), (Throwable)e);
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setupRegKeepAlive(valueInt > 0, keepAliveReplyTimeout > 0, keepAliveReplyTimeout, valueInt, keepAliveTimeout);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_PERIOD + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_PERIOD + " caused " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (JCO_CPIC_KEEP_ALIVE_TIMEOUT.equals(key)) {
            try {
                int keepAliveReplyTimeout;
                int keepAlivePeriod;
                int valueInt = Integer.parseInt(value);
                if (valueInt < 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than zero for property jco.cpic_keep_alive_timeout is not allowed");
                }
                String strKeepAlivePeriod = properties.getProperty(JCO_CPIC_KEEP_ALIVE_PERIOD);
                if (strKeepAlivePeriod == null) return isPropertyDefined;
                try {
                    keepAlivePeriod = Integer.parseInt(strKeepAlivePeriod);
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_period caused " + e.getMessage(), (Throwable)e);
                }
                try {
                    String strKeepAliveReplyTimeout = properties.getProperty(JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT);
                    keepAliveReplyTimeout = strKeepAliveReplyTimeout != null ? Integer.parseInt(strKeepAliveReplyTimeout) : 0;
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_reply_timeou caused " + e.getMessage(), (Throwable)e);
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setupRegKeepAlive(keepAlivePeriod > 0, keepAliveReplyTimeout > 0, keepAliveReplyTimeout, keepAlivePeriod, valueInt);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_TIMEOUT + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_TIMEOUT + " caused " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT.equals(key)) {
            try {
                int keepAliveTimeout;
                int keepAlivePeriod;
                int valueInt = Integer.parseInt(value);
                if (valueInt < 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "A value less than zero for property jco.cpic_keep_alive_reply_timeou is not allowed");
                }
                String strKeepAlivePeriod = properties.getProperty(JCO_CPIC_KEEP_ALIVE_PERIOD);
                if (strKeepAlivePeriod == null) return isPropertyDefined;
                try {
                    keepAlivePeriod = Integer.parseInt(strKeepAlivePeriod);
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_period caused " + e.getMessage(), (Throwable)e);
                }
                try {
                    String strKeepAliveTimeout = properties.getProperty(JCO_CPIC_KEEP_ALIVE_TIMEOUT);
                    keepAliveTimeout = strKeepAliveTimeout != null ? Integer.parseInt(strKeepAliveTimeout) : 100;
                }
                catch (Exception e) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value for property jco.cpic_keep_alive_timeout caused " + e.getMessage(), (Throwable)e);
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setupRegKeepAlive(keepAlivePeriod > 0, valueInt > 0, valueInt, keepAlivePeriod, keepAliveTimeout);
                return isPropertyDefined;
            }
            catch (JCoRuntimeException jre) {
                throw jre;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT + " is not an integer", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + JCO_CPIC_KEEP_ALIVE_REPLY_TIMEOUT + " caused " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (JRFC_TRACE.equals(key)) {
            try {
                int jrfcTraceInt = Integer.parseInt(value);
                if (jrfcTraceInt < 0) return isPropertyDefined;
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setRfcTrace(jrfcTraceInt > 0);
                return isPropertyDefined;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_TRACE + " is not an integer", (Throwable)ex);
            }
        }
        if (JRFC_TRACE_PATH.equals(key)) return isPropertyDefined;
        if (JRFC_LOGFILE_MAXSIZE.equals(key)) {
            try {
                int jrfcLogFileMaxBackups;
                int jrfcLogFileMaxSize = Integer.parseInt(value);
                if (jrfcLogFileMaxSize < 0) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_LOGFILE_MAXSIZE + " is integer, but < 0");
                }
                String jrfcLogFileMaxBackups_s = properties.getProperty(JRFC_LOGFILE_MAXBACKUPS);
                if (jrfcLogFileMaxBackups_s != null && (jrfcLogFileMaxBackups = Integer.parseInt(jrfcLogFileMaxBackups_s)) >= 0 && jrfcLogFileMaxBackups * jrfcLogFileMaxSize < 20) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_LOGFILE_MAXSIZE + " multiplied with " + JRFC_LOGFILE_MAXBACKUPS + ": " + jrfcLogFileMaxBackups + " deceeds minimal allowed space of " + 20 + "MB");
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().getRfcTraceWriter().setLogFileMaxSize(jrfcLogFileMaxSize);
                return isPropertyDefined;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_LOGFILE_MAXSIZE + " is not an integer", (Throwable)ex);
            }
        }
        if (JRFC_LOGFILE_MAXBACKUPS.equals(key)) {
            try {
                short jrfcLogFileMaxBackups = Short.parseShort(value);
                String jrfcLogFileMaxSize_s = properties.getProperty(JRFC_LOGFILE_MAXSIZE);
                if (jrfcLogFileMaxSize_s != null) {
                    int jrfcLogFileMaxSize = Integer.parseInt(jrfcLogFileMaxSize_s);
                    if (jrfcLogFileMaxBackups >= 0 && jrfcLogFileMaxBackups * jrfcLogFileMaxSize < 20) {
                        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_LOGFILE_MAXBACKUPS + " multiplied with " + JRFC_LOGFILE_MAXSIZE + ": " + jrfcLogFileMaxSize + " deceeds minimal allowed space of " + 20 + "MB");
                    }
                }
                JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().getRfcTraceWriter().setLogFileMaxBackups(jrfcLogFileMaxBackups);
                return isPropertyDefined;
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_LOGFILE_MAXBACKUPS + " is not a short", (Throwable)ex);
            }
        }
        if (JRFC_CLIENT_CONNECT_TIMEOUT.equals(key)) {
            try {
                int valueInt = Integer.parseInt(value);
                if (valueInt < 1) throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_CLIENT_CONNECT_TIMEOUT + " is not in the allowed range of [1..3600]");
                if (valueInt > 3600) {
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_CLIENT_CONNECT_TIMEOUT + " is not in the allowed range of [1..3600]");
                }
                RfcRuntime rfcRuntime = JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance();
                rfcRuntime.setRfcConnectTimeout(valueInt);
                int rc = rfcRuntime.setCpicConnectTimeout(valueInt * 1000);
                if (rc == 0) return isPropertyDefined;
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + valueInt + " for property " + JRFC_CLIENT_CONNECT_TIMEOUT + " caused an internal CPIC error (rc=" + rc + ")");
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JRFC_CLIENT_CONNECT_TIMEOUT + " is not an integer", (Throwable)ex);
            }
        }
        if (JCO_DELTA_MANAGEMENT.equals(key)) {
            this.setMiddlewarePropertyValue(key, value);
            return isPropertyDefined;
        }
        if (JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION.equals(key)) {
            int iv = 0;
            try {
                iv = Integer.parseInt(value);
            }
            catch (Exception ex) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + JCO_USE_REPOSITORY_ROUNDTRIP_OPTIMIZATION + " is not an integer", (Throwable)ex);
            }
            if (iv == 0) return isPropertyDefined;
            if (iv == 1) return isPropertyDefined;
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for property jco.use_repository_roundtrip_optimization are 0 or 1 only");
        }
        if (JCO_TRACE_FORMAT.equals(key)) return isPropertyDefined;
        if (!JCO_NI_DNS_CACHE_TTL.equals(key)) {
            if (!JCO_NI_DNS_NEGATIVE_CACHE_TTL.equals(key)) return false;
        }
        try {
            int valueInt = Integer.parseInt(value);
            if (valueInt < 0) throw new JCoRuntimeException(131, "The value " + value + " for " + key + " is not in the allowed range of [0-86400]");
            if (valueInt > 86400) {
                throw new JCoRuntimeException(131, "The value " + value + " for " + key + " is not in the allowed range of [0-86400]");
            }
            int rc = 0;
            rc = JCO_NI_DNS_CACHE_TTL.length() == key.length() ? JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setDNSCacheTTL(valueInt) : JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().setDNSNegativeCacheTTL(valueInt);
            if (rc >= 0) return isPropertyDefined;
            throw new JCoRuntimeException(108, "Value " + valueInt + " for property " + key + " caused an internal NI error (rc=" + rc + ")");
        }
        catch (JCoRuntimeException jre) {
            throw jre;
        }
        catch (NumberFormatException ex) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value " + value + " for property " + key + " is not an integer", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Value " + value + " for property " + key + " caused " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setPropertyValue(String key, String value) {
        if (this.processPublicProperty(key, value)) {
            if (!JCO_TRACE_LEVEL.equals(key) && !JCO_TRACE_PATH.equals(key)) {
                if (Trace.isOn(32)) {
                    Trace.fireTrace(32, "[JCoAPI] JCo.setProperty(" + key + ", " + value + ')', Trace.isOn(64));
                }
                if (value != null) {
                    properties.setProperty(key, value);
                } else {
                    properties.remove(key);
                }
            }
        } else if (value != null) {
            properties.setProperty(key, value);
        } else {
            properties.remove(key);
        }
    }

    private static byte[] createZeroDecFloat(DecFloatType type) {
        int len = 0;
        if (type == DecFloatType.DECFLOAT16_BE || type == DecFloatType.DECFLOAT16_LE) {
            len = 8;
        } else if (type == DecFloatType.DECFLOAT34_BE || type == DecFloatType.DECFLOAT34_LE) {
            len = 16;
        }
        byte[] result = new byte[len];
        DecFloat.fromString(type, "0.0", result, 0, result.length);
        return result;
    }

    private void throwExceptionIfDestinationInvalid(JCoDestination d, String api) throws JCoRuntimeException {
        if (d == null) {
            throw new IllegalArgumentException("Destination null is not allowed in " + api);
        }
        if (!(d instanceof InternalDestination)) {
            throw new IllegalArgumentException(d.getClass().getName() + " is not allowed. Use the JCoDestinationManager to obtain a destination instance.");
        }
        if (!d.isValid()) {
            throw new JCoRuntimeException(180, ((InternalDestination)d).describeState());
        }
    }

    protected void beginSequence(JCoDestination destination) {
        this.throwExceptionIfDestinationInvalid(destination, "JCoContext.begin()");
        if (destination.getType() == 'R') {
            throw new JCoRuntimeException(136, "Stateful communication to registered RFC server programs is not supported");
        }
        this.sessionManager.beginSequence(destination);
    }

    protected void endSequence(JCoDestination destination) throws JCoException {
        this.throwExceptionIfDestinationInvalid(destination, "JCoContext.endSequence()");
        this.sessionManager.endSequence(destination);
    }

    protected boolean isStateful(JCoDestination destination) {
        this.throwExceptionIfDestinationInvalid(destination, "JCoContext.isStateful()");
        return this.sessionManager.isStateful(destination);
    }

    int getInternalMode() {
        return this.jcoMode;
    }

    abstract boolean startAutoJob(AutoJobRunner.AutoJob var1);

    protected abstract ConnectionManager createConnectionManager();

    protected abstract void updateDestinationDataProvider(DestinationDataProvider var1);

    protected abstract void updateServerDataProvider(ServerDataProvider var1);

    protected abstract void updateMessageServerDataProvider(MessageServerDataProvider var1);

    abstract void updateSessionRefProvider(SessionReferenceProvider var1);

    abstract void updateTenantProvider(TenantProvider var1);

    public abstract void startTask(String var1);

    public abstract void endTask();

    public boolean isTaskMonitorOn() {
        return false;
    }

    protected void addTraceListener(JCoTraceListener listener) {
        Trace.addTraceListener(listener);
    }

    protected void removeTraceListener(JCoTraceListener listener) {
        Trace.removeTraceListener(listener);
    }

    protected void setRuntimeTrace(int level, String path) {
        String previousPath;
        level = Trace.setJCoTrace(level);
        properties.setProperty(JCO_TRACE_LEVEL, String.valueOf(level));
        if (Trace.systemTracePath == null) {
            previousPath = (String)(path != null ? properties.setProperty(JCO_TRACE_PATH, path) : properties.remove(JCO_TRACE_PATH));
        } else {
            previousPath = properties.getProperty(JCO_TRACE_PATH);
            if (previousPath == null) {
                properties.setProperty(JCO_TRACE_PATH, Trace.systemTracePath);
                if (level > 0 && !Trace.systemTracePath.equals(path)) {
                    previousPath = Trace.systemTracePath;
                }
            }
        }
        if (level > 0 && Trace.firstTraceEntry == null && (path != null && !path.equals(previousPath) || path == null && previousPath != null)) {
            StringBuilder sb = new StringBuilder(256);
            if (Trace.systemTracePath == null || previousPath == null) {
                sb.append("[JCoAPI] INFO: JCo trace path is ");
                if (previousPath == null) {
                    sb.append("set to ");
                } else {
                    sb.append("changed from \"").append(previousPath).append("\" to ");
                }
                if (path != null) {
                    sb.append('\"').append(path).append('\"');
                } else {
                    sb.append("<null>");
                }
            } else {
                sb.append("[JCoAPI] WARNING: Requested JCo trace path ");
                if (path != null) {
                    sb.append('\"').append(path).append('\"');
                } else {
                    sb.append("setting to <null>");
                }
                sb.append(" is rejected and the system trace path \"").append(previousPath).append("\" is kept");
            }
            StackTraceElement[] stack = new Throwable().getStackTrace();
            if (stack != null && stack.length > 1) {
                int i = 1;
                while (!stack[i].getClassName().equals("com.sap.conn.jco.JCo") && ++i < stack.length) {
                }
                if (i == stack.length) {
                    sb.append(CRLF).append('\t').append(stack[0]);
                    i = 1;
                }
                do {
                    sb.append(CRLF).append("\tinvoked at ").append(stack[i]);
                } while (++i < stack.length);
                sb.append(CRLF);
            }
            Trace.fireTrace(1, sb.toString(), false);
        }
    }

    protected int getTraceLevel() {
        return Trace.toExternalTraceLevel(Trace.internalLogLevel);
    }

    protected String getTracePath() {
        return properties.getProperty(JCO_TRACE_PATH);
    }

    public static String findProperty(String key, Properties props) {
        String value = null;
        Object objValue = props.get(key);
        if (objValue == null && (objValue = props.get(key = key.substring(key.lastIndexOf(46) + 1))) == null) {
            key = key.toUpperCase(Locale.ENGLISH);
            objValue = props.get(key);
        }
        if (objValue != null) {
            value = objValue.toString().trim();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
                value = "1";
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
                value = "0";
            }
        }
        return value != null && value.length() > 0 ? value : null;
    }

    public static void removeProperty(String key, Properties props) {
        if (props.containsKey(key)) {
            props.remove(key);
        } else if (props.containsKey(key = key.substring(key.lastIndexOf(46) + 1))) {
            props.remove(key);
        } else if (props.containsKey(key = key.toUpperCase(Locale.ENGLISH))) {
            props.remove(key);
        }
    }

    public static boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase(Locale.ENGLISH)).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    protected JCoCustomRepository createCustomRepository(String name) {
        return new CustomRepository(name);
    }

    protected JCoStructure createStructure(JCoRecordMetaData metaData) {
        return new DefaultStructure(metaData);
    }

    protected JCoStructure createStructure(JCoTable table, int row) {
        int pos = table.getRow();
        DefaultStructure s = new DefaultStructure(table.getRecordMetaData());
        table.setRow(row);
        s.copyFrom((JCoRecord)table);
        table.setRow(pos);
        return s;
    }

    protected JCoTable createTable(JCoRecordMetaData metaData) {
        return new DefaultTable(metaData);
    }

    protected JCoAbapObject constructAbapObject(JCoClassMetaData classMetaData, Map<String, Object> initialValues) {
        DefaultAbapObject newInstance = new DefaultAbapObject(classMetaData);
        for (String attributeName : initialValues.keySet()) {
            if (!classMetaData.hasField(attributeName)) continue;
            newInstance.setValue(attributeName, initialValues.get(attributeName));
        }
        newInstance.setInitialized();
        return newInstance;
    }

    protected JCoListMetaData createListMetaData(JCoListMetaData metaData) {
        return new DefaultListMetaData(metaData);
    }

    protected JCoListMetaData createListMetaData(String name, int capacity) {
        return new DefaultListMetaData(name, capacity);
    }

    protected JCoListMetaData createListMetaData(String name) {
        return new DefaultListMetaData(name);
    }

    protected JCoRecordMetaData createRecordMetaData(JCoRecordMetaData metaData) {
        return new DefaultRecordMetaData(metaData);
    }

    protected JCoRecordMetaData createRecordMetaData(String name) {
        return new DefaultRecordMetaData(name);
    }

    protected JCoRecordMetaData createRecordMetaData(String name, int capacity) {
        return new DefaultRecordMetaData(name, capacity);
    }

    protected DefaultClassMetaData createClassMetaData(JCoClassMetaData metaData) {
        return new DefaultClassMetaData(metaData);
    }

    protected DefaultClassMetaData createClassMetaData(String name, String[] parentClasses, String[] implementedInterfaces, int capacity) {
        return new DefaultClassMetaData(name, parentClasses, implementedInterfaces, capacity);
    }

    protected JCoFunctionTemplate createFunctionTemplate(String name, JCoListMetaData imports, JCoListMetaData exports, JCoListMetaData changing, JCoListMetaData tables, AbapExceptionModel[] exceptions, boolean supportsASXML) {
        boolean isLocked;
        boolean bl = isLocked = !(imports != null && !imports.isLocked() || changing != null && !changing.isLocked() || exports != null && !exports.isLocked() || tables != null && !tables.isLocked());
        if (isLocked) {
            return new AbapFunctionTemplate(name, imports, exports, changing, tables, exceptions, supportsASXML);
        }
        throw new IllegalArgumentException("The metaData for the parameter list(s) is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.");
    }

    protected JCoFunctionTemplate createFunctionTemplate(String name, JCoListMetaData imports, JCoListMetaData exports, JCoListMetaData changing, JCoListMetaData tables, AbapException[] exceptions, boolean supportsASXML) {
        boolean isLocked;
        AbapExceptionModel[] exceptionList = null;
        if (exceptions != null) {
            exceptionList = new AbapExceptionModel[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptionList[i] = new AbapExceptionModel(exceptions[i].getKey(), exceptions[i].getMessage());
            }
        }
        boolean bl = isLocked = !(imports != null && !imports.isLocked() || changing != null && !changing.isLocked() || exports != null && !exports.isLocked() || tables != null && !tables.isLocked());
        if (isLocked) {
            return new AbapFunctionTemplate(name, imports, exports, changing, tables, exceptionList, supportsASXML);
        }
        throw new IllegalArgumentException("The metaData for the parameter list(s) is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.");
    }

    protected JCoFunctionUnit createFunctionUnit(String unitID, JCoBackgroundUnitAttributes unitAttributes) {
        AbapFunctionUnit unit = new AbapFunctionUnit(unitAttributes);
        unit.setID(Codecs.Hex.decode(unitID));
        return unit;
    }

    protected JCoFunctionUnit createFunctionUnit(JCoBackgroundUnitAttributes unitAttributes) {
        AbapFunctionUnit unit = new AbapFunctionUnit(unitAttributes);
        byte[] bID = this.getRfcRuntimeInstance().createUUID();
        unit.setID(bID);
        return unit;
    }

    protected JCoRequestUnit createRequestUnit(String unitID, JCoBackgroundUnitAttributes unitAttributes) {
        AbapRequestUnit unit = new AbapRequestUnit(unitAttributes);
        unit.setID(Codecs.Hex.decode(unitID));
        return unit;
    }

    protected JCoRequestUnit createRequestUnit(JCoBackgroundUnitAttributes unitAttributes) {
        AbapRequestUnit unit = new AbapRequestUnit(unitAttributes);
        byte[] bID = this.getRfcRuntimeInstance().createUUID();
        unit.setID(bID);
        return unit;
    }

    protected JCoBackgroundUnitAttributes createBackgroundUnitAttributes() {
        return new AbapBackgroundUnitAttributes();
    }

    protected JCoUnitIdentifier createUnitIdentifier(String unitID, JCoUnitIdentifier.Type unitType) {
        if (unitType == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unit type equal to null is not allowed in createUnitIdentifier");
        }
        byte[] unitIdBytes = Codecs.Hex.decode(unitID);
        if (unitIdBytes.length != 16) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unit ID is not allowed. Only unit IDs with 16 bytes are supported. [" + unitID + "]");
        }
        AbapFunctionUnit.UnitIdentifier unitIdentifier = new AbapFunctionUnit.UnitIdentifier();
        unitIdentifier.update(unitIdBytes, unitType);
        return unitIdentifier;
    }

    protected JCoThroughput createThroughput() {
        return new DefaultThroughput();
    }

    protected String getMiddlewarePropertyValue(String key) {
        return this.getMiddlewareInstance().getProperty(key);
    }

    protected void setMiddlewarePropertyValue(String key, String value) {
        this.getMiddlewareInstance().setProperty(key, value);
    }

    protected String getPropertyValue(String key) {
        block5: {
            if (JCO_NI_DNS_CACHE_TTL.equals(key) || JCO_NI_DNS_NEGATIVE_CACHE_TTL.equals(key)) {
                try {
                    boolean positive = key.equalsIgnoreCase(JCO_NI_DNS_CACHE_TTL);
                    int ttl = 0;
                    ttl = positive ? JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().getDNSCacheTTL() : JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().getDNSNegativeCacheTTL();
                    if (ttl < 0) {
                        if (Trace.isOn(2)) {
                            Trace.fireTrace(2, "[JCoAPI] Internal NI error occurred while retrieving the current value for property " + key + " (rc=" + ttl + ")");
                        }
                        return properties.getProperty(key);
                    }
                    return Integer.toString(ttl);
                }
                catch (Exception ex) {
                    if (!Trace.isOn(2)) break block5;
                    Trace.fireTrace(2, "[JCoAPI] Exception occurred while retrieving the current value for property " + key + ":", ex);
                }
            }
        }
        return properties.getProperty(key);
    }

    protected long parseTimeValue(String timeValue, int defaultMillisFactor) throws NumberFormatException {
        int tokenIndex;
        if (timeValue != null && (tokenIndex = timeValue.length() - 1) >= 0 && !Character.isDigit(timeValue.charAt(tokenIndex))) {
            String unit;
            while (--tokenIndex >= 0 && !Character.isDigit(timeValue.charAt(tokenIndex))) {
            }
            if (tokenIndex >= 0 && (unit = timeValue.substring(++tokenIndex).trim()).length() > 0) {
                int millisFactor = 0;
                switch (unit.charAt(0)) {
                    case 's': {
                        if (unit.length() != 1 && !unit.equals("sec") && !unit.equals("seconds") && !unit.equals("second")) break;
                        millisFactor = 1000;
                        break;
                    }
                    case 'm': {
                        if (unit.length() == 1) {
                            millisFactor = 60000;
                            break;
                        }
                        if (unit.equals("ms") || unit.equals("msec") || unit.equals("milliseconds") || unit.equals("millisecond")) {
                            millisFactor = 1;
                            break;
                        }
                        if (!unit.equals("min") && !unit.equals("minutes") && !unit.equals("minute")) break;
                        millisFactor = 60000;
                        break;
                    }
                    case 'h': {
                        if (unit.length() != 1 && !unit.equals("hr") && !unit.equals("hrs") && !unit.equals("hours") && !unit.equals("hour")) break;
                        millisFactor = 3600000;
                        break;
                    }
                }
                if (millisFactor > 0) {
                    timeValue = timeValue.substring(0, tokenIndex);
                    return Long.parseLong(timeValue) * (long)millisFactor;
                }
            }
        }
        return Long.parseLong(timeValue) * (long)defaultMillisFactor;
    }

    protected abstract String getRuntimeParameter(String var1);

    public static String getProfileParameter(String parameter) {
        return JCoRuntimeFactory.getRuntime().getRuntimeParameter(parameter);
    }

    protected abstract boolean registerNativeMethods(Class<?> var1);

    public static boolean registerNatives(Class<?> clazz) {
        return JCoRuntimeFactory.getRuntime().registerNativeMethods(clazz);
    }

    public abstract RfcRuntime getRfcRuntimeInstance();

    protected abstract AbstractServerManager getJCoServerFactoryInstance();

    public static AbstractServerManager getJCoServerManager() {
        return JCoRuntimeFactory.getRuntime().getJCoServerFactoryInstance();
    }

    protected static boolean checkAccess(Set<String> friendlyClasses, String className) {
        boolean isAllowed = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length - 1; ++i) {
            if (!stack[i].getClassName().equals(className) || !friendlyClasses.contains(stack[i + 1].getClassName())) continue;
            isAllowed = true;
            break;
        }
        if (!isAllowed) {
            String junitInternalRunner = "org.junit.internal.runners.TestClassRunner";
            String junitInternalRunnerNew = "org.junit.runners.ParentRunner";
            String junitRunner = "org.junit.runner.JUnitCore";
            for (int i = 0; i < stack.length; ++i) {
                if (!stack[i].getClassName().equals(junitRunner) && !stack[i].getClassName().equals(junitInternalRunner) && !stack[i].getClassName().equals(junitInternalRunnerNew)) continue;
                isAllowed = true;
                break;
            }
        }
        return isAllowed;
    }

    static String createSecureString(String str) {
        if (str == null) {
            return null;
        }
        try {
            byte[] buffer = Codecs.AES.encrypt(str, (SecretKey)GUID.getProcessID());
            str = null;
            buffer[6] = ~buffer[6];
            return Codecs.Base64.encode(buffer);
        }
        catch (Throwable th) {
            Trace.fireTraceCritical("[JCoAPI] Exception occurred while creating a secure string:", th);
            return "encryption failed";
        }
    }

    static void setRuntimeInterface(JCoInterface runtimeInterface) {
        JCoInterface.setRuntime((JCoInterface)runtimeInterface);
    }

    protected List<String> getDestinationIDs() {
        return this.getDestinationManager().getDestinationIDs(this.tenantManager.getTenantContext());
    }

    protected List<String> getCustomDestinationIDs(String destinationID) {
        return this.getDestinationManager().getCustomDestinationIDs(this.tenantManager.getTenantContext(), destinationID);
    }

    protected String getRepositoryDestinationID(String destinationID) {
        return this.getDestinationManager().getRepositoryDestinationID(this.tenantManager.getTenantContext(), destinationID);
    }

    protected JCoDestinationMonitor getDestinationMonitor(String destinationID) {
        return this.getDestinationManager().getDestinationMonitor(this.tenantManager.getTenantContext(), destinationID);
    }

    protected JCoDestinationMonitor getRepositoryDestinationMonitor(String destinationID) {
        return this.getDestinationManager().getRepositoryDestinationMonitor(this.tenantManager.getTenantContext(), destinationID);
    }

    protected JCoRepository getRepository(String repositoryID) {
        return this.tenantManager.getTenantContext().getRepositoryManager().getRepository(repositoryID);
    }

    protected List<String> getRepositoryIDs() {
        return this.tenantManager.getTenantContext().getRepositoryManager().getRepositoryIDs();
    }

    protected abstract ConnectionMonitor getConnectionMonitor();

    protected TenantContextManager getTenantContextManager() {
        return this.tenantManager;
    }

    protected JCoRepositoryQueryResult queryMetaDataSet(JCoRepository repository, List<String> functions, List<String> types, List<String> classes) throws JCoException {
        if (repository instanceof AbapRepository) {
            return ((AbapRepository)repository).lookupMetadata(functions, types, classes);
        }
        throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only Repositories created by JCo runtime are allowed in lookupMetadata. Encountered instance is " + repository.getClass().getName());
    }

    static {
        jcoThreadGroup = new ThreadGroup("JCoThreads");
    }
}

