/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public final class MetaDataStorage {
    protected String storageName;
    protected BasicRepository repository = null;
    private ConcurrentHashMap<String, AbapFunctionTemplate> functions;
    private ConcurrentHashMap<String, DefaultRecordMetaData> structures;
    private ConcurrentHashMap<String, DefaultClassMetaData> classes;

    public MetaDataStorage(BasicRepository basicRepository, String name) {
        this.storageName = name;
        this.repository = basicRepository;
        this.functions = new ConcurrentHashMap();
        this.structures = new ConcurrentHashMap();
        this.classes = new ConcurrentHashMap();
    }

    private void updateParents(AbstractMetaData removed, Serializable meta) {
        for (String name : this.getCachedFunctionNames()) {
            AbapFunctionTemplate template = this.functions.get(name);
            boolean updated = this.updateParents((AbstractMetaData)template.getImportParameterList(), removed, meta);
            updated = this.updateParents((AbstractMetaData)template.getExportParameterList(), removed, meta) || updated;
            updated = this.updateParents((AbstractMetaData)template.getChangingParameterList(), removed, meta) || updated;
            updated = this.updateParents((AbstractMetaData)template.getTableParameterList(), removed, meta) || updated;
            if (!updated) continue;
            this.saveFunctionTemplateInternal(template);
        }
        for (String name : this.getCachedRecordNames()) {
            DefaultRecordMetaData rMd = this.structures.get(name);
            if (!this.updateParents(rMd, removed, meta)) continue;
            this.saveRecordMetaDataInternal(rMd);
        }
    }

    private boolean updateParents(AbstractMetaData parent, AbstractMetaData removed, Serializable meta) {
        boolean updated = false;
        if (parent != null && parent.numOdata > 0) {
            for (int i = 0; i < parent.numFields; ++i) {
                if (parent.tabMeta[i] != removed) continue;
                parent.tabMeta[i] = meta;
                if (meta instanceof String) {
                    parent.allTypesResolved = false;
                }
                updated = true;
            }
        }
        return updated;
    }

    private void storeNestedMetaData(AbstractMetaData meta) {
        if (meta == null) {
            return;
        }
        block4: for (int i = 0; i < meta.getFieldCount(); ++i) {
            switch (meta.getType(i)) {
                case 17: 
                case 99: {
                    AbstractMetaData savedMD;
                    AbstractMetaData md;
                    if (!(meta.tabMeta[i] instanceof DefaultRecordMetaData) || (md = (DefaultRecordMetaData)((Object)meta.tabMeta[i])) == (savedMD = this.structures.get(md.recName))) continue block4;
                    this.saveRecordMetaDataInternal((DefaultRecordMetaData)md);
                    continue block4;
                }
                case 16: {
                    DefaultClassMetaData saved;
                    if (!(meta.tabMeta[i] instanceof DefaultClassMetaData)) continue block4;
                    AbstractMetaData md = (DefaultClassMetaData)((Object)meta.tabMeta[i]);
                    AbstractMetaData savedMD = this.classes.get(((DefaultClassMetaData)md).recName);
                    if (md != savedMD) {
                        this.saveClassMetaDataInternal((DefaultClassMetaData)md);
                    }
                    if (md == (saved = this.classes.get(((DefaultClassMetaData)md).recName))) continue block4;
                    this.saveClassMetaData((DefaultClassMetaData)md);
                    continue block4;
                }
            }
        }
    }

    private boolean compare(DefaultRecordMetaData meta1, DefaultRecordMetaData meta2) {
        if (meta1 != meta2) {
            if (meta1 == null || meta2 == null) {
                return false;
            }
            if (meta1.numFields != meta2.numFields) {
                return false;
            }
            for (int i = 0; i < meta1.numFields; ++i) {
                if (meta1.type[i] != meta2.type[i]) {
                    return false;
                }
                if (meta1.length[1][i] != meta2.length[1][i]) {
                    return false;
                }
                if (meta1.length[0][i] != meta2.length[0][i]) {
                    return false;
                }
                if (meta1.offset[1][i] != meta2.offset[1][i]) {
                    return false;
                }
                if (meta1.offset[0][i] != meta2.offset[0][i]) {
                    return false;
                }
                if (!meta1.name[i].equals(meta2.name[i])) {
                    return false;
                }
                if (meta1.decimals[i] != meta2.decimals[i]) {
                    return false;
                }
                if (meta1.tabMeta[i] == meta2.tabMeta[i] || meta1.tabMeta[i] instanceof String && meta1.tabMeta[i].equals(meta2.tabMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compare(DefaultClassMetaData meta1, DefaultClassMetaData meta2) {
        if (meta1 != meta2) {
            if (meta1 == null || meta2 == null) {
                return false;
            }
            if (meta1.numFields != meta2.numFields) {
                return false;
            }
            for (int i = 0; i < meta1.numFields; ++i) {
                if (meta1.type[i] != meta2.type[i]) {
                    return false;
                }
                if (meta1.length[1][i] != meta2.length[1][i]) {
                    return false;
                }
                if (meta1.length[0][i] != meta2.length[0][i]) {
                    return false;
                }
                if (!meta1.name[i].equals(meta2.name[i])) {
                    return false;
                }
                if (meta1.decimals[i] != meta2.decimals[i]) {
                    return false;
                }
                if (meta1.tabMeta[i] == meta2.tabMeta[i] || meta1.tabMeta[i] instanceof String && meta1.tabMeta[i].equals(meta2.tabMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    private <MD extends AbstractMetaData> MD resolveMetaData(MD meta) throws JCoException {
        if (meta == null) {
            return null;
        }
        block4: for (int i = 0; i < meta.getFieldCount(); ++i) {
            switch (meta.getType(i)) {
                case 17: 
                case 99: {
                    AbstractMetaData md;
                    Object tabMeta = meta.tabMeta[i];
                    if (tabMeta instanceof String) {
                        md = null;
                        md = this.loadRecordMetaDataFromCache((String)tabMeta);
                        if (md == null) {
                            md = this.repository.getRecordMetaData((String)tabMeta);
                            if (md == null) {
                                return null;
                            }
                            md = this.loadRecordMetaData((String)tabMeta);
                        }
                        meta.tabMeta[i] = md;
                        tabMeta = md;
                    }
                    if (tabMeta instanceof DynamicRecordMetaData) {
                        this.repository.resolveDynamicRecordMetaData((DynamicRecordMetaData)tabMeta);
                        continue block4;
                    }
                    if (!(tabMeta instanceof DefaultRecordMetaData) || ((DefaultRecordMetaData)((Object)meta.tabMeta[i])).allTypesResolved) continue block4;
                    this.resolveMetaData((DefaultRecordMetaData)tabMeta);
                    continue block4;
                }
                case 16: {
                    AbstractMetaData md;
                    Object tabMeta = meta.tabMeta[i];
                    if (tabMeta instanceof String) {
                        md = null;
                        md = this.loadClassMetaDataFromCache((String)tabMeta);
                        if (md == null) {
                            md = this.repository.getClassMetaData((String)tabMeta);
                            if (md == null) {
                                return null;
                            }
                            md = this.loadClassMetaData((String)tabMeta);
                        }
                        meta.tabMeta[i] = md;
                        tabMeta = md;
                    }
                    if (!(tabMeta instanceof DefaultClassMetaData) || ((DefaultClassMetaData)((Object)meta.tabMeta[i])).allTypesResolved) continue block4;
                    this.resolveMetaData((DefaultClassMetaData)tabMeta);
                    continue block4;
                }
            }
        }
        return meta;
    }

    AbapFunctionTemplate loadFunctionTemplateFromCache(String name) {
        return this.functions.get(name);
    }

    AbapFunctionTemplate loadFunctionTemplate(String name) throws JCoException {
        AbapFunctionTemplate template = this.loadFunctionTemplateFromCache(name);
        if (template != null) {
            AbstractMetaData imports = (AbstractMetaData)template.getImportParameterList();
            AbstractMetaData changings = (AbstractMetaData)template.getChangingParameterList();
            AbstractMetaData exports = (AbstractMetaData)template.getExportParameterList();
            AbstractMetaData tables = (AbstractMetaData)template.getTableParameterList();
            boolean resolved = imports == null || imports.allTypesResolved;
            resolved = resolved && (changings == null || changings.allTypesResolved);
            resolved = resolved && (exports == null || exports.allTypesResolved);
            boolean bl = resolved = resolved && (tables == null || tables.allTypesResolved);
            if (!resolved) {
                template = this.functions.get(name);
                imports = (AbstractMetaData)template.getImportParameterList();
                changings = (AbstractMetaData)template.getChangingParameterList();
                exports = (AbstractMetaData)template.getExportParameterList();
                tables = (AbstractMetaData)template.getTableParameterList();
                try {
                    if (imports != null && !imports.allTypesResolved) {
                        if ((imports = this.resolveMetaData(imports)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        imports.allTypesResolved = true;
                    }
                    if (changings != null && !changings.allTypesResolved) {
                        if ((changings = this.resolveMetaData(changings)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        changings.allTypesResolved = true;
                    }
                    if (exports != null && !exports.allTypesResolved) {
                        if ((exports = this.resolveMetaData(exports)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        exports.allTypesResolved = true;
                    }
                    if (tables != null && !tables.allTypesResolved) {
                        if ((tables = this.resolveMetaData(tables)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        tables.allTypesResolved = true;
                    }
                }
                catch (JCoException je) {
                    Trace.fireTraceCritical(je.getMessage(), je);
                    throw je;
                }
                catch (Throwable t) {
                    String msg = "loadFunctionTemplate(" + name + ") caused " + t.getMessage();
                    Trace.fireTraceCritical(msg, t);
                    if (t instanceof RuntimeException) {
                        throw new RuntimeException(msg, t);
                    }
                    throw new Error(msg, t);
                }
                this.saveFunctionTemplate(template);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbapFunctionTemplate saveFunctionTemplate(AbapFunctionTemplate template) {
        if (template == null) {
            return null;
        }
        if (template.getName() == null) {
            throw new IllegalArgumentException("Function name in template is null");
        }
        ConcurrentHashMap<String, AbapFunctionTemplate> concurrentHashMap = this.functions;
        synchronized (concurrentHashMap) {
            return this.saveFunctionTemplateInternal(template);
        }
    }

    private AbapFunctionTemplate saveFunctionTemplateInternal(AbapFunctionTemplate template) {
        AbapFunctionTemplate removed = null;
        if (template == null) {
            return null;
        }
        if (template.getName() == null) {
            throw new IllegalArgumentException("Function name in template is null");
        }
        try {
            this.storeNestedMetaData((DefaultListMetaData)template.getImportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getChangingParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getExportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getTableParameterList());
            removed = this.functions.put(template.getName(), template);
        }
        catch (Throwable t) {
            String msg = "saveFunctionTemplate(" + template.getName() + ") caused " + t;
            Trace.fireTraceCritical(msg, t);
            if (t instanceof RuntimeException) {
                throw new RuntimeException(msg, t);
            }
            throw new Error(msg, t);
        }
        return removed;
    }

    AbapFunctionTemplate removeFunctionTemplate(String name) {
        if (name == null) {
            return null;
        }
        return this.functions.remove(name);
    }

    DefaultRecordMetaData loadRecordMetaDataFromCache(String name) {
        return this.structures.get(name);
    }

    DefaultRecordMetaData loadRecordMetaData(String name) throws JCoException {
        DefaultRecordMetaData meta = this.loadRecordMetaDataFromCache(name);
        if (meta != null && !meta.allTypesResolved) {
            meta = this.structures.get(name);
            if ((meta = this.resolveMetaData(meta)) == null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for " + name);
            }
            meta.allTypesResolved = true;
            this.saveRecordMetaData(meta);
            meta = this.structures.get(name);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultRecordMetaData saveRecordMetaData(DefaultRecordMetaData meta) {
        if (meta == null) {
            return null;
        }
        if (meta.recName == null) {
            throw new IllegalArgumentException("Record name is null");
        }
        ConcurrentHashMap<String, AbapFunctionTemplate> concurrentHashMap = this.functions;
        synchronized (concurrentHashMap) {
            return this.saveRecordMetaDataInternal(meta);
        }
    }

    private DefaultRecordMetaData saveRecordMetaDataInternal(DefaultRecordMetaData meta) {
        DefaultRecordMetaData removed = this.structures.get(meta.getName());
        if (removed == null || !this.compare(removed, meta)) {
            removed = this.structures.put(meta.getName(), meta);
            this.storeNestedMetaData(meta);
            if (removed != null) {
                this.updateParents(removed, (Serializable)((Object)meta));
            }
        }
        return removed;
    }

    DefaultRecordMetaData removeRecordMetaData(String name) {
        if (name == null) {
            return null;
        }
        DefaultRecordMetaData removed = this.structures.remove(name);
        if (removed != null) {
            this.updateParents(removed, (Serializable)((Object)removed.recName));
        }
        return removed;
    }

    DefaultClassMetaData loadClassMetaDataFromCache(String name) {
        return this.classes.get(name);
    }

    DefaultClassMetaData loadClassMetaData(String name) throws JCoException {
        DefaultClassMetaData meta = this.loadClassMetaDataFromCache(name);
        if (meta != null && !meta.allTypesResolved) {
            meta = this.classes.get(name);
            if ((meta = this.resolveMetaData(meta)) == null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for " + name);
            }
            meta.allTypesResolved = true;
            this.saveClassMetaData(meta);
            meta = this.classes.get(name);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultClassMetaData saveClassMetaData(DefaultClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        if (meta.recName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        ConcurrentHashMap<String, AbapFunctionTemplate> concurrentHashMap = this.functions;
        synchronized (concurrentHashMap) {
            return this.saveClassMetaDataInternal(meta);
        }
    }

    private DefaultClassMetaData saveClassMetaDataInternal(DefaultClassMetaData meta) {
        DefaultClassMetaData removed = this.classes.get(meta.getName());
        if (removed == null || !this.compare(removed, meta)) {
            removed = this.classes.put(meta.getName(), meta);
            this.storeNestedMetaData(meta);
            if (removed != null) {
                this.updateParents(removed, (Serializable)((Object)meta));
            }
        }
        return removed;
    }

    DefaultClassMetaData removeClassMetaData(String name) {
        if (name == null) {
            return null;
        }
        DefaultClassMetaData removed = this.classes.remove(name);
        if (removed != null) {
            this.updateParents(removed, (Serializable)((Object)removed.recName));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ConcurrentHashMap<String, AbapFunctionTemplate> concurrentHashMap = this.functions;
        synchronized (concurrentHashMap) {
            this.functions.clear();
            this.structures.clear();
            this.classes.clear();
        }
    }

    Collection<String> getCachedFunctionNames() {
        return this.functions.keySet();
    }

    Collection<String> getCachedRecordNames() {
        return this.structures.keySet();
    }

    Collection<String> getCachedClassNames() {
        return this.classes.keySet();
    }

    boolean containsRecord(String name) {
        return this.structures.containsKey(name);
    }

    int getFunctionMetaDataCount() {
        return this.functions.size();
    }

    int getRecordMetaDataCount() {
        return this.structures.size();
    }

    int getClassMetaDataCount() {
        return this.classes.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(1000);
        buffer.append("cached functions [");
        buffer.append(this.getCachedFunctionNames().size());
        buffer.append("]:");
        Iterator<String> it = this.getCachedFunctionNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(JCoRuntime.CRLF);
        buffer.append("cached structures [");
        buffer.append(this.getCachedRecordNames().size());
        buffer.append("] :");
        it = this.getCachedRecordNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(JCoRuntime.CRLF);
        buffer.append("cached classes [");
        buffer.append(this.getCachedClassNames().size());
        buffer.append("] :");
        it = this.getCachedClassNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

