/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Obfuscator {
    private static final int IIIIII00 = 252;
    private static final int OOOOOOII = 3;
    private static final int IIIIOOOO = 240;
    private static final int OOOOIIII = 15;
    private static final int IIOOOOOO = 192;
    private static final int OOIIIIII = 63;
    private static final int OOOIIIII = 31;
    private static final int OOOOIIOO = 12;
    private static final int OOOIOOII = 19;
    private static final int OIIOOIOO = 100;
    private static final int IIIOIIOO = 236;
    private static final int CHARS = 88;
    private static final int MAX = 87;
    private static final SecureRandom random;
    private static final MAP decoders;
    private static final String cname;
    private static final byte[][][] check;
    private static final byte[] chars;
    private static final byte[] values;

    Obfuscator(Map<Integer, byte[]> keys) {
        decoders.putAll(keys);
    }

    private static final boolean check(int m) {
        byte[][] names;
        String cls;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack == null || stack.length < 2) {
            return false;
        }
        int i = 1;
        while ((cls = stack[i++].getClassName()).equals(cname) && i < stack.length) {
        }
        switch (m) {
            case 0: {
                names = check[0];
                if (names.length == 2) break;
                return true;
            }
            case 1: {
                names = check[1];
                if (names.length == 1) break;
                return true;
            }
            default: {
                return true;
            }
        }
        int n = 0;
        while (n < names.length) {
            byte[] name = names[n++];
            if (cls.length() != name.length) continue;
            for (i = name.length - 1; i >= 0 && cls.charAt(i) == ~name[i]; --i) {
            }
            if (i >= 0) continue;
            return false;
        }
        return true;
    }

    private static final byte[] init(int seed) {
        byte[] encoder = new byte[64];
        int inc = 1;
        boolean first = true;
        int idx = seed >>> 16 & 0xFF;
        switch (idx / 30) {
            case 0: {
                inc = 5;
                break;
            }
            case 1: {
                inc = 7;
                break;
            }
            case 2: {
                inc = 11;
            }
        }
        idx = idx % 30 + 1 << 1;
        int skip = seed & 0xFF;
        if (skip < 44) {
            int split = (seed >>> 8 & 0xFF) + (skip += 2);
            if (split > 87) {
                split -= 88;
            }
            int cycle = 1;
            int ch = split;
            for (int i = 64; i > 0; --i) {
                encoder[idx] = chars[ch];
                if ((idx += inc) > 63) {
                    idx %= 64;
                }
                ch += skip;
                if (first) {
                    if (ch <= 87) continue;
                    if ((ch -= 88) >= split) {
                        ch = split + cycle++;
                        continue;
                    }
                    first = false;
                    continue;
                }
                if (ch < split) continue;
                if ((ch = split + cycle++) > 87) {
                    ch -= 88;
                    continue;
                }
                first = true;
            }
        } else {
            int split = (seed >>> 8 & 0xFF) - (skip -= 42);
            if (split < 0) {
                split += 88;
            }
            int cycle = 1;
            int ch = split;
            for (int i = 64; i > 0; --i) {
                encoder[idx] = chars[ch];
                if ((idx += inc) > 63) {
                    idx %= 64;
                }
                ch -= skip;
                if (first) {
                    if (ch >= 0) continue;
                    if ((ch += 88) <= split) {
                        ch = split - cycle++;
                        continue;
                    }
                    first = false;
                    continue;
                }
                if (ch > split) continue;
                if ((ch = split - cycle++) < 0) {
                    ch += 88;
                    continue;
                }
                first = true;
            }
        }
        return encoder;
    }

    private static final byte[] encoder(byte[] data) {
        int i1 = random.nextInt(88);
        int i2 = random.nextInt(88);
        int i3 = random.nextInt(88);
        if (data != null && data.length > 3) {
            data[0] = (byte)(random.nextInt(256) & 0x13 | 0x64);
            data[1] = chars[i1];
            data[data.length - 2] = chars[i2];
            data[data.length - 1] = chars[i3];
        }
        return Obfuscator.init(i1 << 16 | i2 << 8 | i3);
    }

    public static final byte[] encode(String plaintext) {
        byte[] raw;
        int encoding = 0;
        if (plaintext != null) {
            raw = plaintext.getBytes(Utf8ByteToCharConverter.UTF_8);
            if (raw.length >= plaintext.length() << 1) {
                raw = plaintext.getBytes(Utf8ByteToCharConverter.UTF_16BE);
            } else {
                encoding = 1;
            }
        } else {
            raw = JCoRuntime.EMPTY_BYTE_ARRAY;
            encoding = 1;
        }
        if (Obfuscator.check(0) || raw.length > 254) {
            return Obfuscator.generate(raw);
        }
        int size = (((raw.length + 19) / 3 * 4 + 3) / 24 + 1) * 24;
        int len = (size - 4) / 4 * 3;
        byte[] decoded = new byte[len];
        random.nextBytes(decoded);
        int offset = random.nextInt(Math.min(len - raw.length - 1, 32));
        decoded[len - 1] = (byte)(encoding << 6 | offset);
        decoded[offset++] = (byte)(plaintext != null ? raw.length : -1);
        System.arraycopy(raw, 0, decoded, offset, raw.length);
        byte[] result = new byte[size];
        byte[] encoder = Obfuscator.encoder(result);
        byte d = result[0];
        byte e = result[1];
        int sum = 0;
        int src = 0;
        int dst = 2;
        while (src < len) {
            byte a = d;
            byte b = e;
            byte c = decoded[src++];
            d = decoded[src++];
            e = decoded[src++];
            int x = c ^ (sum += a + b);
            int y = d ^ (sum += b + c);
            int z = e ^ (sum += c + d);
            result[dst++] = encoder[(x & 0xFC) >> 2];
            result[dst++] = encoder[(x & 3) << 4 | (y & 0xF0) >> 4];
            result[dst++] = encoder[(y & 0xF) << 2 | (z & 0xC0) >> 6];
            result[dst++] = encoder[z & 0x3F];
        }
        return result;
    }

    public static final String encodeAsString(String plaintext) {
        return new String(Obfuscator.encode(plaintext), Utf8ByteToCharConverter.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] decoder(byte[] data) {
        int i;
        byte[] decoder;
        int seed = (data[0] & 0xC) << 22 | values[data[1]] << 16 | values[data[data.length - 2]] << 8 | values[data[data.length - 1]];
        Integer key = new Integer(seed);
        MAP mAP = decoders;
        synchronized (mAP) {
            decoder = (byte[])decoders.get(key);
        }
        if (decoder != null) {
            return decoder;
        }
        byte[] encoder = Obfuscator.init(seed);
        decoder = new byte[128];
        for (i = 127; i >= 0; --i) {
            decoder[i] = -1;
        }
        for (i = 63; i >= 0; --i) {
            decoder[encoder[i]] = (byte)i;
        }
        MAP mAP2 = decoders;
        synchronized (mAP2) {
            decoders.put(key, decoder);
        }
        return decoder;
    }

    public static final String decode(byte[] encoded) {
        int offset;
        if (encoded == null) {
            return null;
        }
        if (Obfuscator.check(1) || !Obfuscator.valid(encoded)) {
            return Obfuscator.transform(encoded);
        }
        byte[] decoder = Obfuscator.decoder(encoded);
        int len = (encoded.length - 4) / 4 * 3;
        byte[] decoded = new byte[len];
        byte a = encoded[0];
        byte b = encoded[1];
        int bits = 0;
        int count = 0;
        int sum = 0;
        int src = 2;
        int dst = 0;
        while (dst < len) {
            byte value;
            if ((value = encoded[src++]) < 0) {
                return Obfuscator.transform(encoded);
            }
            if ((value = decoder[value]) < 0) {
                return Obfuscator.transform(encoded);
            }
            bits = bits << 6 | value;
            if ((count += 6) < 8) continue;
            byte c = (byte)(bits >>> (count -= 8) & 0xFF ^ (sum += a + b));
            a = b;
            b = c;
            decoded[dst++] = b;
        }
        if ((offset = decoded[--len] & 0x1F) >= decoded.length) {
            return Obfuscator.transform(encoded);
        }
        count = decoded[offset] & 0xFF;
        if (count == 255) {
            return null;
        }
        if (++offset + count > decoded.length) {
            return Obfuscator.transform(encoded);
        }
        return new String(decoded, offset, count, decoded[len] >>> 6 == 1 ? Utf8ByteToCharConverter.UTF_8 : Utf8ByteToCharConverter.UTF_16BE);
    }

    public static final String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        byte[] raw = encoded.getBytes(Utf8ByteToCharConverter.UTF_8);
        if (raw.length > encoded.length()) {
            return Obfuscator.transform(raw);
        }
        return Obfuscator.decode(raw);
    }

    private static final byte[] generate(byte[] data) {
        int i;
        byte[] result = (byte[])chars.clone();
        byte[] encoder = new byte[64];
        int len = 88;
        for (i = 63; i >= 0; --i) {
            int idx = random.nextInt(len--);
            encoder[i] = result[idx];
            System.arraycopy(result, idx + 1, result, idx, len - idx);
        }
        len = (((data.length + 19) / 3 * 4 + 3) / 24 + 1) * 24;
        result = new byte[len];
        result[++i] = (byte)(random.nextInt(256) & 0x13 | 0x64);
        result[++i] = chars[random.nextInt(88)];
        len -= 3;
        while (i < len) {
            result[++i] = encoder[random.nextInt(64)];
        }
        result[++i] = chars[random.nextInt(88)];
        result[++i] = chars[random.nextInt(88)];
        return result;
    }

    private static final String transform(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length < 3) {
            return "";
        }
        SecureRandom rand = new SecureRandom(data);
        int len = data.length > 384 ? 254 : (data.length > 364 ? 254 - rand.nextInt(4) : (data.length > 52 ? (data.length - 1) / 4 * 3 - 17 - rand.nextInt(18) : (data.length > 8 ? (data.length + 2) / 3 - rand.nextInt(data.length / 4) : data.length / 3)));
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            int value = data[i] ^ rand.nextInt(256);
            result[i] = value > 126 ? (char)(value == 254 ? 63 : (value >>> 1) - (value & 1)) : (value < 32 ? (char)(value + 32) : (char)value);
        }
        return new String(result);
    }

    private static final boolean valid(byte[] data) {
        if (data == null || data.length < 48 || data.length % 24 > 0) {
            return false;
        }
        if ((data[0] & 0xEC) != 100) {
            return false;
        }
        byte b = data[1];
        if (b < 0 || values[b] < 0) {
            return false;
        }
        b = data[data.length - 2];
        if (b < 0 || values[b] < 0) {
            return false;
        }
        b = data[data.length - 1];
        return b >= 0 && values[b] >= 0;
    }

    static {
        int i;
        random = new SecureRandom();
        decoders = new MAP(64, 5000);
        cname = Obfuscator.class.getName();
        check = new byte[][][]{new byte[][]{{-100, -112, -110, -47, -116, -98, -113, -47, -100, -112, -111, -111, -47, -107, -100, -112, -47, -115, -117, -47, -81, -115, -112, -113, -102, -115, -117, -122, -71, -106, -109, -102, -69, -102, -116, -117, -106, -111, -98, -117, -106, -112, -111, -69, -98, -117, -98, -81, -115, -112, -119, -106, -101, -102, -115}, {-100, -112, -110, -47, -120, -110, -47, -113, -108, -104, -47, -116, -98, -113, -47, -84, -102, -115, -119, -102, -115, -74, -111, -103, -112}}, new byte[][]{{-100, -112, -110, -47, -116, -98, -113, -47, -100, -112, -111, -111, -47, -107, -100, -112, -47, -115, -117, -47, -69, -102, -103, -98, -118, -109, -117, -69, -102, -116, -117, -106, -111, -98, -117, -106, -112, -111, -78, -98, -111, -98, -104, -102, -115}}};
        chars = new byte[]{33, 35, 36, 37, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126};
        values = new byte[128];
        for (i = 127; i >= 0; --i) {
            Obfuscator.values[i] = -1;
        }
        for (i = 87; i >= 0; --i) {
            Obfuscator.values[Obfuscator.chars[i]] = (byte)i;
        }
    }

    private static final class MAP
    extends LinkedHashMap<Integer, byte[]> {
        private static final long serialVersionUID = 1L;
        private int maxSize;

        private MAP(int initialCapacity, int maximumSize) {
            super(initialCapacity, 0.75f, true);
            this.maxSize = maximumSize;
        }

        @Override
        protected final boolean removeEldestEntry(Map.Entry<Integer, byte[]> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

