/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.SerializationAwareVisitor;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.SerializationAware;

public class Parameter
implements IRfcParameter,
SerializationAware {
    DefaultParameterList parameterList;
    int index;
    Converter converter;
    int numBytes;
    boolean active;

    public Parameter(DefaultParameterList parameterList, int index, Converter converter) {
        this.parameterList = parameterList;
        this.index = index;
        this.converter = converter;
        this.numBytes = 0;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public String getName() {
        return this.parameterList.metaData.name[this.index];
    }

    @Override
    public int getType() {
        return this.parameterList.metaData.type[this.index];
    }

    @Override
    public byte[] getBytes() {
        byte[] ret = null;
        int length = 0;
        switch (this.parameterList.metaData.type[this.index]) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeChar(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeNumber(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 2: 
            case 4: {
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeBinary(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 23: 
            case 24: {
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeDecNumber(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 29: {
                String value = (String)this.parameterList.odata[this.parameterList.metaData.oindex[this.index]];
                if (value == null) {
                    ret = new byte[1];
                } else {
                    byte[] temp = value.getBytes(Utf8ByteToCharConverter.UTF_8);
                    ret = new byte[temp.length + 1];
                    System.arraycopy(temp, 0, ret, 0, temp.length);
                }
                length = ret.length;
                break;
            }
            case 30: {
                ret = (byte[])this.parameterList.odata[this.parameterList.metaData.oindex[this.index]];
                if (ret == null) {
                    ret = new byte[]{};
                }
                length = ret.length;
                break;
            }
            default: {
                ret = new byte[]{};
            }
        }
        this.numBytes = length;
        return ret;
    }

    @Override
    public void setBytes(byte[] rfcBytes) {
        int length = 0;
        switch (this.parameterList.metaData.type[this.index]) {
            case 0: 
            case 1: 
            case 3: {
                this.converter.encodeChar(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                break;
            }
            case 6: {
                this.converter.encodeNumchar(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                this.converter.encodeNumber(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                break;
            }
            case 2: 
            case 4: {
                this.converter.encodeBinary(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                break;
            }
            case 23: 
            case 24: {
                this.converter.encodeDecNumber(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                break;
            }
            case 29: {
                this.parameterList.odata[this.parameterList.metaData.oindex[this.index]] = new String(rfcBytes, 0, rfcBytes.length - 1, Utf8ByteToCharConverter.UTF_8);
                length = rfcBytes.length;
                break;
            }
            case 30: {
                this.parameterList.odata[this.parameterList.metaData.oindex[this.index]] = rfcBytes;
                length = rfcBytes.length;
                break;
            }
        }
        this.parameterList.setInitialized(this.index);
        this.numBytes = length;
    }

    public void setNumBytes(int numBytes) {
        this.numBytes = numBytes;
    }

    @Override
    public int getNumBytes() {
        return this.numBytes;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive() {
        this.active = true;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public DefaultParameterList getParameterList() {
        return this.parameterList;
    }

    @Override
    public void accept(SerializationAwareVisitor v) {
        v.visit(this);
    }
}

