/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.MessageServerDataEventListener;
import com.sap.conn.jco.ext.MessageServerDataProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class PropertyFileMessageServerDataProvider
implements MessageServerDataProvider {
    private static String MESSAGESERVERFILE_SUFFIX = ".jcoMessageServer";
    private File parentDirectory = null;

    PropertyFileMessageServerDataProvider(String directory) throws FileNotFoundException {
        File dir = new File(directory);
        if (!dir.exists()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 27).append("Directory \"").append(path).append("\" does not exist").toString());
        }
        if (!dir.canRead()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 34).append("Read access to directory \"").append(path).append("\" denied").toString());
        }
        this.parentDirectory = dir;
    }

    @Override
    public Properties getMessageServerProperties(String messageServerName) {
        File propertiesFile;
        if (messageServerName == null) {
            messageServerName = "";
        }
        if (!(propertiesFile = new File(this.parentDirectory, new StringBuilder(messageServerName.length() + MESSAGESERVERFILE_SUFFIX.length()).append(messageServerName).append(MESSAGESERVERFILE_SUFFIX).toString())).exists()) {
            return null;
        }
        if (!propertiesFile.canRead()) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 29).append("Read access to file \"").append(path).append("\" denied").toString(), null);
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException exc) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 22).append("Failed to read file \"").append(path).append('\"').toString(), exc);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    @Override
    public boolean supportsEvents() {
        return false;
    }

    @Override
    public void setMessageServerDataEventListener(MessageServerDataEventListener eventListener) {
    }
}

