/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class PropertyFileServerDataProvider
implements ServerDataProvider {
    private static String SERVERFILE_SUFFIX = ".jcoServer";
    private File parentDirectory = null;

    PropertyFileServerDataProvider(String directory) throws FileNotFoundException {
        File dir = new File(directory);
        if (!dir.exists()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 27).append("Directory \"").append(path).append("\" does not exist").toString());
        }
        if (!dir.canRead()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 34).append("Read access to directory \"").append(path).append("\" denied").toString());
        }
        this.parentDirectory = dir;
    }

    @Override
    public Properties getServerProperties(String serverName) {
        File propertiesFile;
        if (serverName == null) {
            serverName = "";
        }
        if (!(propertiesFile = new File(this.parentDirectory, new StringBuilder(serverName.length() + SERVERFILE_SUFFIX.length()).append(serverName).append(SERVERFILE_SUFFIX).toString())).exists()) {
            return null;
        }
        if (!propertiesFile.canRead()) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 29).append("Read access to file \"").append(path).append("\" denied").toString(), null);
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException exc) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 22).append("Failed to read file \"").append(path).append('\"').toString(), exc);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    @Override
    public boolean supportsEvents() {
        return false;
    }

    @Override
    public void setServerDataEventListener(ServerDataEventListener eventListener) {
    }
}

