/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RepositoryManager {
    private HashMap<String, BasicRepository> repositories = new HashMap(29);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(InternalDestination destination) throws JCoException {
        String key = destination.getSystemID();
        BasicRepository repository = this.repositories.get(key);
        if (repository == null) {
            HashMap<String, BasicRepository> hashMap = this.repositories;
            synchronized (hashMap) {
                repository = this.repositories.get(key);
                if (repository == null) {
                    if (Trace.isOn(8)) {
                        Trace.fireTrace(8, "[JCoAPI] Adding a repository for " + key);
                    }
                    repository = new AbapRepository(key, destination);
                    this.repositories.put(key, repository);
                } else if (repository instanceof AbapRepository) {
                    ((AbapRepository)repository).destinationList.addDestination(destination);
                }
            }
        } else if (repository instanceof AbapRepository) {
            ((AbapRepository)repository).destinationList.addDestination(destination);
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRepository(BasicRepository repository) {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            BasicRepository repo = this.repositories.get(repository.getName());
            if (repo == null) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] Registering repository " + repository.getName());
                }
            } else {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Repository " + repository.getName() + " already registered");
            }
            this.repositories.put(repository.getName(), repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(RfcDestination destination) {
        if (destination.repository != null) {
            HashMap<String, BasicRepository> hashMap = this.repositories;
            synchronized (hashMap) {
                BasicRepository repository = this.repositories.get(destination.repository.getName());
                if (repository instanceof AbapRepository) {
                    ((AbapRepository)repository).destinationList.removeDestination(destination);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRepositoryIDs() {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            return new ArrayList<String>(this.repositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(String repositoryID) {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            return this.repositories.get(repositoryID);
        }
    }

    public int size() {
        return this.repositories.size();
    }
}

