/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.DestinationState;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.TenantContext;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.List;

final class RfcDestinationMonitor
implements JCoDestinationMonitor {
    private DestinationState state = DestinationState.VALID;
    private ClientFactory clientFactory = null;
    String destinationId = null;
    String originDestinationId = null;
    String destinationName = null;
    long lastActiveTimestamp = 0L;
    int maxUsed = 0;
    int peakLimit = 0;
    int capacity = 0;

    RfcDestinationMonitor(ClientFactory factory) {
        this.destinationId = factory.getDestinationID();
        this.originDestinationId = factory.getOriginDestinationID();
        this.destinationName = factory.getDestinationName();
        factory.setDestinationMonitor(this);
        this.clientFactory = factory;
    }

    void markChanged() {
        this.state = DestinationState.CHANGED;
        ClientFactory factory = this.clientFactory;
        if (factory != null) {
            factory.removeDestinationMonitor();
            this.clientFactory = null;
        }
    }

    void markDeleted() {
        this.state = DestinationState.DELETED;
        ClientFactory factory = this.clientFactory;
        if (factory != null) {
            factory.removeDestinationMonitor();
            this.clientFactory = null;
        }
    }

    ClientFactory getClientFactory() {
        if (this.state != DestinationState.VALID) {
            String errmsg = new StringBuilder(128).append("Destination monitor is invalid. The monitored destination with ID ").append(this.destinationId).append(" has been ").append(this.state == DestinationState.CHANGED ? "changed." : "removed.").toString();
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, "[JCoAPI] " + errmsg);
            }
            throw new JCoRuntimeException(180, "JCO_ERROR_DESTINATION_DATA_INVALID", errmsg);
        }
        if (this.clientFactory == null) {
            TenantContext context = JCoRuntimeFactory.getRuntime().getTenantContextManager().getTenantContext();
            ClientFactory factory = ConnectionManager.getConnectionManager().getFactoryByDestinationID(context, this.destinationId);
            if (factory != null) {
                factory.setMaxUsed(this.maxUsed);
                factory.setDestinationMonitor(this);
                this.clientFactory = factory;
            }
        }
        return this.clientFactory;
    }

    void removeClientFactory(ClientFactory factory) {
        if (this.clientFactory == factory) {
            this.originDestinationId = factory.getOriginDestinationID();
            this.lastActiveTimestamp = factory.getLastActivityTimestamp();
            this.maxUsed = factory.getMaxUsed();
            this.peakLimit = factory.getPeakLimit();
            this.capacity = factory.getCapacity();
            this.clientFactory = null;
        }
    }

    public long getLastActivityTimestamp() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.lastActiveTimestamp = factory.getLastActivityTimestamp();
        }
        return this.lastActiveTimestamp;
    }

    public int getMaxUsedCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.maxUsed = factory.getMaxUsed();
        }
        return this.maxUsed;
    }

    public int getPeakLimit() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.peakLimit = factory.getPeakLimit();
        }
        return this.peakLimit;
    }

    public int getPoolCapacity() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            this.capacity = factory.getCapacity();
        }
        return this.capacity;
    }

    public int getPooledConnectionCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getPooledConnectionCount();
        }
        return 0;
    }

    public int getUsedConnectionCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getNumUsed();
        }
        return 0;
    }

    public int getWaitingThreadCount() {
        ClientFactory factory = this.getClientFactory();
        if (factory != null) {
            return factory.getNumWaitingThreads();
        }
        return 0;
    }

    public List<? extends JCoConnectionData> getConnectionsData() {
        ClientFactory factory = this.getClientFactory();
        ArrayList<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();
        if (factory != null) {
            factory.getMonitoredData(monitoredData);
        }
        return monitoredData;
    }

    public String getDestinationID() {
        return this.destinationId;
    }

    public String getOriginDestinationID() {
        return this.originDestinationId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isValid() {
        return this.state == DestinationState.VALID;
    }
}

