/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.SessionTimeoutChecker;
import com.sap.conn.jco.rt.Trace;
import java.util.Map;

class SessionFinalizer
implements AutoJobRunner.AutoJob {
    private AutoJobRunner autoJobRunner;
    long jobCreated = System.currentTimeMillis();
    long lastExecution = 0L;
    Map<String, ? extends Context> contexts;

    SessionFinalizer(AutoJobRunner parentAutoJobRunner, Map<String, ? extends Context> contextsToFinalize) {
        this.autoJobRunner = parentAutoJobRunner;
        this.contexts = contextsToFinalize;
    }

    @Override
    public void execute() {
        this.lastExecution = System.currentTimeMillis();
        long sessionTimeout = SessionTimeoutChecker.getTimeout();
        Context[] ctx = this.contexts.values().toArray(new Context[this.contexts.size()]);
        long lastAccessCheckTime = System.currentTimeMillis() - sessionTimeout;
        boolean removeAll = this.jobCreated < lastAccessCheckTime;
        for (int i = 0; i < ctx.length; ++i) {
            if (!removeAll && ctx[i].lastAccess >= lastAccessCheckTime) continue;
            try {
                this.contexts.remove(ctx[i].getSessionID());
                ctx[i].clearServerConnection();
                ctx[i].removeSessionReference();
                ctx[i].reset();
                continue;
            }
            catch (Throwable th) {
                if (!Trace.isOn(4)) continue;
                Trace.fireTrace(4, "[JCoAPI] " + th.getClass().getName() + " occurred while finalizing session ID: [" + ctx[i].getSessionID() + "]", th);
            }
        }
        if (removeAll || this.contexts.size() == 0) {
            this.contexts = null;
            this.autoJobRunner.removeJob(this);
            this.autoJobRunner = null;
        }
    }

    @Override
    public final long getExecutePeriod() {
        return SessionTimeoutChecker.getTimeoutCheckInterval();
    }

    @Override
    public final long getLastExecutionTime() {
        return this.lastExecution;
    }
}

