/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.SerializationAwareVisitor;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.SerializationAware;

public class TableParameter
implements IRfcTable,
SerializationAware {
    DefaultTable table;
    Converter converter;
    String name;
    boolean active;
    int index;
    int numFields;
    IRfcTable.DeltaState state;

    protected TableParameter(JCoTable table, String name) {
        this((DefaultTable)table, name, null);
    }

    protected TableParameter(DefaultTable table, String name) {
        this(table, name, null);
    }

    protected TableParameter(DefaultTable table, String name, Converter converter) {
        this(table, name, converter, 0);
    }

    protected TableParameter(DefaultTable table, String name, Converter converter, int index) {
        this.table = table;
        this.name = name;
        this.converter = converter;
        this.active = false;
        this.index = index;
        this.numFields = -1;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getBytes(int row) {
        int padOffset;
        int i;
        if (row >= this.table.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.numRows - 1) + ']');
        }
        this.table.row = row;
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.table.metaData;
        byte[] ret = new byte[metaData.tabLength[this.converter.sendCodepageType]];
        block10: for (i = 0; i < metaData.numFields; ++i) {
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.table, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 40: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    this.converter.decodeNumber(this.table, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.table, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 23: 
                case 24: {
                    this.converter.decodeDecNumber(this.table, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
            }
        }
        if ((padOffset = metaData.offset[this.converter.sendCodepageType][--i] + metaData.length[this.converter.sendCodepageType][i]) < ret.length) {
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.padSpaces(ret, padOffset);
                    break;
                }
                case 6: {
                    this.converter.padZeros(ret, padOffset);
                    break;
                }
            }
        }
        return ret;
    }

    @Override
    public void setBytes(int row, byte[] rfcBytes) {
        int length;
        int offset;
        int i;
        if (row >= this.table.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.numRows - 1) + ']');
        }
        this.table.row = row;
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.table.metaData;
        if (this.numFields < 0) {
            this.numFields = metaData.computeFieldNumber(rfcBytes.length, this.converter.receiveCodepageType);
        }
        for (i = 0; i < this.numFields; ++i) {
            offset = metaData.offset[this.converter.receiveCodepageType][i];
            length = metaData.length[this.converter.receiveCodepageType][i];
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: {
                    this.converter.encodeChar(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 40: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    this.converter.encodeNumber(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 23: 
                case 24: {
                    this.converter.encodeDecNumber(this.table, rfcBytes, i, offset, length);
                    break;
                }
            }
            this.table.setEdited(i);
        }
        if (i < metaData.numFields && (offset = metaData.offset[this.converter.receiveCodepageType][i]) < rfcBytes.length) {
            length = metaData.length[this.converter.receiveCodepageType][i];
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.encodeChar(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.table, rfcBytes, i, offset, length);
                    break;
                }
                case 4: {
                    this.converter.encodeBinary(this.table, rfcBytes, i, offset, length);
                    break;
                }
            }
            this.table.setEdited(i);
        }
    }

    @Override
    public void appendRow(byte[] rfcBytes) {
        int rowIndex = this.table.numRows;
        this.table.appendRow();
        this.setBytes(rowIndex, rfcBytes);
    }

    @Override
    public void appendRows(int numRows) {
        this.table.appendRows(numRows);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public int getNumRows() {
        return this.table.numRows;
    }

    @Override
    public int getRowLength() {
        return ((DefaultRecordMetaData)this.table.metaData).tabLength[this.converter.sendCodepageType];
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive() {
        this.active = true;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void ensureBufferCapacity(int numRows) {
        this.table.ensureBufferCapacity(numRows);
    }

    void setTable(DefaultTable table) {
        this.numFields = -1;
        this.table = table;
    }

    public DefaultTable getTable() {
        return this.table;
    }

    @Override
    public boolean deleteRow(int pos) {
        if (pos < 0 || pos >= this.table.getNumRows()) {
            return false;
        }
        this.table.deleteRow(pos);
        return true;
    }

    @Override
    public boolean insertRow(int pos) {
        if (pos < 0 || pos > this.table.getNumRows()) {
            return false;
        }
        this.table.insertRow(pos);
        return true;
    }

    @Override
    public void setDmState(IRfcTable.DeltaState state) {
        this.state = state;
    }

    @Override
    public void accept(SerializationAwareVisitor v) {
        v.visit(this);
    }
}

