/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.RepositoryManager;
import com.sap.conn.jco.rt.RfcDestination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class TenantContext {
    private String tenant;
    private HashMap<String, ClientFactory> factories = new HashMap();
    private HashMap<String, AtomicInteger> creationSemaphores = new HashMap();
    private ArrayList<ClientConnection> detachedClients = new ArrayList();
    private ArrayList<String> detachedClientDestinationIds = new ArrayList();
    private ArrayList<String> detachedClientGroupNames = new ArrayList();
    private Hashtable<String, RfcDestination> destinations = new Hashtable(29);
    private RepositoryManager repositoryManager = new RepositoryManager();
    private Hashtable<String, DefaultServer> availableServers = new Hashtable();
    private Hashtable<String, Properties> availableServerCfgs = new Hashtable();

    public TenantContext(String tenant) {
        this.tenant = tenant;
    }

    String getTenant() {
        return this.tenant;
    }

    HashMap<String, ClientFactory> getFactories() {
        return this.factories;
    }

    HashMap<String, AtomicInteger> getCreationSemaphores() {
        return this.creationSemaphores;
    }

    ArrayList<ClientConnection> getDetachedClients() {
        return this.detachedClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[][] getDetachedConnectionsForMonitor() {
        Object[][] returnArray = null;
        if (this.detachedClients.size() > 0) {
            returnArray = new Object[2][];
            ArrayList<ClientConnection> arrayList = this.detachedClients;
            synchronized (arrayList) {
                returnArray[0] = this.detachedClients.toArray(new ClientConnection[this.detachedClients.size()]);
                returnArray[1] = this.detachedClientGroupNames.toArray(new String[this.detachedClientGroupNames.size()]);
            }
        }
        return returnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDetachedClient(String destinationId, ClientConnection client) {
        ArrayList<ClientConnection> arrayList = this.detachedClients;
        synchronized (arrayList) {
            if (this.detachedClients.size() > 0) {
                this.detachedClients.add(client);
                if (destinationId != null && destinationId.length() > 0) {
                    this.detachedClientDestinationIds.add(destinationId);
                    this.detachedClientGroupNames.add(new StringBuilder(destinationId.length() + 11).append(destinationId).append(" (detached)").toString());
                } else {
                    this.detachedClientDestinationIds.add("");
                    this.detachedClientGroupNames.add("single client");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeDetachedClient(ClientConnection client) {
        ArrayList<ClientConnection> arrayList = this.detachedClients;
        synchronized (arrayList) {
            int index;
            if (this.detachedClients.size() > 0 && (index = this.detachedClients.indexOf(client)) >= 0) {
                this.detachedClients.remove(index);
                this.detachedClientDestinationIds.remove(index);
                this.detachedClientGroupNames.remove(index);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection removeDetachedClient(String destinationId) {
        ArrayList<ClientConnection> arrayList = this.detachedClients;
        synchronized (arrayList) {
            int index;
            if (this.detachedClients.size() > 0 && (index = this.detachedClientDestinationIds.indexOf(destinationId)) >= 0) {
                this.detachedClientDestinationIds.remove(index);
                this.detachedClientGroupNames.remove(index);
                return this.detachedClients.remove(index);
            }
        }
        return null;
    }

    Hashtable<String, RfcDestination> getDestinations() {
        return this.destinations;
    }

    RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    Hashtable<String, DefaultServer> getAvailableServers() {
        return this.availableServers;
    }

    Hashtable<String, Properties> getAvailableServerCfgs() {
        return this.availableServerCfgs;
    }

    public String toString() {
        return "Tenant " + this.tenant + " D: " + this.destinations.size() + ", P:" + this.factories.size() + " ,R" + this.repositoryManager.size();
    }
}

