/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.TenantProvider;
import com.sap.conn.jco.rt.TenantContext;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class TenantContextManager {
    private ConcurrentHashMap<String, TenantContext> tenants = new ConcurrentHashMap();
    private TenantContext defaultTenantContext = new TenantContext("JCoSingleTenant");
    private TenantProvider tenantProvider;

    void updateTenantProvider(TenantProvider provider) {
        this.tenantProvider = provider;
        if (provider == null) {
            this.tenants.clear();
        }
    }

    TenantProvider getTenantProvider() {
        return this.tenantProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TenantContext getTenantContext() {
        if (this.tenantProvider == null) {
            return this.defaultTenantContext;
        }
        String tenant = this.tenantProvider.getCurrentTenant();
        TenantContext context = this.tenants.get(tenant);
        if (context == null) {
            ConcurrentHashMap<String, TenantContext> concurrentHashMap = this.tenants;
            synchronized (concurrentHashMap) {
                context = this.tenants.get(tenant);
                if (context == null) {
                    if (Trace.isOn(32)) {
                        Trace.fireTrace(32, new StringBuilder(200).append("[JCoAPI] TenantContextManager.getTenantContext() detected unknown tenant ").append(tenant).append(" and created a context for it").toString());
                    }
                    context = new TenantContext(tenant);
                    this.tenants.put(tenant, context);
                }
            }
        }
        return context;
    }

    boolean isDefaultContext(TenantContext tenantContext) {
        return tenantContext == this.defaultTenantContext;
    }

    Collection<TenantContext> getAllTenants() {
        if (this.tenantProvider == null) {
            ArrayList<TenantContext> wrapper = new ArrayList<TenantContext>();
            wrapper.add(this.defaultTenantContext);
            return wrapper;
        }
        return this.tenants.values();
    }
}

