/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.json.Field;
import com.sap.conn.jco.rt.json.JCoSerializationException;
import com.sap.conn.jco.rt.json.JSonContainerReader;
import com.sap.conn.jco.rt.json.JSonParser;
import java.io.IOException;

class JSonClassMetaDataReader
extends JSonContainerReader {
    private DefaultClassMetaData cmd;

    JSonClassMetaDataReader(JSonParser parser) {
        super(parser);
    }

    @Override
    JSonClassMetaDataReader read(String name) throws IOException {
        this.cmd = (DefaultClassMetaData)JCo.createClassMetaData((String)name);
        this.readClassAttributes();
        this.repo.addClassMetaDataToCache(this.cmd);
        return this;
    }

    void readClassAttributes() throws IOException {
        while (this.parser.nextNonBlankChar() == 44) {
            String attribute = this.parser.nextString();
            this.parser.assertChar(':');
            if ("interfaces".equals(attribute)) {
                String[] interfaces;
                for (String implementedInterface : interfaces = this.parser.readStringArray()) {
                    this.cmd.addImplementedInterface(implementedInterface);
                }
                continue;
            }
            if ("superclasses".equals(attribute)) {
                String[] superClasses;
                for (String parentClass : superClasses = this.parser.readStringArray()) {
                    this.cmd.addParentClass(parentClass);
                }
                continue;
            }
            if ("attributes".equals(attribute)) {
                this.readFields();
                continue;
            }
            throw new JCoSerializationException("Unknown attribute \"" + attribute + "\" for class " + this.cmd.getName(), this.parser);
        }
        this.parser.undo();
    }

    @Override
    void setField(Field f) throws IOException {
        JCoClassMetaData.JCoAttributeKind kindType = this.toAttributeKind(f.name, f.kind, "kind");
        this.checkAttribute(f.name, f.declaringClass, "declaring class");
        int type = AbstractMetaData.getJCOType(f.type);
        if (type != 2 && type != 4 && type != 0 && type != 6) {
            f.nucLength = 0;
            f.ucLength = 0;
        }
        this.cmd.add(f.declaringClass, f.name, type, f.ucLength, f.decimals, f.descr, f.ddicName, null, kindType, f.readOnly, f.defaultValue);
    }

    void checkAttribute(String fieldName, String attributeKind, String fieldType) {
        if (attributeKind == null) {
            throw new JCoSerializationException("Missing " + fieldType + " for attribute " + fieldName + " of ABAP class " + this.cmd.getName());
        }
    }

    JCoClassMetaData.JCoAttributeKind toAttributeKind(String fieldName, String attributeKind, String fieldType) {
        this.checkAttribute(fieldName, attributeKind, fieldType);
        try {
            return JCoClassMetaData.JCoAttributeKind.valueOf((String)attributeKind);
        }
        catch (IllegalArgumentException iae) {
            throw new JCoSerializationException(fieldType + " for attribute " + fieldName + " of ABAP class " + this.cmd.getName() + " is invalid [" + attributeKind + "]");
        }
    }
}

