/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.json.JSonContainerWriter;
import com.sap.conn.jco.rt.json.JSonWriter;
import java.io.IOException;
import java.util.List;

class JSonClassMetaDataWriter
extends JSonContainerWriter {
    JSonClassMetaDataWriter(JSonWriter writer) {
        super(writer);
    }

    void writeMetaData(DefaultClassMetaData md) throws IOException {
        List<String> parentClasses;
        this.writer.write(123);
        this.writer.writeNVPair("name", md.getName());
        List<String> implementedInterfaces = md.getImplementedInterfaces();
        if (implementedInterfaces.size() > 0) {
            this.writer.write(44);
            this.writer.writeStrings("interfaces", implementedInterfaces);
        }
        if ((parentClasses = md.getParentClasses()).size() > 0) {
            this.writer.write(44);
            this.writer.writeStrings("superclasses", parentClasses);
        }
        if (md.getFieldCount() > 0) {
            this.writer.write(44);
            this.writer.writeQuoted("attributes");
            this.writer.write(58);
            this.writer.write(91);
            boolean first = true;
            for (int i = 0; i < md.getFieldCount(); ++i) {
                if (first) {
                    first = false;
                } else {
                    this.writer.write(44);
                }
                this.writeField(md, i);
            }
            this.writer.write(93);
        }
        this.writer.write(125);
    }

    @Override
    void writeSpecificProperties(AbstractMetaData md, int i) throws IOException {
        DefaultClassMetaData cmd = (DefaultClassMetaData)md;
        this.writer.writeSubsequentPair("declClass", cmd.getDeclaringClass(i));
        this.writer.writeSubsequentPair("kind", cmd.getAttributeKind(i).toString());
        this.writer.writeSubsequentPair("readonly", cmd.isReadOnly(i));
        this.writer.writeSubsequentPair("default", cmd.getDefault(i));
    }
}

