/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.json.JSonWriter;
import java.io.IOException;

public abstract class JSonContainerWriter {
    JSonWriter writer;

    JSonContainerWriter(JSonWriter writer) {
        this.setWriter(writer);
    }

    void setWriter(JSonWriter writer) {
        this.writer = writer;
    }

    char getAbapType(AbstractMetaData md, int i) {
        return AbstractMetaData.getJCOTypeChar(md.getType(i));
    }

    void writeField(AbstractMetaData md, int i) throws IOException {
        this.writer.writeLine();
        this.writer.write("\t\t\t{");
        this.writer.writeNVPair("name", md.getName(i));
        this.writeFieldProperties(md, i);
        this.writer.write(125);
    }

    abstract void writeSpecificProperties(AbstractMetaData var1, int var2) throws IOException;

    void writeFieldProperties(AbstractMetaData md, int i) throws IOException {
        this.writeSpecificProperties(md, i);
        this.writer.writeSubsequentPair("doc", md.getDescription(i));
        this.writer.writeSubsequentPair("abapType", this.getAbapType(md, i));
        this.writer.writeSubsequentPair("ddicName", md.getRecordTypeName(i));
        switch (md.getType(i)) {
            case 0: 
            case 4: 
            case 6: {
                this.writer.writeSubsequentPair("nucLength", md.getByteLength(i));
                this.writer.writeSubsequentPair("ucLength", md.getUnicodeByteLength(i));
                break;
            }
            case 2: {
                this.writer.writeSubsequentPair("nucLength", md.getByteLength(i));
                this.writer.writeSubsequentPair("ucLength", md.getUnicodeByteLength(i));
                this.writer.writeSubsequentPair("decimals", md.getDecimals(i));
                break;
            }
            case 17: 
            case 99: {
                int nucLength = md.getByteLength(i);
                int ucLength = md.getUnicodeByteLength(i);
                if (nucLength <= 0 && ucLength <= 0) break;
                this.writer.writeSubsequentPair("nucLength", nucLength);
                this.writer.writeSubsequentPair("ucLength", ucLength);
            }
        }
    }
}

