/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.json.JCoSerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class JSonParser {
    private Reader reader;
    private int next = -1;
    private int charsRead = 0;
    private boolean undone = false;
    private CharSequence buffer = null;

    public JSonParser(String source) {
        this(new StringReader(source));
        this.buffer = source;
    }

    public JSonParser(Reader reader) {
        this.reader = reader;
    }

    long position() {
        return this.charsRead;
    }

    private int nextChar() throws IOException {
        if (this.undone) {
            this.undone = false;
            return this.next;
        }
        this.next = this.reader.read();
        if (this.next != -1) {
            ++this.charsRead;
        }
        return this.next;
    }

    public int nextNonBlankChar() throws IOException {
        if (this.undone) {
            this.undone = false;
            return this.next;
        }
        while ((this.next = this.reader.read()) != -1) {
            ++this.charsRead;
            if (this.next <= 32) continue;
            return this.next;
        }
        this.next = -1;
        return -1;
    }

    char unescape(char escapedPart) {
        switch (escapedPart) {
            case '\\': {
                return '\\';
            }
            case '\"': {
                return '\"';
            }
            case 'a': {
                return '\u0007';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
            case '0': {
                return '\u0000';
            }
        }
        throw new JCoSerializationException("Unexpected char [" + escapedPart + "] in unescape()");
    }

    public String nextString() throws IOException {
        if (this.nextNonBlankChar() != 34) {
            throw new JCoSerializationException("'\"' expected, but '" + (char)this.next + "' read", this);
        }
        StringBuilder sb = new StringBuilder();
        this.nextChar();
        boolean escaped = false;
        while (this.next != -1 && (this.next != 34 || escaped)) {
            if (escaped) {
                sb.append(this.unescape((char)this.next));
                escaped = false;
            } else if (this.next == 92) {
                escaped = true;
            } else {
                sb.append((char)this.next);
            }
            this.nextChar();
        }
        if (this.next == -1) {
            throw new JCoSerializationException("Unterminated string");
        }
        return sb.toString();
    }

    public long nextLongOrLongString() throws IOException {
        long n = 0L;
        int ch = this.nextNonBlankChar();
        if ((char)ch == '\"') {
            ch = this.nextNonBlankChar();
        }
        boolean noDigit = true;
        while (Character.isDigit((char)ch)) {
            noDigit = false;
            n *= 10L;
            n += (long)(this.next - 48);
            ch = this.nextChar();
        }
        if ((char)ch != '\"') {
            this.undo();
        }
        if (noDigit) {
            throw new JCoSerializationException("Digit(s) expected", this);
        }
        return n;
    }

    public int nextIntOrIntString() throws IOException {
        return (int)this.nextLongOrLongString();
    }

    public String nextFloatAsString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int ch = this.nextNonBlankChar();
        if ((char)ch == '\"') {
            ch = this.nextNonBlankChar();
        }
        boolean noDigit = true;
        while (Character.isDigit((char)ch)) {
            noDigit = false;
            sb.append((char)ch);
            ch = this.nextChar();
        }
        this.undo();
        if (noDigit) {
            throw new JCoSerializationException("Digit(s) expected before \".\"", this);
        }
        char nextChar = this.assertChar('.', ',', '\"');
        if (nextChar == '\"' || nextChar == ',') {
            if (nextChar == '\"') {
                this.assertChar(',');
            }
            this.undo();
            return sb.toString();
        }
        sb.append('.');
        ch = this.nextChar();
        noDigit = true;
        while (Character.isDigit((char)ch) || !noDigit && (char)ch == 'E') {
            noDigit = false;
            sb.append((char)ch);
            ch = this.nextChar();
        }
        if ((char)ch != '\"') {
            this.undo();
        }
        if (noDigit) {
            throw new JCoSerializationException("Digit(s) expected after \".\"", this);
        }
        return sb.toString();
    }

    public boolean nextBool() throws IOException {
        switch (this.nextNonBlankChar()) {
            case 116: {
                this.assertString("rue");
                return true;
            }
            case 102: {
                this.assertString("alse");
                return false;
            }
        }
        throw new JCoSerializationException("Boolean value (true or false) expected", this);
    }

    public void nextValue() throws IOException {
        int c = this.nextNonBlankChar();
        this.undo();
        if (c == 34) {
            this.nextString();
        } else if (Character.isDigit(c)) {
            this.nextIntOrIntString();
        } else {
            this.nextBool();
        }
    }

    public void undo() {
        if (this.next > 32) {
            this.undone = true;
        }
    }

    public char assertChar(char ... c) throws IOException {
        char next = (char)this.nextNonBlankChar();
        for (char cToTest : c) {
            if (cToTest != next) continue;
            return cToTest;
        }
        throw new JCoSerializationException("Some of '" + new String(c) + "' expected, but '" + next + "' read", this);
    }

    String[] readStringArray() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        this.assertChar('[');
        while (this.nextNonBlankChar() == 34) {
            this.undo();
            strings.add(this.nextString());
            if (this.nextNonBlankChar() == 44) continue;
        }
        this.undo();
        this.assertChar(']');
        return strings.toArray(new String[strings.size()]);
    }

    public void assertString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.nextChar() == s.charAt(i)) continue;
            throw new JCoSerializationException("'" + s.charAt(i) + "' expected, but '" + (char)this.next + "' read", this);
        }
    }

    public String getPositionMessage() {
        StringBuilder sb = new StringBuilder(" near position ").append(this.charsRead).append(' ');
        if (this.buffer != null) {
            int last;
            int from = this.charsRead - 10;
            if (from < 0) {
                from = 0;
            }
            if ((last = this.charsRead + 10) > this.buffer.length()) {
                last = this.buffer.length();
            }
            sb.append("[");
            if (this.charsRead > 0) {
                sb.append(this.buffer.subSequence(from, this.charsRead));
            }
            sb.append('>').append(this.buffer.charAt(this.charsRead)).append('<');
            if (this.charsRead < last) {
                sb.append(this.buffer.subSequence(this.charsRead + 1, last));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean skipField() throws IOException {
        int tablesOpen = 0;
        int structuresOpen = 0;
        block7: while (true) {
            int nextChar = this.nextNonBlankChar();
            switch (nextChar) {
                case 91: {
                    ++tablesOpen;
                    break;
                }
                case 93: {
                    if (tablesOpen == 1 && structuresOpen == 0) {
                        return true;
                    }
                    if (tablesOpen == 0) {
                        this.undo();
                        return true;
                    }
                    --tablesOpen;
                    break;
                }
                case 123: {
                    ++structuresOpen;
                    break;
                }
                case 125: {
                    if (structuresOpen == 1 && tablesOpen == 0) {
                        return true;
                    }
                    if (structuresOpen == 0) {
                        this.undo();
                        return true;
                    }
                    --structuresOpen;
                    break;
                }
                case 44: {
                    if (tablesOpen != 0 || structuresOpen != 0) continue block7;
                    int tmpChar = this.nextNonBlankChar();
                    this.undo();
                    if (tmpChar != 34) continue block7;
                    return false;
                }
            }
        }
    }
}

