/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.json.Field;
import com.sap.conn.jco.rt.json.JCoSerializationException;
import com.sap.conn.jco.rt.json.JSonContainerReader;
import com.sap.conn.jco.rt.json.JSonParser;
import java.io.IOException;

class JSonStructureReader
extends JSonContainerReader {
    DefaultRecordMetaData md;
    int nestingType;

    JSonStructureReader(JSonParser parser) {
        super(parser);
    }

    @Override
    JSonStructureReader read(String name) throws IOException {
        this.md = (DefaultRecordMetaData)JCo.createRecordMetaData((String)name);
        this.nestingType = -1;
        this.readStructureAttributes();
        this.repo.addRecordMetaDataToCache(this.md);
        return this;
    }

    void readStructureAttributes() throws IOException {
        int nucLen = 0;
        int ucLen = 0;
        while (this.parser.nextNonBlankChar() == 44) {
            String attribute = this.parser.nextString();
            this.parser.assertChar(':');
            if ("nestingType".equals(attribute)) {
                this.nestingType = this.parser.nextIntOrIntString();
                continue;
            }
            if ("nucLength".equals(attribute)) {
                nucLen = this.parser.nextIntOrIntString();
                continue;
            }
            if ("ucLength".equals(attribute)) {
                ucLen = this.parser.nextIntOrIntString();
                continue;
            }
            if ("fields".equals(attribute)) {
                if (this.nestingType == -1) {
                    throw new JCoSerializationException("Missing attribute \"nestingType\" for structure " + this.md.getName());
                }
                this.readFields();
                continue;
            }
            throw new JCoSerializationException("Unknown attribute \"" + attribute + "\" for structure " + this.md.getName(), this.parser);
        }
        this.md.setRecordLength(nucLen, ucLen);
        if (this.nestingType == 1) {
            this.md.markAsNestedType1Structure();
        }
        this.parser.undo();
    }

    @Override
    void setField(Field f) {
        if (f.ucOffset == -1 || f.nucOffset == -1) {
            throw new JCoSerializationException("Missing offsets for field " + f.name + " of structure " + this.md.getName());
        }
        int type = AbstractMetaData.getJCOType(f.type);
        if (this.nestingType == 1 && type == 17) {
            JCoRecordMetaData struct = this.repo.getRecordMetaDataFromCache(f.ddicName);
            if (struct == null) {
                throw new JCoRuntimeException(190, "Unable to resolve " + f.ddicName);
            }
            this.md.add(f.name, type, f.nucLength, f.nucOffset, f.ucLength, f.ucOffset, f.decimals, f.descr, struct, null);
        } else {
            this.md.add(f.name, type, f.nucLength, f.nucOffset, f.ucLength, f.ucOffset, f.decimals, f.descr, f.ddicName, null);
        }
    }
}

