/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.CustomRepository;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.json.JCoSerializationException;
import com.sap.conn.jco.rt.json.JSonClassMetaDataReader;
import com.sap.conn.jco.rt.json.JSonFunctionTemplateReader;
import com.sap.conn.jco.rt.json.JSonParser;
import com.sap.conn.jco.rt.json.JSonStructureReader;
import com.sap.conn.jco.rt.json.JSonTableReader;
import java.io.IOException;
import java.io.Reader;

public class RepReader {
    private BasicRepository repo;

    public RepReader(BasicRepository repo) {
        this.repo = repo;
    }

    public void load(Reader reader) throws IOException {
        this.load(new JSonParser(reader));
    }

    void load(JSonParser parser) throws IOException {
        int ch;
        parser.assertChar('{');
        boolean isVersionOk = false;
        boolean first = true;
        while ((ch = parser.nextNonBlankChar()) != -1) {
            if (ch == 125) {
                if (isVersionOk) {
                    return;
                }
                throw new JCoSerializationException("Missing attribute \"format\"");
            }
            if (first) {
                first = false;
                parser.undo();
            } else if (ch != 44) {
                throw new JCoSerializationException("Missing ','", parser);
            }
            String attribute = parser.nextString();
            if ("name".equals(attribute)) {
                parser.assertChar(':');
                parser.nextString();
                continue;
            }
            if ("unicodeEnabled".equals(attribute)) {
                parser.assertChar(':');
                boolean isUc = parser.nextBool();
                if (!(this.repo instanceof CustomRepository)) continue;
                ((CustomRepository)this.repo).setContainsUnicodeInfo(isUc);
                continue;
            }
            if ("structures".equals(attribute)) {
                parser.assertChar(':');
                new JSonStructureReader(parser).read(this.repo);
                continue;
            }
            if ("tables".equals(attribute)) {
                parser.assertChar(':');
                new JSonTableReader(parser).read(this.repo);
                continue;
            }
            if ("functions".equals(attribute)) {
                parser.assertChar(':');
                new JSonFunctionTemplateReader(parser).read(this.repo);
                continue;
            }
            if ("classes".equals(attribute)) {
                parser.assertChar(':');
                new JSonClassMetaDataReader(parser).read(this.repo);
                continue;
            }
            if ("format".equals(attribute)) {
                parser.assertChar(':');
                String version = parser.nextString();
                isVersionOk = version.startsWith("1.");
                if (isVersionOk) continue;
                throw new JCoSerializationException("Unable to read serialization format " + version + ". The only supported format by this implementation is 1.x");
            }
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "Unknown repository attribute \"" + attribute + "\"");
            }
            throw new JCoSerializationException("Unknown repository attribute " + attribute);
        }
        throw new JCoSerializationException("Unexpected end of stream (repository incomplete)");
    }
}

