/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.json.JSonRepoConsts;
import com.sap.conn.jco.rt.json.JSonStructureWriter;
import com.sap.conn.jco.rt.json.JSonWriter;
import com.sap.conn.jco.rt.json.RecordCacheIterator;
import java.io.IOException;

class StructureCacheIterator
extends RecordCacheIterator {
    StructureCacheIterator(BasicRepository rep) {
        super(rep, rep.getCachedRecordMetaDataNames(), "structures");
    }

    @Override
    boolean isWanted(DefaultRecordMetaData md) {
        return !JSonRepoConsts.isVector(md) && !this.isProcessed(this.getStructName(md));
    }

    private String getStructName(DefaultRecordMetaData md) {
        String structName = md.getLineType();
        return structName != null ? structName : md.getName();
    }

    @Override
    public DefaultRecordMetaData next() {
        DefaultRecordMetaData next = (DefaultRecordMetaData)super.next();
        this.markAsProcessed(this.getStructName(next));
        return next;
    }

    @Override
    void writeMetaData(DefaultRecordMetaData type, JSonWriter writer) throws IOException {
        new JSonStructureWriter(writer).writeMetaData(type);
    }
}

