/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.JCoTraceWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jTraceWriter
extends Trace
implements JCoTraceWriter {
    private static Log4jTraceWriter self = null;
    private Logger logger = Logger.getLogger((String)"com.sap.conn.jco");
    private Level currentLevel = Level.OFF;

    public static synchronized void initialize() {
        if (self == null) {
            self = new Log4jTraceWriter();
            Trace.addTraceWriter(self);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninitialize() {
        if (self != null) {
            try {
                Trace.removeTraceWriter(self);
            }
            finally {
                self = null;
            }
        }
    }

    @Override
    public void trace(int level, String message) {
        try {
            if (level == 0) {
                this.logger.fatal((Object)message);
            } else if ((level & 1) != 0) {
                this.logger.error((Object)message);
            } else if ((level & 2) != 0) {
                this.logger.warn((Object)message);
            } else if ((level & 4) != 0) {
                this.logger.info((Object)message);
            } else if ((level & 0x20) != 0) {
                this.logger.debug((Object)message);
            } else if ((level & 0x40) != 0 || (level & 8) != 0) {
                this.logger.trace((Object)message);
            } else {
                this.logger.log((Priority)Level.ALL, (Object)message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getTraceLevel() {
        int logLevel = 0;
        Level level = this.logger.getEffectiveLevel();
        if (level == Level.OFF) {
            logLevel = 0;
        } else if (level == Level.ERROR || level == Level.FATAL) {
            logLevel |= 1;
        } else if (level == Level.WARN) {
            logLevel |= 3;
        } else if (level == Level.INFO) {
            logLevel |= 7;
        } else if (level == Level.DEBUG) {
            logLevel |= 0x27;
        } else if (level == Level.TRACE) {
            logLevel |= 0x6F;
        } else if (level == Level.ALL) {
            logLevel |= 0xFF;
        }
        if (this.currentLevel != level) {
            this.currentLevel = level;
            Trace.writeInfo(this);
        }
        return logLevel;
    }
}

