/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

public abstract class NumberConverter {
    private static String createExceptionMessage(char[] number, int offset, int length, String type) {
        return new StringBuilder().append("Invalid format of '").append(number, offset, length).append("' to be interpreted as ").append(type).toString();
    }

    public static int parseInt(char[] number, int offset, int length) throws NumberFormatException {
        int overflowCheck;
        if (length == 0) {
            throw new NumberFormatException("Integer needs a length larger than 0");
        }
        int intValue = 0;
        boolean isNegative = false;
        int i = offset;
        int end = offset + length;
        int currentDigit = -1;
        if (number[offset] == '-') {
            isNegative = true;
            overflowCheck = Integer.MIN_VALUE;
            ++i;
        } else {
            overflowCheck = -2147483647;
        }
        int overflowCheckBeforeLastDigit = overflowCheck / 10;
        while (i < end) {
            if (intValue < overflowCheckBeforeLastDigit) {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "int"));
            }
            if (number[i] < '0' || number[i] > '9') {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "int"));
            }
            currentDigit = number[i] - 48;
            ++i;
            if ((intValue *= 10) < overflowCheck + currentDigit) {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "int"));
            }
            intValue -= currentDigit;
        }
        if (isNegative) {
            if (i > offset + 1) {
                return intValue;
            }
            throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "int"));
        }
        return -intValue;
    }

    public static long parseLong(char[] number, int offset, int length) {
        long overflowCheck;
        if (length == 0) {
            throw new NumberFormatException("Long needs a length larger than 0");
        }
        long longValue = 0L;
        boolean isNegative = false;
        int i = offset;
        int end = offset + length;
        int currentDigit = -1;
        if (number[offset] == '-') {
            isNegative = true;
            overflowCheck = Long.MIN_VALUE;
            ++i;
        } else {
            overflowCheck = -9223372036854775807L;
        }
        long overflowCheckBeforeLastDigit = overflowCheck / 10L;
        while (i < end) {
            if (longValue < overflowCheckBeforeLastDigit) {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "long"));
            }
            if (number[i] < '0' || number[i] > '9') {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "long"));
            }
            currentDigit = number[i] - 48;
            ++i;
            if ((longValue *= 10L) < overflowCheck + (long)currentDigit) {
                throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "long"));
            }
            longValue -= (long)currentDigit;
        }
        if (isNegative) {
            if (i > offset + 1) {
                return longValue;
            }
            throw new NumberFormatException(NumberConverter.createExceptionMessage(number, offset, length, "long"));
        }
        return -longValue;
    }
}

