/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.rt.AbstractMetaData;

public class UtcTypes {
    public static final int SECONDS_PER_DAY = 86400;
    static final int MINUTES_PER_DAY = 1440;
    static short[] daysOfMonths = new short[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static void checkRange(long value, int type) {
        switch (type) {
            case 51: {
                UtcLong.checkRange(value);
                break;
            }
            case 52: {
                UtcSecond.checkRange(value);
                break;
            }
            case 53: {
                UtcMinute.checkRange(value);
                break;
            }
            case 54: {
                DtDay.checkRange(value);
                break;
            }
            case 55: {
                DtWeek.checkRange(value);
                break;
            }
            case 56: {
                DtMonth.checkRange(value);
                break;
            }
            case 57: {
                TSecond.checkRange(value);
                break;
            }
            case 58: {
                TMinute.checkRange(value);
                break;
            }
            case 59: {
                Cday.checkRange(value);
                break;
            }
            default: {
                throw new ConversionException("Unexpected type " + AbstractMetaData.getJCOTypeString(type) + " in UtcTypes.checkRange");
            }
        }
    }

    static boolean IsLeapYear(int year) {
        return year < 1582 ? year % 4 == 0 : year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    static int parseHMS(String value, int offset, boolean withSeconds) {
        int hours = Integer.parseInt(value.substring(offset, offset + 2));
        if (hours < 0 || hours > 24) {
            throw new ConversionException("" + hours + " out of hours range 00..24");
        }
        int minutes = Integer.parseInt(value.substring(offset + 3, offset + 3 + 2));
        if (minutes < 0 || minutes > 59) {
            throw new ConversionException("" + minutes + " out of minutes range 00..59");
        }
        if (withSeconds) {
            int seconds = Integer.parseInt(value.substring(offset + 6, offset + 6 + 2));
            if (seconds < 0 || seconds > 59) {
                throw new ConversionException("" + seconds + " out of seconds range 00..59");
            }
            return hours * 3600 + minutes * 60 + seconds;
        }
        return hours * 60 + minutes;
    }

    protected static YMD parseYMD(String value) {
        int daysInMonth;
        YMD d = new YMD();
        d.year = Integer.parseInt(value.substring(0, 4));
        if (d.year < 1 || d.year > 9999) {
            throw new ConversionException(new Integer(d.year).toString() + " out of years range 0001..9999");
        }
        d.month = Integer.parseInt(value.substring(5, 7));
        if (d.month < 1 || d.month > 12) {
            throw new ConversionException(new Integer(d.month).toString() + " out of months range 01..12");
        }
        d.day = Integer.parseInt(value.substring(8, 10));
        int n = d.month == 2 ? (UtcTypes.IsLeapYear(d.year) ? 29 : 28) : (daysInMonth = daysOfMonths[d.month - 1]);
        if (d.day < 1 || d.day > daysInMonth) {
            throw new ConversionException(new Integer(d.day).toString() + " out of days range 01.." + daysInMonth);
        }
        if (d.year == 1582 && d.month == 10 && d.day > 4 && d.day < 15) {
            throw new ConversionException("this date does not exist due to introduction of Gregorian calendar (10 days were dropped: Oct 5 through Oct 14)");
        }
        return d;
    }

    protected static int YMDToInt(YMD d) {
        int dtday = UtcTypes.DaysInPreviousYears(d.year);
        for (int i = 0; i < d.month - 1; ++i) {
            dtday += i == 1 ? (UtcTypes.IsLeapYear(d.year) ? 29 : 28) : (d.year == 1582 && i == 9 ? 21 : daysOfMonths[i]);
        }
        if (d.year == 1582 && d.month == 10 && d.day >= 15) {
            d.day -= 10;
        }
        return dtday + d.day - 1;
    }

    protected static YMD intToYMD(int dtday) {
        YMD d = new YMD();
        d.year = dtday / 365 + 1;
        while (d.year > 1 && UtcTypes.DaysInPreviousYears(d.year) > dtday) {
            --d.year;
        }
        dtday -= UtcTypes.DaysInPreviousYears(d.year);
        d.month = 0;
        int daysInMonth = daysOfMonths[0];
        while (dtday >= daysInMonth) {
            dtday -= daysInMonth;
            ++d.month;
            daysInMonth = d.month == 1 ? (UtcTypes.IsLeapYear(d.year) ? 29 : 28) : (d.year == 1582 && d.month == 9 ? 21 : daysOfMonths[d.month]);
        }
        ++d.month;
        d.day = dtday + 1;
        if (d.year == 1582 && d.month == 10 && d.day > 4) {
            d.day += 10;
        }
        return d;
    }

    protected static int DaysInPreviousYears(int currentYear) {
        int lastYear = currentYear - 1;
        int julianYears = lastYear > 1600 ? 1600 : lastYear;
        int r = julianYears % 100;
        int days = julianYears / 100 * 36525 + (r >> 2) * 1461 + r % 4 * 365;
        if (currentYear > 1582) {
            days -= 10;
        }
        if (lastYear > 1600) {
            int y = lastYear - 1600;
            days += y / 400 * 146097;
            r = (y %= 400) % 100;
            days += y / 100 * 36524 + (r >> 2) * 1461 + r % 4 * 365;
        }
        return days;
    }

    protected static void appendHMS(StringBuilder sb, int hours, int minutes, int seconds) {
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        if (seconds >= 0) {
            sb.append(':');
            if (seconds < 10) {
                sb.append('0');
            }
            sb.append(seconds);
        }
    }

    protected static void appendYMD(StringBuilder sb, int year, int month, int day) {
        String yearS = String.valueOf(year);
        if (year < 1000) {
            sb.append("0000".substring(yearS.length()));
        }
        sb.append(yearS);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        if (day >= 0) {
            sb.append('-');
            if (day < 10) {
                sb.append('0');
            }
            sb.append(day);
        }
    }

    static class YMD {
        int year;
        int month;
        int day;

        YMD() {
        }
    }

    public static class Cday {
        private static final int STRING_LEN = 5;
        public static final short MAX = 366;
        public static final short DEFAULT = 0;

        public static void checkRange(long value) {
            short casted_value = (short)value;
            if ((long)casted_value != value || value < 0L || value > 366L) {
                throw new ConversionException("Value " + value + " is out of CDAY range [" + 0 + ", " + 366 + "].");
            }
        }

        public static short parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Short.valueOf(value) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 5;
            if (legalFormat) {
                for (int i = 0; i < 5 && legalFormat; ++i) {
                    legalFormat = i == 2 ? value.charAt(i) == '-' : Character.isDigit(value.charAt(i));
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into CDAY: illegal format");
            }
            try {
                short month = Short.parseShort(value.substring(0, 2));
                if (month < 1 || month > 12) {
                    throw new ConversionException("illegal month: " + month);
                }
                short cday = -1;
                for (int i = 0; i < month - 1; ++i) {
                    cday = (short)(cday + daysOfMonths[i]);
                }
                short day = Short.parseShort(value.substring(3));
                if (day < 1 || day > daysOfMonths[month - 1]) {
                    throw new ConversionException("illegal day for month " + month + ": " + day);
                }
                cday = (short)(cday + (day + 1));
                return cday;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into CDAY", (Throwable)ex);
            }
        }

        public static String toString(short value) {
            if (value == 0) {
                return "01-01";
            }
            short cday = (short)(value - 1);
            int day = 0;
            int month = 1;
            for (int i = 0; i < daysOfMonths.length; ++i) {
                if (cday < daysOfMonths[i]) {
                    day = cday + 1;
                    break;
                }
                cday = (short)(cday - daysOfMonths[i]);
                ++month;
            }
            if (day <= 0) {
                throw new ConversionException("cannot convert internal representation (short)" + cday + " into CDAY");
            }
            StringBuilder sb = new StringBuilder(5);
            if (month < 10) {
                sb.append('0');
            }
            sb.append(month);
            sb.append('-');
            if (day < 10) {
                sb.append('0');
            }
            sb.append(day);
            return sb.toString();
        }
    }

    public static class TMinute {
        private static final int STRING_LEN = 5;
        public static final short MAX = 1441;
        public static final short DEFAULT = 0;

        public static void checkRange(long value) {
            short casted_value = (short)value;
            if ((long)casted_value != value || value < 0L || value > 1441L) {
                throw new ConversionException("Value " + value + " is out of TMINUTE range [" + 0 + ", " + 1441 + "].");
            }
        }

        public static short parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Short.valueOf(value) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 5;
            if (legalFormat) {
                for (int i = 0; i < 5 && legalFormat; ++i) {
                    legalFormat = i == 2 ? value.charAt(i) == ':' : Character.isDigit(value.charAt(i));
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into TMINUTE: illegal format");
            }
            try {
                short tminute = (short)UtcTypes.parseHMS(value, 0, false);
                if (tminute > 1440) {
                    throw new ConversionException("TMINUTE out of range 00:00..24:00");
                }
                return (short)(tminute + 1);
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into TMINUTE", (Throwable)ex);
            }
        }

        public static String toString(short value) {
            if (value == 0) {
                return "00:00";
            }
            short tminute = (short)(value - 1);
            StringBuilder sb = new StringBuilder(5);
            UtcTypes.appendHMS(sb, tminute / 60, tminute % 60, -1);
            return sb.toString();
        }
    }

    public static class TSecond {
        private static final int STRING_LEN = 8;
        public static final int MAX = 86401;
        public static final int DEFAULT = 0;

        public static void checkRange(long value) {
            int casted_value = (int)value;
            if ((long)casted_value != value || value < 0L || value > 86401L) {
                throw new ConversionException("Value " + value + " is out of TSECOND range [" + 0 + ", " + 86401 + "].");
            }
        }

        public static int parse(String tseconds) {
            boolean legalFormat;
            if ((tseconds = tseconds.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Integer.valueOf(tseconds) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = tseconds.length() == 8;
            if (legalFormat) {
                for (int i = 0; i < tseconds.length() && legalFormat; ++i) {
                    legalFormat = i == 2 || i == 5 ? tseconds.charAt(i) == ':' : Character.isDigit(tseconds.charAt(i));
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + tseconds + " into TSECOND: illegal format");
            }
            try {
                int tsecond = UtcTypes.parseHMS(tseconds, 0, true);
                if (tsecond > 86400) {
                    throw new ConversionException("TSECOND out of range 00:00:00..24:00:00");
                }
                return tsecond + 1;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + tseconds + " into TSECOND", (Throwable)ex);
            }
        }

        public static String toString(int value) {
            if (value == 0) {
                return "";
            }
            int tsecond = value - 1;
            int sec = tsecond % 3600;
            StringBuilder sb = new StringBuilder(8);
            UtcTypes.appendHMS(sb, tsecond / 3600, sec / 60, sec % 60);
            return sb.toString();
        }
    }

    public static class DtMonth {
        private static final int STRING_LEN = 7;
        public static final int MAX = 119988;
        public static final int DEFAULT = 0;

        public static void checkRange(long value) {
            int casted_value = (int)value;
            if ((long)casted_value != value || value < 0L || value > 119988L) {
                throw new ConversionException("Value " + value + " is out of DTMONTH range [" + 0 + ", " + 119988 + "].");
            }
        }

        public static int parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Integer.valueOf(value) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 7;
            if (legalFormat) {
                for (int i = 0; i < 7 && legalFormat; ++i) {
                    legalFormat = i == 4 ? value.charAt(i) == '-' : Character.isDigit(value.charAt(i));
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into DTMONTH: illegal format");
            }
            try {
                int year = Integer.parseInt(value.substring(0, 4));
                if (year < 1 || year > 9999) {
                    throw new ConversionException(new Integer(year).toString() + " out of years range 0001..9999");
                }
                int month = Integer.parseInt(value.substring(5));
                if (month < 1 || month > 12) {
                    throw new ConversionException(new Integer(month).toString() + " out of months range 01..12");
                }
                return (year - 1) * 12 + month - 1 + 1;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into DTMONTH", (Throwable)ex);
            }
        }

        public static String toString(int value) {
            if (value == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder(7);
            UtcTypes.appendYMD(sb, --value / 12 + 1, value % 12 + 1, -1);
            return sb.toString();
        }
    }

    public static class DtWeek {
        private static final int STRING_LEN = 8;
        public static final int MAX = 521725;
        public static final int DEFAULT = 0;
        static int maxYear = 0;
        static int currentJan1 = -1;
        static int[] yearsWithW53 = null;
        static int nextIndex = 0;

        public static void checkRange(long value) {
            int casted_value = (int)value;
            if ((long)casted_value != value || value < 0L || value > 521725L) {
                throw new ConversionException("Value " + value + " is out of DTWEEK range [" + 0 + ", " + 521725 + "].");
            }
        }

        public static int parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Integer.valueOf(value) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 8;
            if (legalFormat) {
                block8: for (int i = 0; i < 8 && legalFormat; ++i) {
                    switch (i) {
                        case 4: {
                            legalFormat = value.charAt(i) == '-';
                            continue block8;
                        }
                        case 5: {
                            legalFormat = value.charAt(i) == 'W';
                            continue block8;
                        }
                        default: {
                            legalFormat = Character.isDigit(value.charAt(i));
                        }
                    }
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into DTWEEK: illegal format");
            }
            try {
                int year = Integer.parseInt(value.substring(0, 4));
                if (year < 0 || year > 9999) {
                    throw new ConversionException(new Integer(year).toString() + " out of years range 0000..9999");
                }
                int week = Integer.parseInt(value.substring(6));
                if (week < 1 || week > 53) {
                    throw new ConversionException(new Integer(week).toString() + " out weeks range 01..53");
                }
                return DtWeek.yearAndWeekToInt(year, week) + 1;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into DTWEEK", (Throwable)ex);
            }
        }

        public static String toString(int value) {
            int w53year;
            int index;
            if (value == 0) {
                return "0";
            }
            if (--value == 0) {
                return "0000-W53";
            }
            int year = 0;
            int week = 0;
            year = (value - 1) / 52 + 1;
            if (year > 9999) {
                year = 9999;
            }
            for (index = DtWeek.PriorW53YearsCount(year); index > 0 && value - (index * 53 + ((w53year = yearsWithW53[index - 1]) - index) * 52) < 0; --index) {
            }
            if (index > 0) {
                year = yearsWithW53[index - 1];
                if ((value -= index * 53 + (year - index) * 52) == 0) {
                    week = 53;
                }
            } else {
                year = 0;
            }
            if (week == 0) {
                int y = (value - 1) / 52;
                week = value - y * 52;
                year += y + 1;
            }
            return String.format("%04d-W%02d", year, week);
        }

        private static int yearAndWeekToInt(int year, int week) {
            if (year == 0) {
                if (week == 53) {
                    return 0;
                }
                throw new ConversionException("year 0000 can only be used in conjunction with W53 (0000-W53)");
            }
            int index = DtWeek.PriorW53YearsCount(year);
            if (week == 53 && (nextIndex == 0 || yearsWithW53[index] != year)) {
                String yearS = new Integer(year).toString();
                if (year < 1000) {
                    yearS = "0000".substring(yearS.length()) + yearS;
                }
                throw new ConversionException("year " + yearS + " does not have 53 weeks");
            }
            return index * 53 + (year - 1 - index) * 52 + week;
        }

        private static int PriorW53YearsCount(int year) {
            int index;
            if (year >= maxYear) {
                if (yearsWithW53 == null) {
                    yearsWithW53 = new int[1776];
                    currentJan1 = 5;
                    maxYear = 1;
                }
                while (maxYear <= year) {
                    boolean isLeapYear = UtcTypes.IsLeapYear(maxYear);
                    if (currentJan1 == 3 || currentJan1 == 2 && isLeapYear) {
                        DtWeek.yearsWithW53[DtWeek.nextIndex++] = maxYear;
                    }
                    currentJan1 = maxYear == 1582 ? 5 : (currentJan1 + (isLeapYear ? 2 : 1)) % 7;
                    ++maxYear;
                }
            }
            for (index = nextIndex; index > 0 && yearsWithW53[index - 1] >= year; --index) {
            }
            return index;
        }
    }

    public static class DtDay {
        private static final int STRING_LEN = 10;
        public static final int MAX = 3652061;
        public static final int DEFAULT = 0;

        public static void checkRange(long value) {
            int casted_value = (int)value;
            if ((long)casted_value != value || value < 0L || value > 3652061L) {
                throw new ConversionException("Value " + value + " is out of DTDAY range [" + 0 + ", " + 3652061 + "].");
            }
        }

        public static int parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0;
            }
            try {
                if (Integer.valueOf(value) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 10;
            if (legalFormat) {
                for (int i = 0; i < 10 && legalFormat; ++i) {
                    legalFormat = i == 4 || i == 7 ? value.charAt(i) == '-' : Character.isDigit(value.charAt(i));
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into DTDAY: illegal format");
            }
            try {
                YMD d = UtcTypes.parseYMD(value);
                return UtcTypes.YMDToInt(d) + 1;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into DTDAY", (Throwable)ex);
            }
        }

        public static String toString(int value) {
            if (value == 0) {
                return "";
            }
            YMD d = UtcTypes.intToYMD(value - 1);
            StringBuilder sb = new StringBuilder(10);
            UtcTypes.appendYMD(sb, d.year, d.month, d.day);
            return sb.toString();
        }
    }

    public static class UtcMinute {
        private static final int STRING_LEN = 16;
        public static final long MAX = 5258967840L;
        public static final long DEFAULT = 0L;

        public static void checkRange(long value) {
            if (value < 0L || value > 5258967840L) {
                throw new ConversionException("Value " + value + " is out of UTCSECOND range [" + 0L + ", " + 5258967840L + "].");
            }
        }

        public static long parse(String value) {
            boolean legalFormat;
            if ((value = value.trim()).length() == 0) {
                return 0L;
            }
            try {
                if (Long.valueOf(value) == 0L) {
                    return 0L;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = value.length() == 16;
            if (legalFormat) {
                block9: for (int i = 0; i < 16 && legalFormat; ++i) {
                    switch (i) {
                        case 4: 
                        case 7: {
                            legalFormat = value.charAt(i) == '-';
                            continue block9;
                        }
                        case 10: {
                            legalFormat = value.charAt(i) == 'T';
                            continue block9;
                        }
                        case 13: {
                            legalFormat = value.charAt(i) == ':';
                            continue block9;
                        }
                        default: {
                            legalFormat = Character.isDigit(value.charAt(i));
                        }
                    }
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + value + " into UTCMINUTE: illegal format");
            }
            try {
                YMD d = UtcTypes.parseYMD(value);
                int minutes = UtcTypes.parseHMS(value, 11, false);
                if (minutes >= 1440) {
                    throw new ConversionException("UTCMINUTE " + value + ": HH:MM out of range 00:00..23:59");
                }
                long utcminute = (long)UtcTypes.YMDToInt(d) * 1440L + (long)minutes + 1L;
                return utcminute;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + value + " into UTCMINUTE", (Throwable)ex);
            }
        }

        public static String toString(long value) {
            if (value == 0L) {
                return "0001-01-01T00:00";
            }
            YMD d = UtcTypes.intToYMD((int)(--value / 1440L));
            int minutes = (int)(value % 1440L);
            StringBuilder sb = new StringBuilder(16);
            UtcTypes.appendYMD(sb, d.year, d.month, d.day);
            sb.append('T');
            UtcTypes.appendHMS(sb, minutes / 60, minutes % 60, -1);
            return sb.toString();
        }
    }

    public static class UtcSecond {
        private static final int STRING_LEN = 19;
        public static final long MAX = 315538070400L;
        public static final long DEFAULT = 0L;

        public static void checkRange(long value) {
            if (value < 0L || value > 315538070400L) {
                throw new ConversionException("Value " + value + " is out of UTCSECOND range [" + 0L + ", " + 315538070400L + "].");
            }
        }

        public static long parse(String utcseconds) {
            boolean legalFormat;
            if ((utcseconds = utcseconds.trim()).length() == 0) {
                return 0L;
            }
            try {
                if (Long.valueOf(utcseconds) == 0L) {
                    return 0L;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = utcseconds.length() == 19;
            if (legalFormat) {
                block9: for (int i = 0; i < utcseconds.length() && legalFormat; ++i) {
                    switch (i) {
                        case 4: 
                        case 7: {
                            legalFormat = utcseconds.charAt(i) == '-';
                            continue block9;
                        }
                        case 10: {
                            legalFormat = utcseconds.charAt(i) == 'T';
                            continue block9;
                        }
                        case 13: 
                        case 16: {
                            legalFormat = utcseconds.charAt(i) == ':';
                            continue block9;
                        }
                        default: {
                            legalFormat = Character.isDigit(utcseconds.charAt(i));
                        }
                    }
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + utcseconds + " into UTCSECOND: illegal format");
            }
            try {
                YMD d = UtcTypes.parseYMD(utcseconds);
                int seconds = UtcTypes.parseHMS(utcseconds, 11, true);
                if (seconds >= 86400) {
                    throw new ConversionException("UTCSECOND " + utcseconds + ": HH:MM:SS out of range 00:00:00..23:59:59");
                }
                long utcsecond = (long)UtcTypes.YMDToInt(d) * 86400L + (long)seconds + 1L;
                return utcsecond;
            }
            catch (Exception ex) {
                throw new ConversionException("Cannot convert " + utcseconds + " into UTCSECOND", (Throwable)ex);
            }
        }

        public static String toString(long utcsecs) {
            if (utcsecs == 0L) {
                return "0001-01-01T00:00:00";
            }
            YMD d = UtcTypes.intToYMD((int)(--utcsecs / 86400L));
            int seconds = (int)(utcsecs % 86400L);
            int sec = seconds % 3600;
            StringBuilder sb = new StringBuilder(19);
            UtcTypes.appendYMD(sb, d.year, d.month, d.day);
            sb.append('T');
            UtcTypes.appendHMS(sb, seconds / 3600, sec / 60, sec % 60);
            return sb.toString();
        }
    }

    public static class UtcLong {
        private static final int STRING_LEN = 27;
        private static final long USEC_PER_SECOND = 10000000L;
        private static final long USEC_PER_DAY = 864000000000L;
        public static final long MAX = 3155380704000000000L;
        public static final long DEFAULT = 0L;

        public static void checkRange(long value) {
            if (value < 0L || value > 3155380704000000000L) {
                throw new ConversionException("Value " + value + " is out of UTCLONG range [" + 0L + ", " + 3155380704000000000L + "].");
            }
        }

        public static long parse(String utc) {
            boolean legalFormat;
            if ((utc = utc.trim()).length() == 0) {
                return 0L;
            }
            try {
                if (Long.valueOf(utc) == 0L) {
                    return 0L;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = legalFormat = utc.length() == 27;
            if (legalFormat) {
                block8: for (int i = 0; i < utc.length() && legalFormat; ++i) {
                    switch (i) {
                        case 4: 
                        case 7: {
                            legalFormat = utc.charAt(i) == '-';
                            continue block8;
                        }
                        case 10: {
                            legalFormat = utc.charAt(i) == 'T';
                            continue block8;
                        }
                        case 13: 
                        case 16: {
                            legalFormat = utc.charAt(i) == ':';
                            continue block8;
                        }
                        case 19: {
                            legalFormat = utc.charAt(i) == ',';
                            continue block8;
                        }
                        default: {
                            legalFormat = Character.isDigit(utc.charAt(i));
                        }
                    }
                }
            }
            if (!legalFormat) {
                throw new ConversionException("Cannot convert " + utc + " into UTCLONG: illegal format");
            }
            YMD d = UtcTypes.parseYMD(utc);
            int seconds = UtcTypes.parseHMS(utc, 11, true);
            int usec = Integer.parseInt(utc.substring(20));
            if (seconds >= 86400) {
                throw new ConversionException("UTCLONG " + utc + ": HH:MM:SS out of range 00:00:00..23:59:59");
            }
            long utclong = ((long)UtcTypes.YMDToInt(d) * 86400L + (long)seconds) * 10000000L + (long)usec + 1L;
            return utclong;
        }

        public static String toString(long value) {
            if (value == 0L) {
                return "0001-01-01T00:00:00,0000000";
            }
            YMD d = UtcTypes.intToYMD((int)(--value / 864000000000L));
            long usec = value % 864000000000L;
            int seconds = (int)(usec / 10000000L);
            usec %= 10000000L;
            int sec = seconds % 3600;
            StringBuilder sb = new StringBuilder(27);
            UtcTypes.appendYMD(sb, d.year, d.month, d.day);
            sb.append('T');
            UtcTypes.appendHMS(sb, seconds / 3600, sec / 60, sec % 60);
            sb.append(',');
            String usecS = String.valueOf(usec);
            sb.append("0000000".substring(usecS.length())).append(usec);
            return sb.toString();
        }
    }
}

