/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.api;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Language;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcInvalidConfigurationException;
import java.util.Locale;
import java.util.Properties;

public final class RfcOptions {
    private Properties properties;
    private String propertyPrefix;
    private String destination = null;
    private char type = (char)63;
    private String sysnr = null;
    private int trace;
    private int cpicTrace;
    private boolean logonCheck = true;
    private byte allocationType;
    private String ashost = null;
    private String gwhost = null;
    private String gwserv = null;
    private String saprouter = null;
    private boolean useSymbolicService = false;
    private String user = null;
    private String alias_user = null;
    private boolean usePrincipalPropagation = false;
    private String client = null;
    private String language = null;
    private byte[] password = null;
    private int pcs = 1;
    private int useSAPGui = 0;
    private boolean abapDebug = false;
    private String communication_cp = null;
    private boolean getsso2 = false;
    private boolean containsMysapSSO2 = false;
    private boolean containsX509cert = false;
    private String extid_data = null;
    private String extid_type = null;
    private static final int RFC_SNC_MODE_OFF = 0;
    private static final int RFC_SNC_MODE_ON = 1;
    private int snc_mode = 0;
    private int snc_qop = 8;
    private String snc_myname = null;
    private String snc_partnername = null;
    private String snc_lib = null;
    private boolean sncUseSSO = true;
    private String r3name = null;
    private String group = null;
    private boolean sticky = false;
    private String mshost = null;
    private String msserv = null;
    private String stickyAppserver = null;
    private String reg_name = null;
    private String reg_host = null;
    private boolean useDeltaManagement = true;
    private int cloudConnectorVersion = -1;
    private String cloudConnectorLocationId = "";
    private short serializationFormat = 0;
    private boolean useBasXML = true;

    public RfcOptions(char type) {
        this.type = type;
        this.allocationType = (byte)3;
    }

    private boolean isNumericString(String str, int len) {
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private void throwConfigurationExceptionWithTrace(String message) throws RfcInvalidConfigurationException {
        this.throwConfigurationExceptionWithTrace(message, null);
    }

    private void throwConfigurationExceptionWithTrace(String message, Throwable cause) throws RfcInvalidConfigurationException {
        RfcInvalidConfigurationException ce = new RfcInvalidConfigurationException(message, this, cause);
        Trc.criticalTrace(message, ce);
        throw ce;
    }

    private void checkClient() throws RfcInvalidConfigurationException {
        if (this.client == null) {
            throw new RfcInvalidConfigurationException("Parameter SAP client ('jco.client.client') is missing", this);
        }
        int len = this.client.length();
        boolean throwException = false;
        if (len == 3) {
            if (!this.client.equals("XXX") && !this.isNumericString(this.client, len)) {
                throwException = true;
            }
        } else if (this.client.length() < 3) {
            char d1 = '0';
            char d2 = '0';
            if (this.client.length() == 2) {
                d1 = this.client.charAt(0);
                d2 = this.client.charAt(1);
            } else if (this.client.length() == 1) {
                d2 = this.client.charAt(0);
            }
            if (d1 >= '0' && d1 <= '9' && d2 >= '0' && d2 <= '9') {
                this.client = new StringBuilder(3).append('0').append(d1).append(d2).toString();
            } else {
                throwException = true;
            }
        } else {
            throwException = true;
        }
        if (throwException) {
            throw new RfcInvalidConfigurationException("Parameter SAP client ('jco.client.client') needs to be a three digit number string instead of '" + this.client + "'", this);
        }
    }

    private void checkGatewayService() throws RfcInvalidConfigurationException {
        if (this.gwserv == null) {
            return;
        }
        boolean throwException = false;
        int len = this.gwserv.length();
        if (len == 4) {
            if (!this.isNumericString(this.gwserv, len)) {
                throwException = true;
            }
        } else if (this.gwserv.startsWith("sapgw")) {
            if (len > 6 && this.gwserv.charAt(5) == '$' && this.gwserv.charAt(6) == '$' && (len == 7 || len == 8 && this.gwserv.charAt(7) == 's')) {
                if (AbSysInfo.systemNumber == null || AbSysInfo.systemNumber.length() == 0) {
                    this.throwConfigurationExceptionWithTrace("'" + this.gwserv + "' as value for 'jco.client.gwserv' requires SAPSYSTEM to be set in the environment");
                } else if (Environment.inJStartup()) {
                    boolean isDualStack;
                    String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                    boolean bl = isDualStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                    if (!isDualStack) {
                        this.throwConfigurationExceptionWithTrace("'" + this.gwserv + "' as value for 'jco.client.gwserv' is only valid in a dual stack environment");
                    }
                }
                if (this.isNumericString(AbSysInfo.systemNumber, 2)) {
                    this.gwserv = len == 7 ? new StringBuilder(7).append("sapgw").append(AbSysInfo.systemNumber).toString() : new StringBuilder(8).append("sapgw").append(AbSysInfo.systemNumber).append('s').toString();
                } else {
                    throwException = true;
                }
            } else if (len < 7 || len > 8) {
                throwException = true;
            } else {
                char c = '\u0000';
                for (int i = 5; i < 7; ++i) {
                    c = this.gwserv.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    throwException = true;
                    break;
                }
                if (len == 8 && this.gwserv.charAt(7) != 's') {
                    throwException = true;
                }
            }
        }
        if (throwException) {
            this.throwConfigurationExceptionWithTrace("Parameter gateway service ('jco.client.gwserv') needs to be of format ####, sapgw## or sapgw##s (where # is a digit) instead of '" + this.gwserv + '\'');
        }
    }

    private void checkSystemNumber() throws RfcInvalidConfigurationException {
        if (this.sysnr == null) {
            this.throwConfigurationExceptionWithTrace("Parameter ABAP system number ('jco.client.sysnr') is missing");
        }
        if (this.sysnr.equals("$$")) {
            String string = this.sysnr = AbSysInfo.systemNumber != null && AbSysInfo.systemNumber.length() > 0 ? AbSysInfo.systemNumber : null;
            if (this.sysnr == null) {
                this.throwConfigurationExceptionWithTrace("'$$' as value for ('jco.client.sysnr') requires SAPSYSTEM to be set in the environment");
            } else if (Environment.inJStartup()) {
                boolean isDualStack;
                String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                boolean bl = isDualStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                if (!isDualStack) {
                    this.throwConfigurationExceptionWithTrace("'$$' as value for ('jco.client.sysnr') is only valid in a dual stack environment");
                }
            }
        } else {
            boolean throwException = false;
            int len = this.sysnr.length();
            if (len == 2) {
                if (!this.isNumericString(this.sysnr, len)) {
                    throwException = true;
                }
            } else if (len < 2) {
                if (len == 1) {
                    char c = this.sysnr.charAt(0);
                    if (c < '0' || c > '9') {
                        throwException = true;
                    } else {
                        this.sysnr = new StringBuilder(2).append('0').append(c).toString();
                    }
                } else {
                    this.sysnr = "00";
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                this.throwConfigurationExceptionWithTrace("Parameter backend system number ('jco.client.sysnr') needs to be a two digit number string instead of '" + this.sysnr + "'");
            }
        }
    }

    private void checkLogonData() throws RfcInvalidConfigurationException {
        if (this.type == 'V') {
            this.password = null;
            return;
        }
        if (this.type == 'E' || this.type == 'R') {
            this.password = null;
            if (this.user == null) {
                this.user = "EXTERN";
            }
            if (this.language == null) {
                this.language = "E";
            }
            return;
        }
        this.checkClient();
        if (this.user != null || this.alias_user != null) {
            if (this.password == null && (this.snc_mode == 0 || this.snc_mode == 1 && !this.sncUseSSO)) {
                this.throwConfigurationExceptionWithTrace("Parameter password ('jco.client.passwd') is missing");
            }
        } else {
            if (!(this.containsMysapSSO2 || this.containsX509cert || this.extid_type != null && this.extid_data != null || this.snc_mode != 0 && (this.snc_mode != 1 || this.sncUseSSO) || this.usePrincipalPropagation)) {
                this.throwConfigurationExceptionWithTrace("Parameter containing a user ID is missing: neither user nor user alias nor external ID nor SSO ticket nor X.509 certificate is specified");
            }
            this.password = null;
        }
    }

    public void checkParameters() throws RfcInvalidConfigurationException {
        switch (this.type) {
            case 'F': {
                this.ashost = "localhost";
                this.sysnr = AbSysInfo.systemNumber != null && AbSysInfo.systemNumber.length() > 0 ? AbSysInfo.systemNumber : null;
                this.type = (char)65;
            }
            case 'A': 
            case 'a': {
                if (this.ashost == null) {
                    this.throwConfigurationExceptionWithTrace("Parameter backend host ('jco.client.ashost') is missing");
                }
                this.checkSystemNumber();
                this.checkGatewayService();
                break;
            }
            case 'B': 
            case 'b': {
                if (this.mshost == null) {
                    this.throwConfigurationExceptionWithTrace("Parameter message server host ('jco.client.mshost') is missing");
                }
                if (this.r3name == null && this.msserv == null) {
                    this.throwConfigurationExceptionWithTrace("Either parameter ABAP system ID ('jco.client.r3name') or message server service ('jco.client.msserv') needs to be provided. None of both is available.");
                }
                if (this.group != null) break;
                this.group = "PUBLIC";
                break;
            }
            case 'E': 
            case 'R': {
                this.useDeltaManagement = false;
                if (this.type == 'E' && this.reg_host == null) {
                    this.throwConfigurationExceptionWithTrace("Parameter external server program host ('jco.client.tphost') is missing");
                }
                if (this.type == 'R' && this.gwhost == null) {
                    this.throwConfigurationExceptionWithTrace("Parameter gateway host ('jco.client.gwhost') is missing");
                }
                if (this.reg_name == null) {
                    if (this.type == 'R') {
                        this.throwConfigurationExceptionWithTrace("Parameter registered program ID ('jco.client.tpname') is missing");
                    } else {
                        this.throwConfigurationExceptionWithTrace("Parameter external program path and name ('jco.client.tpname') is missing");
                    }
                }
                if (this.gwserv == null) {
                    if (this.sysnr == null) {
                        if (this.gwhost == null) break;
                        this.throwConfigurationExceptionWithTrace("Parameter gateway service ('jco.client.gwserv') is missing");
                        break;
                    }
                    this.checkSystemNumber();
                    break;
                }
                this.checkGatewayService();
                break;
            }
            case 'V': {
                this.throwConfigurationExceptionWithTrace("Parameter connection type ('jco.client.type') value 'V' is not supported");
                break;
            }
            case '2': {
                this.throwConfigurationExceptionWithTrace("Parameter ('jco.client.type') value '" + this.type + "' is not supported");
            }
            case '?': {
                this.throwConfigurationExceptionWithTrace("Parameter ('jco.client.type') is missing");
            }
            default: {
                this.throwConfigurationExceptionWithTrace("Parameter ('jco.client.type') value '" + this.type + "' is invalid");
            }
        }
        if (this.isSticky() && this.type != 'B' && this.type != 'b') {
            this.throwConfigurationExceptionWithTrace("Sticky mode is only allowed for load balancing logon. Specify ('jco.client.r3name') or ('jco.client.msserv') together with ('jco.client.mshost').");
        }
        this.checkLogonData();
        switch (this.snc_mode) {
            case 1: {
                if (this.snc_qop < 1 || this.snc_qop > 9) {
                    this.throwConfigurationExceptionWithTrace("Parameter SNC quality of protection ('jco.client.snc_qop') value '" + this.snc_qop + "' is invalid");
                }
                if (this.snc_partnername == null && this.type != 'B') {
                    this.throwConfigurationExceptionWithTrace("Parameter SNC partner name ('jco.client.snc_partnername') is missing");
                }
                if (this.snc_myname == null) {
                    this.snc_myname = " ";
                }
                if (this.snc_lib != null) break;
                this.snc_lib = "";
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.snc_mode = 0;
            }
        }
        if (this.pcs < 1 || this.pcs > 2) {
            this.throwConfigurationExceptionWithTrace("Parameter partner's char size ('jco.client.pcs') value '" + this.pcs + "' is invalid");
        }
        if (!(this.communication_cp == null || this.communication_cp.length() == 4 && this.isNumericString(this.communication_cp, 4))) {
            this.throwConfigurationExceptionWithTrace("Parameter logon codepage ('jco.client.codepage') needs to be a 4 digit number string instead of '" + this.communication_cp + "'");
        }
    }

    public void setProperties(Properties prop, String prefix) throws RfcInvalidConfigurationException {
        this.properties = prop;
        this.propertyPrefix = prefix;
        this.sysnr = this.getTrimmedProperty(prop, prefix, "sysnr");
        String reader = this.getTrimmedProperty(prop, prefix, "trace");
        this.trace = "1".equals(reader) ? 1 : 0;
        this.cpicTrace = -1;
        reader = this.getTrimmedProperty(prop, prefix, "cpic_trace");
        if (reader != null) {
            try {
                this.cpicTrace = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.logonCheck = (reader = this.getTrimmedProperty(prop, prefix, "lcheck")) == null || this.toBoolean(reader);
        this.ashost = this.getTrimmedProperty(prop, prefix, "ashost");
        this.gwhost = this.getTrimmedProperty(prop, prefix, "gwhost");
        this.gwserv = this.getTrimmedProperty(prop, prefix, "gwserv");
        this.useSymbolicService = this.toBoolean(this.getTrimmedProperty(prop, prefix, "use_symbolic_service"));
        this.saprouter = this.getTrimmedProperty(prop, prefix, "saprouter");
        this.containsMysapSSO2 = this.containsProperty(prop, prefix, "mysapsso2");
        this.containsX509cert = this.containsProperty(prop, prefix, "x509cert");
        this.user = this.getRightTrimmedProperty(prop, prefix, "user");
        if (this.user != null) {
            int strlen = this.user.length();
            StringBuilder strBuf = new StringBuilder(strlen);
            for (int i = 0; i < strlen; ++i) {
                strBuf.append(Character.toUpperCase(this.user.charAt(i)));
            }
            this.user = strBuf.toString();
        }
        this.alias_user = this.getTrimmedProperty(prop, prefix, "alias_user");
        if (this.containsProperty(prop, prefix, "passwd") && (reader = this.getRightTrimmedProperty(prop, prefix, "passwd")) != null) {
            this.password = Codecs.Base64.decode(reader);
        }
        this.client = this.getTrimmedProperty(prop, prefix, "client");
        if (this.client == null && this.containsProperty(prop, prefix, "client")) {
            this.client = "XXX";
        }
        if ((reader = this.getTrimmedProperty(prop, prefix, "lang")) != null) {
            this.language = Language.getSAPLanguage(reader);
            if (this.language == null) {
                this.throwConfigurationExceptionWithTrace("Parameter logon language ('jco.client.lang') code '" + reader + "' is invalid");
            }
            this.pcs = this.language.charAt(0) > '\uac00' ? 2 : 1;
        } else {
            this.language = null;
            this.pcs = 1;
        }
        this.communication_cp = this.getTrimmedProperty(prop, prefix, "codepage");
        if (this.communication_cp != null) {
            this.pcs = this.communication_cp.length() == 4 && this.communication_cp.charAt(0) == '4' && this.communication_cp.charAt(1) == '1' && this.communication_cp.charAt(2) == '0' ? 2 : 1;
        }
        if ((reader = this.getTrimmedProperty(prop, prefix, "pcs")) != null) {
            try {
                this.pcs = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                this.throwConfigurationExceptionWithTrace("Parameter partner's char size ('jco.client.pcs') value '" + reader + "' is invalid");
            }
        }
        if (Environment.inStandalone()) {
            if (this.type == 'A' || this.type == 'B') {
                reader = this.getTrimmedProperty(prop, prefix, "use_sapgui");
                if (reader != null) {
                    try {
                        this.useSAPGui = Integer.parseInt(reader);
                        if (this.useSAPGui < 0) {
                            this.useSAPGui = 0;
                        } else if (this.useSAPGui > 2) {
                            this.useSAPGui = 2;
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.useSAPGui = 0;
                    }
                } else {
                    this.useSAPGui = 0;
                }
                if ("1".equals(reader = this.getTrimmedProperty(prop, prefix, "abap_debug"))) {
                    this.abapDebug = true;
                    this.useSAPGui = 1;
                } else {
                    this.abapDebug = false;
                }
            } else {
                this.useSAPGui = 0;
                this.abapDebug = false;
            }
        }
        reader = this.getTrimmedProperty(prop, prefix, "getsso2");
        this.getsso2 = this.toBoolean(reader);
        this.extid_data = this.getTrimmedProperty(prop, prefix, "extid_data");
        this.extid_type = this.getTrimmedProperty(prop, prefix, "extid_type");
        reader = this.getTrimmedProperty(prop, prefix, "snc_mode");
        this.snc_mode = this.toBoolean(reader) ? 1 : 0;
        reader = this.getTrimmedProperty(prop, prefix, "snc_qop");
        if (reader != null) {
            try {
                this.snc_qop = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                this.throwConfigurationExceptionWithTrace("Parameter SNC quality of protection ('jco.client.snc_qop') value '" + reader + "' is invalid");
            }
        } else {
            this.snc_qop = 8;
        }
        this.snc_myname = this.getTrimmedProperty(prop, prefix, "snc_myname");
        this.snc_partnername = this.getTrimmedProperty(prop, prefix, "snc_partnername");
        this.snc_lib = this.getTrimmedProperty(prop, prefix, "snc_lib");
        reader = this.getTrimmedProperty(prop, prefix, "snc_sso");
        this.sncUseSSO = reader == null ? true : this.toBoolean(reader);
        this.r3name = this.getTrimmedProperty(prop, prefix, "r3name");
        this.group = this.getTrimmedProperty(prop, prefix, "group");
        this.mshost = this.getTrimmedProperty(prop, prefix, "mshost");
        this.msserv = this.getTrimmedProperty(prop, prefix, "msserv");
        this.reg_name = this.getTrimmedProperty(prop, prefix, "tpname");
        this.reg_host = this.getTrimmedProperty(prop, prefix, "tphost");
        reader = this.getTrimmedProperty(prop, prefix, "delta");
        this.useDeltaManagement = reader == null ? RfcApi.isDeltaManagementActive() : this.toBoolean(reader);
        reader = this.getTrimmedProperty(prop, prefix, "use_basxml");
        this.useBasXML = reader == null ? true : this.toBoolean(reader);
        this.destination = this.getTrimmedProperty(prop, prefix, "destination");
        if (this.destination == null) {
            this.destination = "<Java Rfc client>";
            this.properties.setProperty(prefix + "destination", this.destination);
        }
        this.sticky = this.toBoolean(this.getTrimmedProperty(prop, prefix, "sticky"));
        if (this.type == 'a' || this.type == 'b') {
            reader = this.getTrimmedProperty(prop, prefix, "cloud_connector_version");
            if (reader != null) {
                try {
                    this.cloudConnectorVersion = Integer.parseInt(reader);
                    if (this.cloudConnectorVersion != 2) {
                        this.throwConfigurationExceptionWithTrace("Parameter jco.client.cloud_connector_version may only be used with value 2.");
                    }
                }
                catch (NumberFormatException nfe) {
                    this.throwConfigurationExceptionWithTrace("Parameter jco.client.cloud_connector_version must be a number: 2.");
                }
            } else {
                this.cloudConnectorVersion = -1;
            }
            this.usePrincipalPropagation = (reader = this.getTrimmedProperty(prop, prefix, "principal_name")) != null && (this.user == null || this.password == null);
            reader = this.getTrimmedProperty(prop, prefix, "cloud_connector_location_id");
            if (reader != null && reader.length() > 0) {
                this.cloudConnectorLocationId = reader;
            }
        }
        if ((reader = this.getTrimmedProperty(prop, prefix, "serialization_format")) == null || !reader.toLowerCase(Locale.ENGLISH).equals("column_based") && !reader.toLowerCase(Locale.ENGLISH).equals("columnbased")) {
            this.serializationFormat = 0;
        } else {
            reader = this.getTrimmedProperty(prop, prefix, "network");
            if (reader == null || reader.toLowerCase(Locale.ENGLISH).equals("lan")) {
                this.serializationFormat = (short)25041;
            } else if (reader.toLowerCase(Locale.ENGLISH).equals("wan")) {
                this.serializationFormat = (short)-23599;
            } else if (reader.toLowerCase(Locale.ENGLISH).equals("off")) {
                this.serializationFormat = (short)8657;
            }
        }
    }

    public int getCloudConnectorVersion() {
        return this.cloudConnectorVersion;
    }

    public String getCloudConnectorLocationId() {
        return this.cloudConnectorLocationId;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onlyConnectionInfo) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("TYPE=").append(this.type);
        if (this.destination != null) {
            if (this.destination.indexOf(32) < 0) {
                buf.append(" DEST=").append(this.destination);
            } else {
                buf.append(" DEST=\"").append(this.destination).append('\"');
            }
        }
        if (!onlyConnectionInfo) {
            if (this.client != null) {
                buf.append(" CLIENT=").append(this.client);
            }
            if (this.user != null) {
                if (this.user.indexOf(32) < 0) {
                    buf.append(" USER=").append(this.user);
                } else {
                    buf.append(" USER=\"").append(this.user).append('\"');
                }
            }
            if (this.alias_user != null) {
                if (this.alias_user.indexOf(32) < 0) {
                    buf.append(" ALIAS_USER=").append(this.alias_user);
                } else {
                    buf.append(" ALIAS_USER=\"").append(this.alias_user).append('\"');
                }
            }
            if (this.password != null) {
                buf.append(" PASSWD=<secret>");
            }
            if (this.language != null) {
                buf.append(" LANG=").append(Language.getISOLanguage(this.language));
            }
        }
        switch (this.type) {
            case 'A': 
            case 'a': {
                buf.append(" ASHOST=").append(this.ashost);
                buf.append(" SYSNR=").append(this.sysnr);
                if (this.gwhost != null) {
                    buf.append(" GWHOST=").append(this.gwhost);
                }
                if (this.gwserv == null) break;
                buf.append(" GWSERV=").append(this.gwserv);
                break;
            }
            case 'B': 
            case 'b': {
                buf.append(" MSHOST=").append(this.mshost);
                if (this.msserv != null) {
                    buf.append(" MSSERV=").append(this.msserv);
                }
                if (this.r3name != null) {
                    buf.append(" R3NAME=").append(this.r3name);
                }
                buf.append(" GROUP=").append(this.group);
                break;
            }
            case 'E': {
                buf.append(" TPHOST=").append(this.reg_host);
            }
            case 'R': {
                if (this.reg_name == null || this.reg_name.indexOf(32) < 0) {
                    buf.append(" TPNAME=").append(this.reg_name);
                } else {
                    buf.append(" TPNAME=\"").append(this.reg_name).append('\"');
                }
                if (this.gwhost != null) {
                    buf.append(" GWHOST=").append(this.gwhost);
                }
                if (this.gwserv == null) break;
                buf.append(" GWSERV=").append(this.gwserv);
                break;
            }
        }
        if (this.saprouter != null) {
            buf.append(" SAPROUTER=").append(this.saprouter);
        }
        if (this.snc_mode == 1) {
            buf.append(" SNC_MODE=1 SNC_QOP=").append(Integer.toString(this.snc_qop));
            if (this.snc_partnername != null && this.type != 'B') {
                if (this.snc_partnername.indexOf(32) < 0) {
                    buf.append(" SNC_PARTNERNAME=").append(this.snc_partnername);
                } else {
                    buf.append(" SNC_PARTNERNAME=\"").append(this.snc_partnername).append('\"');
                }
            }
            if (this.snc_myname != null && this.snc_myname.length() > 0) {
                if (this.snc_myname.indexOf(32) < 0) {
                    buf.append(" SNC_MYNAME=").append(this.snc_myname);
                } else {
                    buf.append(" SNC_MYNAME=\"").append(this.snc_myname).append('\"');
                }
            }
            if (!this.sncUseSSO) {
                buf.append(" SNC_SSO=0");
            }
        }
        if (!onlyConnectionInfo) {
            if (this.isTrace()) {
                buf.append(" TRACE=").append(this.trace);
            }
            if (this.cpicTrace != -1) {
                buf.append(" CPIC_TRACE=").append(this.cpicTrace);
            }
            if (this.getsso2) {
                buf.append(" GETSSO2=1");
            }
            if (this.containsMysapSSO2) {
                buf.append(" MYSAPSSO2=<used>");
            }
            if (this.containsX509cert) {
                buf.append(" X509CERT=<used>");
            }
            if (this.extid_type != null) {
                buf.append(" EXTIDTYPE=").append(this.extid_type);
            }
            if (this.extid_data != null) {
                if (this.extid_data.length() <= 40) {
                    if (this.extid_data.indexOf(32) < 0) {
                        buf.append(" EXTIDDATA=").append(this.extid_data);
                    } else {
                        buf.append(" EXTIDDATA=\"").append(this.extid_data).append('\"');
                    }
                } else {
                    buf.append(" EXTIDDATA=<used>");
                }
            }
        }
        if (this.communication_cp != null) {
            buf.append(" CODEPAGE=").append(this.communication_cp);
        }
        buf.append(" PCS=").append(this.pcs);
        if (!this.useDeltaManagement) {
            buf.append(" DELTA=0");
        }
        if (!this.useBasXML) {
            buf.append(" BASXML=0");
        }
        if (this.abapDebug) {
            buf.append(" ABAP_DEBUG=1");
        }
        if (this.useSAPGui > 0) {
            buf.append(" USE_SAPGUI=").append(this.useSAPGui);
        }
        if (this.cloudConnectorVersion != -1) {
            buf.append(" SCCVERSION=").append(this.cloudConnectorVersion);
        }
        if (this.cloudConnectorLocationId.length() != 0) {
            buf.append(" SCCLOCATIONID=").append(this.cloudConnectorLocationId);
        }
        if (this.serializationFormat != 0) {
            buf.append(" SERIALIZATION_FORMAT=").append("columnBased");
            String network = null;
            if (25041 == this.serializationFormat) {
                network = "LAN";
            } else if (-23599 == this.serializationFormat) {
                network = "WAN";
            } else if (8657 == this.serializationFormat) {
                network = "OFF";
            }
            if (network != null) {
                buf.append(" NETWORK=");
            }
        }
        return buf.toString();
    }

    public String getDestination() {
        return this.destination;
    }

    public static String sysNrToString(int sysnrInt) throws RfcException {
        if (sysnrInt < 0 || sysnrInt > 99) {
            throw new RfcException(19, new StringBuilder(100).append("Parameter ABAP system number ('sysnr') needs to be a two digit number string instead of '").append(sysnrInt).append('\'').toString(), 101, 0L, true);
        }
        return new StringBuilder(2).append((char)(48 + sysnrInt / 10)).append((char)(48 + sysnrInt % 10)).toString();
    }

    public String getSysnr() {
        return this.sysnr;
    }

    public String getAshost() {
        return this.ashost;
    }

    public void setAshost(String newAshost) {
        this.ashost = newAshost;
    }

    public boolean isTrace() {
        return this.trace > 0;
    }

    public int getCpicTrace() {
        return this.cpicTrace;
    }

    public String getGwhost() {
        return this.gwhost;
    }

    public String getGwserv() {
        return this.gwserv;
    }

    public boolean useSymbolicService() {
        return this.useSymbolicService;
    }

    public String getSaprouter() {
        return this.saprouter;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isGetsso2() {
        return this.getsso2;
    }

    public String getExtid_data() {
        return this.extid_data;
    }

    public String getExtid_type() {
        return this.extid_type;
    }

    public String getX509cert() throws RfcInvalidConfigurationException {
        return this.getTrimmedProperty(this.properties, this.propertyPrefix, "x509cert");
    }

    public int getSncMode() {
        return this.snc_mode;
    }

    public String getSnc_myname() {
        return this.snc_myname;
    }

    public int getSnc_qop() {
        return this.snc_qop;
    }

    public String getSncPartnerName() {
        return this.snc_partnername;
    }

    public String getSnc_lib() {
        return this.snc_lib;
    }

    public String getR3name() {
        return this.r3name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getMshost() {
        return this.mshost;
    }

    public String getMsserv() {
        return this.msserv;
    }

    public String getReg_name() {
        return this.reg_name;
    }

    public String getReg_host() {
        return this.reg_host;
    }

    public char getType() {
        return this.type;
    }

    public String getMysapsso2() throws RfcInvalidConfigurationException {
        return this.getTrimmedProperty(this.properties, this.propertyPrefix, "mysapsso2");
    }

    public boolean usesPrincipalPropagation() {
        return this.usePrincipalPropagation;
    }

    public String getClient() {
        return this.client;
    }

    public String getLanguage() {
        return this.language;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public int getPcs() {
        return this.pcs;
    }

    public int getUseSAPGui() {
        return this.useSAPGui;
    }

    public boolean usesAbapDebug() {
        return this.abapDebug;
    }

    public boolean executeLogonCheck() {
        return this.logonCheck;
    }

    public byte getAllocationType() {
        return this.allocationType;
    }

    public void setAllocationType(byte allocType) {
        this.allocationType = allocType;
    }

    public String getAlias() {
        return this.alias_user;
    }

    public short getSerializationFormat() {
        return this.serializationFormat;
    }

    private String findProperty(Properties props, String prefix, String key) throws RfcInvalidConfigurationException {
        try {
            String value = props.getProperty(prefix + key);
            if (value == null && (value = props.getProperty(key)) == null) {
                key = key.toUpperCase(Locale.ENGLISH);
                value = props.getProperty(key);
            }
            return value;
        }
        catch (Throwable th) {
            this.throwConfigurationExceptionWithTrace(th.getClass().getName() + " occurred while obtaining the value for parameter '" + key + "' from Properties instance of class " + props.getClass().getName(), th);
            return null;
        }
    }

    private boolean containsProperty(Properties props, String prefix, String key) throws RfcInvalidConfigurationException {
        try {
            return props.containsKey(prefix + key) || props.containsKey(key) || props.containsKey(key.toUpperCase(Locale.ENGLISH));
        }
        catch (Throwable th) {
            this.throwConfigurationExceptionWithTrace(th.getClass().getName() + " occurred while checking the key existence for parameter '" + key + "' in Properties instance of class " + props.getClass().getName(), th);
            return false;
        }
    }

    protected boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase(Locale.ENGLISH)).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    protected String getRightTrimmedProperty(Properties props, String prefix, String key) throws RfcInvalidConfigurationException {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = this.rightTrim(value)).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String getTrimmedProperty(Properties props, String prefix, String key) throws RfcInvalidConfigurationException {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String rightTrim(String str) {
        if (str != null) {
            int last;
            int i;
            for (i = last = str.length() - 1; i >= 0 && str.charAt(i) <= ' '; --i) {
            }
            if (i < last) {
                str = str.substring(0, i + 1);
            }
        }
        return str;
    }

    public String getCommunication_cp() {
        return this.communication_cp;
    }

    public boolean isDeltaManagementOn() {
        return this.useDeltaManagement;
    }

    public boolean isBasXMLAllowed() {
        return this.useBasXML;
    }

    public boolean useSncWithoutSSO() {
        return this.snc_mode == 1 && !this.sncUseSSO;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public String getStickyAppserver() {
        return this.stickyAppserver;
    }

    public void setStickyAppserver(String newLU) {
        this.stickyAppserver = newLU;
    }

    public void setSysnr(String newSysnr) {
        this.sysnr = newSysnr;
    }

    public void setGwserv(String newGwserv) {
        this.gwserv = newGwserv;
    }

    public void setSncPartnerName(String newSncPartnerName) {
        this.snc_partnername = newSncPartnerName;
    }
}

