/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;

public class NeoSocketDriver
extends RfcDriver {
    private static final byte OPEN_REQUEST = 0;
    private static final byte INVOKE_REQUEST = 1;
    private static final byte CLOSE_REQUEST = 2;
    private static final byte RFC_REQUEST = 3;
    private static final byte RFC_REQUEST_FINAL = 4;
    private static final byte SCC_RESPONSE = 5;
    private static final byte RFC_RESPONSE = 6;
    private static final byte SCC_ERROR = 7;
    private static final byte RFC_CANCEL = 8;
    private static final byte SCC_PING = 9;
    private static final byte INVOKE_REQUEST_WITH_DATA = 10;
    private static final byte INVOKE_UNIT = 11;
    static final int BUFFER_SIZE = 28000;
    OutputStream os;
    InputStream is;
    byte[] driverBuffer = new byte[48];
    byte[] connectionIdentifier;
    byte[] conv_id = new byte[8];
    byte partnerVersion = 0;
    long timeOfLastIO;
    private Socket clientSocket;
    boolean firstFunctionContainer = true;
    int containerCounter = 0;

    public NeoSocketDriver(RfcIoOpenCntl iocntl) {
        super(iocntl);
        this.connectionIdentifier = new byte[32];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int open(RfcOptions options) throws RfcException {
        this.act_cntl.rfc_uuid = GUID.Factory.createGUID();
        this.act_cntl.rfc_uuid_set = true;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("UUID: Neo socket driver open create uuid:");
            Trc.ab_rfctrc(GUID.toString(this.act_cntl.rfc_uuid));
            Trc.ab_rfctrc("\n");
        }
        this.act_cntl.signon = true;
        communicationHeader = this.get_com_head(this.act_cntl.trace);
        System.arraycopy(communicationHeader, 0, this.act_cntl.m_buffer, 0, communicationHeader.length);
        this.act_cntl.m_buffer_ptr = communicationHeader.length;
        this.act_cntl.m_bytes_free -= communicationHeader.length;
        server_host = options.getGwhost();
        server_port = options.getGwserv();
        this.act_cntl.target = new StringBuilder(30).append(server_host).append(':').append(server_port).toString();
        this.act_cntl.sysid = "<empty>";
        rt = JCoRuntimeFactory.getRuntime();
        isTaskMonitorOn = rt.isTaskMonitorOn();
        if (isTaskMonitorOn) {
            msg = new StringBuilder(256).append("JCo executing connect [").append(this.act_cntl.sysid).append('|').append(this.act_cntl.target).append("|<empty>]");
            rt.startTask(msg.toString());
        }
        try {
            cloudConnectorVersion = options.getCloudConnectorVersion();
            if (cloudConnectorVersion == -1) {
                cloudConnectorVersion = 2;
            }
            if (cloudConnectorVersion == 2 && options.usesPrincipalPropagation()) {
                cloudConnectorVersion += 4;
            }
            serverPort = server_port == null ? cloudConnectorVersion : Integer.parseInt(server_port);
            serverHost = server_host == null ? options.getCloudConnectorLocationId() : server_host;
            this.clientSocket = NeoSocketDriver.socketFactory == null ? new Socket(serverHost, serverPort) : NeoSocketDriver.socketFactory.createSocket(serverHost, serverPort);
            this.clientSocket.setSoTimeout(RfcIoOpenCntl.getClientConnectTimeout() * 1000);
            this.os = new BufferedOutputStream(this.clientSocket.getOutputStream(), 32768);
            this.is = this.clientSocket.getInputStream();
        }
        catch (IOException e) {
            throw new RfcException(6, "Opening socket to partner failed: " + e.getMessage(), 102, 0L, false, e);
        }
        finally {
            if (isTaskMonitorOn) {
                rt.endTask();
            }
        }
        try {
            buf = new StringBuilder();
            if (this.act_cntl.userid != null) {
                buf.append("userName=").append(URLEncoder.encode(this.act_cntl.userid, "UTF-8")).append('&');
            }
            buf.append("abapClient=").append(URLEncoder.encode(this.act_cntl.mandt, "UTF-8")).append('&');
            switch (options.getType()) {
                case 'b': {
                    msserv = options.getMsserv();
                    buf.append("mshost=").append(options.getMshost());
                    if (msserv == null) {
                        buf.append("&sysID=").append(options.getR3name());
                    } else {
                        buf.append("&msserv=").append(msserv);
                    }
                    buf.append("&group=").append(options.getGroup());
                    break;
                }
                case 'a': {
                    buf.append("ashost=").append(options.getAshost()).append("&sysNr=").append(options.getSysnr());
                    break;
                }
                default: {
                    throw new RfcException(1, "Unsupported type '" + options.getType() + "' for NeoSocketDriver", 101, 0L, false);
                }
            }
            frame = buf.toString().getBytes(Utf8ByteToCharConverter.UTF_8);
            this.writeDatagram((byte)0, frame, frame.length);
            this.os.flush();
            action = this.is.read();
            switch (action) {
                case 5: {
                    this.is.read(this.connectionIdentifier);
                    this.is.read(this.conv_id);
                    this.is.read(this.driverBuffer, 0, 4);
                    messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 0);
                    if (messageLength > 0) {
                        messageBytes = new byte[messageLength];
                        this.is.read(messageBytes);
                        this.partnerVersion = messageBytes[0];
                        ** break;
                    }
lbl87:
                    // 3 sources

                    break;
                }
                case 7: {
                    this.is.skip(40L);
                    this.is.read(this.driverBuffer, 0, 4);
                    messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 0);
                    messageBytes = new byte[messageLength];
                    this.is.read(messageBytes);
                    throw new RfcException(6, "Opening connection to backend failed: " + new String(messageBytes, "UTF8"), 102, 0L, false);
                }
                case -1: {
                    throw new RfcException(6, "Opening connection to backend failed. No data received from partner side.", 102, 0L, false);
                }
                default: {
                    throw new RfcException(new RfcIoException(3, "Invalid communication state on open (Action " + action + " not expected)"));
                }
            }
        }
        catch (SocketTimeoutException ste) {
            throw new RfcException(23, new StringBuilder(180).append("Timeout occurred while establishing the connection to an ABAP system. Remote system accessed via destination ").append(options.getDestination()).append(" did not reply within ").append(RfcIoOpenCntl.getClientConnectTimeout()).append(" seconds.").toString(), 102, 0L, false);
        }
        catch (IOException e) {
            throw new RfcException(6, "IOError on tunnel socket during connect attempt.", 102, 0L, false, e);
        }
        finally {
            try {
                this.clientSocket.setSoTimeout(0);
            }
            catch (SocketException e) {
                throw new RfcException(6, "SocketException on tunnel socket when resetting socket timeout.", 102, 0L, false, e);
            }
        }
        this.act_cntl.updateConvID();
        return 0;
    }

    @Override
    public int accept(RfcAcceptInfo acceptInfo) {
        return 1;
    }

    @Override
    public void close() {
        if (this.clientSocket != null) {
            try {
                this.os.write(2);
                this.os.write(this.connectionIdentifier);
                this.os.write(this.conv_id);
                this.driverBuffer[0] = 0;
                this.driverBuffer[1] = 0;
                this.driverBuffer[2] = 0;
                this.driverBuffer[3] = 0;
                this.os.write(this.driverBuffer, 0, 4);
                this.os.flush();
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientSocket = null;
            this.os = null;
            this.is = null;
        }
    }

    @Override
    public boolean isPartnerReachable() {
        if (this.clientSocket != null) {
            try {
                this.os.write(9);
                this.os.write(this.connectionIdentifier);
                this.os.write(this.conv_id);
                this.driverBuffer[0] = 0;
                this.driverBuffer[1] = 0;
                this.driverBuffer[2] = 0;
                this.driverBuffer[3] = 0;
                this.os.write(this.driverBuffer, 0, 4);
                this.os.flush();
                this.timeOfLastIO = System.currentTimeMillis();
                int action = this.is.read();
                switch (action) {
                    case 5: {
                        this.is.skip(40L);
                        this.is.read(this.driverBuffer, 0, 4);
                        break;
                    }
                    case 7: {
                        this.is.skip(40L);
                        this.is.read(this.driverBuffer, 0, 4);
                        int messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 0);
                        byte[] messageBytes = new byte[messageLength];
                        this.is.read(messageBytes);
                        this.setMessage("Cloud Connector reached, but replied with an error: " + new String(messageBytes, "UTF8"));
                        break;
                    }
                    case -1: {
                        this.setMessage("No data received from partner side on ping.");
                        return false;
                    }
                    default: {
                        this.setMessage("Invalid communication state on ping (Action " + action + " not expected)");
                        return false;
                    }
                }
            }
            catch (IOException e) {
                this.setMessage("Connection is corrupted: " + e);
                try {
                    this.clientSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.clientSocket = null;
                this.os = null;
                this.is = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int wait(byte[] buffer, int bufsize, int[] bytes_read) {
        return 0;
    }

    @Override
    public void abort() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int listen(byte[] buffer, int buffersize, int[] bytes_read, int timeout) {
        int ret = 0;
        try {
            this.clientSocket.setSoTimeout(timeout);
            ret = this.internalRead(buffer, bytes_read);
        }
        catch (SocketException e) {
            ret = 1;
        }
        finally {
            try {
                this.clientSocket.setSoTimeout(0);
            }
            catch (SocketException e) {
                ret = 1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] buffer, int buffersize, boolean last) {
        int rc;
        block17: {
            rc = 0;
            ++this.containerCounter;
            try {
                if (this.firstFunctionContainer) {
                    boolean sendUnit;
                    StringBuilder functionInfo = new StringBuilder();
                    boolean bl = sendUnit = this.act_cntl.functionNames != null && this.partnerVersion >= 2;
                    if (sendUnit) {
                        functionInfo.append("functionNames=").append(this.act_cntl.functionNames[0]);
                        for (int i = 1; i < this.act_cntl.functionNames.length; ++i) {
                            functionInfo.append('|').append(this.act_cntl.functionNames[i]);
                        }
                    } else {
                        functionInfo.append("functionName=").append(this.act_cntl.functionName);
                    }
                    if (this.act_cntl.userid != null) {
                        functionInfo.append("&userName=").append(URLEncoder.encode(this.act_cntl.userid, "UTF-8"));
                    }
                    byte[] functionInfoBuffer = functionInfo.toString().getBytes(Utf8ByteToCharConverter.UTF_8);
                    if (this.partnerVersion == 0) {
                        this.writeDatagram((byte)1, functionInfoBuffer, functionInfoBuffer.length);
                        this.os.flush();
                        rc = this.checkForAccessException();
                        if (rc != 0) {
                            return rc;
                        }
                    } else {
                        this.writeDatagram(sendUnit ? (byte)11 : 10, functionInfoBuffer, functionInfoBuffer.length);
                    }
                    this.firstFunctionContainer = false;
                }
                this.writeDatagram(!last ? (byte)3 : 4, buffer, buffersize);
                if (last) {
                    this.firstFunctionContainer = true;
                    this.containerCounter = 0;
                    break block17;
                }
                this.os.flush();
                if (this.partnerVersion <= 0 || this.containerCounter != 5 && this.containerCounter != 10 && this.containerCounter != 20) break block17;
                int oldTimeout = this.clientSocket.getSoTimeout();
                try {
                    this.clientSocket.setSoTimeout(1);
                    rc = this.checkForAccessException();
                }
                catch (SocketTimeoutException ste) {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No decline received after " + this.containerCounter + " containers for handle [" + this.act_cntl.hrfc + ']');
                    }
                }
                finally {
                    this.clientSocket.setSoTimeout(oldTimeout);
                }
            }
            catch (IOException ioe) {
                rc = 14;
                this.setMessage("Writing to OutputStream failed with " + ioe.getMessage());
            }
        }
        return rc;
    }

    private void writeDatagram(byte action, byte[] buffer, int buffersize) throws IOException {
        this.os.write(action);
        this.os.write(this.connectionIdentifier);
        this.os.write(this.conv_id);
        RfcUtilities.intAsByteArray(buffersize, this.driverBuffer);
        this.os.write(this.driverBuffer, 0, 4);
        this.os.write(buffer, 0, buffersize);
        this.timeOfLastIO = System.currentTimeMillis();
    }

    private int checkForAccessException() throws IOException, UnsupportedEncodingException {
        int rc = 0;
        int action = this.is.read();
        this.is.read(this.driverBuffer, 0, 44);
        this.timeOfLastIO = System.currentTimeMillis();
        switch (action) {
            case 5: {
                break;
            }
            case 7: {
                int messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 40);
                byte[] messageBytes = new byte[messageLength];
                this.is.read(messageBytes);
                rc = 5;
                this.setMessage(new String(messageBytes, "UTF8"));
                return rc;
            }
            case -1: {
                rc = 8;
                this.setMessage("No data received when sending request for " + this.act_cntl.functionName + ": " + action);
                return rc;
            }
            default: {
                rc = 3;
                this.setMessage("Invalid communication response when sending request for " + this.act_cntl.functionName + ": " + action);
                return rc;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int buffersize, int[] bytes_read) {
        int rc = 0;
        try {
            this.clientSocket.setSoTimeout(100);
            rc = this.internalRead(buffer, bytes_read);
            while (rc == 17) {
                if (this.act_cntl.RfcIsCanceled()) {
                    bytes_read[0] = 0;
                    int n = this.cancel() ? 34 : 3;
                    return n;
                }
                rc = this.internalRead(buffer, bytes_read);
            }
        }
        catch (SocketException se) {
            rc = 8;
        }
        finally {
            try {
                if (this.clientSocket != null) {
                    this.clientSocket.setSoTimeout(0);
                }
            }
            catch (SocketException e) {
                rc = 8;
            }
        }
        return rc;
    }

    private int internalRead(byte[] buffer, int[] bytes_read) {
        int rc = 0;
        int readBytesCount = 0;
        try {
            int readOffset;
            for (readOffset = 0; readOffset < 45; readOffset += readBytesCount) {
                readBytesCount = this.is.read(this.driverBuffer, readOffset, 45 - readOffset);
                if (readBytesCount != -1) continue;
                rc = 14;
                this.setMessage("read: EndOfStream reached when trying to read SCC header");
                return rc;
            }
            switch (this.driverBuffer[0]) {
                case 5: {
                    int responseLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 41);
                    this.is.skip(responseLength);
                    break;
                }
                case 6: {
                    bytes_read[0] = RfcUtilities.byteArrayToInt(this.driverBuffer, 41);
                    readBytesCount = 0;
                    for (readOffset = 0; readOffset < bytes_read[0]; readOffset += readBytesCount) {
                        readBytesCount = this.is.read(buffer, readOffset, bytes_read[0] - readOffset);
                        if (readBytesCount != -1) continue;
                        rc = 14;
                        this.setMessage("read: EndOfStream reached when trying to read protocol buffer");
                        return rc;
                    }
                    break;
                }
                case 7: {
                    int messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 41);
                    byte[] messageBytes = new byte[messageLength];
                    this.is.read(messageBytes);
                    rc = 5;
                    this.setMessage("Partner signaled an error: " + new String(messageBytes, "UTF8"));
                    return rc;
                }
                default: {
                    rc = 3;
                    this.setMessage("Invalid communication response on read: " + this.driverBuffer[0]);
                    return rc;
                }
            }
        }
        catch (SocketTimeoutException ste) {
            return 17;
        }
        catch (IOException ioe) {
            rc = 14;
            this.setMessage("read: Reading from InputStream failed: " + ioe.getMessage());
        }
        this.timeOfLastIO = System.currentTimeMillis();
        return rc;
    }

    boolean cancel() {
        if (this.clientSocket != null) {
            this.setMessage("connection with handle " + this.act_cntl.hrfc + " [" + Trc.convIDToString(this.conv_id) + "] closed after cancel" + "\nStack trace: \n" + this.act_cntl.getCancelStackTrace());
            try {
                this.os.write(8);
                this.os.write(this.connectionIdentifier);
                this.os.write(this.conv_id);
                this.driverBuffer[0] = 0;
                this.driverBuffer[1] = 0;
                this.driverBuffer[2] = 0;
                this.driverBuffer[3] = 0;
                this.os.write(this.driverBuffer, 0, 4);
                this.os.flush();
                this.timeOfLastIO = System.currentTimeMillis();
                this.clientSocket.setSoTimeout(10000);
                int action = this.is.read();
                switch (action) {
                    case 5: {
                        this.is.skip(40L);
                        this.is.read(this.driverBuffer, 0, 4);
                        break;
                    }
                    case 7: {
                        this.is.skip(40L);
                        this.is.read(this.driverBuffer, 0, 4);
                        int messageLength = RfcUtilities.byteArrayToInt(this.driverBuffer, 0);
                        byte[] messageBytes = new byte[messageLength];
                        this.is.read(messageBytes);
                        String errorText = "Connection with handle " + this.act_cntl.hrfc + " [" + Trc.convIDToString(this.conv_id) + "] is closed, but cancel was not possible. CPIC layer returned (" + new String(messageBytes, "UTF8") + ')';
                        this.setMessage(errorText);
                        Trc.criticalTrace(null, errorText);
                        return false;
                    }
                    case -1: {
                        this.setMessage("Cancel sent, but no response received.");
                        return false;
                    }
                    default: {
                        this.setMessage("Invalid communication state on cancel (Action " + action + " not expected)");
                        return false;
                    }
                }
            }
            catch (SocketTimeoutException ste) {
            }
            catch (IOException e) {
                this.setMessage("Connection is corrupted, will close it: " + e);
                try {
                    this.clientSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.clientSocket = null;
                this.os = null;
                this.is = null;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rflush() {
        this.timeOfLastIO = System.currentTimeMillis();
        return 0;
    }

    @Override
    public int wflush() {
        int rc = 0;
        try {
            this.os.flush();
            this.timeOfLastIO = System.currentTimeMillis();
        }
        catch (IOException ioe) {
            rc = 14;
            this.setMessage("Flushing OutputStream failed: " + ioe.getMessage());
        }
        return rc;
    }

    @Override
    public int getPacketSize() {
        return 28000;
    }

    @Override
    public void info(byte[] info) {
        System.arraycopy(this.conv_id, 0, info, 0, 8);
    }

    @Override
    public boolean isSncMode() {
        return false;
    }

    @Override
    public byte[] getSncPartnerAclKey() {
        return null;
    }

    @Override
    public String getSncPartnerName() {
        return null;
    }

    @Override
    public int proto(int set_get, int proto) {
        return proto;
    }

    @Override
    public RfcDriverState getRfcDriverState() {
        return null;
    }

    @Override
    public void restoreState(RfcDriverState driverState) {
    }
}

