/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import javax.net.SocketFactory;

public abstract class RfcDriver {
    private String message = null;
    static SocketFactory socketFactory = null;
    protected RfcIoOpenCntl act_cntl;
    protected static final byte[] com_head = new byte[]{-39, -58, -61, -16, -16, -16, -16, -16, -16, -16, -16, -16};
    protected static final byte[] trace_com_head = new byte[]{-39, -58, -61, -16, -16, -16, -16, -16, -16, -16, -16, -29};

    public static void setSocketFactory(SocketFactory socketFactory) {
        RfcDriver.socketFactory = socketFactory;
    }

    protected byte[] get_com_head(boolean trace) {
        return trace ? trace_com_head : com_head;
    }

    public RfcDriver(RfcIoOpenCntl iocntl) {
        this.act_cntl = iocntl;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setMessageTRC(String msg) {
        this.message = msg;
        if (this.act_cntl != null && this.act_cntl.trace) {
            Trc.ab_rfctrc(msg);
        }
    }

    public void clearMessage() {
        this.message = null;
    }

    public abstract int open(RfcOptions var1) throws RfcException;

    public abstract int accept(RfcAcceptInfo var1);

    public abstract int write(byte[] var1, int var2, boolean var3);

    public abstract int read(byte[] var1, int var2, int[] var3);

    public abstract int rflush();

    public abstract int wflush();

    public abstract void close();

    public abstract boolean isPartnerReachable();

    public abstract int wait(byte[] var1, int var2, int[] var3);

    public abstract void abort();

    public abstract int getPacketSize();

    public abstract int listen(byte[] var1, int var2, int[] var3, int var4);

    public abstract void info(byte[] var1);

    public abstract boolean isSncMode();

    public abstract byte[] getSncPartnerAclKey();

    public abstract String getSncPartnerName();

    public abstract int proto(int var1, int var2);

    public abstract RfcDriverState getRfcDriverState();

    public abstract void restoreState(RfcDriverState var1);
}

