/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.data.ARFCSDATA;
import com.sap.conn.rfc.data.ARfcSDataHeader;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPlaybackInfo;
import com.sap.conn.rfc.engine.Trc;

public class RfcTypePlayback
extends RfcDriver {
    private static final int blocksize = 1785;
    public ARFCSDATA itab_h;
    public ARfcSDataHeader key = new ARfcSDataHeader();
    public boolean pr_mode;
    public int linno;

    public RfcTypePlayback(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    @Override
    public synchronized int open(RfcOptions options) {
        this.pr_mode = true;
        return 0;
    }

    @Override
    public boolean isPartnerReachable() {
        return true;
    }

    @Override
    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        RfcPlaybackInfo info = (RfcPlaybackInfo)acceptInfo;
        this.pr_mode = false;
        this.itab_h = info.itab_h;
        this.linno = 0;
        return 0;
    }

    @Override
    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        if (!this.pr_mode) {
            return 0;
        }
        DefaultTable data = this.itab_h.getTable();
        data.appendRow();
        String[] tidFields = this.key.getTIDFields();
        data.encodeCHAR(tidFields[0], 0);
        data.setEdited(0);
        data.encodeCHAR(tidFields[1], 1);
        data.setEdited(1);
        data.encodeCHAR(tidFields[2], 2);
        data.setEdited(2);
        data.encodeCHAR(tidFields[3], 3);
        data.setEdited(3);
        data.encodeCHAR(this.key.getDestination(), 4);
        data.setEdited(4);
        data.encodeNUM(this.key.getLuwCounter(), 5);
        data.setEdited(5);
        data.encodeBYTE(this.key.getBlockCounter(), 6);
        data.setEdited(6);
        byte[] tmpBuff = new byte[255];
        int i = 0;
        int j = 7;
        while (i + 255 <= buffersize) {
            System.arraycopy(buffer, i, tmpBuff, 0, 255);
            data.encodeBYTE(tmpBuff, j);
            data.setEdited(j);
            i += 255;
            ++j;
        }
        if (buffersize % 255 != 0) {
            System.arraycopy(buffer, i, tmpBuff, 0, buffersize - i);
            data.encodeBYTE(tmpBuff, j);
            data.setEdited(j);
        }
        this.key.incrementBlockCounter();
        return 0;
    }

    @Override
    public synchronized int read(byte[] buffer, int buffersize, int[] bytes_read) {
        if (this.pr_mode) {
            return 0;
        }
        DefaultTable table = this.itab_h.getTable();
        if (table.getNumRows() <= this.linno) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("read(RfcTypePlayback) :: Finished after " + Integer.toString(this.linno) + " rows" + JCoRuntime.CRLF);
            }
            return 10;
        }
        table.setRow(this.linno);
        ++this.linno;
        byte[] readBuff = null;
        int i = 0;
        for (int j = 7; j < 14; ++j) {
            readBuff = table.decodeBYTE(j);
            System.arraycopy(readBuff, 0, buffer, i, readBuff.length);
            i += readBuff.length;
        }
        bytes_read[0] = i;
        return 0;
    }

    @Override
    public int rflush() {
        return 0;
    }

    @Override
    public int wflush() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public void abort() {
    }

    @Override
    public int getPacketSize() {
        return 1785;
    }

    @Override
    public int listen(byte[] buffer, int buffersize, int[] bytes_read, int timeout) {
        return 0;
    }

    @Override
    public void info(byte[] info) {
    }

    @Override
    public int proto(int set_get, int proto) {
        return 0;
    }

    @Override
    public int wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
        return 0;
    }

    @Override
    public RfcDriverState getRfcDriverState() {
        return null;
    }

    @Override
    public void restoreState(RfcDriverState driverState) {
    }

    @Override
    public byte[] getSncPartnerAclKey() {
        return this.act_cntl.htRFC.getSncPartnerAclKey();
    }

    @Override
    public String getSncPartnerName() {
        return this.act_cntl.htRFC.getSncPartnerName();
    }

    @Override
    public boolean isSncMode() {
        return this.act_cntl.htRFC.isSncMode();
    }
}

