/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.RfcApi;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class AbSysInfo {
    public static final byte SYSINT_LITTLE_ENDIAN = 1;
    public static final byte SYSINT_BIG_ENDIAN = 2;
    public static final byte SYSFLOAT_IEEE = 1;
    public static final byte SYSFLOAT_370 = 2;
    public static final byte intformat;
    public static final byte floatformat = 1;
    public static final String charset;
    public static final String pcs_charset = "1100";
    public static final String SapRelease = "753";
    public static final String kernelRelease;
    public static String programName;
    public static final String ipAddress;
    public static final String ipv6Address;
    public static final String host;
    public static final String systemID;
    public static final String systemNumber;
    public static final String callerID;
    public static final String osName;
    static final String[] intFormats;
    static final String[] floatFormats;
    static final String[] compressionFormats;
    static final String[] conversionErrorBehavior;

    public static String getIPv4Address(Inet6Address ipv6Address) {
        byte[] address = ipv6Address.getAddress();
        StringBuilder buf = new StringBuilder(15);
        buf.append(address[12] & 0xFF).append('.').append(address[13] & 0xFF).append('.').append(address[14] & 0xFF).append('.').append(address[15] & 0xFF);
        return buf.toString();
    }

    static {
        int idx;
        programName = "SAPJCo";
        intFormats = new String[]{"???", "LIT", "BIG"};
        floatFormats = new String[]{"????", "IEEE", "\\370"};
        compressionFormats = new String[]{"", "SPACE", "LZ", "(SPACE)", "(LZ)", "SPACE-U2", "SPACE-U4"};
        conversionErrorBehavior = new String[]{"REJECT", "IGNORE"};
        String name = null;
        String ipv4 = null;
        String ipv6 = null;
        try {
            InetAddress ia = null;
            try {
                String localAddr = null;
                if (Environment.inStandalone()) {
                    localAddr = JCo.getProperty((String)"jco.ni.local_address");
                } else {
                    if (Environment.inSAPJ2EE() || Environment.inJStartup()) {
                        localAddr = JCoRuntime.getProfileParameter("jstartup/local_addr");
                    }
                    if (!(localAddr != null && localAddr.length() != 0 || (localAddr = JCoRuntime.getProfileParameter("is/local_addr")) != null && localAddr.length() != 0)) {
                        localAddr = JCoRuntime.getProfileParameter("SAPLOCALHOST");
                    }
                }
                if (localAddr != null && localAddr.length() > 0) {
                    ia = InetAddress.getByName(localAddr);
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (ia == null) {
                ia = InetAddress.getLocalHost();
            }
            if (ia instanceof Inet6Address) {
                Inet6Address iav6 = (Inet6Address)ia;
                if (iav6.isIPv4CompatibleAddress()) {
                    ipv4 = AbSysInfo.getIPv4Address(iav6);
                }
                ipv6 = iav6.getHostAddress();
            } else {
                ipv4 = ia.getHostAddress();
                ipv6 = null;
            }
            name = ia.getHostName();
            if (name != null && name.length() > 0) {
                int idx2 = name.indexOf(46, 1);
                if (idx2 > 0) {
                    name = name.substring(0, idx2);
                }
            } else {
                name = "localhost";
            }
        }
        catch (Exception exc) {
            ipv4 = "127.0.0.1";
            ipv6 = null;
            name = "localhost";
        }
        ipAddress = ipv4;
        ipv6Address = ipv6;
        host = name;
        intformat = (byte)2;
        charset = "4102";
        String nativeLayerVersion = RfcApi.RfcGetVersion();
        kernelRelease = nativeLayerVersion != null ? ((idx = nativeLayerVersion.indexOf(46)) > 0 && idx < 5 ? nativeLayerVersion.substring(0, idx) : SapRelease) : SapRelease;
        systemID = "";
        systemNumber = "";
        callerID = host;
        try {
            name = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String str = System.getProperty("os.name");
                    if (str != null && str.length() > 10 && str.startsWith("Windows ")) {
                        if (str.charAt(9) == '.') {
                            str = str.substring(0, 9);
                        } else if (str.charAt(10) == '.') {
                            str = str.substring(0, 10);
                        } else {
                            if ((str = str.substring(8)).startsWith("Server ")) {
                                str = str.substring(7);
                            }
                            StringBuilder sb = new StringBuilder(str.length() + 4);
                            sb.append("Win ").append(str);
                            if (sb.length() > 10 && sb.charAt(8) == ' ' && sb.charAt(9) == 'R' && sb.charAt(10) <= '9') {
                                sb.deleteCharAt(8);
                            }
                            str = sb.toString();
                        }
                    }
                    return str;
                }
            });
        }
        catch (Exception exc) {
            name = "";
        }
        osName = name;
    }
}

