/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcRegisterInfo;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.driver.NeoSocketDriver;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcTypeDirectCpic;
import com.sap.conn.rfc.driver.RfcTypePlayback;
import com.sap.conn.rfc.driver.RfcTypeRecorder;
import com.sap.conn.rfc.driver.RfcTypeRegisterCpic;
import com.sap.conn.rfc.engine.DefaultRfcTraceWriter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;
import javax.net.SocketFactory;

public class DefaultRfcRuntime
implements RfcRuntime {
    private DefaultRfcTraceWriter defaultRfcTraceWriter;

    @Override
    public RfcAcceptInfo createAcceptInfo(Properties properties) {
        return new RfcRegisterInfo();
    }

    @Override
    public String getVersion() {
        return CpicDriver.CpicGetVersion();
    }

    @Override
    public RfcDriver createChannel(RfcIoOpenCntl currentControl) {
        RfcDriver driver = null;
        switch (currentControl.type) {
            case 0: 
            case 1: {
                driver = new RfcTypeDirectCpic(currentControl);
                break;
            }
            case 4: {
                driver = new RfcTypeRegisterCpic(currentControl);
                break;
            }
            case 3: {
                driver = new RfcTypePlayback(currentControl);
                break;
            }
            case 5: {
                driver = new RfcTypeRecorder(currentControl);
                break;
            }
            case 2: {
                driver = new NeoSocketDriver(currentControl);
            }
        }
        return driver;
    }

    @Override
    public RfcTraceWriter getRfcTraceWriter() {
        if (this.defaultRfcTraceWriter == null) {
            this.defaultRfcTraceWriter = new DefaultRfcTraceWriter();
        }
        return this.defaultRfcTraceWriter;
    }

    @Override
    public void updateClientConnectionProperties(char connectionType, Properties properties) {
    }

    @Override
    public void initializeHandle(RfcIoOpenCntl currentControl) {
    }

    @Override
    public int changeCpicTraceFile(String fileName) {
        return CpicDriver.changeCpicTraceFile(fileName);
    }

    @Override
    public int changeCpicTraceLevel(int level) {
        return CpicDriver.changeCpicTraceLevel(level);
    }

    @Override
    public int setCpicAcceptRemoteTrace(int acceptRemoteTrace) {
        return CpicDriver.setCpicAcceptRemoteTrace(acceptRemoteTrace);
    }

    @Override
    public int setCpicTrace(int level, String fileName) {
        return CpicDriver.setCpicTrace(level, fileName);
    }

    @Override
    public int setCpicTraceFileSize(int fileSize) {
        return CpicDriver.setCpicTraceFileSize(fileSize);
    }

    @Override
    public String getTraceFileName() {
        return CpicDriver.getTraceFileName();
    }

    @Override
    public void setRfcTrace(boolean traceOn) {
        RfcIoOpenCntl.setGeneralTrace(traceOn);
    }

    @Override
    public void setRfcConnectTimeout(int timeout) {
        RfcIoOpenCntl.setClientConnectTimeout(timeout);
    }

    @Override
    public RfcIoOpenCntl getNextListener() {
        return RfcTypeRegisterCpic.getNextListener();
    }

    @Override
    public int waitForCpicRequest(int timeout) {
        return RfcTypeRegisterCpic.waitForRequest(timeout);
    }

    @Override
    public int getNumServerConnections(RfcAcceptInfo acceptInfo) throws RfcException {
        return RfcTypeRegisterCpic.getNumServerConnections(acceptInfo);
    }

    @Override
    public void setCpicMaxConv(int no_elem) throws RfcException {
        CpicDriver.setCpicMaxConv(no_elem);
    }

    @Override
    public int setCpicConnectTimeout(int timeout) {
        return CpicDriver.setCpicConnectTimeout(timeout);
    }

    @Override
    public int setCpicLocalAddress(String ipAddress) {
        return CpicDriver.setCpicLocalAddress(ipAddress);
    }

    @Override
    public int setDNSCacheTTL(int newDNSCacheTTL) {
        return CpicDriver.setDNSCacheTTL(newDNSCacheTTL);
    }

    @Override
    public int getDNSCacheTTL() {
        return CpicDriver.getDNSCacheTTL();
    }

    @Override
    public int setDNSNegativeCacheTTL(int newDNSNegativeCacheTTL) {
        return CpicDriver.setDNSNegativeCacheTTL(newDNSNegativeCacheTTL);
    }

    @Override
    public int getDNSNegativeCacheTTL() {
        return CpicDriver.getDNSNegativeCacheTTL();
    }

    public String getOwnCodepage() {
        return "4102";
    }

    public boolean isLittleEndian() {
        return false;
    }

    @Override
    public void setupRegKeepAlive(boolean pingActivate, boolean pingReply, int ping_reply_timeout_in_sec, int ping_period_in_sec, int ping_write_timeout_in_ms) throws RfcException {
        CpicDriver.setupRegKeepAlive(pingActivate, pingReply, ping_reply_timeout_in_sec, ping_period_in_sec, ping_write_timeout_in_ms);
    }

    @Override
    public String[] launchSapGui(RfcIoOpenCntl currentControl, String startCommand, String sapGuiId, String systemID, int systemNr) {
        return ((CpicDriver)currentControl.channel).launchSapGui(startCommand, sapGuiId, systemID, systemNr);
    }

    @Override
    public byte[] createUUID() {
        return CpicDriver.createUUID();
    }

    @Override
    public GatewayRegInfo getGatewayRegInfo(RfcIoOpenCntl cntl) throws RfcException {
        return RfcTypeRegisterCpic.getGatewayRegInfo(cntl);
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        RfcDriver.setSocketFactory(factory);
    }
}

