/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import com.sap.conn.rfc.engine.Trc;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

class DefaultRfcTraceWriter
implements RfcTraceWriter {
    private static final String errorFilePrefix = "dev_jco_rfc";
    private static final String errorFileSuffix = ".log";
    private static final String m_errorFileName = "dev_jco_rfc.log";
    private static FileWriter m_errorTraceFileWriter;
    private static File m_errorFile;
    private long logFileMaxSize = 0x800000L;
    private short logFileMaxBackups = (short)-1;
    private static final long MAX_TRACE_FILE_LENGTH = Long.MAX_VALUE;
    static final String versionInfo;
    private static final String backupFilenamePattern = "dev_jco_rfc.\\d{8}_\\d{6}.log";
    private static ThreadLocal<TraceWriterFactory> locTraceFileFactory;

    @Override
    public synchronized void setLogFileMaxSize(int logFileMaxSizeInMB) {
        this.logFileMaxSize = logFileMaxSizeInMB * 1024 * 1024;
    }

    @Override
    public synchronized void setLogFileMaxBackups(short logFileMaxBackups) {
        this.logFileMaxBackups = logFileMaxBackups;
    }

    @Override
    public void criticalTrace(String text) {
        this.openErrorTrace();
        if (m_errorTraceFileWriter != null) {
            this.writeInErrorTrace(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openErrorTrace() {
        DefaultRfcTraceWriter defaultRfcTraceWriter = this;
        synchronized (defaultRfcTraceWriter) {
            if (m_errorTraceFileWriter == null) {
                try {
                    Date date = new Date();
                    String path = null;
                    try {
                        path = JCo.getProperty((String)"jrfc.trace_path");
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (path == null && (path = System.getProperty("jrfc.trace_path")) == null) {
                        try {
                            path = JCo.getProperty((String)"jco.trace_path");
                        }
                        catch (NullPointerException npe) {
                            // empty catch block
                        }
                        if (path == null) {
                            path = System.getProperty("jco.trace_path");
                        }
                    }
                    StringBuilder fileName = new StringBuilder(256);
                    if (path != null && path.length() > 0 && new File(path).isDirectory()) {
                        fileName.append(path);
                        char last = path.charAt(path.length() - 1);
                        if (last != '\\' && last != '/') {
                            fileName.append(System.getProperty("file.separator"));
                        }
                    }
                    fileName.append(m_errorFileName);
                    m_errorFile = new File(fileName.toString());
                    try {
                        m_errorTraceFileWriter = new FileWriter(m_errorFile, true);
                    }
                    catch (IOException e) {
                        System.err.println("Error Log is written to " + new File(m_errorFileName).getAbsolutePath() + ", because given file access failed");
                        m_errorTraceFileWriter = new FileWriter(m_errorFileName, true);
                    }
                    m_errorTraceFileWriter.write(new StringBuilder(100).append(JCoRuntime.CRLF).append("**** Error file opened at ").append(((SimpleDateFormat)openFileDateFormat.get()).format(date)).append(versionInfo).toString());
                    m_errorTraceFileWriter.flush();
                }
                catch (Exception ex) {
                    m_errorFile = null;
                    m_errorTraceFileWriter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInErrorTrace(String text) {
        if (text == null) {
            return;
        }
        DefaultRfcTraceWriter defaultRfcTraceWriter = this;
        synchronized (defaultRfcTraceWriter) {
            long length = m_errorFile.length();
            if (length > this.logFileMaxSize) {
                Date now = new Date();
                boolean isClosed = false;
                try {
                    if (m_errorTraceFileWriter != null) {
                        m_errorTraceFileWriter.flush();
                        m_errorTraceFileWriter.close();
                        m_errorTraceFileWriter = null;
                        isClosed = true;
                    }
                }
                catch (IOException e) {
                    isClosed = false;
                }
                if (isClosed) {
                    String fullName = m_errorFile.getAbsolutePath();
                    String baseName = fullName.substring(0, fullName.lastIndexOf("."));
                    String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(now);
                    fullName = new StringBuilder(baseName.length() + 20).append(baseName).append('.').append(timestamp).append(errorFileSuffix).toString();
                    if (m_errorFile.renameTo(new File(fullName))) {
                        try {
                            m_errorFile.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        m_errorFile = null;
                    }
                    this.openErrorTrace();
                }
                if (this.logFileMaxBackups >= 0) {
                    try {
                        File directory = m_errorFile.getCanonicalFile().getParentFile();
                        ErrorTraceBackupFilter backupFilter = new ErrorTraceBackupFilter();
                        File[] errorTraceBackups = directory.listFiles(backupFilter);
                        if (errorTraceBackups != null) {
                            int toDelete = errorTraceBackups.length - this.logFileMaxBackups;
                            while (toDelete > 0) {
                                File oldest = errorTraceBackups[0];
                                int pos = 0;
                                for (int i = 1; i < errorTraceBackups.length; ++i) {
                                    if (errorTraceBackups[i].lastModified() >= oldest.lastModified()) continue;
                                    oldest = errorTraceBackups[i];
                                    pos = i;
                                }
                                oldest.delete();
                                if (--toDelete <= 0) continue;
                                File[] newList = new File[errorTraceBackups.length - 1];
                                System.arraycopy(errorTraceBackups, 0, newList, 0, pos);
                                System.arraycopy(errorTraceBackups, pos + 1, newList, pos, newList.length - pos);
                                errorTraceBackups = newList;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                if (m_errorTraceFileWriter != null) {
                    m_errorTraceFileWriter.write(text);
                    m_errorTraceFileWriter.flush();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeTrace() {
        locTraceFileFactory.get().closeTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLatestOpenTrace() {
        DefaultRfcTraceWriter defaultRfcTraceWriter = this;
        synchronized (defaultRfcTraceWriter) {
            if (m_errorTraceFileWriter != null) {
                try {
                    m_errorTraceFileWriter.close();
                    m_errorTraceFileWriter = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void debugTrace(String text) {
        locTraceFileFactory.get().write(text);
    }

    @Override
    public void infoTrace(String text) {
        locTraceFileFactory.get().write(text);
    }

    @Override
    public void infoLog(String text) {
        locTraceFileFactory.get().write(text);
    }

    static {
        m_errorFile = null;
        versionInfo = new StringBuilder(50).append(" Rel. ").append(JCoRuntimeFactory.getRuntime().getVersion()).append(" [").append(RfcApi.RfcGetVersion()).append(']').append(JCoRuntime.CRLF).toString();
        locTraceFileFactory = new ThreadLocal<TraceWriterFactory>(){

            @Override
            protected TraceWriterFactory initialValue() {
                return new TraceWriterFactory();
            }
        };
    }

    private static class TraceWriterFactory {
        private File currentFile = null;
        private FileWriter currentFileWriter = null;
        private String baseName = null;
        private int fileCounter = 0;

        TraceWriterFactory() {
            StringBuilder fileName = new StringBuilder(256);
            String path = JCo.getProperty((String)"jrfc.trace_path");
            if (path == null && (path = System.getProperty("jrfc.trace_path")) == null && (path = JCo.getProperty((String)"jco.trace_path")) == null) {
                path = System.getProperty("jco.trace_path");
            }
            if (path != null && path.length() > 0 && new File(path).isDirectory()) {
                fileName.append(path);
                char last = path.charAt(path.length() - 1);
                if (last != '\\' && last != '/') {
                    fileName.append(System.getProperty("file.separator"));
                }
            }
            String jrfcTraceFileName = CpicDriver.getTraceFileName();
            fileName.append("jco_");
            fileName.append(jrfcTraceFileName.substring(1, jrfcTraceFileName.length() - 4));
            this.baseName = fileName.toString();
        }

        private String getNextFileName() {
            ++this.fileCounter;
            StringBuilder fName = new StringBuilder(256);
            fName.append(this.baseName).append('.');
            if (this.fileCounter < 100) {
                fName.append('0');
            }
            if (this.fileCounter < 10) {
                fName.append('0');
            }
            fName.append(this.fileCounter);
            fName.append(".trc");
            return fName.toString();
        }

        private String createMarker() {
            return new StringBuilder(100).append(JCoRuntime.CRLF).append("**** Trace file opened at ").append(RfcTraceWriter.openFileDateFormat.get().format(new Date())).append(versionInfo).toString();
        }

        private FileWriter getWriter() {
            boolean createNextFile = this.currentFile == null || this.currentFile.length() > Long.MAX_VALUE;
            try {
                if (createNextFile) {
                    this.currentFile = new File(this.getNextFileName());
                    if (this.currentFile.exists()) {
                        this.currentFile.delete();
                    }
                    this.currentFileWriter = new FileWriter(this.currentFile);
                    this.currentFileWriter.write(this.createMarker());
                    this.currentFileWriter.flush();
                } else if (this.currentFileWriter == null) {
                    this.currentFileWriter = new FileWriter(this.currentFile, true);
                    this.currentFileWriter.write(this.createMarker());
                }
                return this.currentFileWriter;
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder(256);
                msg.append("JRFC Error> Could not create regular trace file");
                msg.append(JCoRuntime.CRLF);
                msg.append("\texception occurred: ");
                msg.append(ex.toString());
                Trc.criticalTrace(0L, msg.toString());
                return null;
            }
        }

        public void closeTrace() {
            try {
                if (this.currentFileWriter != null) {
                    this.currentFileWriter.close();
                    this.currentFileWriter = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void write(String text) {
            FileWriter writer = this.getWriter();
            if (writer == null) {
                return;
            }
            try {
                writer.write(text);
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ErrorTraceBackupFilter
    implements FilenameFilter {
        ErrorTraceBackupFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return Pattern.matches(DefaultRfcTraceWriter.backupFilenamePattern, name);
        }
    }
}

