/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.BasXMLOutputStream;
import com.sap.conn.rfc.api.IRfcComplexParameter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.SerializationAware;
import com.sap.conn.rfc.data.ItStream;
import com.sap.conn.rfc.data.LZTable;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializer;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerSupplyOutWrapper;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.IOException;

public abstract class RfcCall {
    private static int COMPRESSION_MINIMUM_TABLE_SIZE = 8192;

    public static void ab_rfcbxt_withoutFlush(RfcIoOpenCntl act_cntl, IRfcParameter[] importing_abap, IRfcParameter[] changing, IRfcTable[] tables) throws RfcIoException {
        RfcPut.ab_rfcput(act_cntl, 1280);
        if (act_cntl.rfc_uuid_set) {
            RfcPut.ab_rfcput(act_cntl, 1300, act_cntl.rfc_uuid, act_cntl.rfc_uuid.length, 0);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("UUID:  RfcBackNew sent the uuid to the partner:" + GUID.toString(act_cntl.rfc_uuid) + JCoRuntime.CRLF);
            }
        }
        if (act_cntl.usebASXML) {
            RfcCall.send_as_basxml(act_cntl, importing_abap, changing, tables);
        } else if (act_cntl.serializationFormat != 0 && act_cntl.version >= 5) {
            RfcCall.ngRfcSerialize(act_cntl, importing_abap, null, changing, tables, false);
        } else {
            RfcCall.rfc_extdata(act_cntl, importing_abap, changing, tables);
        }
    }

    public static void rfc_table(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        byte[] tabinfo = new byte[8];
        byte[] tmp = RfcUtilities.intAsByteArray(table.getRowLength());
        System.arraycopy(tmp, 0, tabinfo, 0, 4);
        tmp = RfcUtilities.intAsByteArray(table.getNumRows());
        System.arraycopy(tmp, 0, tabinfo, 4, 4);
        RfcPut.ab_rfcput(act_cntl, 770, tabinfo, tabinfo.length, 0);
        int compress = act_cntl.protocol & 3;
        if ((compress & 2) != 0) {
            int rc = RfcCall.send_table_lz(act_cntl, table);
            if (rc == 0) {
                return;
            }
            compress &= 0xFFFFFFFD;
        }
        if ((compress & 1) != 0) {
            RfcCall.send_table_space(act_cntl, table);
        } else {
            RfcCall.send_table(act_cntl, table, 771);
        }
    }

    private static int send_table_lz(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        int tsize = 0;
        LZTable lzTable = null;
        int rc = 0;
        tsize = table.getNumRows() * table.getRowLength();
        if (tsize <= COMPRESSION_MINIMUM_TABLE_SIZE) {
            return 1;
        }
        lzTable = new LZTable("*LZ*");
        rc = ItStream.compress(lzTable, table);
        if (rc != 0) {
            return rc;
        }
        RfcCall.send_table(act_cntl, lzTable, 773);
        RfcPut.ab_rfcput(act_cntl, 774);
        return 0;
    }

    private static void send_table(RfcIoOpenCntl act_cntl, IRfcTable table, int rfcid) throws RfcIoException {
        for (int i = 0; i < table.getNumRows(); ++i) {
            byte[] entry = table.getBytes(i);
            RfcPut.ab_rfcput(act_cntl, rfcid, entry, entry.length, 0);
        }
    }

    private static void send_table_space(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        int leng = table.getRowLength();
        int fill = table.getNumRows();
        int sendleng = 0;
        byte last_byte = 0;
        byte[] entry = null;
        for (int count = 0; count < fill; ++count) {
            entry = table.getBytes(count);
            sendleng = 0;
            last_byte = entry[leng - 1];
            for (int j = leng - 1; j >= 0; --j) {
                if (entry[j] != last_byte) {
                    sendleng = j + 2;
                    break;
                }
                last_byte = entry[j];
            }
            if (sendleng == 0) {
                sendleng = 1;
            }
            RfcPut.ab_rfcput(act_cntl, 772, entry, sendleng, 0);
        }
    }

    public static void RfcCallEnd(RfcIoOpenCntl act_cntl) throws RfcIoException {
        RfcPut.ab_rfcend(act_cntl);
    }

    private static void RfcCallNew(RfcIoOpenCntl act_cntl, String functionName, boolean usebASXML, AbapClassException.Mode classExceptionMode) throws RfcIoException {
        String saprel = "753";
        RfcPut.ab_rfcput(act_cntl, 1282);
        if (classExceptionMode != AbapClassException.Mode.OFF && act_cntl.partner_rel != null && "72".compareTo(act_cntl.partner_rel) <= 0) {
            RfcPut.ab_rfcput(act_cntl, 1057, new byte[]{classExceptionMode == AbapClassException.Mode.EXCEPTION_CHAIN ? (byte)2 : 1}, 1, 0);
        }
        RfcPut.ab_rfcput_string(act_cntl, 11, saprel);
        RfcPut.ab_rfcput_string(act_cntl, 258, functionName);
        if (act_cntl.isStateless() && !act_cntl.accepted) {
            RfcPut.ab_rfcput(act_cntl, 1314);
        }
        if (!act_cntl.useDeltaManagement || usebASXML && act_cntl.usebASXML && act_cntl.serializationFormat == 0) {
            RfcPut.ab_rfcput(act_cntl, 823);
        }
        if (act_cntl.rfc_uuid_set) {
            RfcPut.ab_rfcput(act_cntl, 1300, act_cntl.rfc_uuid, act_cntl.rfc_uuid.length, 0);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("UUID:  RfcCallNew sent the uuid to the partner:" + GUID.toString(act_cntl.rfc_uuid) + JCoRuntime.CRLF);
            }
        }
        if (act_cntl.th_client_id != null && !act_cntl.accepted) {
            RfcPut.ab_rfcput(act_cntl, 305, act_cntl.th_client_id, act_cntl.th_client_id.length, 0);
        }
    }

    public static int ab_rfccxt2(RfcIoOpenCntl act_cntl, String function, IRfcParameter[] importing_abap, IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables, boolean usebASXML, AbapClassException.Mode classExceptionMode) throws RfcIoException {
        RfcCall.RfcCallNew(act_cntl, function, usebASXML, classExceptionMode);
        if (act_cntl.serializationFormat != 0 && act_cntl.version >= 5) {
            if (act_cntl.rfc_role == 'C') {
                RfcCall.ngRfcSerialize(act_cntl, importing_abap, exporting_abap, changing, tables, true);
            } else {
                RfcCall.ngRfcSerialize(act_cntl, importing_abap, exporting_abap, changing, tables, false);
            }
        } else if (usebASXML && act_cntl.usebASXML) {
            RfcCall.sendIsSuppliedInfo(act_cntl, exporting_abap, changing);
            RfcCall.send_as_basxml(act_cntl, importing_abap, changing, tables);
        } else {
            RfcCall.sendIsSuppliedInfo(act_cntl, exporting_abap, changing);
            RfcCall.rfc_extdata(act_cntl, importing_abap, changing, tables);
        }
        RfcCall.RfcCallEnd(act_cntl);
        return 0;
    }

    private static void sendIsSuppliedInfo(RfcIoOpenCntl act_cntl, IRfcParameter[] exports, IRfcParameter[] changing) throws RfcIoException {
        int i;
        RfcPut.ab_rfcput(act_cntl, 1298);
        if (exports != null) {
            for (i = 0; i < exports.length; ++i) {
                RfcPut.ab_rfcput_string(act_cntl, 517, exports[i].getName());
            }
        }
        if (changing != null) {
            for (i = 0; i < changing.length; ++i) {
                RfcPut.ab_rfcput_string(act_cntl, 517, changing[i].getName());
            }
        }
    }

    private static int send_as_basxml(RfcIoOpenCntl act_cntl, IRfcParameter[] ddescr_exp, IRfcParameter[] ddescr_chn, IRfcTable[] tdescr) throws RfcIoException {
        try {
            int i;
            boolean compressionEnabledForConnection = (act_cntl.protocol & 2) != 0;
            BasXMLWriter w = new BasXMLWriter(new BasXMLOutputStream(act_cntl, compressionEnabledForConnection));
            if (ddescr_exp != null) {
                for (i = 0; i < ddescr_exp.length; ++i) {
                    if (ddescr_exp[i] instanceof SerializationAware) {
                        ((SerializationAware)((Object)ddescr_exp[i])).accept(w);
                        continue;
                    }
                    if (!act_cntl.trace) continue;
                    Trc.ab_rfctrc("WARNING bASXML Writer: Ignoring import/export parameter " + ddescr_exp[i].getName() + " as it is not bASXML aware (" + ddescr_exp[i].getClass().getName() + ')' + JCoRuntime.CRLF);
                }
            }
            if (ddescr_chn != null) {
                for (i = 0; i < ddescr_chn.length; ++i) {
                    if (ddescr_chn[i] instanceof SerializationAware) {
                        ((SerializationAware)((Object)ddescr_chn[i])).accept(w);
                        continue;
                    }
                    if (!act_cntl.trace) continue;
                    Trc.ab_rfctrc("WARNING bASXML Writer: Ignoring changing parameter " + ddescr_chn[i].getName() + " as it is not bASXML aware (" + ddescr_chn[i].getClass().getName() + ')' + JCoRuntime.CRLF);
                }
            }
            if (tdescr != null) {
                for (i = 0; i < tdescr.length; ++i) {
                    if (tdescr[i] instanceof SerializationAware) {
                        ((SerializationAware)((Object)tdescr[i])).accept(w);
                        continue;
                    }
                    if (!act_cntl.trace) continue;
                    Trc.ab_rfctrc("WARNING bASXML Writer: Ignoring table parameter " + tdescr[i].getName() + " as it is not bASXML aware (" + tdescr[i].getClass().getName() + ')' + JCoRuntime.CRLF);
                }
            }
            w.close();
        }
        catch (RfcIoException rioe) {
            throw rioe;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return 0;
    }

    private static void ngRfcSerialize(RfcIoOpenCntl act_cntl, IRfcParameter[] importing_abap, IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables, boolean sendSuppliedInfo) throws RfcIoException {
        int i;
        NgRfcSerializer serializer = new NgRfcSerializer(act_cntl);
        if (sendSuppliedInfo) {
            NgRfcSerializerSupplyOutWrapper serializeSuppOutWrapper = new NgRfcSerializerSupplyOutWrapper(serializer, act_cntl.trace);
            if (exporting_abap != null) {
                for (i = 0; i < exporting_abap.length; ++i) {
                    if (exporting_abap[i] == null) continue;
                    if (exporting_abap[i] instanceof SerializationAware) {
                        ((SerializationAware)((Object)exporting_abap[i])).accept(serializeSuppOutWrapper);
                        continue;
                    }
                    Trc.ab_rfctrc("WARNING NgRfc Writer: Ignoring abap export parameter " + exporting_abap[i].getName() + " as it is not NgRfc aware (" + exporting_abap[i].getClass().getName() + ')' + JCoRuntime.CRLF);
                }
            }
            if (changing != null) {
                for (i = 0; i < changing.length; ++i) {
                    if (changing[i] == null) continue;
                    if (changing[i] instanceof SerializationAware) {
                        ((SerializationAware)((Object)changing[i])).accept(serializeSuppOutWrapper);
                        continue;
                    }
                    Trc.ab_rfctrc("WARNING NgRfc Writer: Ignoring changing parameter " + changing[i].getName() + " as it is not NgRfc aware (" + changing[i].getClass().getName() + ')' + JCoRuntime.CRLF);
                }
            }
        }
        if (importing_abap != null) {
            for (i = 0; i < importing_abap.length; ++i) {
                if (importing_abap[i] == null) continue;
                if (importing_abap[i] instanceof SerializationAware) {
                    ((SerializationAware)((Object)importing_abap[i])).accept(serializer);
                    continue;
                }
                Trc.ab_rfctrc("WARNING NgRfc Writer: Ignoring abap import parameter " + importing_abap[i].getName() + " as it is not NgRfc aware (" + importing_abap[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (changing != null) {
            serializer.setChangingParam(true);
            for (i = 0; i < changing.length; ++i) {
                if (changing[i] == null) continue;
                if (changing[i] instanceof SerializationAware) {
                    ((SerializationAware)((Object)changing[i])).accept(serializer);
                    continue;
                }
                Trc.ab_rfctrc("WARNING NgRfc Writer: Ignoring changing parameter " + changing[i].getName() + " as it is not NgRfc aware (" + changing[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
            serializer.setChangingParam(false);
        }
        if (tables != null) {
            for (i = 0; i < tables.length; ++i) {
                if (tables[i] == null) continue;
                if (tables[i] instanceof SerializationAware) {
                    ((SerializationAware)((Object)tables[i])).accept(serializer);
                    continue;
                }
                Trc.ab_rfctrc("WARNING NgRfc Writer: Ignoring table parameter " + tables[i].getName() + " as it is not NgRfc aware (" + tables[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        serializer.close();
    }

    private static int rfc_extdata(RfcIoOpenCntl act_cntl, IRfcParameter[] ddescr_exp, IRfcParameter[] ddescr_chn, IRfcTable[] tdescr) throws RfcIoException {
        byte[] tmp;
        int i;
        if (ddescr_exp != null) {
            for (i = 0; i < ddescr_exp.length; ++i) {
                if (ddescr_exp[i].getType() == 42) {
                    ((IRfcComplexParameter)ddescr_exp[i]).sendXmlDataStream(act_cntl);
                    continue;
                }
                RfcPut.ab_rfcput_string(act_cntl, 513, ddescr_exp[i].getName());
                tmp = ddescr_exp[i].getBytes();
                if (act_cntl.scrambleParameters) {
                    RfcPut.ab_rfcscrput(act_cntl, 516, tmp, tmp.length);
                    continue;
                }
                RfcPut.ab_rfcput(act_cntl, 515, tmp, tmp.length, 0);
            }
        }
        if (ddescr_chn != null) {
            for (i = 0; i < ddescr_chn.length; ++i) {
                if (ddescr_chn[i].getType() == 42) {
                    ((IRfcComplexParameter)ddescr_chn[i]).sendXmlDataStream(act_cntl);
                    continue;
                }
                RfcPut.ab_rfcput_string(act_cntl, 513, ddescr_chn[i].getName());
                tmp = ddescr_chn[i].getBytes();
                if (act_cntl.scrambleParameters) {
                    RfcPut.ab_rfcscrput(act_cntl, 516, tmp, tmp.length);
                    continue;
                }
                RfcPut.ab_rfcput(act_cntl, 515, tmp, tmp.length, 0);
            }
        }
        if (tdescr != null) {
            for (i = 0; i < tdescr.length; ++i) {
                RfcPut.ab_rfcput_string(act_cntl, 769, tdescr[i].getName());
                if (act_cntl.useDeltaManagement) {
                    int tableId = act_cntl.getNextTableId(tdescr[i]);
                    byte[] objIdBytes = RfcUtilities.intAsByteArray(tableId);
                    RfcPut.ab_rfcput(act_cntl, 816, objIdBytes, objIdBytes.length, 0);
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("Send delta ID " + tableId + " for table " + tdescr[i].getName() + JCoRuntime.CRLF);
                    }
                }
                RfcCall.rfc_table(act_cntl, tdescr[i]);
            }
        }
        return 0;
    }
}

