/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.FlatStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Parameter;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.engine.RfcGetData_Input;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.Arrays;

public abstract class RfcGetImp {
    static final int GETDATA_NORMAL = 0;
    static final int GETDATA_SCRAMBLED = 1;
    static final int GETDATA_COMPR = 2;

    static IRfcParameter searchParameter(RfcGetInfo getinfo) {
        String name;
        int i;
        if (getinfo.exporting_abap != null) {
            for (i = 0; i < getinfo.exporting_abap.length; ++i) {
                name = getinfo.exporting_abap[i].getName();
                if (!name.equals(getinfo.name)) continue;
                return getinfo.exporting_abap[i];
            }
        }
        if (getinfo.changing_abap != null) {
            for (i = 0; i < getinfo.changing_abap.length; ++i) {
                name = getinfo.changing_abap[i].getName();
                if (!name.equals(getinfo.name)) continue;
                return getinfo.changing_abap[i];
            }
        }
        return null;
    }

    static void activateParameter(RfcGetInfo getinfo) {
        String name;
        int i;
        if (getinfo.importing_abap != null) {
            for (i = 0; i < getinfo.importing_abap.length; ++i) {
                name = getinfo.importing_abap[i].getName();
                if (!name.equals(getinfo.name)) continue;
                getinfo.importing_abap[i].setActive();
                return;
            }
        }
        if (getinfo.changing_abap != null) {
            for (i = 0; i < getinfo.changing_abap.length; ++i) {
                name = getinfo.changing_abap[i].getName();
                if (!name.equals(getinfo.name)) continue;
                getinfo.changing_abap[i].setActive();
                return;
            }
        }
    }

    static void updateParameterConverters(RfcGetInfo getinfo, RfcIoOpenCntl act_cntl) {
        IRfcParameter param;
        int i;
        if (getinfo.exporting_abap == null && getinfo.changing_abap == null && getinfo.tables == null) {
            return;
        }
        Converter conv = new Converter(act_cntl);
        if (getinfo.exporting_abap != null) {
            for (i = 0; i < getinfo.exporting_abap.length; ++i) {
                param = getinfo.exporting_abap[i];
                if (param instanceof Parameter) {
                    ((Parameter)param).setConverter(conv);
                    continue;
                }
                if (!(param instanceof FlatStructure)) continue;
                ((FlatStructure)param).setConverter(conv);
            }
        }
        if (getinfo.changing_abap != null) {
            for (i = 0; i < getinfo.changing_abap.length; ++i) {
                param = getinfo.changing_abap[i];
                if (param instanceof Parameter) {
                    ((Parameter)param).setConverter(conv);
                    continue;
                }
                if (!(param instanceof FlatStructure)) continue;
                ((FlatStructure)param).setConverter(conv);
            }
        }
        if (getinfo.tables != null) {
            for (i = 0; i < getinfo.tables.length; ++i) {
                IRfcTable table = getinfo.tables[i];
                if (!(table instanceof TableParameter)) continue;
                ((TableParameter)table).setConverter(conv);
            }
        }
    }

    static void ab_rfcfvalue(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        byte[] buffer = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(buffer, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        IRfcParameter param = RfcGetImp.searchParameter(getinfo);
        if (param != null) {
            param.setBytes(buffer);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("Receiving parameter " + getinfo.name + JCoRuntime.CRLF);
            }
        } else if (act_cntl.trace) {
            Trc.ab_rfctrc("***Discarding unrequested parameter " + getinfo.name + JCoRuntime.CRLF);
        }
    }

    public static void ab_rfcvalue(RfcIoOpenCntl act_cntl, RfcValInfo info_p, int leng) throws RfcGetException {
        RfcGetData_Input input = new RfcGetData_Input();
        input.handle = act_cntl;
        input.senderLeng = 0;
        RfcGetImp.rfc_getdata(input, info_p, leng, 0);
    }

    static void rfc_getdata(RfcGetData_Input pInput, RfcValInfo valinfo, int leng, int mode) throws RfcGetException {
        switch (mode) {
            case 1: {
                valinfo.imp_leng = leng - 4;
                break;
            }
            case 2: {
                if (valinfo.val_addr == null) {
                    valinfo.imp_leng = leng;
                    break;
                }
                valinfo.imp_leng = pInput.senderLeng;
                break;
            }
            default: {
                valinfo.imp_leng = leng;
            }
        }
        if (mode != 1 || valinfo.val_addr == null) {
            RfcGetImp.rfc_readData(pInput, valinfo.val_addr, valinfo.val_leng, leng);
            int maxCopySize = Math.min(valinfo.imp_leng, valinfo.val_leng);
            if (mode == 2 && valinfo.val_addr != null && leng < maxCopySize) {
                byte lastbyte = valinfo.val_addr[leng - 1];
                Arrays.fill(valinfo.val_addr, leng, valinfo.val_addr.length, lastbyte);
            }
        }
        if (valinfo.imp_leng > valinfo.val_leng) {
            valinfo.imp_leng = valinfo.val_leng;
        }
    }

    private static void rfc_readData(RfcGetData_Input pInput, byte[] pTarget, int targetSize, int readLeng) throws RfcGetException {
        int rfcLeng = Math.min(targetSize, readLeng);
        try {
            pInput.handle.ab_rfcread(pTarget, rfcLeng, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
        if (targetSize < readLeng) {
            rfcLeng = readLeng - targetSize;
            try {
                pInput.handle.ab_rfcread(null, rfcLeng, 0);
            }
            catch (RfcIoException ioEx) {
                throw new RfcGetException(ioEx);
            }
        }
    }
}

