/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.engine.RfcGet;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.sysfunc.RfcCreateTID;
import com.sap.conn.rfc.sysfunc.RfcDocu;
import com.sap.conn.rfc.sysfunc.RfcJPing;
import com.sap.conn.rfc.sysfunc.RfcPing;
import com.sap.conn.rfc.sysfunc.RfcSetRegServerProperty;
import com.sap.conn.rfc.sysfunc.RfcSystemInfo;
import com.sap.i18n.cp.ConvertXToC;
import java.util.HashMap;
import java.util.Map;

public final class RfcGetName {
    private static SystemFunctions m_systemFunctions = new SystemFunctions(17);

    private RfcGetName() {
    }

    public static IRfcFunction[] getSystemFunctions() {
        return m_systemFunctions.values().toArray(new IRfcFunction[m_systemFunctions.size()]);
    }

    public static String ab_RfcDispatchLoc(RfcIoOpenCntl act_cntl) throws RfcException {
        String functionName = RfcGetName.ab_RfcGetName(act_cntl);
        if (act_cntl.partner_type != '3' && !JCoRuntime.isNonAbapPartnerAllowed() && act_cntl.partner_type != '2') {
            if (Environment.inSAPJ2EE()) {
                throw new RfcException(1, "Communication with non-ABAP RFC clients is not allowed. See SAP note 1729203 for details.", 104, act_cntl.hrfc, true);
            }
            throw new RfcException(1, "Communication with non-ABAP RFC clients is not allowed. See SAP note 1877907 for details.", 104, act_cntl.hrfc, true);
        }
        IRfcFunction function = m_systemFunctions.getFunction(functionName);
        if (function == null) {
            return functionName;
        }
        if (act_cntl.trace) {
            Trc.ab_rfctrc(">>>> [" + act_cntl.hrfc + "] Dispatching call to built-in system function: " + functionName + JCoRuntime.CRLF);
        }
        function.execute(act_cntl);
        return null;
    }

    private static char[] ab_rfcxfname(RfcIoOpenCntl act_cntl) throws RfcGetException {
        RfcGetInfo rfcget_info = new RfcGetInfo();
        RfcValInfo val_info = new RfcValInfo();
        byte[] fname = new byte[64];
        rfcget_info.fbInfo = val_info;
        val_info.RfcSetValInfoScalar(fname, fname.length);
        RfcGet.ab_rfcget(act_cntl, RfcGet.RfcGetState.FUNCTIONNAME, rfcget_info);
        try {
            ConvertXToC conv = I18NConverters.getConvertXToC(act_cntl.charset);
            return conv.ConvertArr(fname, 0, val_info.imp_leng);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "  Error> ab_rfcxfname[" + act_cntl.hrfc + "]: " + ex.getMessage(), ex);
        }
    }

    public static String ab_RfcGetName(RfcIoOpenCntl act_cntl) throws RfcException {
        int len;
        char[] functionName;
        try {
            functionName = RfcGetName.ab_rfcxfname(act_cntl);
        }
        catch (RfcGetException getEx) {
            String msg = "ab_RfcGetName failed: " + getEx.getMessage();
            switch (getEx.getRc()) {
                case 11: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]: connection closed" + JCoRuntime.CRLF);
                    }
                    throw new RfcException(6, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
                case 19: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]: invalid protocol version detected" + JCoRuntime.CRLF);
                    }
                    throw new RfcException(22, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
                case 14: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]: conversion error occurred" + JCoRuntime.CRLF);
                    }
                    throw new RfcException(21, msg, getEx.getErrorGroup(), 0L, false, getEx);
                }
            }
            if (act_cntl.trace) {
                Trc.ab_rfctrc("ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]: an error occurred. (rc: " + getEx.getRc() + ')' + JCoRuntime.CRLF);
            }
            throw new RfcException(1, msg, getEx.getErrorGroup(), 0L, false, getEx);
        }
        for (len = functionName.length - 1; len >= 0 && functionName[len] == ' '; --len) {
        }
        return new String(functionName, 0, len + 1);
    }

    static {
        try {
            m_systemFunctions.putFunction(new RfcCreateTID());
            m_systemFunctions.putFunction(new RfcDocu());
            m_systemFunctions.putFunction(new RfcJPing());
            m_systemFunctions.putFunction(new RfcPing());
            m_systemFunctions.putFunction(new RfcSetRegServerProperty());
            m_systemFunctions.putFunction(new RfcSystemInfo());
        }
        catch (Exception ex) {
            Trc.criticalTrace("Installation of system functions failed", ex);
        }
        catch (Error e) {
            Trc.criticalTrace("Installation of system functions failed", e);
        }
    }

    private static final class SystemFunctions
    extends HashMap<String, IRfcFunction> {
        private static final long serialVersionUID = 3001520160525L;

        private SystemFunctions(int initialCapacity) {
            super(initialCapacity);
            if (this.accessDenied()) {
                throw new SecurityException();
            }
        }

        private final boolean accessDenied() {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            if (stack == null || stack.length < 2) {
                return false;
            }
            String friend = RfcGetName.class.getName();
            if (stack.length > 3 && stack[3].getClassName().equals(friend)) {
                return false;
            }
            if (stack.length > 2 && stack[2].getClassName().equals(friend)) {
                return false;
            }
            return stack.length <= 4 || !stack[4].getClassName().equals(friend);
        }

        final IRfcFunction getFunction(String functionName) {
            return (IRfcFunction)super.get(functionName);
        }

        final IRfcFunction putFunction(IRfcFunction function) {
            if (this.accessDenied()) {
                return (IRfcFunction)super.get(function.getName());
            }
            return super.put(function.getName(), function);
        }

        @Override
        public final void clear() {
        }

        @Override
        public final IRfcFunction put(String key, IRfcFunction value) {
            return (IRfcFunction)super.get(key);
        }

        @Override
        public final void putAll(Map<? extends String, ? extends IRfcFunction> m) {
        }

        @Override
        public final IRfcFunction remove(Object key) {
            return (IRfcFunction)super.get(key);
        }
    }
}

