/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.BasXMLParser;
import com.sap.conn.jco.rt.DefaultRemoteContext;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.IRfcComplexParameter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.SerializationAware;
import com.sap.conn.rfc.data.ItStream;
import com.sap.conn.rfc.data.LZTable;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.PasswordState;
import com.sap.conn.rfc.engine.RfcGet;
import com.sap.conn.rfc.engine.RfcGetData_Input;
import com.sap.conn.rfc.engine.RfcGetImp;
import com.sap.conn.rfc.engine.RfcGetInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.RfcValInfo;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializer;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerSetActiveOnlyWrapper;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerSetWrapper;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import com.sap.i18n.cp.ConvertXToC;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;

public abstract class RfcImp {
    static void ab_rfccheck_uuid(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] uuid = new byte[16];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(uuid, uuid.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        if (!act_cntl.rfc_uuid_set) {
            act_cntl.rfc_uuid = uuid;
            act_cntl.rfc_uuid_set = true;
            if (act_cntl.trace) {
                Trc.ab_rfctrc(new StringBuilder(60).append("UUID: ab_rfccheck_uuid take uuid over ").append(GUID.toString(act_cntl.rfc_uuid)).append(JCoRuntime.CRLF).toString());
            }
        } else {
            if (act_cntl.trace) {
                Trc.ab_rfctrc(new StringBuilder(60).append("UUID: ab_rfccheck_uuid compare uuid's ").append(GUID.toString(uuid)).append(JCoRuntime.CRLF).toString());
            }
            if (!GUID.equals(uuid, act_cntl.rfc_uuid)) {
                StringBuilder buf = new StringBuilder(512);
                buf.append("Mismatch between rfc uuid's detected:").append(JCoRuntime.CRLF);
                buf.append("\town      uuid: ").append(GUID.toString(act_cntl.rfc_uuid)).append(JCoRuntime.CRLF);
                buf.append("\treceived uuid: ").append(GUID.toString(uuid)).append(JCoRuntime.CRLF);
                buf.append("Invalid Conversation Id ?").append(JCoRuntime.CRLF);
                buf.append("Connection Data:").append(JCoRuntime.CRLF);
                buf.append("\tip  :").append(AbSysInfo.ipAddress).append(JCoRuntime.CRLF);
                if (AbSysInfo.ipv6Address != null) {
                    buf.append("\tipv6: " + AbSysInfo.ipv6Address).append(JCoRuntime.CRLF);
                }
                buf.append("\trip : ").append(act_cntl.target).append(JCoRuntime.CRLF);
                buf.append("\tdest: ").append(act_cntl.destination).append(JCoRuntime.CRLF);
                buf.append("\trfc_role: ").append(act_cntl.rfc_role).append(JCoRuntime.CRLF);
                Trc.criticalTrace(act_cntl, buf.toString());
                throw new RfcGetException(2, new StringBuilder(75).append("Invalid uuid detected own: ").append(GUID.toString(act_cntl.rfc_uuid)).append(" given: ").append(GUID.toString(uuid)).toString());
            }
        }
    }

    static void ab_rfctcontLZ(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng, boolean last) throws RfcGetException {
        int rc = 0;
        if (last) {
            if (getinfo.tab_tabh == null || getinfo.tab_tabh_compr == null) {
                getinfo.tab_tabh_compr = null;
                if (act_cntl.trace) {
                    Trc.ab_rfctrc("ab_rfctcontLZ :: Error : getinfo.tab_tabh(_compr)=NULL (p=" + getinfo.name + ')' + JCoRuntime.CRLF);
                }
                return;
            }
            rc = ItStream.decompress(getinfo.tab_tabh, getinfo.tab_tabh_compr, getinfo.tab_leng);
            if (rc != 0) {
                throw new RfcGetException(14, "Error when decompressing LZ compressed table: " + rc);
            }
            getinfo.tab_tabh_compr = null;
        } else {
            if (getinfo.tab_tabh == null) {
                RfcValInfo valinfo = new RfcValInfo();
                valinfo.RfcSetValInfoScalar(null, 0);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                if (act_cntl.trace) {
                    Trc.ab_rfctrc("ab_rfctcontLZ :: Error : getinfo.tab_tabh(_compr)=NULL (p=" + getinfo.name + ')' + JCoRuntime.CRLF);
                }
                return;
            }
            if (getinfo.tab_tabh_compr == null) {
                getinfo.tab_tabh_compr = new LZTable("*LZ*");
            }
            RfcValInfo valinfo = new RfcValInfo();
            byte[] newLine = new byte[leng];
            valinfo.RfcSetValInfoScalar(newLine, leng);
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
            getinfo.tab_tabh_compr.appendRow(newLine);
        }
    }

    static int receiveDeltaId(RfcIoOpenCntl act_cntl, int leng) throws RfcGetException {
        byte[] deltaInt = new byte[4];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(deltaInt, deltaInt.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        int objId = RfcUtilities.byteArrayToInt(deltaInt);
        return objId;
    }

    static void receiveDeltaLog(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = getinfo.dmLogEntry.deltaLogBuffer;
        valinfo.RfcSetValInfoScalar(buffer, buffer.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        getinfo.dmLogEntry.readFromBuffer();
    }

    static boolean receiveXMLData(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        switch (getinfo.complexParameterState) {
            case 1: {
                int i;
                RfcValInfo valinfo = new RfcValInfo();
                byte[] buffer = new byte[leng];
                valinfo.RfcSetValInfoScalar(buffer, leng);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                String parameterName = new String(buffer, 1, Math.min(150, buffer.length - 1), Utf8ByteToCharConverter.UTF_8);
                int where = parameterName.indexOf(62);
                if (where > -1) {
                    parameterName = parameterName.substring(0, where);
                }
                parameterName = RfcImp.unescapeName(parameterName);
                boolean found = false;
                if (getinfo.exporting_abap != null) {
                    for (i = 0; i < getinfo.exporting_abap.length; ++i) {
                        if (getinfo.exporting_abap[i].getType() != 42 || !parameterName.equalsIgnoreCase(getinfo.exporting_abap[i].getName())) continue;
                        getinfo.complexParameter = (IRfcComplexParameter)getinfo.exporting_abap[i];
                        found = true;
                        break;
                    }
                }
                if (!found && getinfo.changing_abap != null) {
                    for (i = 0; i < getinfo.changing_abap.length; ++i) {
                        if (getinfo.changing_abap[i].getType() != 42 || !parameterName.equalsIgnoreCase(getinfo.changing_abap[i].getName())) continue;
                        getinfo.complexParameter = (IRfcComplexParameter)getinfo.changing_abap[i];
                        found = true;
                        break;
                    }
                }
                if (found) {
                    getinfo.complexParameterState = 2;
                    getinfo.complexParameter.receiveXmlDataStarted();
                    getinfo.complexParameter.setXmlBytes(buffer);
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("Receiving XML parameter: " + parameterName + '\n');
                    }
                } else {
                    getinfo.complexParameterState = 3;
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("***Discarding unrequested XML parameter: " + parameterName + '\n');
                    }
                }
                return true;
            }
            case 2: {
                RfcValInfo valinfo = new RfcValInfo();
                byte[] buffer = new byte[leng];
                valinfo.RfcSetValInfoScalar(buffer, leng);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                getinfo.complexParameter.setXmlBytes(buffer);
                return true;
            }
        }
        return false;
    }

    static void receiveXMLParameter(RfcGetInfo getinfo) throws RfcGetException {
        switch (getinfo.complexParameterState) {
            case 0: {
                getinfo.complexParameterState = 1;
                break;
            }
            case 2: {
                getinfo.complexParameter.receiveXmlDataFinished();
            }
            default: {
                getinfo.complexParameterState = 0;
                getinfo.complexParameter = null;
            }
        }
    }

    static void receiveBasXMLFinish(RfcGetInfo getInfo) throws RfcGetException {
        try {
            getInfo.basXmlParser.setFinished();
            getInfo.basXmlParser = null;
        }
        catch (XMLParserException xpe) {
            throw new RfcGetException(14, (Throwable)xpe);
        }
    }

    static RfcGet.RfcGetState receiveBasXMLInit(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo, int leng) throws RfcGetException {
        int i;
        RfcValInfo valinfo = new RfcValInfo();
        byte[] basXMLHeader = new byte[leng];
        valinfo.RfcSetValInfoScalar(basXMLHeader, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        if (basXMLHeader[0] != 2 && basXMLHeader[0] != 1) {
            throw new RfcGetException(2, "Unknown binary XML format: " + basXMLHeader[0]);
        }
        RfcGet.RfcGetState rfcstate = basXMLHeader[1] == 1 ? RfcGet.RfcGetState.BASXML_COMPRESSED_DATA : RfcGet.RfcGetState.BASXML_DATA;
        HashMap<String, SerializationAware> parameters = new HashMap<String, SerializationAware>();
        if (getInfo.exporting_abap != null) {
            for (i = 0; i < getInfo.exporting_abap.length; ++i) {
                if (getInfo.exporting_abap[i] instanceof SerializationAware) {
                    parameters.put(getInfo.exporting_abap[i].getName(), (SerializationAware)((Object)getInfo.exporting_abap[i]));
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING bASXML Parser: Ignoring import/export parameter " + getInfo.exporting_abap[i].getName() + " as it is not bASXML aware (" + getInfo.exporting_abap[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (getInfo.changing_abap != null) {
            for (i = 0; i < getInfo.changing_abap.length; ++i) {
                if (getInfo.changing_abap[i] instanceof SerializationAware) {
                    parameters.put(getInfo.changing_abap[i].getName(), (SerializationAware)((Object)getInfo.changing_abap[i]));
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING bASXML Parser: Ignoring changing parameter " + getInfo.changing_abap[i].getName() + " as it is not bASXML aware (" + getInfo.changing_abap[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (getInfo.tables != null) {
            for (i = 0; i < getInfo.tables.length; ++i) {
                if (getInfo.tables[i] instanceof SerializationAware) {
                    parameters.put(getInfo.tables[i].getName(), (SerializationAware)((Object)getInfo.tables[i]));
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING bASXML Parser: Ignoring table parameter " + getInfo.tables[i].getName() + " as it is not bASXML aware (" + getInfo.changing_abap[i].getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        getInfo.basXmlParser = new BasXMLParser(parameters, getInfo.tables, act_cntl.trace, basXMLHeader[1] == 1);
        if (act_cntl.accepted) {
            act_cntl.usebASXML = true;
        }
        return rfcstate;
    }

    static void receiveBasXMLData(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[leng];
        valinfo.RfcSetValInfoScalar(buffer, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        getInfo.basXmlParser.setBytes(buffer);
        try {
            getInfo.basXmlParser.parse();
        }
        catch (XMLParserException xpe) {
            throw new RfcGetException(14, "Error while parsing bASXML document", xpe);
        }
    }

    static void receiveBasXMLCompressedData(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[leng];
        valinfo.RfcSetValInfoScalar(buffer, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            getInfo.basXmlParser.setCompressedBytes(buffer);
        }
        catch (DataFormatException dfe) {
            throw new RfcGetException(2, "Error while decompressing compressed bASXML document", dfe);
        }
        catch (XMLParserException xpe) {
            throw new RfcGetException(14, "Error while parsing bASXML document", xpe);
        }
    }

    static void receiveNgRfcSerializedData(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo, int rfcid, int leng) {
        NgRfcDeserializer deserializer = new NgRfcDeserializer(act_cntl, getInfo.dmLogEntry);
        NgRfcDeserializerSetWrapper deserializerSetter = new NgRfcDeserializerSetWrapper(deserializer);
        if (getInfo.importing_abap != null) {
            NgRfcDeserializerSetActiveOnlyWrapper deserializerActiveOnlySetter = new NgRfcDeserializerSetActiveOnlyWrapper(deserializer);
            for (IRfcParameter iRfcParameter : getInfo.importing_abap) {
                if (iRfcParameter instanceof SerializationAware) {
                    ((SerializationAware)((Object)iRfcParameter)).accept(deserializerActiveOnlySetter);
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING NgRfc Deserializer: Ignoring import/export parameter " + iRfcParameter.getName() + " as it is not NgRfcAware (" + iRfcParameter.getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (getInfo.exporting_abap != null) {
            for (IRfcParameter iRfcParameter : getInfo.exporting_abap) {
                if (iRfcParameter instanceof SerializationAware) {
                    ((SerializationAware)((Object)iRfcParameter)).accept(deserializerSetter);
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING NgRfc Deserializer: Ignoring import/export parameter " + iRfcParameter.getName() + " as it is not NgRfcAware (" + iRfcParameter.getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (getInfo.changing_abap != null) {
            for (IRfcParameter iRfcParameter : getInfo.changing_abap) {
                if (iRfcParameter instanceof SerializationAware) {
                    ((SerializationAware)((Object)iRfcParameter)).accept(deserializerSetter);
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING NgRfc Deserializer: Ignoring changing parameter " + iRfcParameter.getName() + " as it is not NgRfcAware (" + iRfcParameter.getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        if (getInfo.tables != null) {
            for (IRfcTable irfcTable : getInfo.tables) {
                if (irfcTable instanceof SerializationAware) {
                    ((SerializationAware)((Object)irfcTable)).accept(deserializerSetter);
                    continue;
                }
                if (!act_cntl.trace) continue;
                Trc.ab_rfctrc("WARNING NgRfc Deserializer: Ignoring table parameter " + irfcTable.getName() + " as it is not NgRfcAware (" + irfcTable.getClass().getName() + ')' + JCoRuntime.CRLF);
            }
        }
        deserializer.ngRfcDeserializeParams(rfcid, leng);
    }

    static RfcGet.RfcGetState receiveClassExceptionInit(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] basXMLHeader = new byte[leng];
        valinfo.RfcSetValInfoScalar(basXMLHeader, leng);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        if (basXMLHeader[0] != 2 && basXMLHeader[0] != 1) {
            throw new RfcGetException(2, "Unknown binary XML format: " + basXMLHeader[0]);
        }
        RfcGet.RfcGetState rfcstate = basXMLHeader[1] == 1 ? RfcGet.RfcGetState.BASXML_COMPRESSED_DATA : RfcGet.RfcGetState.BASXML_DATA;
        getInfo.basXmlParser = new BasXMLParser(act_cntl.trace, basXMLHeader[1] == 1, getInfo.repositoryProvider);
        return rfcstate;
    }

    static void receiveClassExceptionEnd(RfcIoOpenCntl act_cntl, RfcGetInfo getInfo) throws RfcGetException {
        if (getInfo.remoteContext != null) {
            getInfo.remoteContext.setDestination(act_cntl.destination);
            getInfo.remoteContext.setServerInstance(act_cntl.target);
        }
        try {
            getInfo.basXmlParser.setFinished();
            RfcGetException getException = new RfcGetException(getInfo.basXmlParser.getAbapClassExceptionInfo());
            getException.setRemoteContext(getInfo.remoteContext);
            getInfo.basXmlParser = null;
            throw getException;
        }
        catch (XMLParserException xpe) {
            throw new RfcGetException(14, (Throwable)xpe);
        }
    }

    static void receiveCallStack(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int len) throws RfcGetException {
        if (getinfo.remoteContext == null) {
            getinfo.remoteContext = new DefaultRemoteContext();
        }
        getinfo.remoteContext.scanCallStack(RfcImp.valInfoForRemoteContext(act_cntl, len).convertToString(act_cntl.charset));
    }

    static void receiveClassExceptionInfo(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int len) throws RfcGetException {
        if (getinfo.remoteContext == null) {
            getinfo.remoteContext = new DefaultRemoteContext();
        }
        getinfo.remoteContext.scanClassExceptionInfo(RfcImp.valInfoForRemoteContext(act_cntl, len).convertToString(act_cntl.charset));
    }

    private static RfcValInfo valInfoForRemoteContext(RfcIoOpenCntl act_cntl, int len) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(new byte[len], len);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, len);
        return valinfo;
    }

    static boolean ab_rfctcompr(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        int fill = 0;
        if (getinfo.tab_tabh == null) {
            valinfo.RfcSetValInfoScalar(null, leng);
            --getinfo.tab_fill;
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        } else {
            byte[] newLine = new byte[getinfo.tab_leng];
            RfcGetData_Input input = new RfcGetData_Input();
            valinfo.RfcSetValInfoScalar(newLine, getinfo.tab_leng);
            input.handle = act_cntl;
            input.senderLeng = getinfo.tab_leng;
            RfcGetImp.rfc_getdata(input, valinfo, leng, 2);
            getinfo.tab_tabh.appendRow(newLine);
            fill = getinfo.tab_tabh.getNumRows();
        }
        return fill >= getinfo.tab_fill;
    }

    static boolean ab_rfctcontent(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        int fill = 0;
        if (getinfo.tab_tabh == null) {
            int count = leng / getinfo.tab_leng;
            valinfo.RfcSetValInfoScalar(null, leng);
            if (count < 1) {
                count = 1;
            }
            getinfo.tab_fill -= count;
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        } else {
            byte[] newLine = new byte[leng];
            valinfo.RfcSetValInfoScalar(newLine, leng);
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
            getinfo.tab_tabh.appendRow(newLine);
            fill = getinfo.tab_tabh.getNumRows();
        }
        return fill >= getinfo.tab_fill;
    }

    static boolean ab_rfctinfo(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        int tabfill;
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[8];
        valinfo.RfcSetValInfoScalar(buffer, buffer.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        int tableng = RfcUtilities.byteArrayToInt(buffer);
        getinfo.tab_fill = tabfill = RfcUtilities.byteArrayToInt(buffer, 4);
        getinfo.tab_leng = tableng;
        getinfo.tab_tabh = null;
        if (getinfo.tab_tabh_delta != null) {
            if (getinfo.tab_tabh_delta.getName() == getinfo.name) {
                getinfo.tab_tabh = getinfo.tab_tabh_delta;
                if (act_cntl.trace) {
                    Trc.ab_rfctrc("Receiving full delta table: " + getinfo.name + JCoRuntime.CRLF);
                }
            }
            getinfo.tab_tabh_delta = null;
        }
        if (getinfo.tables != null && getinfo.tab_tabh == null) {
            for (int i = 0; i < getinfo.tables.length; ++i) {
                if (!getinfo.tables[i].getName().equalsIgnoreCase(getinfo.name)) continue;
                getinfo.tab_tabh = getinfo.tables[i];
                if (!act_cntl.trace) break;
                Trc.ab_rfctrc("Receiving table: " + getinfo.name + JCoRuntime.CRLF);
                break;
            }
        }
        if (getinfo.tab_tabh != null) {
            getinfo.tab_tabh.setActive();
            getinfo.tab_tabh.clear();
            if (tabfill > 1) {
                getinfo.tab_tabh.ensureBufferCapacity(tabfill);
            }
        } else if (act_cntl.trace) {
            Trc.ab_rfctrc("***Discarding unrequested table: " + getinfo.name + JCoRuntime.CRLF);
        }
        return tabfill == 0;
    }

    static void ab_rfcname(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[leng];
        char[] tmp = null;
        valinfo.RfcSetValInfoScalar(buffer, buffer.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            ConvertXToC converter = I18NConverters.getConvertXToC(act_cntl.charset);
            tmp = converter.ConvertArr(buffer, 0, valinfo.imp_leng);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "ab_rfcname conversion failed: " + ex.getMessage(), ex);
        }
        getinfo.name = new String(tmp);
    }

    static void ab_rfchead(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] rfcHeader = new byte[8];
        RfcValInfo valinfo = new RfcValInfo();
        String msg = null;
        valinfo.RfcSetValInfoScalar(rfcHeader, rfcHeader.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        if (!act_cntl.read_conn_header_info) {
            return;
        }
        act_cntl.version = rfcHeader[0];
        act_cntl.intformat = rfcHeader[1];
        act_cntl.floatformat = rfcHeader[2];
        act_cntl.compression = rfcHeader[3];
        rfcHeader[4] = (byte)(rfcHeader[4] + 48);
        rfcHeader[5] = (byte)(rfcHeader[5] + 48);
        rfcHeader[6] = (byte)(rfcHeader[6] + 48);
        rfcHeader[7] = (byte)(rfcHeader[7] + 48);
        try {
            act_cntl.charset = new String(rfcHeader, 4, 4, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RfcGetException(14, "Failed to convert code page info of RFC header from binary format to String");
        }
        if (act_cntl.trace) {
            StringBuilder buf = new StringBuilder(60);
            buf.append("Received RFCHEADER [").append(act_cntl.hrfc).append("]: ");
            buf.append(Codecs.Hex.encode(act_cntl.version)).append('/');
            buf.append(AbSysInfo.intFormats[act_cntl.intformat]).append('/');
            buf.append(AbSysInfo.floatFormats[act_cntl.floatformat]).append('/');
            buf.append(AbSysInfo.compressionFormats[act_cntl.compression]).append('/');
            buf.append(act_cntl.charset).append(JCoRuntime.CRLF);
            Trc.ab_rfctrc(buf.toString());
        }
        if (act_cntl.version > 5) {
            msg = "Error: unsupported protocol version received [" + act_cntl.version + ']';
            if (act_cntl.trace) {
                Trc.ab_rfctrc(msg + JCoRuntime.CRLF + JCoRuntime.CRLF);
            }
            throw new RfcGetException(19, msg);
        }
        switch (act_cntl.compression) {
            case 5: {
                act_cntl.pcs = (byte)2;
                break;
            }
            case 6: {
                act_cntl.pcs = (byte)4;
                break;
            }
            case 1: {
                act_cntl.pcs = 1;
                break;
            }
            default: {
                msg = "Error: invalid compression value " + act_cntl.compression + " received";
                if (act_cntl.trace) {
                    Trc.ab_rfctrc(msg + "\n\n");
                }
                throw new RfcGetException(19, msg);
            }
        }
        if (act_cntl.rfc_role == 'C' && !act_cntl.charset.equals(act_cntl.getCommunicationCodepage())) {
            act_cntl.identified = false;
        }
        act_cntl.setCommunicationCodepage(act_cntl.charset);
        act_cntl.real_pcs = act_cntl.pcs;
    }

    static void ab_rfcUnicodeHeader(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] rfcUnicodeHeader = new byte[11];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(rfcUnicodeHeader, rfcUnicodeHeader.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        if (!act_cntl.read_conn_header_info) {
            return;
        }
        rfcUnicodeHeader[0] = (byte)(rfcUnicodeHeader[0] + 48);
        rfcUnicodeHeader[1] = (byte)(rfcUnicodeHeader[1] + 48);
        rfcUnicodeHeader[2] = (byte)(rfcUnicodeHeader[2] + 48);
        rfcUnicodeHeader[3] = (byte)(rfcUnicodeHeader[3] + 48);
        act_cntl.real_pcs = (byte)(0xF & rfcUnicodeHeader[6]);
        act_cntl.ignoreConvErr = rfcUnicodeHeader[4];
        if (act_cntl.real_pcs == 2 && act_cntl.pcs == 1) {
            act_cntl.unicodeHeader = rfcUnicodeHeader;
        }
        if (act_cntl.trace) {
            StringBuilder buf = new StringBuilder(80);
            buf.append("Received UNICODE-RFCHEADER [").append(act_cntl.hrfc).append("]: cp:");
            buf.append((char)rfcUnicodeHeader[0]).append((char)rfcUnicodeHeader[1]).append((char)rfcUnicodeHeader[2]).append((char)rfcUnicodeHeader[3]).append("/ce:");
            buf.append(AbSysInfo.conversionErrorBehavior[act_cntl.ignoreConvErr]).append("/et:");
            buf.append(rfcUnicodeHeader[5]).append("/cs:");
            buf.append(act_cntl.real_pcs).append("/rc:0x");
            buf.append(Codecs.Hex.encode(rfcUnicodeHeader[7])).append(Codecs.Hex.encode(rfcUnicodeHeader[8])).append(Codecs.Hex.encode(rfcUnicodeHeader[9])).append(Codecs.Hex.encode(rfcUnicodeHeader[10]));
            buf.append(JCoRuntime.CRLF);
            Trc.ab_rfctrc(buf.toString());
        }
    }

    static void rfcSetRemoteInfo(RfcIoOpenCntl act_cntl, int rfcid, int rfcleng) throws RfcGetException {
        byte[] tmp = new byte[rfcleng];
        RfcValInfo valinfo = new RfcValInfo();
        ConvertXToC converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, rfcleng);
        try {
            converter = I18NConverters.getConvertXToC(act_cntl.charset);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "Failed to instantiate converter: " + ex.getMessage(), ex);
        }
        switch (rfcid) {
            case 7: 
            case 24: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.inetAddress = InetAddress.getByName(new String(ptr).trim());
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'IpAddress'", ex);
                }
            }
            case 17: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.partner_type = ptr.length > 0 ? ptr[0] : (char)'\u0000';
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'OwnType'", ex);
                }
            }
            case 18: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.partner_rel = new String(ptr);
                    act_cntl.own_rel = "753";
                    if (act_cntl.version >= 4 || act_cntl.rfc_role != 'C') break;
                    if (act_cntl.partner_rel.length() >= 3 && act_cntl.partner_rel.charAt(0) == '7' && (act_cntl.partner_rel.charAt(1) > '0' || act_cntl.partner_rel.charAt(1) == '0' && act_cntl.partner_rel.charAt(2) >= '2') || act_cntl.partner_rel.charAt(0) > '7') {
                        act_cntl.version = (byte)4;
                        act_cntl.identified = false;
                        if ((act_cntl.protocol & 0x800) == 0 || act_cntl.serializationFormat == 0) break;
                        act_cntl.version = (byte)5;
                        break;
                    }
                    act_cntl.usebASXML = false;
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'OwnRel'", ex);
                }
            }
            case 19: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.kernel_rel = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'KernelRel'", ex);
                }
            }
            case 8: {
                try {
                    int lastNonWhitespace;
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    for (lastNonWhitespace = ptr.length - 1; lastNonWhitespace >= 0 && ptr[lastNonWhitespace] == ' '; --lastNonWhitespace) {
                    }
                    String partnerDestination = new String(ptr, 0, lastNonWhitespace + 1);
                    if (lastNonWhitespace > 1 && ptr[lastNonWhitespace - 2] == '_') {
                        StringTokenizer partnerSystemInfos = new StringTokenizer(partnerDestination, "_");
                        int tokenCount = partnerSystemInfos.countTokens();
                        if (tokenCount > 2) {
                            act_cntl.target = partnerSystemInfos.nextToken();
                            --tokenCount;
                            while (tokenCount > 2) {
                                act_cntl.target = act_cntl.target + '_' + partnerSystemInfos.nextToken();
                                --tokenCount;
                            }
                            act_cntl.sysid = partnerSystemInfos.nextToken();
                            act_cntl.systnr = partnerSystemInfos.nextToken();
                            if (act_cntl.partner_type != '\u0000') break;
                            act_cntl.partner_type = (char)51;
                            break;
                        }
                        act_cntl.target = partnerDestination;
                        break;
                    }
                    act_cntl.target = partnerDestination;
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'CDestination'", ex);
                }
            }
            case 6: {
                try {
                    int lastNonZeroByte;
                    for (lastNonZeroByte = valinfo.imp_leng - 1; lastNonZeroByte >= 0 && tmp[lastNonZeroByte] == 0; --lastNonZeroByte) {
                    }
                    if (lastNonZeroByte < 0) break;
                    ptr = converter.ConvertArr(tmp, 0, lastNonZeroByte + ("4103".equals(act_cntl.charset) ? 2 : 1));
                    act_cntl.destination = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'Destination'", ex);
                }
            }
            case 273: 
            case 336: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.userid = new String(ptr).trim();
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'UserID'", ex);
                }
            }
            case 9: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.cuserid = new String(ptr).trim();
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'CUserID'", ex);
                }
            }
            case 276: 
            case 337: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.mandt = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'Client'", ex);
                }
            }
            case 277: 
            case 338: {
                try {
                    ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
                    act_cntl.lang = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Failed to convert container 'Language'", ex);
                }
            }
            case 305: {
                if (tmp.length <= 0) break;
                act_cntl.th_client_id = tmp;
                break;
            }
        }
    }

    static void ab_rfcerror(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int type, int leng) throws RfcGetException {
        byte[] tmp = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        ConvertXToC converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            converter = I18NConverters.getConvertXToC(act_cntl.charset);
            ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "Failed to convert error info container: " + ex.getMessage(), ex);
        }
        String content = new String(ptr);
        switch (type) {
            case 1045: {
                getinfo.msgId = content;
                break;
            }
            case 1046: {
                getinfo.msgTy = ptr.length > 0 ? ptr[0] : (char)'\u0000';
                break;
            }
            case 1047: {
                getinfo.msgNo = content;
                break;
            }
            case 1041: {
                getinfo.msgv1 = content;
                break;
            }
            case 1042: {
                getinfo.msgv2 = content;
                break;
            }
            case 1043: {
                getinfo.msgv3 = content;
                break;
            }
            case 1044: {
                getinfo.msgv4 = content;
                break;
            }
            case 1025: {
                throw new RfcGetException(8, content, getinfo.msgId, getinfo.msgTy, getinfo.msgNo, getinfo.msgv1, getinfo.msgv2, getinfo.msgv3, getinfo.msgv4);
            }
            case 1026: {
                throw new RfcGetException(7, content, getinfo.msgId, getinfo.msgTy, getinfo.msgNo, getinfo.msgv1, getinfo.msgv2, getinfo.msgv3, getinfo.msgv4);
            }
            case 1027: 
            case 1028: {
                getinfo.errId = content;
                break;
            }
        }
    }

    static void ab_rfcFunctionName(RfcIoOpenCntl act_cntl, RfcGetInfo info_p, int leng) throws RfcGetException {
        RfcGetImp.ab_rfcvalue(act_cntl, info_p.fbInfo, leng);
    }

    static void receiveSso2String(RfcIoOpenCntl act_cntl, int leng) throws RfcGetException {
        byte[] tmp = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        String content = null;
        ConvertXToC converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            converter = I18NConverters.getConvertXToC(act_cntl.charset);
            ptr = converter.ConvertArr(tmp, 0, valinfo.imp_leng);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "Failed to convert container 'Sso2'", ex);
        }
        act_cntl.mysapsso2 = content = new String(ptr);
    }

    private static String unescapeName(String parameterName) throws RfcGetException {
        if (parameterName.indexOf("_-") >= 0) {
            int end = parameterName.length();
            StringBuilder escapedNameBuffer = new StringBuilder(end);
            int i = 0;
            while (i < end) {
                if (parameterName.charAt(i) == '_') {
                    if (parameterName.charAt(++i) == '-') {
                        if (parameterName.charAt(++i) == '-') {
                            try {
                                escapedNameBuffer.append((char)Codecs.Hex.decode(parameterName.charAt(i + 1), parameterName.charAt(i + 2)));
                                i += 3;
                                continue;
                            }
                            catch (Exception e) {
                                throw new RfcGetException(14, "Illegal escape sequence _--" + parameterName.charAt(i + 1) + parameterName.charAt(i + 2) + " in parameterName encountered");
                            }
                        }
                        escapedNameBuffer.append('/');
                        continue;
                    }
                    escapedNameBuffer.append('_');
                    continue;
                }
                escapedNameBuffer.append(parameterName.charAt(i));
                ++i;
            }
            return escapedNameBuffer.toString();
        }
        return parameterName;
    }

    static void receivePasswordState(RfcIoOpenCntl act_cntl, int length) throws RfcGetException {
        if (length != 4) {
            throw new RfcGetException(2, "Password state container should have a length of 4 , not " + length);
        }
        byte[] pwStateBuffer = new byte[4];
        try {
            act_cntl.ab_rfcread(pwStateBuffer, 4, 0);
        }
        catch (RfcIoException rie) {
            throw new RfcGetException(rie);
        }
        if (1 == act_cntl.intformat) {
            byte save = pwStateBuffer[0];
            pwStateBuffer[0] = pwStateBuffer[3];
            pwStateBuffer[3] = save;
            save = pwStateBuffer[1];
            pwStateBuffer[1] = pwStateBuffer[2];
            pwStateBuffer[2] = save;
        }
        int value = RfcUtilities.byteArrayToInt(pwStateBuffer);
        switch (value) {
            case -2: {
                act_cntl.pwdState = PasswordState.CHANGE_NOT_ALLOWED;
                break;
            }
            case -1: {
                act_cntl.pwdState = PasswordState.CHANGE_NOT_TODAY;
                break;
            }
            case 0: {
                act_cntl.pwdState = PasswordState.CHANGE_NOT_REQUIRED;
                break;
            }
            case 1: {
                act_cntl.pwdState = PasswordState.INITIAL;
                break;
            }
            case 2: {
                act_cntl.pwdState = PasswordState.EXPIRED;
                break;
            }
            case 3: {
                act_cntl.pwdState = PasswordState.RULES_ENFORCED;
                break;
            }
        }
    }
}

