/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.BasXMLOutputStream;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.api.RfcConnectionState;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.data.ARFCTIDStructure;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.PasswordState;
import com.sap.conn.rfc.engine.RfcCall;
import com.sap.conn.rfc.engine.RfcClientConnectionState;
import com.sap.conn.rfc.engine.RfcGetName;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.engine.RfcRcv;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.TRfc;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcInvalidConfigurationException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKey;

public final class RfcIoOpenCntl {
    public String name;
    public int type;
    public String destination;
    RfcDriver channel;
    private String codepage;
    private String communication_cp;
    public String charset;
    public char rfc_role;
    public char own_type;
    public String own_rel;
    public char partner_type = '\u0000';
    public String partner_rel;
    public String kernel_rel;
    private byte[] conv_id;
    private String convIdAsString = null;
    public byte version;
    public byte intformat;
    public byte floatformat;
    public byte compression;
    public String sysid;
    public int protocol;
    public byte[] m_buffer;
    public int m_buffer_ptr;
    public int[] m_bytes_read = new int[1];
    public int m_bytes_in_buffer;
    public int m_bytes_free;
    public String target;
    public String mandt;
    public String lang;
    public String userid;
    public String cuserid;
    public String systnr;
    public boolean trace;
    public boolean traceSetByPartner = false;
    public boolean signon;
    public boolean snc;
    public byte allocationType;
    boolean used;
    public boolean opened;
    public boolean accepted;
    public boolean input;
    public boolean output;
    public boolean closed;
    public boolean close_pending;
    public boolean identified;
    public boolean reg_exclusiv;
    public int unresp_call;
    public long hrfc;
    public RfcIoOpenCntl htRFC;
    public int wcount;
    public byte pcs;
    public byte real_pcs;
    public byte ignoreConvErr;
    public byte[] unicodeHeader;
    public String mysapsso2;
    public byte[] th_client_id;
    public byte[] rfc_uuid;
    public boolean rfc_uuid_set;
    public boolean receivedIsSupplied = false;
    public boolean send_conn_header_info = true;
    public boolean read_conn_header_info = true;
    Object connRef;
    int access_counter = 0;
    Object access_counter_mutex = new Object();
    public String functionName;
    public String[] functionNames;
    public boolean inCallback = false;
    public boolean usebASXML = false;
    public int serializationFormat = 0;
    public AbapClassException.Mode abapClassExceptionMode;
    public boolean useDeltaManagement = false;
    boolean resetStillNeeded = true;
    boolean stateless = true;
    boolean withGUI = false;
    boolean scrambleParameters = false;
    public InetAddress inetAddress;
    PasswordState pwdState = null;
    int dmStartCounter = 1;
    int dmCounter = 0;
    private List<IRfcTable> dmTables;
    boolean canceled = false;
    String cancelStackTrace = null;
    long channelBytes;
    public static final int RFC_TYPE_DIRECT_CPIC = 0;
    public static final int RFC_TYPE_EXTERNAL_R3 = 1;
    public static final int RFC_TYPE_NEO_ABAP = 2;
    public static final int RFC_TYPE_PLAYBACK = 3;
    public static final int RFC_TYPE_REGISTER_CPIC = 4;
    public static final int RFC_TYPE_RECORDER = 5;
    public static final int PROTO_SET = 0;
    public static final int PROTO_GET = 1;
    public static final int PROTO_ASSUME = 3;
    public static final int RFCPROT_TERM_IO = 16;
    public static final int RFCPROT_ASYNC_TERM_IO = 32;
    public static final int RFCPROT_EXTERNAL_GUI = 64;
    public static final int RFCPROT_DIALOG = 16;
    public static final int RFCPROT_ASYNC_DIALOG = 48;
    public static final int RFCPROT_VERSION_3 = 256;
    public static final int RFCPROT_SERVER_MODE = 512;
    public static final int RFCPROT_VERSION_4 = 1024;
    public static final int RFCPROT_VERSION_5 = 2048;
    public static final int RFCPROT_SIMPLE = 0;
    public static final int RFCPROT_SPACE_COMPRESSION = 1;
    public static final int RFCPROT_LZ_COMPRESSION = 2;
    public static final int RFCPROT_ENCRYPTION = 4;
    public static final int RFCPROT_DEBUGGING = 8;
    public static final int RFCPROT_MAX = 3595;
    public static final byte RFCHEADER_VERSION_1 = 1;
    public static final byte RFCHEADER_VERSION_3 = 3;
    public static final byte RFCHEADER_VERSION_4 = 4;
    public static final byte RFCHEADER_VERSION_5 = 5;
    public static final byte RFCHEADER_MAXVERSION = 5;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT = 1;
    public static final byte RFCHEADER_COMPR_NOCRYPT = 2;
    public static final byte RFCHEADER_NOCOMPR_CRYPT = 3;
    public static final byte RFCHEADER_COMPR_CRYPT = 4;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT_UNICODE_2 = 5;
    public static final byte RFCHEADER_NOCOMPR_NOCRYPT_UNICODE_4 = 6;
    private static boolean m_gRfcTrace = false;
    private static final int SAP_CONV_ID_LN = 8;
    private static final byte[] cp4102 = new byte[]{4, 1, 0, 2};
    private static final byte[] session = new byte[]{1};
    private static int m_clientConnectTimeout = 60;

    RfcIoOpenCntl() {
        this.own_type = (char)69;
        this.conv_id = new byte[8];
        this.abapClassExceptionMode = AbapClassException.Mode.OFF;
    }

    public final String getCodepage() {
        return this.codepage;
    }

    public final String getCommunicationCodepage() {
        return this.communication_cp;
    }

    public final void setCodepage(String cp) {
        this.codepage = cp;
    }

    public final void setCommunicationCodepage(String commCp) {
        this.communication_cp = commCp;
    }

    public final PasswordState getPasswordState() {
        return this.pwdState;
    }

    public void skipData(int rfcid, int rfcleng) throws RfcGetException {
        if (rfcid == 0) {
            throw new RfcGetException(2, "Tried to skip invalid container");
        }
        try {
            this.ab_rfcread(null, rfcleng, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
        this.readEndCheck(rfcid);
    }

    public int readRFCID() throws RfcGetException {
        byte[] idBuffer = new byte[2];
        try {
            this.ab_rfcread(idBuffer, idBuffer.length, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
        return RfcUtilities.byteArrayToUnsignedShort(idBuffer);
    }

    public int readRFCLength() throws RfcGetException {
        byte[] lenBuffer = new byte[2];
        try {
            this.ab_rfcread(lenBuffer, lenBuffer.length, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
        int rfcleng = RfcUtilities.byteArrayToUnsignedShort(lenBuffer);
        if (rfcleng == 65535) {
            lenBuffer = new byte[4];
            try {
                this.ab_rfcread(lenBuffer, lenBuffer.length, 0);
            }
            catch (RfcIoException ioEx) {
                throw new RfcGetException(ioEx);
            }
            rfcleng = RfcUtilities.byteArrayToInt(lenBuffer);
        }
        return rfcleng;
    }

    public void readEndCheck(int rfcid) throws RfcGetException {
        byte[] end_buffer = new byte[2];
        int end_rfcid = 0;
        try {
            this.ab_rfcread(end_buffer, end_buffer.length, 0);
        }
        catch (RfcIoException ioEx) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("EndCheck cannot read end container for: ");
            msg.append(rfcid);
            msg.append(" rc: ");
            msg.append(ioEx.getIoRcAsString());
            throw new RfcGetException(msg.toString(), ioEx);
        }
        end_rfcid = RfcUtilities.byteArrayToUnsignedShort(end_buffer);
        if (end_rfcid != rfcid) {
            StringBuilder msg = new StringBuilder(100);
            msg.append("EndCheck container chain broken for container expected: ");
            msg.append(rfcid);
            msg.append(" received: ");
            msg.append(end_rfcid);
            throw new RfcGetException(4, msg.toString());
        }
    }

    public void save_protocol() throws RfcGetException {
        byte[] buffer = new byte[4];
        try {
            this.ab_rfcread(buffer, buffer.length, 0);
            int max_version = RfcUtilities.byteArrayToInt(buffer);
            this.protocol = this.ab_rfcproto(1, max_version);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(ioEx);
        }
    }

    public int ab_rfcread(byte[] e_buffer, int length, int e_buffer_ptr) throws RfcIoException {
        if (this.output) {
            this.ab_rfcflush();
            this.output = false;
        }
        if (this.closed) {
            String msg = this.channel.getMessage();
            if (this.trace) {
                StringBuilder text = new StringBuilder(64);
                text.append("Error> ab_rfcread[");
                text.append(this.hrfc);
                text.append("] failed, connection already closed: ");
                text.append(msg).append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(10, msg);
        }
        this.input = true;
        while (length > this.m_bytes_in_buffer) {
            String ptr;
            int ret = 0;
            if (e_buffer != null) {
                System.arraycopy(this.m_buffer, this.m_buffer_ptr, e_buffer, e_buffer_ptr, this.m_bytes_in_buffer);
            }
            e_buffer_ptr += this.m_bytes_in_buffer;
            length -= this.m_bytes_in_buffer;
            ret = this.channel.read(this.m_buffer, this.m_buffer.length, this.m_bytes_read);
            this.m_buffer_ptr = 0;
            this.m_bytes_in_buffer = this.m_bytes_read[0];
            this.m_bytes_free = 0;
            this.channelBytes += (long)this.m_bytes_in_buffer;
            if (this.trace) {
                Trc.rfctrace(this, "READ", this.m_buffer, this.m_bytes_in_buffer);
            }
            if (ret != 0 && this.m_bytes_in_buffer == 0 && (ptr = this.channel.getMessage()) != null) {
                Trc.rfctrace(this, "FREE-Message", ptr.getBytes(Utf8ByteToCharConverter.UTF_8), ptr.length());
            }
            if (ret != 0) {
                if (ret == 10 || ret == 23 || ret == 27) {
                    if (this.accepted) {
                        this.ab_rfcabort2();
                    } else {
                        this.ab_rfcclose();
                    }
                }
                throw new RfcIoException(ret, this.channel.getMessage(), false);
            }
            if (this.m_bytes_in_buffer != 0) continue;
            String msg = this.channel.getMessage();
            if (msg != null) {
                if (this.trace) {
                    StringBuilder text = new StringBuilder(128);
                    text.append("Error> ab_rfcread [");
                    text.append(this.hrfc);
                    text.append("] channel.read(");
                    text.append(ret);
                    text.append(") failed with message: ");
                    text.append(msg);
                    text.append(JCoRuntime.CRLF);
                    Trc.ab_rfctrc(text.toString());
                }
                throw new RfcIoException(5, msg);
            }
            if (this.trace) {
                StringBuilder text = new StringBuilder(64);
                text.append("Error> ab_rfcread [");
                text.append(this.hrfc);
                text.append("] channel.read(");
                text.append(ret);
                text.append(") failed without message");
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(8, "no data received");
        }
        if (length > 0) {
            if (e_buffer != null) {
                System.arraycopy(this.m_buffer, this.m_buffer_ptr, e_buffer, e_buffer_ptr, length);
            }
            this.m_buffer_ptr += length;
            this.m_bytes_in_buffer -= length;
        }
        return 0;
    }

    public int ab_rfcwrite(byte[] e_buffer, int length, int e_buffer_ptr) throws RfcIoException {
        if (this.input) {
            this.ab_rfcflush();
            this.input = false;
        }
        if (this.closed) {
            if (this.trace) {
                StringBuilder text = new StringBuilder(64);
                text.append("Error> ab_rfcwrite [");
                text.append(this.hrfc);
                text.append("] failed: connection already closed");
                text.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(10, "connection already closed");
        }
        this.output = true;
        if (!this.identified) {
            this.identified = true;
            this.ab_rfcid();
        }
        int ret = 0;
        while (length > this.m_bytes_free) {
            System.arraycopy(e_buffer, e_buffer_ptr, this.m_buffer, this.m_buffer_ptr, this.m_bytes_free);
            e_buffer_ptr += this.m_bytes_free;
            length -= this.m_bytes_free;
            if (this.trace) {
                Trc.rfctrace(this, "WRITE", this.m_buffer, this.m_buffer.length);
            }
            this.channelBytes += (long)this.m_buffer.length;
            ret = this.channel.write(this.m_buffer, this.m_buffer.length, false);
            if (ret != 0) {
                String msg = this.channel.getMessage();
                if (this.trace) {
                    StringBuilder text = new StringBuilder(64);
                    text.append("Error> ab_rfcwrite [");
                    text.append(this.hrfc);
                    text.append("] channel.write(");
                    text.append(ret);
                    text.append(")  failed with message: ");
                    text.append(msg);
                    text.append(JCoRuntime.CRLF);
                }
                throw new RfcIoException(ret, msg);
            }
            this.m_buffer_ptr = 0;
            this.m_bytes_free = this.m_buffer.length;
            this.m_bytes_in_buffer = 0;
        }
        if (length > 0) {
            System.arraycopy(e_buffer, e_buffer_ptr, this.m_buffer, this.m_buffer_ptr, length);
            this.m_buffer_ptr += length;
            this.m_bytes_free -= length;
        }
        return 0;
    }

    public void ab_rfcflush() throws RfcIoException {
        int ret = 0;
        if (this.output && this.m_buffer_ptr != 0) {
            if (this.trace) {
                Trc.rfctrace(this, "WRITE", this.m_buffer, this.m_buffer_ptr);
            }
            this.channelBytes += (long)this.m_buffer_ptr;
            ret = this.channel.write(this.m_buffer, this.m_buffer_ptr, true);
            if (ret != 0) {
                String msg = this.channel.getMessage();
                if (this.trace) {
                    StringBuilder text = new StringBuilder(128);
                    text.append(" Error> ab_rfcflush [");
                    text.append(this.hrfc);
                    text.append("] channel.write(");
                    text.append(ret);
                    text.append(") failed with message: ");
                    text.append(msg);
                    text.append(JCoRuntime.CRLF);
                    Trc.ab_rfctrc(text.toString());
                }
                switch (ret) {
                    case 34: {
                        throw new RfcIoException(ret, msg);
                    }
                }
                throw new RfcIoException(5, msg);
            }
        }
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        int n = this.m_bytes_free = this.m_buffer == null ? this.channel.getPacketSize() : this.m_buffer.length;
        if (this.output) {
            if (this.trace) {
                Trc.rfctrace(this, "FLUSH(WRITE)", null, 0);
            }
            ret = this.channel.wflush();
            if (this.channelBytes > 0L) {
                if (Trace.isOn(64)) {
                    Trace.fireTrace(64, "[JCoRFC] [traffic] Sent " + this.channelBytes + " bytes for " + this.functionName);
                }
                this.channelBytes = 0L;
            }
        } else {
            if (this.trace) {
                Trc.rfctrace(this, "FLUSH (READ)", null, 0);
            }
            ret = this.channel.rflush();
        }
        if (ret != 0) {
            String msg = this.channel.getMessage();
            if (this.trace) {
                StringBuilder text = new StringBuilder(64);
                text.append(" Error> ab_rfcflush [");
                text.append(this.hrfc);
                if (this.output) {
                    text.append("] channel.rflush(");
                } else {
                    text.append("] channel.wflush(");
                }
                text.append(ret);
                text.append(") failed with message: ");
                text.append(msg);
                text.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            if (this.accepted) {
                this.ab_rfcabort2();
            } else {
                this.ab_rfcclose();
            }
            throw new RfcIoException(5, msg);
        }
    }

    public int ab_rfcproto(int mode, int proto) throws RfcIoException {
        if (this.channel == null) {
            throw new RfcIoException(18, "driver not initialized");
        }
        proto = this.channel.proto(mode, proto);
        return proto;
    }

    private void send_rfcuuid() throws RfcIoException {
        if (this.rfc_uuid_set) {
            if (this.trace) {
                Trc.ab_rfctrc(new StringBuilder(128).append("UUID: send_rfcuuid ").append(GUID.toString(this.rfc_uuid)).append(JCoRuntime.CRLF).toString());
            }
            RfcPut.ab_rfcput(this, 1300, this.rfc_uuid, this.rfc_uuid.length, 0);
        }
    }

    public int ab_rfcid() throws RfcIoException {
        int max_version = this.ab_rfcproto(0, 3595);
        if (this.send_conn_header_info) {
            byte[] header = new byte[8];
            byte[] bufferCodepage = null;
            byte[] bufferCodepageUnicodeHeader = null;
            switch (this.version) {
                case 0: {
                    if ((max_version & 0x100) != 0) {
                        header[0] = 3;
                        break;
                    }
                    header[0] = 1;
                    break;
                }
                default: {
                    header[0] = this.version;
                }
            }
            if (this.pcs == 1) {
                header[3] = 1;
                try {
                    bufferCodepage = this.communication_cp.getBytes("US-ASCII");
                    bufferCodepage[0] = (byte)(bufferCodepage[0] - 48);
                    bufferCodepage[1] = (byte)(bufferCodepage[1] - 48);
                    bufferCodepage[2] = (byte)(bufferCodepage[2] - 48);
                    bufferCodepage[3] = (byte)(bufferCodepage[3] - 48);
                }
                catch (UnsupportedEncodingException ex) {
                    if (this.trace) {
                        StringBuilder text = new StringBuilder(90);
                        text.append("Error> ab_rfcid [");
                        text.append(this.hrfc);
                        text.append("] could not convert communication code page from binary to string");
                        text.append(JCoRuntime.CRLF);
                        Trc.ab_rfctrc(text.toString());
                    }
                    throw new RfcIoException(25, "could not convert communication code page from binary to string");
                }
            } else {
                header[3] = 5;
                bufferCodepage = cp4102;
            }
            header[4] = bufferCodepage[0];
            header[5] = bufferCodepage[1];
            header[6] = bufferCodepage[2];
            header[7] = bufferCodepage[3];
            header[1] = AbSysInfo.intformat;
            header[2] = 1;
            if (this.trace) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Send RFCHEADER [").append(this.hrfc).append("]: ");
                buf.append(Codecs.Hex.encode(header[0])).append('/');
                buf.append(AbSysInfo.intFormats[header[1]]).append('/');
                buf.append(AbSysInfo.floatFormats[header[2]]).append('/');
                buf.append(AbSysInfo.compressionFormats[header[3]]).append('/');
                buf.append(bufferCodepage[0]).append(bufferCodepage[1]).append(bufferCodepage[2]).append(bufferCodepage[3]);
                buf.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(buf.toString());
            }
            RfcPut.ab_rfcput(this, 257, header, header.length, 0);
            byte[] buffer = null;
            buffer = RfcUtilities.intAsByteArray(max_version);
            RfcPut.ab_rfcput(this, 259, buffer, buffer.length, 0);
            byte[] uHeader = new byte[11];
            bufferCodepageUnicodeHeader = cp4102;
            uHeader[6] = 2;
            uHeader[0] = bufferCodepageUnicodeHeader[0];
            uHeader[1] = bufferCodepageUnicodeHeader[1];
            uHeader[2] = bufferCodepageUnicodeHeader[2];
            uHeader[3] = bufferCodepageUnicodeHeader[3];
            uHeader[4] = this.ignoreConvErr;
            uHeader[5] = (byte)(Environment.inJStartup() ? 6 : 8);
            byte[] mySub = RfcUtilities.intAsByteArray(35);
            uHeader[7] = mySub[0];
            uHeader[8] = mySub[1];
            uHeader[9] = mySub[2];
            uHeader[10] = mySub[3];
            if (this.trace) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Send UNICODE-RFCHEADER [").append(this.hrfc).append("]: cp:");
                buf.append(uHeader[0]).append(uHeader[1]).append(uHeader[2]).append(uHeader[3]).append("/ce:");
                buf.append(AbSysInfo.conversionErrorBehavior[this.ignoreConvErr]).append("/et:");
                buf.append(uHeader[5]).append("/cs:");
                buf.append(uHeader[6]).append("/rc:0x");
                buf.append(Codecs.Hex.encode(uHeader[7])).append(Codecs.Hex.encode(uHeader[8])).append(Codecs.Hex.encode(uHeader[9])).append(Codecs.Hex.encode(uHeader[10]));
                buf.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(buf.toString());
            }
            RfcPut.ab_rfcput(this, 262, uHeader, uHeader.length, 0);
        }
        RfcPut.ab_rfcput_string(this, 7, AbSysInfo.ipAddress);
        if (AbSysInfo.ipv6Address != null) {
            RfcPut.ab_rfcput_string(this, 24, AbSysInfo.ipv6Address);
        }
        RfcPut.ab_rfcput(this, 17, new char[]{this.own_type}, 1, 0);
        RfcPut.ab_rfcput_string(this, 18, "753");
        RfcPut.ab_rfcput_string(this, 19, AbSysInfo.kernelRelease);
        RfcPut.ab_rfcput_string(this, 8, AbSysInfo.callerID);
        RfcPut.ab_rfcput_string(this, 304, AbSysInfo.programName);
        RfcPut.ab_rfcput_string(this, 6, this.destination);
        this.send_rfcuuid();
        return 0;
    }

    public void ab_rfccount(int count) {
        switch (count) {
            case 0: {
                this.unresp_call = 0;
                break;
            }
            case 1: {
                ++this.unresp_call;
                break;
            }
            default: {
                if (this.unresp_call <= 0) break;
                --this.unresp_call;
            }
        }
    }

    public void rfcio_setopt(RfcOptions options) throws RfcInvalidConfigurationException {
        this.userid = options.getUser();
        this.mandt = options.getClient();
        this.lang = options.getLanguage();
        this.trace = options.isTrace() || m_gRfcTrace;
        this.mysapsso2 = options.getMysapsso2();
        this.pcs = (byte)options.getPcs();
        this.snc = options.getSncMode() > 0;
        this.withGUI = options.getUseSAPGui() != 0;
        this.stateless = !this.withGUI;
        this.serializationFormat = options.getSerializationFormat();
        if (this.pcs == 1) {
            if (options.getCommunication_cp() != null) {
                this.setCommunicationCodepage(options.getCommunication_cp());
            } else {
                this.setCommunicationCodepage("1100");
            }
        }
        RfcApi.runtime.initializeHandle(this);
    }

    public void setAcceptInfo(RfcAcceptInfo acceptInfo) {
        this.destination = acceptInfo.getDestination();
        this.trace = acceptInfo.isTraceOn() || m_gRfcTrace;
        this.allocationType = acceptInfo.getAllocationType();
        this.useDeltaManagement = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ab_rfcclose() {
        if (!this.closed) {
            JCoRuntime rt = JCoRuntimeFactory.getRuntime();
            boolean isTaskMonitorOn = rt.isTaskMonitorOn();
            if (isTaskMonitorOn) {
                StringBuilder monitorText = new StringBuilder(64).append("JCo closing connection [").append(this.sysid == null ? "<empty>" : this.sysid).append('|').append(this.target).append('|').append(this.getCPICConversationID()).append(']');
                rt.startTask(monitorText.toString());
            }
            Trc.rfctrace(this, "CLOSE", null, 0);
            try {
                this.channel.close();
                this.closed = true;
            }
            finally {
                if (isTaskMonitorOn) {
                    rt.endTask();
                }
            }
        }
        this.m_buffer = null;
    }

    public void ab_rfcabort2() {
        if (this.output) {
            try {
                this.ab_rfcflush();
            }
            catch (RfcIoException rfcIoException) {
                // empty catch block
            }
            this.output = false;
        }
        if (this.trace) {
            Trc.rfctrace(this, "ABORT", null, 0);
        }
        this.channel.abort();
        this.ab_rfcclose();
    }

    public int open_channel() {
        this.channel = RfcApi.runtime.createChannel(this);
        if (this.channel == null) {
            return 1;
        }
        this.m_buffer = new byte[this.channel.getPacketSize()];
        this.m_buffer_ptr = 0;
        this.m_bytes_read[0] = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_free = this.m_buffer.length;
        return 0;
    }

    public RfcDriver getChannel() {
        return this.channel;
    }

    public int ab_rfclisten(int timeout) throws RfcIoException {
        int ret = 0;
        if (this.output) {
            this.ab_rfcflush();
            this.output = false;
        }
        if (this.closed) {
            if (this.trace) {
                StringBuilder text = new StringBuilder(64);
                text.append("Error> ab_rfclisten [");
                text.append(this.hrfc);
                text.append("] failed: connection already closed.");
                text.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            return 10;
        }
        this.input = true;
        if (this.channel == null) {
            throw new RfcIoException(18, "driver not initialized");
        }
        ++this.wcount;
        ret = this.channel.listen(this.m_buffer, this.m_buffer.length, this.m_bytes_read, timeout);
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = this.m_bytes_read[0];
        this.channelBytes += (long)this.m_bytes_in_buffer;
        this.m_bytes_free = 0;
        if (ret >= 0) {
            if (this.trace) {
                Trc.ab_rfctrc(JCoRuntime.CRLF + ">>>> Listen/WaitForRequest (counter = " + this.wcount + ')' + JCoRuntime.CRLF);
                if (this.m_bytes_in_buffer > 0) {
                    Trc.rfctrace(this, "LISTEN", this.m_buffer, this.m_bytes_in_buffer);
                }
            }
            this.wcount = 0;
        }
        if (ret > 0) {
            switch (ret) {
                case 10: {
                    if (this.accepted) {
                        this.ab_rfcabort2();
                    } else {
                        this.ab_rfcclose();
                    }
                    return ret;
                }
                case 17: 
                case 29: {
                    return ret;
                }
            }
            String msg = this.channel.getMessage();
            if (this.trace) {
                StringBuilder text = new StringBuilder(128);
                text.append("Error> ab_rfclisten [");
                text.append(this.hrfc);
                text.append("] channel.listen failed with message: ");
                text.append(msg);
                text.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcIoException(ret, msg);
        }
        if (ret < 0) {
            return 17;
        }
        return 0;
    }

    public void ab_rfcreset() {
        if (this.input) {
            this.m_buffer_ptr = 0;
            this.m_bytes_in_buffer = this.m_bytes_read[0];
            this.m_bytes_free = 0;
        }
    }

    public void ab_rfcreset_send() {
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_read[0] = 0;
        this.m_bytes_free = this.m_buffer == null ? this.channel.getPacketSize() : this.m_buffer.length;
        this.dmCounter = 0;
        this.dmStartCounter = 1;
    }

    public void ab_rfccon(RfcOptions options) throws RfcIoException, RfcInvalidConfigurationException {
        String extid_data = options.getExtid_data();
        String x509cert = options.getX509cert();
        if (this.mysapsso2 != null) {
            RfcPut.ab_rfcput_string(this, 1648, this.mysapsso2);
            this.mysapsso2 = null;
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else if (x509cert != null) {
            RfcPut.ab_rfcput_string(this, 1650, x509cert);
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else if (extid_data != null) {
            RfcPut.ab_rfcput_string(this, 1651, extid_data);
            RfcPut.ab_rfcput_string(this, 1652, options.getExtid_type());
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
        } else if (!options.usesPrincipalPropagation()) {
            if (this.userid != null) {
                RfcPut.ab_rfcput_string(this, 273, this.userid);
            }
            byte[] buffer = options.getPassword();
            if (this.signon && buffer != null) {
                String auth = null;
                try {
                    buffer = (byte[])buffer.clone();
                    buffer[6] = ~buffer[6];
                    auth = Codecs.AES.decryptAsString(buffer, (SecretKey)GUID.getProcessID());
                    buffer = null;
                }
                catch (Throwable th) {
                    throw new RfcIoException(3, "Password decryption failed: " + th.toString());
                }
                RfcPut.ab_rfcscrput_string(this, 279, auth);
                auth = null;
            }
        }
        if (options.useSncWithoutSSO()) {
            RfcPut.ab_rfcput(this, 1653);
        }
        if (options.isGetsso2()) {
            RfcPut.ab_rfcput(this, 1649);
        }
        RfcPut.ab_rfcput_string(this, 276, this.mandt);
        String alias_user = options.getAlias();
        if (alias_user != null) {
            RfcPut.ab_rfcput_string(this, 297, alias_user);
        }
        RfcPut.ab_rfcput_string(this, 277, this.lang);
        RfcPut.ab_rfcput(this, 1281, session, session.length, 0);
    }

    void reset() {
        this.name = null;
        this.type = 0;
        this.destination = null;
        this.channel = null;
        this.codepage = null;
        this.communication_cp = null;
        this.rfc_role = '\u0000';
        this.own_type = (char)69;
        this.own_rel = null;
        this.partner_type = '\u0000';
        this.partner_rel = null;
        this.kernel_rel = null;
        Arrays.fill(this.conv_id, (byte)0);
        this.convIdAsString = null;
        this.version = 0;
        this.intformat = 0;
        this.floatformat = 0;
        this.compression = 0;
        this.charset = null;
        this.sysid = null;
        this.protocol = 0;
        this.m_buffer = null;
        this.m_buffer_ptr = 0;
        this.m_bytes_in_buffer = 0;
        this.m_bytes_free = 0;
        this.m_bytes_read[0] = 0;
        this.target = null;
        this.inetAddress = null;
        this.mandt = null;
        this.lang = null;
        this.userid = null;
        this.cuserid = null;
        this.systnr = null;
        this.trace = false;
        this.traceSetByPartner = false;
        this.signon = false;
        this.snc = false;
        this.opened = false;
        this.accepted = false;
        this.input = false;
        this.output = false;
        this.closed = false;
        this.close_pending = false;
        this.identified = false;
        this.reg_exclusiv = false;
        this.unresp_call = 0;
        this.htRFC = null;
        this.wcount = 0;
        this.pcs = 0;
        this.real_pcs = 0;
        this.ignoreConvErr = 0;
        this.unicodeHeader = null;
        this.mysapsso2 = null;
        this.th_client_id = null;
        this.rfc_uuid = null;
        this.rfc_uuid_set = false;
        this.access_counter = 0;
        this.send_conn_header_info = true;
        this.read_conn_header_info = true;
        this.connRef = null;
        this.functionName = null;
        this.functionNames = null;
        this.inCallback = false;
        this.usebASXML = false;
        this.serializationFormat = 0;
        this.abapClassExceptionMode = AbapClassException.Mode.OFF;
        this.dmCounter = 0;
        this.dmStartCounter = 1;
        this.useDeltaManagement = false;
        this.canceled = false;
        this.cancelStackTrace = null;
        this.resetStillNeeded = true;
        this.stateless = true;
        this.withGUI = false;
        this.scrambleParameters = false;
        this.pwdState = null;
        this.channelBytes = 0L;
    }

    public void updateConvID() {
        this.channel.info(this.conv_id);
        this.convIdAsString = null;
    }

    public void copyRawCPICConversationID(RfcIoOpenCntl targetHandle) {
        System.arraycopy(this.conv_id, 0, targetHandle.conv_id, 0, this.conv_id.length);
    }

    public String getCPICConversationID() {
        if (this.convIdAsString == null) {
            try {
                this.convIdAsString = this.conv_id[0] == 0 ? "<initial>" : new String(this.conv_id, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.convIdAsString;
    }

    public Object getConnectionReference() {
        return this.connRef;
    }

    public boolean isStateful() {
        if (this.connRef instanceof ServerConnection) {
            return ((ServerConnection)this.connRef).getSessionId() != null;
        }
        return !this.stateless;
    }

    public boolean isStateless() {
        if (this.connRef instanceof ServerConnection) {
            return ((ServerConnection)this.connRef).getSessionId() == null;
        }
        return this.stateless;
    }

    public void setStateful(boolean stateful) {
        if (this.connRef instanceof ServerConnection) {
            throw new IllegalStateException("The state of a ServerConnection cannot be adjusted with this method");
        }
        if (!this.withGUI) {
            this.stateless = !stateful;
        }
    }

    public void setScrambleParameters(boolean scramble) {
        this.scrambleParameters = scramble;
    }

    public boolean isSncMode() {
        return this.channel.isSncMode();
    }

    public byte[] getSncPartnerAclKey() {
        return this.channel.getSncPartnerAclKey();
    }

    public String getSncPartnerName() {
        return this.channel.getSncPartnerName();
    }

    public static void setGeneralTrace(boolean useTrace) {
        m_gRfcTrace = useTrace;
    }

    public static boolean isGeneralTraceOn() {
        return m_gRfcTrace;
    }

    public boolean isUsed() {
        return this.used;
    }

    public boolean isPartnerReachable() {
        return this.channel.isPartnerReachable();
    }

    public RfcConnectionState getRfcConnectionState() {
        if (this.trace) {
            Trc.rfctrace(this, "STORE", null, 0);
        }
        return new RfcClientConnectionState(this);
    }

    public void restoreState(RfcConnectionState connectionState) throws RfcException {
        RfcClientConnectionState clientState = (RfcClientConnectionState)connectionState;
        this.name = "<jco client>";
        this.type = clientState.type;
        this.destination = clientState.destination;
        this.codepage = AbSysInfo.charset;
        this.communication_cp = clientState.communication_cp;
        this.rfc_role = (char)67;
        this.own_type = (char)69;
        this.own_rel = "753";
        this.partner_type = clientState.partner_type;
        this.partner_rel = clientState.partner_rel;
        this.kernel_rel = clientState.kernel_rel;
        this.version = clientState.version;
        this.intformat = clientState.intformat;
        this.floatformat = clientState.floatformat;
        this.compression = clientState.compression;
        this.charset = clientState.charset;
        this.sysid = clientState.sysid;
        this.protocol = clientState.protocol;
        this.target = clientState.target;
        try {
            this.inetAddress = clientState.ipAddress != null ? InetAddress.getByName(clientState.ipAddress) : null;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mandt = clientState.mandt;
        this.lang = clientState.lang;
        this.userid = clientState.userid;
        this.cuserid = null;
        this.systnr = clientState.systnr;
        this.trace = clientState.trace;
        this.signon = true;
        this.snc = clientState.snc;
        this.allocationType = clientState.allocationType;
        this.used = true;
        this.opened = true;
        this.accepted = false;
        this.input = clientState.input;
        this.output = clientState.output;
        this.closed = false;
        this.close_pending = false;
        this.identified = clientState.identified;
        this.reg_exclusiv = false;
        this.unresp_call = 0;
        this.htRFC = null;
        this.wcount = 0;
        this.pcs = clientState.pcs;
        this.real_pcs = clientState.real_pcs;
        this.ignoreConvErr = clientState.ignoreConvErr;
        this.unicodeHeader = null;
        this.mysapsso2 = null;
        if (clientState.th_client_id != null) {
            this.th_client_id = new byte[clientState.th_client_id.length];
            System.arraycopy(clientState.th_client_id, 0, this.th_client_id, 0, this.th_client_id.length);
        } else {
            this.th_client_id = null;
        }
        if (clientState.rfc_uuid != null) {
            this.rfc_uuid = new byte[clientState.rfc_uuid.length];
            System.arraycopy(clientState.rfc_uuid, 0, this.rfc_uuid, 0, this.rfc_uuid.length);
        } else {
            this.rfc_uuid = null;
        }
        this.rfc_uuid_set = clientState.rfc_uuid_set;
        this.receivedIsSupplied = false;
        this.send_conn_header_info = false;
        this.read_conn_header_info = false;
        this.connRef = null;
        this.access_counter = clientState.access_counter;
        this.functionName = null;
        this.functionNames = null;
        this.inCallback = false;
        this.usebASXML = false;
        this.serializationFormat = 0;
        this.abapClassExceptionMode = AbapClassException.Mode.OFF;
        if (this.open_channel() > 0) {
            throw new RfcException(3, "Could not restore connection of type " + Trc.rfctype(this.type) + '(' + this.type + ')', 108, this.hrfc, true);
        }
        this.channel.restoreState(clientState.driverState);
        this.updateConvID();
        this.dmCounter = clientState.dmCounter;
        this.dmStartCounter = clientState.dmStartCounter;
    }

    public void rfcAbort(String message) throws RfcException {
        try {
            String errcode = "RFC_EXTERNAL_ABORT";
            RfcPut.ab_rfcput_string(this, 1027, errcode);
            RfcPut.ab_rfcput_string(this, 1026, message);
            this.close_pending = true;
            RfcPut.ab_rfcend(this);
            this.ab_rfcabort2();
        }
        catch (RfcIoException ioEx) {
            int rfc_rc = RfcException.rfcIOtoRC(ioEx.getIoRc());
            throw new RfcException(rfc_rc, ioEx.getMessage(), ioEx.getErrorGroup(), this.hrfc, true, ioEx);
        }
    }

    public void RfcAbort(String message) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcAbort");
        }
        if (message == null) {
            message = "External server aborted without message";
        }
        this.RfcIsValidHandle();
        if (this.trace) {
            Trc.TRfcAbort(this.hrfc, message);
        }
        if (this.type == 3 || this.type == 5) {
            if (this.trace) {
                Trc.ab_rfctrc("<<<< RfcAbort" + JCoRuntime.CRLF + JCoRuntime.CRLF);
            }
            return;
        }
        this.rfcAbort(message);
        if (this.trace) {
            Trc.ab_rfctrc("<* RfcAbort *>" + JCoRuntime.CRLF + JCoRuntime.CRLF);
        }
    }

    public void RfcClose() {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcClose");
        }
        this.ab_rfcclose();
        if (this.trace) {
            Trc.ab_rfctrc("<* RfcClose*>" + JCoRuntime.CRLF);
        }
    }

    public void RfcCancel() {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcCancel");
        }
        this.canceled = true;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        new Throwable().printStackTrace(pw);
        pw.close();
        this.cancelStackTrace = sw.getBuffer().substring("java.lang.Throwable".length()).toString();
        if (this.trace) {
            Trc.ab_rfctrc("<* RfcCancel*>" + JCoRuntime.CRLF);
        }
    }

    public String getCancelStackTrace() {
        return this.cancelStackTrace;
    }

    public boolean RfcIsCanceled() {
        return this.canceled;
    }

    public void RfcCall(String function, IRfcParameter[] importing_abap, IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables, boolean supportsASXML, AbapClassException.Mode classExceptionMode, String tRFCFunction) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcCall");
        }
        this.RfcIsValidHandle();
        this.ab_rfccount(1);
        if (this.accepted) {
            this.inCallback = true;
        }
        if (this.trace) {
            Trc.TRfcCall(this.hrfc, function, importing_abap, changing, tables);
        }
        this.resetStillNeeded = true;
        this.functionName = tRFCFunction == null ? function : tRFCFunction;
        try {
            RfcCall.ab_rfccxt2(this, function, importing_abap, exporting_abap, changing, tables, supportsASXML, classExceptionMode);
        }
        catch (RfcIoException ioEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcCall", false);
            }
            throw new RfcException(ioEx);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcCall", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RfcReceive(IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables, RepositoryProvider repositoryProvider) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcReceive");
        }
        int rfc_rc = 0;
        try {
            RfcRcv.ab_rfcreceive(this, exporting_abap, null, changing, tables, repositoryProvider);
        }
        catch (RfcGetException getEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcReceive", false);
            }
            switch (getEx.getRc()) {
                case 0: {
                    break;
                }
                case 9: {
                    boolean isInCallback = this.inCallback;
                    String originalFunction = this.functionName;
                    this.functionName = null;
                    this.inCallback = true;
                    try {
                        String funcName = RfcGetName.ab_RfcDispatchLoc(this);
                        if (funcName != null) {
                            StringBuilder errorMessage = new StringBuilder(100).append("Function module \"").append(funcName).append("\" not found.");
                            this.RfcAbort(errorMessage.toString());
                            errorMessage.setCharAt(errorMessage.length() - 1, ' ');
                            errorMessage.append("for processing callback request.");
                            char role = this.rfc_role;
                            this.rfc_role = (char)83;
                            RfcException ex = new RfcException(13, errorMessage.toString(), 104, this.hrfc, this.trace);
                            this.rfc_role = role;
                            throw ex;
                        }
                    }
                    finally {
                        this.inCallback = isInCallback;
                        this.functionName = originalFunction;
                    }
                    this.RfcReceive(exporting_abap, changing, tables, repositoryProvider);
                    rfc_rc = 4;
                    break;
                }
                case 14: {
                    rfc_rc = 21;
                    break;
                }
                case 7: {
                    this.ab_rfcclose();
                    throw new RfcException(getEx, this.hrfc);
                }
                case 8: 
                case 22: {
                    try {
                        this.ab_rfcflush();
                    }
                    catch (RfcIoException ioEx) {
                        this.ab_rfcclose();
                        throw new RfcException(6, "Flush IO buffer failed", ioEx.getErrorGroup(), this.hrfc, true, ioEx);
                    }
                    throw new RfcException(getEx, this.hrfc);
                }
                case 13: {
                    rfc_rc = 19;
                    break;
                }
                case 12: {
                    rfc_rc = 11;
                    break;
                }
                case 24: {
                    this.ab_rfcclose();
                    rfc_rc = 20;
                    break;
                }
                case 11: {
                    this.ab_rfcclose();
                    rfc_rc = 6;
                    break;
                }
                default: {
                    this.ab_rfcclose();
                    rfc_rc = 3;
                }
            }
            if (rfc_rc != 4) {
                throw new RfcException(rfc_rc, getEx.getMessage(), getEx.getErrorGroup(), this.hrfc, true, getEx);
            }
        }
        finally {
            if (this.trace) {
                Trc.TRfcReceive(this.hrfc, exporting_abap, changing, tables);
            }
            this.inCallback = false;
            this.dmStartCounter = this.dmCounter + 1;
            this.resetDmTables();
            this.functionName = null;
            if (rfc_rc != 4) {
                this.ab_rfccount(2);
            }
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcReceive", true);
        }
    }

    public final void RfcCallReceive(String function, IRfcParameter[] importing_abap, IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables, String tRFCFunction) throws RfcException {
        RfcException rfcExc = null;
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcCallReceive");
        }
        this.RfcIsValidHandle();
        try {
            this.RfcCall(function, importing_abap, exporting_abap, changing, tables, false, AbapClassException.Mode.OFF, tRFCFunction);
            this.RfcReceive(exporting_abap, changing, tables, null);
            this.functionName = function;
        }
        catch (RfcException ex) {
            rfcExc = ex;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcCallReceive", rfcExc == null);
            if (function.equals("SYSTEM_RESET_RFC_SERVER")) {
                Trc.closeTrace();
            }
        }
        if (rfcExc != null) {
            throw rfcExc;
        }
    }

    public final void RfcIsValidHandle() throws RfcException {
        if (this.hrfc == 0L) {
            throw new RfcException(18, "Invalid RFC handle 0 is encountered", 101, 0L, true);
        }
        if (!this.isUsed()) {
            throw new RfcException(18, "Invalid RFC handle: handle " + this.hrfc + " is not referenced", 101, 0L, true);
        }
        if (this.closed || this.close_pending) {
            throw new RfcException(6, "Handle close pending", 109, this.hrfc, true);
        }
    }

    public void clearRfcConnection() {
        if (this.trace) {
            Trc.TRfcApiStart(this, "clearRfcConnection");
            Trc.rfctrace(this, "CLEAR", null, 0);
        }
        this.channel = null;
        if (this.trace) {
            Trc.ab_rfctrc("<* clearRfcConnection*>" + JCoRuntime.CRLF);
        }
    }

    public final void RfcQueueInsert(String function, IRfcParameter[] exporting, IRfcTable[] tables, String qname, String tid, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException, RfcInvalidConfigurationException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcQueueInsert");
        }
        this.RfcIsValidHandle();
        try {
            TRfc.rfcQueueInsert(this, function, exporting, tables, qname, tid, supportsASXML, classExceptionMode);
        }
        catch (RfcException ex) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcQueueInsert", false);
            }
            throw ex;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcQueueInsert", true);
        }
    }

    public final void RfcConfirmTransId(String tid) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcConfirmTransId");
        }
        this.RfcIsValidHandle();
        IRfcParameter[] out = new IRfcParameter[1];
        ARFCTIDStructure out_tid = new ARFCTIDStructure(this, "TID");
        out_tid.setChars(tid);
        out[0] = out_tid;
        try {
            RfcPut.ab_rfcput(this, 1299);
        }
        catch (RfcIoException ioEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcConfirmTransId", false);
            }
            throw new RfcException(ioEx);
        }
        try {
            this.RfcCallReceive("API_CLEAR_TID", out, null, null, null, null);
        }
        catch (RfcException ex) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcConfirmTransId", false);
            }
            throw ex;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcConfirmTransId", true);
        }
    }

    public final BgRfcUnit RfcStartBgRfcUnit(byte[] unitId) {
        return BgRfcUnit.createUnit(this, unitId);
    }

    public final void RfcCommit(BgRfcUnit bgRfcUnit, RepositoryProvider repositoryProvider) throws RfcException {
        bgRfcUnit.commit(repositoryProvider);
    }

    public final BgRfcUnit RfcDispatchUnit(RepositoryProvider repositoryProvider) throws RfcException {
        return BgRfcUnit.dispatchUnit(this, repositoryProvider);
    }

    public final void RfcFinishDispatch(BgRfcUnit bgRfcUnit) throws RfcException {
        bgRfcUnit.finishDispatch();
    }

    public final String RfcCreateTransID() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcCreateTransID");
        }
        this.RfcIsValidHandle();
        IRfcParameter[] in = new IRfcParameter[1];
        ARFCTIDStructure tid = new ARFCTIDStructure(this, "TID");
        in[0] = tid;
        try {
            this.RfcCallReceive("API_CREATE_TID", null, in, null, null, null);
        }
        catch (RfcException ex) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcCreateTransID", false);
            }
            throw ex;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcCreateTransID", true);
        }
        return tid.toString();
    }

    public final int RfcListen(int timeout) throws RfcException {
        int ioRc = 0;
        int rfc_rc = -1;
        this.functionName = null;
        try {
            ioRc = this.ab_rfclisten(timeout);
        }
        catch (RfcIoException ioEx) {
            throw new RfcException(ioEx);
        }
        rfc_rc = RfcException.rfcIOtoRC(ioRc);
        if (rfc_rc == 0) {
            String function = RfcGetName.ab_RfcDispatchLoc(this);
            if (function == null) {
                if (this.trace) {
                    Trc.TRfcApiEnd("RfcListen got system function", true);
                }
                return 7;
            }
            this.functionName = function;
            return 0;
        }
        return rfc_rc;
    }

    public final String RfcGetName() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcGetName");
        }
        String result = null;
        String string = result = this.functionName != null ? this.functionName : RfcGetName.ab_RfcGetName(this);
        if (this.trace) {
            Trc.ab_rfctrc("\tGot function name: " + JCoRuntime.CRLF);
            Trc.TRfcApiEnd("RfcGetName", true);
        }
        return result;
    }

    public final void RfcSendData(IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcSendData");
        }
        if (this.trace) {
            Trc.TRfcSendData(this.hrfc, exporting, changing, tables);
        }
        try {
            RfcCall.ab_rfcbxt_withoutFlush(this, exporting, changing, tables);
        }
        catch (RfcIoException ioEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcSendData", false);
            }
            throw new RfcException(ioEx);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcSendData", true);
        }
    }

    public final void flushServerConnection() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "Flush and Listen");
        }
        try {
            RfcPut.ab_rfcend(this);
        }
        catch (RfcIoException ioEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("Flush and Listen", false);
            }
            throw new RfcException(ioEx);
        }
        finally {
            this.usebASXML = false;
            this.abapClassExceptionMode = AbapClassException.Mode.OFF;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("Flush and Listen", true);
        }
    }

    public final void RfcGetData(IRfcParameter[] importing, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables, RepositoryProvider repositoryProvider) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcGetData");
            Trc.TRfcGetData(this.hrfc, importing, changing, tables);
        }
        try {
            RfcRcv.ab_rfcreceive(this, importing, exporting, changing, tables, repositoryProvider);
        }
        catch (RfcGetException getEx) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcGetData", false);
            }
            switch (getEx.getRc()) {
                case 14: {
                    throw new RfcException(21, getEx.getMessage(), getEx.getErrorGroup(), this.hrfc, true, getEx);
                }
            }
            throw new RfcException(1, getEx.getMessage(), getEx.getErrorGroup(), this.hrfc, true, getEx);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcGetData", true);
        }
    }

    public final byte[] RfcSncPartnerAclKey() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcSncPartnerAclKey");
        }
        this.RfcIsValidHandle();
        byte[] aclKey = this.getSncPartnerAclKey();
        if (aclKey == null) {
            throw new RfcException(1, "Could not get SNC Partner Acl key", 104, this.hrfc, true);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcSncPartnerName", true);
        }
        return aclKey;
    }

    public final String RfcSncPartnerName() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcSncPartnerName");
        }
        this.RfcIsValidHandle();
        String partnerName = this.getSncPartnerName();
        if (partnerName == null) {
            throw new RfcException(1, "Could not get SNC PartnerName", 104, this.hrfc, true);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcSncPartnerName", true);
        }
        return partnerName;
    }

    public final boolean RfcSncMode() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcSncMode");
        }
        this.RfcIsValidHandle();
        boolean sncMode = this.isSncMode();
        if (this.trace) {
            Trc.TRfcApiEnd("RfcSncMode", true);
        }
        return sncMode;
    }

    public final byte[] RfcGetClientId() throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcGetClientId");
        }
        this.RfcIsValidHandle();
        if (this.trace) {
            if (this.th_client_id == null || this.th_client_id.length == 0) {
                Trc.ab_rfctrc("No passport received [" + this.hrfc + ']' + JCoRuntime.CRLF);
                Trc.ab_rfctrc("<* RfcGetClientId [" + this.hrfc + "] *>" + JCoRuntime.CRLF);
            } else {
                Trc.ab_rfctrc("Got passport with length " + this.th_client_id.length + '\n');
                Trc.TRfcApiEnd("RfcGetClientId", true);
            }
        }
        return this.th_client_id;
    }

    public final void RfcSetClientId(byte[] passport) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcSetClientId");
        }
        this.RfcIsValidHandle();
        if (passport == null) {
            throw new RfcException(19, "Passport is null", 101, this.hrfc, false);
        }
        if (passport.length > 0) {
            this.th_client_id = passport;
            if (this.trace) {
                Trc.ab_rfctrc("Set passport with length " + passport.length + JCoRuntime.CRLF);
            }
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcSetClientId", true);
        }
    }

    public final void RfcRaiseErrorMessage(String exception, String errorMessage, String messageClass, char messageType, String messageNumber, String[] messageParameters) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcRaiseErrorMessage");
        }
        this.RfcIsValidHandle();
        if (messageClass != null && messageNumber != null) {
            if (this.trace) {
                Trc.TRfcRaiseErrorMessage(this.hrfc, exception, messageClass, messageType, messageNumber, messageParameters);
            }
            try {
                if (messageParameters == null) {
                    RfcPut.ab_RfcPutSyMsg(this, messageClass, messageType, messageNumber, null, null, null, null);
                }
                RfcPut.ab_RfcPutSyMsg(this, messageClass, messageType, messageNumber, messageParameters[0], messageParameters[1], messageParameters[2], messageParameters[3]);
            }
            catch (RfcIoException ioEx) {
                if (this.trace) {
                    Trc.TRfcApiEnd("RfcRaiseErrorMessage", false);
                }
                throw new RfcException(ioEx);
            }
        } else if (errorMessage != null && errorMessage.trim().length() > 0 && !errorMessage.equalsIgnoreCase(exception)) {
            String[] messageParts = new String[4];
            int erLen = errorMessage.length();
            for (int i = 0; i < 4; ++i) {
                if (erLen > 50) {
                    messageParts[i] = errorMessage.substring(0, 50);
                    errorMessage = errorMessage.substring(50);
                    erLen = errorMessage.length();
                    continue;
                }
                messageParts[i] = errorMessage;
                errorMessage = "";
                erLen = 0;
            }
            if (this.trace) {
                Trc.TRfcRaiseErrorMessage(this.hrfc, exception, "00", 'E', "001", messageParts);
            }
            try {
                RfcPut.ab_RfcPutSyMsg(this, "00", 'E', "001", messageParts[0], messageParts[1], messageParts[2], messageParts[3]);
            }
            catch (RfcIoException ioEx) {
                if (this.trace) {
                    Trc.TRfcApiEnd("RfcRaiseErrorMessage", false);
                }
                throw new RfcException(ioEx);
            }
        }
        try {
            this.RfcRaise(exception);
        }
        catch (RfcException ex) {
            if (this.trace) {
                Trc.TRfcApiEnd("RfcRaiseErrorMessage", false);
            }
            throw ex;
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcRaiseErrorMessage", true);
        }
    }

    public final void RfcRaise(String text) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RfcRaise");
        }
        this.RfcIsValidHandle();
        if (this.trace) {
            Trc.TRfcRaise(this.hrfc, text);
        }
        try {
            RfcPut.ab_rfcput(this, 1280);
            RfcPut.ab_rfcput_string(this, 1025, text);
            RfcPut.ab_rfcend(this);
        }
        catch (RfcIoException ioEx) {
            this.ab_rfcclose();
            if (this.trace) {
                Trc.TRfcApiEnd("RfcRaise", false);
            }
            throw new RfcException(ioEx);
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RfcRaise", true);
        }
    }

    public final void raiseAbapClassException(AbapClassException ace) throws RfcException {
        if (this.trace) {
            Trc.TRfcApiStart(this, "RaiseAbapClassException");
        }
        this.RfcIsValidHandle();
        if (this.trace) {
            Trc.TRfcRaiseAbapClassException(this.hrfc, ace);
        }
        try {
            RfcPut.ab_rfcput_string(this, 1048, ace.createCallStack());
            RfcPut.ab_rfcput_string(this, 1058, ace.createExceptionInfo());
            boolean compressionEnabledForConnection = (this.protocol & 2) != 0;
            BasXMLWriter writer = new BasXMLWriter(new BasXMLOutputStream(this, compressionEnabledForConnection, true));
            writer.encode(ace);
            writer.close();
            RfcPut.ab_rfcend(this);
        }
        catch (RfcIoException ioEx) {
            this.ab_rfcclose();
            if (this.trace) {
                Trc.TRfcApiEnd("RaiseAbapClassException", false);
            }
            throw new RfcException(ioEx);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.trace) {
            Trc.TRfcApiEnd("RaiseAbapClassException", true);
        }
    }

    public int getNextTableId(IRfcTable table) {
        if (this.dmTables == null) {
            this.dmTables = new ArrayList<IRfcTable>(10);
        }
        ++this.dmCounter;
        this.dmTables.add(table);
        return this.dmCounter;
    }

    public IRfcTable getDmTable(int tableId) {
        int idx = tableId - this.dmStartCounter;
        if (idx >= 0 && idx < this.dmTables.size()) {
            return this.dmTables.get(idx);
        }
        return null;
    }

    public boolean needsReset() {
        return this.resetStillNeeded;
    }

    void resetDmTables() {
        if (this.dmTables != null) {
            this.dmTables.clear();
        }
    }

    public static int getClientConnectTimeout() {
        return m_clientConnectTimeout;
    }

    public static void setClientConnectTimeout(int seconds) {
        m_clientConnectTimeout = seconds;
    }
}

