/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.exceptions.RfcIoException;
import com.sap.i18n.cp.ConvertCToX;
import java.security.SecureRandom;

public abstract class RfcPut {
    public static int ab_RfcPutStringToMemory(RfcIoOpenCntl act_cntl, int rfcid, String in_buffer, byte[] out_buffer, int offset) {
        byte[] scratch_buffer = null;
        if (in_buffer != null) {
            ConvertCToX converter = null;
            converter = act_cntl.pcs == 1 ? I18NConverters.getConvertCToX(act_cntl.getCommunicationCodepage()) : I18NConverters.getConvertCToX(act_cntl.charset);
            scratch_buffer = converter.Convert(in_buffer);
        }
        return RfcPut.ab_RfcPutToMemory(rfcid, scratch_buffer, scratch_buffer == null ? 0 : scratch_buffer.length, out_buffer, offset);
    }

    public static int ab_RfcPutToMemory(int rfcid, byte[] in_buffer, int in_leng, byte[] out_buffer, int offset) {
        byte[] RFC_PRO_HEADER_RID = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_END = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_HEADER_LENG = null;
        byte[] RFC_PRO_HEADER_LENG32 = null;
        boolean b32BitLength = in_leng >= 65535;
        int n = offset;
        if (b32BitLength) {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(65535);
            RFC_PRO_HEADER_LENG32 = RfcPut.set_RFCPRO_LENG32(in_leng);
        } else {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(in_leng);
        }
        System.arraycopy(RFC_PRO_HEADER_RID, 0, out_buffer, n, RFC_PRO_HEADER_RID.length);
        System.arraycopy(RFC_PRO_HEADER_LENG, 0, out_buffer, n += RFC_PRO_HEADER_RID.length, RFC_PRO_HEADER_LENG.length);
        n += RFC_PRO_HEADER_LENG.length;
        if (b32BitLength) {
            System.arraycopy(RFC_PRO_HEADER_LENG32, 0, out_buffer, n, RFC_PRO_HEADER_LENG32.length);
            n += RFC_PRO_HEADER_LENG32.length;
        }
        if (in_leng > 0 && in_buffer.length > 0) {
            System.arraycopy(in_buffer, 0, out_buffer, n, Math.min(in_leng, in_buffer.length));
            n += Math.min(in_leng, in_buffer.length);
        }
        System.arraycopy(RFC_PRO_END, 0, out_buffer, n, RFC_PRO_END.length);
        return n += RFC_PRO_END.length;
    }

    public static void ab_RfcPutSyMsg(RfcIoOpenCntl act_cntl, String msgid, char msgty, String msgno, String msgv1, String msgv2, String msgv3, String msgv4) throws RfcIoException {
        if (msgid != null && msgid.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1045, msgid);
        }
        if (msgty > '\u0000') {
            RfcPut.ab_rfcput(act_cntl, 1046, new char[]{msgty}, 1, 0);
        }
        if (msgno != null && msgno.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1047, msgno);
        }
        if (msgv1 != null && msgv1.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1041, msgv1);
        }
        if (msgv2 != null && msgv2.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1042, msgv2);
        }
        if (msgv3 != null && msgv3.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1043, msgv3);
        }
        if (msgv4 != null && msgv4.length() > 0) {
            RfcPut.ab_rfcput_string(act_cntl, 1044, msgv4);
        }
    }

    public static void ab_rfcput(RfcIoOpenCntl act_cntl, int rfcid) throws RfcIoException {
        byte[] RFC_PRO_HEADER_RID;
        byte[] RFC_PRO_END = RFC_PRO_HEADER_RID = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(0);
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_RID, RFC_PRO_HEADER_RID.length, 0);
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_LENG, RFC_PRO_HEADER_LENG.length, 0);
        act_cntl.ab_rfcwrite(RFC_PRO_END, RFC_PRO_END.length, 0);
    }

    public static void ab_rfcput(RfcIoOpenCntl act_cntl, int rfcid, byte[] buffer, int leng, int offset) throws RfcIoException {
        boolean b32BitLength;
        byte[] RFC_PRO_HEADER_RID;
        byte[] RFC_PRO_END = RFC_PRO_HEADER_RID = RfcPut.set_RFCPRO_ID(rfcid);
        byte[] RFC_PRO_HEADER_LENG = null;
        byte[] RFC_PRO_HEADER_LENG32 = null;
        boolean bl = b32BitLength = leng >= 65535;
        if (b32BitLength) {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(65535);
            RFC_PRO_HEADER_LENG32 = RfcPut.set_RFCPRO_LENG32(leng);
        } else {
            RFC_PRO_HEADER_LENG = RfcPut.set_RFCPRO_LENG(leng);
        }
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_RID, RFC_PRO_HEADER_RID.length, 0);
        act_cntl.ab_rfcwrite(RFC_PRO_HEADER_LENG, RFC_PRO_HEADER_LENG.length, 0);
        if (b32BitLength) {
            act_cntl.ab_rfcwrite(RFC_PRO_HEADER_LENG32, RFC_PRO_HEADER_LENG32.length, 0);
        }
        if (buffer != null && leng > 0) {
            act_cntl.ab_rfcwrite(buffer, leng, offset);
        }
        act_cntl.ab_rfcwrite(RFC_PRO_END, RFC_PRO_END.length, 0);
    }

    public static void ab_rfcput_string(RfcIoOpenCntl act_cntl, int rfcid, String buffer) throws RfcIoException {
        byte[] scratch_buffer = null;
        if (buffer != null) {
            ConvertCToX converter = null;
            converter = act_cntl.pcs == 1 ? I18NConverters.getConvertCToX(act_cntl.getCommunicationCodepage()) : I18NConverters.getConvertCToX(act_cntl.getCodepage());
            scratch_buffer = converter.Convert(buffer);
        }
        RfcPut.ab_rfcput(act_cntl, rfcid, scratch_buffer, scratch_buffer == null ? 0 : scratch_buffer.length, 0);
    }

    public static void ab_rfcput(RfcIoOpenCntl act_cntl, int rfcid, char[] buffer, int leng, int offset) throws RfcIoException {
        byte[] scratch_buffer = null;
        if (buffer != null) {
            ConvertCToX converter = null;
            converter = act_cntl.pcs == 1 ? I18NConverters.getConvertCToX(act_cntl.getCommunicationCodepage()) : I18NConverters.getConvertCToX(act_cntl.getCodepage());
            scratch_buffer = converter.ConvertArr(buffer, offset, offset + leng);
        }
        RfcPut.ab_rfcput(act_cntl, rfcid, scratch_buffer, scratch_buffer == null ? 0 : scratch_buffer.length, 0);
    }

    public static void ab_rfcscrput_string(RfcIoOpenCntl act_cntl, int rfcid, String buffer) throws RfcIoException {
        byte[] scratch_buffer = null;
        if (buffer != null) {
            ConvertCToX converter = null;
            converter = act_cntl.pcs == 1 ? I18NConverters.getConvertCToX(act_cntl.getCommunicationCodepage()) : I18NConverters.getConvertCToX(act_cntl.getCodepage());
            scratch_buffer = converter.Convert(buffer);
        }
        RfcPut.ab_rfcscrput(act_cntl, rfcid, scratch_buffer, scratch_buffer == null ? 0 : scratch_buffer.length);
    }

    public static void ab_rfcscrput(RfcIoOpenCntl act_cntl, int rfcid, byte[] buffer, int length) throws RfcIoException {
        byte[] rid = null;
        byte[] rleng = null;
        SecureRandom r = new SecureRandom();
        long key = 0xFFFFFFFF & r.nextInt();
        byte[] local_buffer = new byte[1024];
        byte[] key_buff = new byte[4];
        rid = RfcPut.set_RFCPRO_ID(rfcid);
        rleng = RfcPut.set_RFCPRO_LENG(length + 4);
        act_cntl.ab_rfcwrite(rid, rid.length, 0);
        act_cntl.ab_rfcwrite(rleng, rleng.length, 0);
        key ^= key << 14;
        System.arraycopy(buffer, 0, local_buffer, 0, length);
        RfcUtilities.ab_scramble(local_buffer, length, key);
        key_buff[0] = (byte)(key >>> 24);
        key_buff[1] = (byte)(key >>> 16);
        key_buff[2] = (byte)(key >>> 8);
        key_buff[3] = (byte)key;
        act_cntl.ab_rfcwrite(key_buff, key_buff.length, 0);
        act_cntl.ab_rfcwrite(local_buffer, length, 0);
        act_cntl.ab_rfcwrite(rid, rid.length, 0);
    }

    public static void ab_rfcend(RfcIoOpenCntl act_cntl) throws RfcIoException {
        RfcPut.ab_rfcput(act_cntl, 65535);
        act_cntl.ab_rfcflush();
    }

    private static byte[] set_RFCPRO_ID(int rfcid) {
        return RfcUtilities.shortAsByteArray(rfcid);
    }

    private static byte[] set_RFCPRO_LENG(int length) {
        return RfcUtilities.shortAsByteArray(length);
    }

    private static byte[] set_RFCPRO_LENG32(int length) {
        return RfcUtilities.intAsByteArray(length);
    }
}

