/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

public abstract class RfcUtilities {
    private static final int KT_ENTRIES = 64;
    private static final byte[] kt = new byte[]{-16, -19, 83, -72, 50, 68, -15, -8, 118, -58, 121, 89, -3, 79, 19, -94, -63, 81, -107, -20, 84, -125, -62, 52, 119, 73, 67, -94, 125, -30, 101, -106, 94, 83, -104, 120, -102, 23, -93, 60, -45, -125, -88, -72, 41, -5, -36, -91, 85, -41, 2, 119, -124, 19, -84, -35, -7, -72, 49, 22, 97, 14, 109, -6};
    public static final int KT_MASK = 63;

    public static byte[] longAsByteArray(long val) {
        byte[] x = new byte[]{(byte)(val >> 56 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)};
        return x;
    }

    public static byte[] intAsByteArray(int val) {
        byte[] x = new byte[4];
        RfcUtilities.intAsByteArray(val, x);
        return x;
    }

    public static void intAsByteArray(int val, byte[] store) {
        store[0] = (byte)(val >> 24 & 0xFF);
        store[1] = (byte)(val >> 16 & 0xFF);
        store[2] = (byte)(val >> 8 & 0xFF);
        store[3] = (byte)(val & 0xFF);
    }

    public static byte[] shortAsByteArray(int val) {
        byte[] x = new byte[]{(byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return x;
    }

    public static int byteArrayToUnsignedShort(byte[] x) {
        short res = (short)(x[0] << 8 | x[1] & 0xFF);
        return 0xFFFF & res;
    }

    public static int byteArrayToInt(byte[] x) {
        int res = x[0] << 24 | (x[1] & 0xFF) << 16 | (x[2] & 0xFF) << 8 | x[3] & 0xFF;
        return 0xFFFFFFFF & res;
    }

    public static int byteArrayToInt(byte[] x, int offset) {
        return RfcUtilities.byteArrayToInt(x, offset, true);
    }

    public static short byteArrayToShort(byte[] x, int offset, boolean isBigEndian) {
        short res = 0;
        res = isBigEndian ? (short)(x[offset] << 8 | x[1 + offset] & 0xFF) : (short)(x[offset] & 0xFF | x[1 + offset] << 8);
        return (short)(0xFFFF & res);
    }

    public static int byteArrayToInt(byte[] x, int offset, boolean isBigEndian) {
        int res = 0;
        res = isBigEndian ? x[offset] << 24 | (x[1 + offset] & 0xFF) << 16 | (x[2 + offset] & 0xFF) << 8 | x[3 + offset] & 0xFF : x[offset] & 0xFF | (x[1 + offset] & 0xFF) << 8 | (x[2 + offset] & 0xFF) << 16 | (x[3 + offset] & 0xFF) << 24;
        return 0xFFFFFFFF & res;
    }

    public static long byteArrayToLong(byte[] x, int offset, boolean isBigEndian) {
        long res = 0L;
        res = isBigEndian ? (long)x[offset] << 56 | (long)(x[1 + offset] & 0xFF) << 48 | (long)(x[2 + offset] & 0xFF) << 40 | (long)(x[3 + offset] & 0xFF) << 32 | (long)(x[4 + offset] & 0xFF) << 24 | (long)(x[5 + offset] & 0xFF) << 16 | (long)(x[6 + offset] & 0xFF) << 8 | (long)(x[7 + offset] & 0xFF) : (long)(x[offset] & 0xFF) | (long)(x[1 + offset] & 0xFF) << 8 | (long)(x[2 + offset] & 0xFF) << 16 | (long)(x[3 + offset] & 0xFF) << 24 | (long)(x[4 + offset] & 0xFF) << 32 | (long)(x[5 + offset] & 0xFF) << 40 | (long)(x[6 + offset] & 0xFF) << 48 | (long)(x[7 + offset] & 0xFF) << 56;
        return 0xFFFFFFFFFFFFFFFFL & res;
    }

    public static boolean byteArraySequenceEquals(byte[] lvalue, int offset_lvalue, byte[] rvalue, int offset_rvalue, int leng) {
        if (lvalue == null && rvalue == null) {
            return true;
        }
        if (lvalue == null ^ rvalue == null) {
            return false;
        }
        if (leng > lvalue.length - offset_lvalue || leng > rvalue.length - offset_rvalue) {
            return false;
        }
        int l_end = leng + offset_lvalue;
        int i = offset_lvalue;
        int j = offset_rvalue;
        while (i < l_end) {
            if (lvalue[i] != rvalue[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean charArraySequenceEquals(char[] lvalue, int offset_lvalue, char[] rvalue, int offset_rvalue, int leng) {
        if (lvalue == null && rvalue == null) {
            return true;
        }
        if (lvalue == null ^ rvalue == null) {
            return false;
        }
        if (leng > lvalue.length - offset_lvalue || leng > rvalue.length - offset_rvalue) {
            return false;
        }
        int l_end = leng + offset_lvalue;
        int i = offset_lvalue;
        int j = offset_rvalue;
        while (i < l_end) {
            if (lvalue[i] != rvalue[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static void ab_scramble(byte[] data, int dlen, long key) {
        long kti = key ^ key >>> 5 ^ key << 1;
        kti &= 0x3FL;
        int i = 0;
        while (i < dlen) {
            short keyvalue = (short)(kt[(int)kti] & 0xFF);
            keyvalue = (short)((long)keyvalue ^ key * (long)i * (long)i - (long)i & 0xFFL);
            int n = i++;
            data[n] = (byte)(data[n] ^ keyvalue);
            ++kti;
            kti &= 0x3FL;
        }
    }
}

