/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.data.ARFCSDATA;
import com.sap.conn.rfc.data.ARFCSSTATE;
import com.sap.conn.rfc.data.ARFCTIDStructure;
import com.sap.conn.rfc.data.ARfcSDataHeader;
import com.sap.conn.rfc.driver.RfcTypePlayback;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcInvalidConfigurationException;
import com.sap.conn.rfc.exceptions.RfcIoException;

public abstract class TRfc {
    public static final int RFC_PB_WITH_STATE = 1;
    public static final int RFC_PB_CHECK = 2;

    public static void rfcQueueInsert(RfcIoOpenCntl act_cntl, String function, IRfcParameter[] exporting, IRfcTable[] tables, String qname, String tid, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException, RfcInvalidConfigurationException {
        ARFCSDATA arfcsdata = new ARFCSDATA(act_cntl, "DATA");
        ARFCSSTATE arfcstate = new ARFCSSTATE(act_cntl, "STATE");
        ARfcSDataHeader arfc_header = new ARfcSDataHeader();
        DefaultTable state = arfcstate.getTable();
        state.appendRow();
        String[] tid_fields = ARFCTIDStructure.splitARFCFieldsFromTID(tid);
        arfc_header.setTIDFields(tid_fields);
        state.encodeCHAR(tid_fields[0], 0);
        state.setEdited(0);
        state.encodeCHAR(tid_fields[1], 1);
        state.setEdited(1);
        state.encodeCHAR(tid_fields[2], 2);
        state.setEdited(2);
        state.encodeCHAR(tid_fields[3], 3);
        state.setEdited(3);
        arfc_header.setDestination(act_cntl.destination);
        state.encodeCHAR(act_cntl.destination, 4);
        state.setEdited(4);
        arfc_header.setLuwCounter(1);
        state.encodeCHAR("1", 5);
        state.setEdited(5);
        state.encodeCHAR(function, 7);
        state.setEdited(7);
        arfc_header.setBlockCounter(1);
        if (qname != null) {
            int strlen = qname.length();
            StringBuilder qFlagNameBuf = new StringBuilder(45 + strlen);
            qFlagNameBuf.append(new char[44]);
            qFlagNameBuf.append('I');
            for (int i = 0; i < strlen; ++i) {
                qFlagNameBuf.append(Character.toUpperCase(qname.charAt(i)));
            }
            state.encodeCHAR(qFlagNameBuf.toString(), 16);
            state.setEdited(16);
        }
        TRfc.rfcRecord(function, exporting, tables, arfcsdata, arfc_header, act_cntl, supportsASXML, classExceptionMode);
        try {
            RfcPut.ab_rfcput(act_cntl, 1284);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                StringBuilder text = new StringBuilder(70);
                text.append("Error> rfcQueueInsert [");
                text.append(act_cntl.hrfc);
                text.append("] : failed to send ARFC_Agent container");
                text.append(JCoRuntime.CRLF);
                Trc.ab_rfctrc(text.toString());
            }
            throw new RfcException(ioEx);
        }
        IRfcTable[] arfcTables = new TableParameter[]{arfcstate, arfcsdata};
        act_cntl.RfcCallReceive("ARFC_DEST_SHIP", null, null, null, arfcTables, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rfcRecord(String function, IRfcParameter[] exporting, IRfcTable[] tables, ARFCSDATA itab_h, ARfcSDataHeader header, RfcIoOpenCntl org_cntl, boolean supportsASXML, AbapClassException.Mode classExceptionMode) throws RfcException, RfcInvalidConfigurationException {
        if (org_cntl == null) {
            throw new RfcException(18, "RFC handle is <null>", 104, 0L, true);
        }
        RfcIoOpenCntl loc_cntl = null;
        try {
            loc_cntl = RfcIoControl.ab_rfcopen("<trfc client>", org_cntl.destination, 3, null);
            if (loc_cntl == null) {
                throw new RfcException(18, "RfcOpen for tRFC failed", 104, 0L, true);
            }
            RfcTypePlayback cntl = (RfcTypePlayback)loc_cntl.channel;
            cntl.itab_h = itab_h;
            cntl.key = header;
            loc_cntl.setCodepage(org_cntl.getCodepage());
            loc_cntl.setCommunicationCodepage(org_cntl.getCommunicationCodepage());
            loc_cntl.pcs = org_cntl.pcs;
            loc_cntl.real_pcs = org_cntl.real_pcs;
            loc_cntl.trace = org_cntl.trace;
            loc_cntl.destination = org_cntl.destination;
            loc_cntl.userid = org_cntl.userid;
            loc_cntl.own_type = org_cntl.own_type;
            loc_cntl.own_rel = org_cntl.own_rel;
            loc_cntl.rfc_role = org_cntl.rfc_role;
            loc_cntl.target = org_cntl.target;
            loc_cntl.inetAddress = org_cntl.inetAddress;
            loc_cntl.mysapsso2 = org_cntl.mysapsso2;
            loc_cntl.th_client_id = org_cntl.th_client_id;
            loc_cntl.lang = org_cntl.lang;
            loc_cntl.version = org_cntl.version;
            loc_cntl.serializationFormat = org_cntl.serializationFormat;
            loc_cntl.stateless = false;
            loc_cntl.RfcCall(function, exporting, null, null, tables, supportsASXML, classExceptionMode, null);
        }
        finally {
            if (loc_cntl != null) {
                loc_cntl.RfcClose();
                RfcIoControl.release(loc_cntl);
            }
        }
    }
}

